/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class EdgeModelSummariesCopier {
    static List<EdgeModelSummary> copy(Collection<? extends EdgeModelSummary> edgeModelSummariesParam) {
        List<EdgeModelSummary> list;
        if (edgeModelSummariesParam == null || edgeModelSummariesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EdgeModelSummary> modifiableList = new ArrayList<>(edgeModelSummariesParam.size());
            edgeModelSummariesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EdgeModelSummary> copyFromBuilder(Collection<? extends EdgeModelSummary.Builder> edgeModelSummariesParam) {
        List<EdgeModelSummary> list;
        if (edgeModelSummariesParam == null || edgeModelSummariesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EdgeModelSummary> modifiableList = new ArrayList<>(edgeModelSummariesParam.size());
            edgeModelSummariesParam.forEach(entry -> {
                EdgeModelSummary member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EdgeModelSummary.Builder> copyToBuilder(Collection<? extends EdgeModelSummary> edgeModelSummariesParam) {
        List<EdgeModelSummary.Builder> list;
        if (edgeModelSummariesParam == null || edgeModelSummariesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EdgeModelSummary.Builder> modifiableList = new ArrayList<>(edgeModelSummariesParam.size());
            edgeModelSummariesParam.forEach(entry -> {
                EdgeModelSummary.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
