/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output of a SageMaker Edge Manager deployable resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdgePresetDeploymentOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<EdgePresetDeploymentOutput.Builder, EdgePresetDeploymentOutput> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(EdgePresetDeploymentOutput::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ARTIFACT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Artifact").getter(getter(EdgePresetDeploymentOutput::artifact)).setter(setter(Builder::artifact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Artifact").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(EdgePresetDeploymentOutput::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(EdgePresetDeploymentOutput::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ARTIFACT_FIELD,
            STATUS_FIELD, STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String artifact;

    private final String status;

    private final String statusMessage;

    private EdgePresetDeploymentOutput(BuilderImpl builder) {
        this.type = builder.type;
        this.artifact = builder.artifact;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The deployment type created by SageMaker Edge Manager. Currently only supports Amazon Web Services IoT Greengrass
     * Version 2 components.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EdgePresetDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The deployment type created by SageMaker Edge Manager. Currently only supports Amazon Web Services IoT
     *         Greengrass Version 2 components.
     * @see EdgePresetDeploymentType
     */
    public final EdgePresetDeploymentType type() {
        return EdgePresetDeploymentType.fromValue(type);
    }

    /**
     * <p>
     * The deployment type created by SageMaker Edge Manager. Currently only supports Amazon Web Services IoT Greengrass
     * Version 2 components.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EdgePresetDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The deployment type created by SageMaker Edge Manager. Currently only supports Amazon Web Services IoT
     *         Greengrass Version 2 components.
     * @see EdgePresetDeploymentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the generated deployable resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the generated deployable resource.
     */
    public final String artifact() {
        return artifact;
    }

    /**
     * <p>
     * The status of the deployable resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EdgePresetDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deployable resource.
     * @see EdgePresetDeploymentStatus
     */
    public final EdgePresetDeploymentStatus status() {
        return EdgePresetDeploymentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the deployable resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EdgePresetDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deployable resource.
     * @see EdgePresetDeploymentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Returns a message describing the status of the deployed resource.
     * </p>
     * 
     * @return Returns a message describing the status of the deployed resource.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(artifact());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgePresetDeploymentOutput)) {
            return false;
        }
        EdgePresetDeploymentOutput other = (EdgePresetDeploymentOutput) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(artifact(), other.artifact())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdgePresetDeploymentOutput").add("Type", typeAsString()).add("Artifact", artifact())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Artifact":
            return Optional.ofNullable(clazz.cast(artifact()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Artifact", ARTIFACT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EdgePresetDeploymentOutput, T> g) {
        return obj -> g.apply((EdgePresetDeploymentOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdgePresetDeploymentOutput> {
        /**
         * <p>
         * The deployment type created by SageMaker Edge Manager. Currently only supports Amazon Web Services IoT
         * Greengrass Version 2 components.
         * </p>
         * 
         * @param type
         *        The deployment type created by SageMaker Edge Manager. Currently only supports Amazon Web Services IoT
         *        Greengrass Version 2 components.
         * @see EdgePresetDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdgePresetDeploymentType
         */
        Builder type(String type);

        /**
         * <p>
         * The deployment type created by SageMaker Edge Manager. Currently only supports Amazon Web Services IoT
         * Greengrass Version 2 components.
         * </p>
         * 
         * @param type
         *        The deployment type created by SageMaker Edge Manager. Currently only supports Amazon Web Services IoT
         *        Greengrass Version 2 components.
         * @see EdgePresetDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdgePresetDeploymentType
         */
        Builder type(EdgePresetDeploymentType type);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the generated deployable resource.
         * </p>
         * 
         * @param artifact
         *        The Amazon Resource Name (ARN) of the generated deployable resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifact(String artifact);

        /**
         * <p>
         * The status of the deployable resource.
         * </p>
         * 
         * @param status
         *        The status of the deployable resource.
         * @see EdgePresetDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdgePresetDeploymentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the deployable resource.
         * </p>
         * 
         * @param status
         *        The status of the deployable resource.
         * @see EdgePresetDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdgePresetDeploymentStatus
         */
        Builder status(EdgePresetDeploymentStatus status);

        /**
         * <p>
         * Returns a message describing the status of the deployed resource.
         * </p>
         * 
         * @param statusMessage
         *        Returns a message describing the status of the deployed resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String artifact;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgePresetDeploymentOutput model) {
            type(model.type);
            artifact(model.artifact);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EdgePresetDeploymentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getArtifact() {
            return artifact;
        }

        public final void setArtifact(String artifact) {
            this.artifact = artifact;
        }

        @Override
        public final Builder artifact(String artifact) {
            this.artifact = artifact;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EdgePresetDeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public EdgePresetDeploymentOutput build() {
            return new EdgePresetDeploymentOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
