/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The endpoint configuration made by Inference Recommender during a recommendation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointOutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EndpointOutputConfiguration.Builder, EndpointOutputConfiguration> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(EndpointOutputConfiguration::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> VARIANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VariantName").getter(getter(EndpointOutputConfiguration::variantName))
            .setter(setter(Builder::variantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantName").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(EndpointOutputConfiguration::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Integer> INITIAL_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InitialInstanceCount").getter(getter(EndpointOutputConfiguration::initialInstanceCount))
            .setter(setter(Builder::initialInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialInstanceCount").build())
            .build();

    private static final SdkField<ProductionVariantServerlessConfig> SERVERLESS_CONFIG_FIELD = SdkField
            .<ProductionVariantServerlessConfig> builder(MarshallingType.SDK_POJO).memberName("ServerlessConfig")
            .getter(getter(EndpointOutputConfiguration::serverlessConfig)).setter(setter(Builder::serverlessConfig))
            .constructor(ProductionVariantServerlessConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            VARIANT_NAME_FIELD, INSTANCE_TYPE_FIELD, INITIAL_INSTANCE_COUNT_FIELD, SERVERLESS_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String endpointName;

    private final String variantName;

    private final String instanceType;

    private final Integer initialInstanceCount;

    private final ProductionVariantServerlessConfig serverlessConfig;

    private EndpointOutputConfiguration(BuilderImpl builder) {
        this.endpointName = builder.endpointName;
        this.variantName = builder.variantName;
        this.instanceType = builder.instanceType;
        this.initialInstanceCount = builder.initialInstanceCount;
        this.serverlessConfig = builder.serverlessConfig;
    }

    /**
     * <p>
     * The name of the endpoint made during a recommendation job.
     * </p>
     * 
     * @return The name of the endpoint made during a recommendation job.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The name of the production variant (deployed model) made during a recommendation job.
     * </p>
     * 
     * @return The name of the production variant (deployed model) made during a recommendation job.
     */
    public final String variantName() {
        return variantName;
    }

    /**
     * <p>
     * The instance type recommended by Amazon SageMaker Inference Recommender.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ProductionVariantInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type recommended by Amazon SageMaker Inference Recommender.
     * @see ProductionVariantInstanceType
     */
    public final ProductionVariantInstanceType instanceType() {
        return ProductionVariantInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type recommended by Amazon SageMaker Inference Recommender.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ProductionVariantInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type recommended by Amazon SageMaker Inference Recommender.
     * @see ProductionVariantInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The number of instances recommended to launch initially.
     * </p>
     * 
     * @return The number of instances recommended to launch initially.
     */
    public final Integer initialInstanceCount() {
        return initialInstanceCount;
    }

    /**
     * Returns the value of the ServerlessConfig property for this object.
     * 
     * @return The value of the ServerlessConfig property for this object.
     */
    public final ProductionVariantServerlessConfig serverlessConfig() {
        return serverlessConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(variantName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(initialInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(serverlessConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointOutputConfiguration)) {
            return false;
        }
        EndpointOutputConfiguration other = (EndpointOutputConfiguration) obj;
        return Objects.equals(endpointName(), other.endpointName()) && Objects.equals(variantName(), other.variantName())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(initialInstanceCount(), other.initialInstanceCount())
                && Objects.equals(serverlessConfig(), other.serverlessConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointOutputConfiguration").add("EndpointName", endpointName())
                .add("VariantName", variantName()).add("InstanceType", instanceTypeAsString())
                .add("InitialInstanceCount", initialInstanceCount()).add("ServerlessConfig", serverlessConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "VariantName":
            return Optional.ofNullable(clazz.cast(variantName()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "InitialInstanceCount":
            return Optional.ofNullable(clazz.cast(initialInstanceCount()));
        case "ServerlessConfig":
            return Optional.ofNullable(clazz.cast(serverlessConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("VariantName", VARIANT_NAME_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InitialInstanceCount", INITIAL_INSTANCE_COUNT_FIELD);
        map.put("ServerlessConfig", SERVERLESS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EndpointOutputConfiguration, T> g) {
        return obj -> g.apply((EndpointOutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointOutputConfiguration> {
        /**
         * <p>
         * The name of the endpoint made during a recommendation job.
         * </p>
         * 
         * @param endpointName
         *        The name of the endpoint made during a recommendation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The name of the production variant (deployed model) made during a recommendation job.
         * </p>
         * 
         * @param variantName
         *        The name of the production variant (deployed model) made during a recommendation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variantName(String variantName);

        /**
         * <p>
         * The instance type recommended by Amazon SageMaker Inference Recommender.
         * </p>
         * 
         * @param instanceType
         *        The instance type recommended by Amazon SageMaker Inference Recommender.
         * @see ProductionVariantInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductionVariantInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type recommended by Amazon SageMaker Inference Recommender.
         * </p>
         * 
         * @param instanceType
         *        The instance type recommended by Amazon SageMaker Inference Recommender.
         * @see ProductionVariantInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductionVariantInstanceType
         */
        Builder instanceType(ProductionVariantInstanceType instanceType);

        /**
         * <p>
         * The number of instances recommended to launch initially.
         * </p>
         * 
         * @param initialInstanceCount
         *        The number of instances recommended to launch initially.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialInstanceCount(Integer initialInstanceCount);

        /**
         * Sets the value of the ServerlessConfig property for this object.
         *
         * @param serverlessConfig
         *        The new value for the ServerlessConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessConfig(ProductionVariantServerlessConfig serverlessConfig);

        /**
         * Sets the value of the ServerlessConfig property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link ProductionVariantServerlessConfig.Builder} avoiding the need to create one manually via
         * {@link ProductionVariantServerlessConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProductionVariantServerlessConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #serverlessConfig(ProductionVariantServerlessConfig)}.
         * 
         * @param serverlessConfig
         *        a consumer that will call methods on {@link ProductionVariantServerlessConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverlessConfig(ProductionVariantServerlessConfig)
         */
        default Builder serverlessConfig(Consumer<ProductionVariantServerlessConfig.Builder> serverlessConfig) {
            return serverlessConfig(ProductionVariantServerlessConfig.builder().applyMutation(serverlessConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String endpointName;

        private String variantName;

        private String instanceType;

        private Integer initialInstanceCount;

        private ProductionVariantServerlessConfig serverlessConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointOutputConfiguration model) {
            endpointName(model.endpointName);
            variantName(model.variantName);
            instanceType(model.instanceType);
            initialInstanceCount(model.initialInstanceCount);
            serverlessConfig(model.serverlessConfig);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getVariantName() {
            return variantName;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ProductionVariantInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getInitialInstanceCount() {
            return initialInstanceCount;
        }

        public final void setInitialInstanceCount(Integer initialInstanceCount) {
            this.initialInstanceCount = initialInstanceCount;
        }

        @Override
        public final Builder initialInstanceCount(Integer initialInstanceCount) {
            this.initialInstanceCount = initialInstanceCount;
            return this;
        }

        public final ProductionVariantServerlessConfig.Builder getServerlessConfig() {
            return serverlessConfig != null ? serverlessConfig.toBuilder() : null;
        }

        public final void setServerlessConfig(ProductionVariantServerlessConfig.BuilderImpl serverlessConfig) {
            this.serverlessConfig = serverlessConfig != null ? serverlessConfig.build() : null;
        }

        @Override
        public final Builder serverlessConfig(ProductionVariantServerlessConfig serverlessConfig) {
            this.serverlessConfig = serverlessConfig;
            return this;
        }

        @Override
        public EndpointOutputConfiguration build() {
            return new EndpointOutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
