/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetScalingConfigurationRecommendationResponse extends SageMakerResponse implements
        ToCopyableBuilder<GetScalingConfigurationRecommendationResponse.Builder, GetScalingConfigurationRecommendationResponse> {
    private static final SdkField<String> INFERENCE_RECOMMENDATIONS_JOB_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InferenceRecommendationsJobName")
            .getter(getter(GetScalingConfigurationRecommendationResponse::inferenceRecommendationsJobName))
            .setter(setter(Builder::inferenceRecommendationsJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceRecommendationsJobName")
                    .build()).build();

    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationId").getter(getter(GetScalingConfigurationRecommendationResponse::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()).build();

    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(GetScalingConfigurationRecommendationResponse::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<Integer> TARGET_CPU_UTILIZATION_PER_CORE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetCpuUtilizationPerCore")
            .getter(getter(GetScalingConfigurationRecommendationResponse::targetCpuUtilizationPerCore))
            .setter(setter(Builder::targetCpuUtilizationPerCore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCpuUtilizationPerCore")
                    .build()).build();

    private static final SdkField<ScalingPolicyObjective> SCALING_POLICY_OBJECTIVE_FIELD = SdkField
            .<ScalingPolicyObjective> builder(MarshallingType.SDK_POJO).memberName("ScalingPolicyObjective")
            .getter(getter(GetScalingConfigurationRecommendationResponse::scalingPolicyObjective))
            .setter(setter(Builder::scalingPolicyObjective)).constructor(ScalingPolicyObjective::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPolicyObjective").build())
            .build();

    private static final SdkField<ScalingPolicyMetric> METRIC_FIELD = SdkField
            .<ScalingPolicyMetric> builder(MarshallingType.SDK_POJO).memberName("Metric")
            .getter(getter(GetScalingConfigurationRecommendationResponse::metric)).setter(setter(Builder::metric))
            .constructor(ScalingPolicyMetric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()).build();

    private static final SdkField<DynamicScalingConfiguration> DYNAMIC_SCALING_CONFIGURATION_FIELD = SdkField
            .<DynamicScalingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DynamicScalingConfiguration")
            .getter(getter(GetScalingConfigurationRecommendationResponse::dynamicScalingConfiguration))
            .setter(setter(Builder::dynamicScalingConfiguration))
            .constructor(DynamicScalingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicScalingConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INFERENCE_RECOMMENDATIONS_JOB_NAME_FIELD, RECOMMENDATION_ID_FIELD, ENDPOINT_NAME_FIELD,
            TARGET_CPU_UTILIZATION_PER_CORE_FIELD, SCALING_POLICY_OBJECTIVE_FIELD, METRIC_FIELD,
            DYNAMIC_SCALING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String inferenceRecommendationsJobName;

    private final String recommendationId;

    private final String endpointName;

    private final Integer targetCpuUtilizationPerCore;

    private final ScalingPolicyObjective scalingPolicyObjective;

    private final ScalingPolicyMetric metric;

    private final DynamicScalingConfiguration dynamicScalingConfiguration;

    private GetScalingConfigurationRecommendationResponse(BuilderImpl builder) {
        super(builder);
        this.inferenceRecommendationsJobName = builder.inferenceRecommendationsJobName;
        this.recommendationId = builder.recommendationId;
        this.endpointName = builder.endpointName;
        this.targetCpuUtilizationPerCore = builder.targetCpuUtilizationPerCore;
        this.scalingPolicyObjective = builder.scalingPolicyObjective;
        this.metric = builder.metric;
        this.dynamicScalingConfiguration = builder.dynamicScalingConfiguration;
    }

    /**
     * <p>
     * The name of a previously completed Inference Recommender job.
     * </p>
     * 
     * @return The name of a previously completed Inference Recommender job.
     */
    public final String inferenceRecommendationsJobName() {
        return inferenceRecommendationsJobName;
    }

    /**
     * <p>
     * The recommendation ID of a previously completed inference recommendation.
     * </p>
     * 
     * @return The recommendation ID of a previously completed inference recommendation.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * The name of an endpoint benchmarked during a previously completed Inference Recommender job.
     * </p>
     * 
     * @return The name of an endpoint benchmarked during a previously completed Inference Recommender job.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The percentage of how much utilization you want an instance to use before autoscaling, which you specified in the
     * request. The default value is 50%.
     * </p>
     * 
     * @return The percentage of how much utilization you want an instance to use before autoscaling, which you
     *         specified in the request. The default value is 50%.
     */
    public final Integer targetCpuUtilizationPerCore() {
        return targetCpuUtilizationPerCore;
    }

    /**
     * <p>
     * An object representing the anticipated traffic pattern for an endpoint that you specified in the request.
     * </p>
     * 
     * @return An object representing the anticipated traffic pattern for an endpoint that you specified in the request.
     */
    public final ScalingPolicyObjective scalingPolicyObjective() {
        return scalingPolicyObjective;
    }

    /**
     * <p>
     * An object with a list of metrics that were benchmarked during the previously completed Inference Recommender job.
     * </p>
     * 
     * @return An object with a list of metrics that were benchmarked during the previously completed Inference
     *         Recommender job.
     */
    public final ScalingPolicyMetric metric() {
        return metric;
    }

    /**
     * <p>
     * An object with the recommended values for you to specify when creating an autoscaling policy.
     * </p>
     * 
     * @return An object with the recommended values for you to specify when creating an autoscaling policy.
     */
    public final DynamicScalingConfiguration dynamicScalingConfiguration() {
        return dynamicScalingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inferenceRecommendationsJobName());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(targetCpuUtilizationPerCore());
        hashCode = 31 * hashCode + Objects.hashCode(scalingPolicyObjective());
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicScalingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScalingConfigurationRecommendationResponse)) {
            return false;
        }
        GetScalingConfigurationRecommendationResponse other = (GetScalingConfigurationRecommendationResponse) obj;
        return Objects.equals(inferenceRecommendationsJobName(), other.inferenceRecommendationsJobName())
                && Objects.equals(recommendationId(), other.recommendationId())
                && Objects.equals(endpointName(), other.endpointName())
                && Objects.equals(targetCpuUtilizationPerCore(), other.targetCpuUtilizationPerCore())
                && Objects.equals(scalingPolicyObjective(), other.scalingPolicyObjective())
                && Objects.equals(metric(), other.metric())
                && Objects.equals(dynamicScalingConfiguration(), other.dynamicScalingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetScalingConfigurationRecommendationResponse")
                .add("InferenceRecommendationsJobName", inferenceRecommendationsJobName())
                .add("RecommendationId", recommendationId()).add("EndpointName", endpointName())
                .add("TargetCpuUtilizationPerCore", targetCpuUtilizationPerCore())
                .add("ScalingPolicyObjective", scalingPolicyObjective()).add("Metric", metric())
                .add("DynamicScalingConfiguration", dynamicScalingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InferenceRecommendationsJobName":
            return Optional.ofNullable(clazz.cast(inferenceRecommendationsJobName()));
        case "RecommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "TargetCpuUtilizationPerCore":
            return Optional.ofNullable(clazz.cast(targetCpuUtilizationPerCore()));
        case "ScalingPolicyObjective":
            return Optional.ofNullable(clazz.cast(scalingPolicyObjective()));
        case "Metric":
            return Optional.ofNullable(clazz.cast(metric()));
        case "DynamicScalingConfiguration":
            return Optional.ofNullable(clazz.cast(dynamicScalingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InferenceRecommendationsJobName", INFERENCE_RECOMMENDATIONS_JOB_NAME_FIELD);
        map.put("RecommendationId", RECOMMENDATION_ID_FIELD);
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("TargetCpuUtilizationPerCore", TARGET_CPU_UTILIZATION_PER_CORE_FIELD);
        map.put("ScalingPolicyObjective", SCALING_POLICY_OBJECTIVE_FIELD);
        map.put("Metric", METRIC_FIELD);
        map.put("DynamicScalingConfiguration", DYNAMIC_SCALING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetScalingConfigurationRecommendationResponse, T> g) {
        return obj -> g.apply((GetScalingConfigurationRecommendationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetScalingConfigurationRecommendationResponse> {
        /**
         * <p>
         * The name of a previously completed Inference Recommender job.
         * </p>
         * 
         * @param inferenceRecommendationsJobName
         *        The name of a previously completed Inference Recommender job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceRecommendationsJobName(String inferenceRecommendationsJobName);

        /**
         * <p>
         * The recommendation ID of a previously completed inference recommendation.
         * </p>
         * 
         * @param recommendationId
         *        The recommendation ID of a previously completed inference recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * The name of an endpoint benchmarked during a previously completed Inference Recommender job.
         * </p>
         * 
         * @param endpointName
         *        The name of an endpoint benchmarked during a previously completed Inference Recommender job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The percentage of how much utilization you want an instance to use before autoscaling, which you specified in
         * the request. The default value is 50%.
         * </p>
         * 
         * @param targetCpuUtilizationPerCore
         *        The percentage of how much utilization you want an instance to use before autoscaling, which you
         *        specified in the request. The default value is 50%.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCpuUtilizationPerCore(Integer targetCpuUtilizationPerCore);

        /**
         * <p>
         * An object representing the anticipated traffic pattern for an endpoint that you specified in the request.
         * </p>
         * 
         * @param scalingPolicyObjective
         *        An object representing the anticipated traffic pattern for an endpoint that you specified in the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPolicyObjective(ScalingPolicyObjective scalingPolicyObjective);

        /**
         * <p>
         * An object representing the anticipated traffic pattern for an endpoint that you specified in the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScalingPolicyObjective.Builder} avoiding
         * the need to create one manually via {@link ScalingPolicyObjective#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScalingPolicyObjective.Builder#build()} is called immediately and
         * its result is passed to {@link #scalingPolicyObjective(ScalingPolicyObjective)}.
         * 
         * @param scalingPolicyObjective
         *        a consumer that will call methods on {@link ScalingPolicyObjective.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingPolicyObjective(ScalingPolicyObjective)
         */
        default Builder scalingPolicyObjective(Consumer<ScalingPolicyObjective.Builder> scalingPolicyObjective) {
            return scalingPolicyObjective(ScalingPolicyObjective.builder().applyMutation(scalingPolicyObjective).build());
        }

        /**
         * <p>
         * An object with a list of metrics that were benchmarked during the previously completed Inference Recommender
         * job.
         * </p>
         * 
         * @param metric
         *        An object with a list of metrics that were benchmarked during the previously completed Inference
         *        Recommender job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(ScalingPolicyMetric metric);

        /**
         * <p>
         * An object with a list of metrics that were benchmarked during the previously completed Inference Recommender
         * job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScalingPolicyMetric.Builder} avoiding the
         * need to create one manually via {@link ScalingPolicyMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScalingPolicyMetric.Builder#build()} is called immediately and
         * its result is passed to {@link #metric(ScalingPolicyMetric)}.
         * 
         * @param metric
         *        a consumer that will call methods on {@link ScalingPolicyMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metric(ScalingPolicyMetric)
         */
        default Builder metric(Consumer<ScalingPolicyMetric.Builder> metric) {
            return metric(ScalingPolicyMetric.builder().applyMutation(metric).build());
        }

        /**
         * <p>
         * An object with the recommended values for you to specify when creating an autoscaling policy.
         * </p>
         * 
         * @param dynamicScalingConfiguration
         *        An object with the recommended values for you to specify when creating an autoscaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamicScalingConfiguration(DynamicScalingConfiguration dynamicScalingConfiguration);

        /**
         * <p>
         * An object with the recommended values for you to specify when creating an autoscaling policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link DynamicScalingConfiguration.Builder}
         * avoiding the need to create one manually via {@link DynamicScalingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DynamicScalingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #dynamicScalingConfiguration(DynamicScalingConfiguration)}.
         * 
         * @param dynamicScalingConfiguration
         *        a consumer that will call methods on {@link DynamicScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamicScalingConfiguration(DynamicScalingConfiguration)
         */
        default Builder dynamicScalingConfiguration(Consumer<DynamicScalingConfiguration.Builder> dynamicScalingConfiguration) {
            return dynamicScalingConfiguration(DynamicScalingConfiguration.builder().applyMutation(dynamicScalingConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String inferenceRecommendationsJobName;

        private String recommendationId;

        private String endpointName;

        private Integer targetCpuUtilizationPerCore;

        private ScalingPolicyObjective scalingPolicyObjective;

        private ScalingPolicyMetric metric;

        private DynamicScalingConfiguration dynamicScalingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScalingConfigurationRecommendationResponse model) {
            super(model);
            inferenceRecommendationsJobName(model.inferenceRecommendationsJobName);
            recommendationId(model.recommendationId);
            endpointName(model.endpointName);
            targetCpuUtilizationPerCore(model.targetCpuUtilizationPerCore);
            scalingPolicyObjective(model.scalingPolicyObjective);
            metric(model.metric);
            dynamicScalingConfiguration(model.dynamicScalingConfiguration);
        }

        public final String getInferenceRecommendationsJobName() {
            return inferenceRecommendationsJobName;
        }

        public final void setInferenceRecommendationsJobName(String inferenceRecommendationsJobName) {
            this.inferenceRecommendationsJobName = inferenceRecommendationsJobName;
        }

        @Override
        public final Builder inferenceRecommendationsJobName(String inferenceRecommendationsJobName) {
            this.inferenceRecommendationsJobName = inferenceRecommendationsJobName;
            return this;
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final Integer getTargetCpuUtilizationPerCore() {
            return targetCpuUtilizationPerCore;
        }

        public final void setTargetCpuUtilizationPerCore(Integer targetCpuUtilizationPerCore) {
            this.targetCpuUtilizationPerCore = targetCpuUtilizationPerCore;
        }

        @Override
        public final Builder targetCpuUtilizationPerCore(Integer targetCpuUtilizationPerCore) {
            this.targetCpuUtilizationPerCore = targetCpuUtilizationPerCore;
            return this;
        }

        public final ScalingPolicyObjective.Builder getScalingPolicyObjective() {
            return scalingPolicyObjective != null ? scalingPolicyObjective.toBuilder() : null;
        }

        public final void setScalingPolicyObjective(ScalingPolicyObjective.BuilderImpl scalingPolicyObjective) {
            this.scalingPolicyObjective = scalingPolicyObjective != null ? scalingPolicyObjective.build() : null;
        }

        @Override
        public final Builder scalingPolicyObjective(ScalingPolicyObjective scalingPolicyObjective) {
            this.scalingPolicyObjective = scalingPolicyObjective;
            return this;
        }

        public final ScalingPolicyMetric.Builder getMetric() {
            return metric != null ? metric.toBuilder() : null;
        }

        public final void setMetric(ScalingPolicyMetric.BuilderImpl metric) {
            this.metric = metric != null ? metric.build() : null;
        }

        @Override
        public final Builder metric(ScalingPolicyMetric metric) {
            this.metric = metric;
            return this;
        }

        public final DynamicScalingConfiguration.Builder getDynamicScalingConfiguration() {
            return dynamicScalingConfiguration != null ? dynamicScalingConfiguration.toBuilder() : null;
        }

        public final void setDynamicScalingConfiguration(DynamicScalingConfiguration.BuilderImpl dynamicScalingConfiguration) {
            this.dynamicScalingConfiguration = dynamicScalingConfiguration != null ? dynamicScalingConfiguration.build() : null;
        }

        @Override
        public final Builder dynamicScalingConfiguration(DynamicScalingConfiguration dynamicScalingConfiguration) {
            this.dynamicScalingConfiguration = dynamicScalingConfiguration;
            return this;
        }

        @Override
        public GetScalingConfigurationRecommendationResponse build() {
            return new GetScalingConfigurationRecommendationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
