/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the compute resources to allocate to run a model, plus any adapter models, that you assign to an inference
 * component. These resources include CPU cores, accelerators, and memory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceComponentComputeResourceRequirements implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceComponentComputeResourceRequirements.Builder, InferenceComponentComputeResourceRequirements> {
    private static final SdkField<Float> NUMBER_OF_CPU_CORES_REQUIRED_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("NumberOfCpuCoresRequired")
            .getter(getter(InferenceComponentComputeResourceRequirements::numberOfCpuCoresRequired))
            .setter(setter(Builder::numberOfCpuCoresRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfCpuCoresRequired").build())
            .build();

    private static final SdkField<Float> NUMBER_OF_ACCELERATOR_DEVICES_REQUIRED_FIELD = SdkField
            .<Float> builder(MarshallingType.FLOAT)
            .memberName("NumberOfAcceleratorDevicesRequired")
            .getter(getter(InferenceComponentComputeResourceRequirements::numberOfAcceleratorDevicesRequired))
            .setter(setter(Builder::numberOfAcceleratorDevicesRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAcceleratorDevicesRequired")
                    .build()).build();

    private static final SdkField<Integer> MIN_MEMORY_REQUIRED_IN_MB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinMemoryRequiredInMb")
            .getter(getter(InferenceComponentComputeResourceRequirements::minMemoryRequiredInMb))
            .setter(setter(Builder::minMemoryRequiredInMb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinMemoryRequiredInMb").build())
            .build();

    private static final SdkField<Integer> MAX_MEMORY_REQUIRED_IN_MB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxMemoryRequiredInMb")
            .getter(getter(InferenceComponentComputeResourceRequirements::maxMemoryRequiredInMb))
            .setter(setter(Builder::maxMemoryRequiredInMb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxMemoryRequiredInMb").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NUMBER_OF_CPU_CORES_REQUIRED_FIELD, NUMBER_OF_ACCELERATOR_DEVICES_REQUIRED_FIELD, MIN_MEMORY_REQUIRED_IN_MB_FIELD,
            MAX_MEMORY_REQUIRED_IN_MB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Float numberOfCpuCoresRequired;

    private final Float numberOfAcceleratorDevicesRequired;

    private final Integer minMemoryRequiredInMb;

    private final Integer maxMemoryRequiredInMb;

    private InferenceComponentComputeResourceRequirements(BuilderImpl builder) {
        this.numberOfCpuCoresRequired = builder.numberOfCpuCoresRequired;
        this.numberOfAcceleratorDevicesRequired = builder.numberOfAcceleratorDevicesRequired;
        this.minMemoryRequiredInMb = builder.minMemoryRequiredInMb;
        this.maxMemoryRequiredInMb = builder.maxMemoryRequiredInMb;
    }

    /**
     * <p>
     * The number of CPU cores to allocate to run a model that you assign to an inference component.
     * </p>
     * 
     * @return The number of CPU cores to allocate to run a model that you assign to an inference component.
     */
    public final Float numberOfCpuCoresRequired() {
        return numberOfCpuCoresRequired;
    }

    /**
     * <p>
     * The number of accelerators to allocate to run a model that you assign to an inference component. Accelerators
     * include GPUs and Amazon Web Services Inferentia.
     * </p>
     * 
     * @return The number of accelerators to allocate to run a model that you assign to an inference component.
     *         Accelerators include GPUs and Amazon Web Services Inferentia.
     */
    public final Float numberOfAcceleratorDevicesRequired() {
        return numberOfAcceleratorDevicesRequired;
    }

    /**
     * <p>
     * The minimum MB of memory to allocate to run a model that you assign to an inference component.
     * </p>
     * 
     * @return The minimum MB of memory to allocate to run a model that you assign to an inference component.
     */
    public final Integer minMemoryRequiredInMb() {
        return minMemoryRequiredInMb;
    }

    /**
     * <p>
     * The maximum MB of memory to allocate to run a model that you assign to an inference component.
     * </p>
     * 
     * @return The maximum MB of memory to allocate to run a model that you assign to an inference component.
     */
    public final Integer maxMemoryRequiredInMb() {
        return maxMemoryRequiredInMb;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfCpuCoresRequired());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfAcceleratorDevicesRequired());
        hashCode = 31 * hashCode + Objects.hashCode(minMemoryRequiredInMb());
        hashCode = 31 * hashCode + Objects.hashCode(maxMemoryRequiredInMb());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentComputeResourceRequirements)) {
            return false;
        }
        InferenceComponentComputeResourceRequirements other = (InferenceComponentComputeResourceRequirements) obj;
        return Objects.equals(numberOfCpuCoresRequired(), other.numberOfCpuCoresRequired())
                && Objects.equals(numberOfAcceleratorDevicesRequired(), other.numberOfAcceleratorDevicesRequired())
                && Objects.equals(minMemoryRequiredInMb(), other.minMemoryRequiredInMb())
                && Objects.equals(maxMemoryRequiredInMb(), other.maxMemoryRequiredInMb());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceComponentComputeResourceRequirements")
                .add("NumberOfCpuCoresRequired", numberOfCpuCoresRequired())
                .add("NumberOfAcceleratorDevicesRequired", numberOfAcceleratorDevicesRequired())
                .add("MinMemoryRequiredInMb", minMemoryRequiredInMb()).add("MaxMemoryRequiredInMb", maxMemoryRequiredInMb())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberOfCpuCoresRequired":
            return Optional.ofNullable(clazz.cast(numberOfCpuCoresRequired()));
        case "NumberOfAcceleratorDevicesRequired":
            return Optional.ofNullable(clazz.cast(numberOfAcceleratorDevicesRequired()));
        case "MinMemoryRequiredInMb":
            return Optional.ofNullable(clazz.cast(minMemoryRequiredInMb()));
        case "MaxMemoryRequiredInMb":
            return Optional.ofNullable(clazz.cast(maxMemoryRequiredInMb()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NumberOfCpuCoresRequired", NUMBER_OF_CPU_CORES_REQUIRED_FIELD);
        map.put("NumberOfAcceleratorDevicesRequired", NUMBER_OF_ACCELERATOR_DEVICES_REQUIRED_FIELD);
        map.put("MinMemoryRequiredInMb", MIN_MEMORY_REQUIRED_IN_MB_FIELD);
        map.put("MaxMemoryRequiredInMb", MAX_MEMORY_REQUIRED_IN_MB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceComponentComputeResourceRequirements, T> g) {
        return obj -> g.apply((InferenceComponentComputeResourceRequirements) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceComponentComputeResourceRequirements> {
        /**
         * <p>
         * The number of CPU cores to allocate to run a model that you assign to an inference component.
         * </p>
         * 
         * @param numberOfCpuCoresRequired
         *        The number of CPU cores to allocate to run a model that you assign to an inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfCpuCoresRequired(Float numberOfCpuCoresRequired);

        /**
         * <p>
         * The number of accelerators to allocate to run a model that you assign to an inference component. Accelerators
         * include GPUs and Amazon Web Services Inferentia.
         * </p>
         * 
         * @param numberOfAcceleratorDevicesRequired
         *        The number of accelerators to allocate to run a model that you assign to an inference component.
         *        Accelerators include GPUs and Amazon Web Services Inferentia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfAcceleratorDevicesRequired(Float numberOfAcceleratorDevicesRequired);

        /**
         * <p>
         * The minimum MB of memory to allocate to run a model that you assign to an inference component.
         * </p>
         * 
         * @param minMemoryRequiredInMb
         *        The minimum MB of memory to allocate to run a model that you assign to an inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minMemoryRequiredInMb(Integer minMemoryRequiredInMb);

        /**
         * <p>
         * The maximum MB of memory to allocate to run a model that you assign to an inference component.
         * </p>
         * 
         * @param maxMemoryRequiredInMb
         *        The maximum MB of memory to allocate to run a model that you assign to an inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxMemoryRequiredInMb(Integer maxMemoryRequiredInMb);
    }

    static final class BuilderImpl implements Builder {
        private Float numberOfCpuCoresRequired;

        private Float numberOfAcceleratorDevicesRequired;

        private Integer minMemoryRequiredInMb;

        private Integer maxMemoryRequiredInMb;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceComponentComputeResourceRequirements model) {
            numberOfCpuCoresRequired(model.numberOfCpuCoresRequired);
            numberOfAcceleratorDevicesRequired(model.numberOfAcceleratorDevicesRequired);
            minMemoryRequiredInMb(model.minMemoryRequiredInMb);
            maxMemoryRequiredInMb(model.maxMemoryRequiredInMb);
        }

        public final Float getNumberOfCpuCoresRequired() {
            return numberOfCpuCoresRequired;
        }

        public final void setNumberOfCpuCoresRequired(Float numberOfCpuCoresRequired) {
            this.numberOfCpuCoresRequired = numberOfCpuCoresRequired;
        }

        @Override
        public final Builder numberOfCpuCoresRequired(Float numberOfCpuCoresRequired) {
            this.numberOfCpuCoresRequired = numberOfCpuCoresRequired;
            return this;
        }

        public final Float getNumberOfAcceleratorDevicesRequired() {
            return numberOfAcceleratorDevicesRequired;
        }

        public final void setNumberOfAcceleratorDevicesRequired(Float numberOfAcceleratorDevicesRequired) {
            this.numberOfAcceleratorDevicesRequired = numberOfAcceleratorDevicesRequired;
        }

        @Override
        public final Builder numberOfAcceleratorDevicesRequired(Float numberOfAcceleratorDevicesRequired) {
            this.numberOfAcceleratorDevicesRequired = numberOfAcceleratorDevicesRequired;
            return this;
        }

        public final Integer getMinMemoryRequiredInMb() {
            return minMemoryRequiredInMb;
        }

        public final void setMinMemoryRequiredInMb(Integer minMemoryRequiredInMb) {
            this.minMemoryRequiredInMb = minMemoryRequiredInMb;
        }

        @Override
        public final Builder minMemoryRequiredInMb(Integer minMemoryRequiredInMb) {
            this.minMemoryRequiredInMb = minMemoryRequiredInMb;
            return this;
        }

        public final Integer getMaxMemoryRequiredInMb() {
            return maxMemoryRequiredInMb;
        }

        public final void setMaxMemoryRequiredInMb(Integer maxMemoryRequiredInMb) {
            this.maxMemoryRequiredInMb = maxMemoryRequiredInMb;
        }

        @Override
        public final Builder maxMemoryRequiredInMb(Integer maxMemoryRequiredInMb) {
            this.maxMemoryRequiredInMb = maxMemoryRequiredInMb;
            return this;
        }

        @Override
        public InferenceComponentComputeResourceRequirements build() {
            return new InferenceComponentComputeResourceRequirements(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
