/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings that take effect while the model container starts up.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceComponentStartupParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceComponentStartupParameters.Builder, InferenceComponentStartupParameters> {
    private static final SdkField<Integer> MODEL_DATA_DOWNLOAD_TIMEOUT_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ModelDataDownloadTimeoutInSeconds")
            .getter(getter(InferenceComponentStartupParameters::modelDataDownloadTimeoutInSeconds))
            .setter(setter(Builder::modelDataDownloadTimeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataDownloadTimeoutInSeconds")
                    .build()).build();

    private static final SdkField<Integer> CONTAINER_STARTUP_HEALTH_CHECK_TIMEOUT_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ContainerStartupHealthCheckTimeoutInSeconds")
            .getter(getter(InferenceComponentStartupParameters::containerStartupHealthCheckTimeoutInSeconds))
            .setter(setter(Builder::containerStartupHealthCheckTimeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ContainerStartupHealthCheckTimeoutInSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MODEL_DATA_DOWNLOAD_TIMEOUT_IN_SECONDS_FIELD, CONTAINER_STARTUP_HEALTH_CHECK_TIMEOUT_IN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer modelDataDownloadTimeoutInSeconds;

    private final Integer containerStartupHealthCheckTimeoutInSeconds;

    private InferenceComponentStartupParameters(BuilderImpl builder) {
        this.modelDataDownloadTimeoutInSeconds = builder.modelDataDownloadTimeoutInSeconds;
        this.containerStartupHealthCheckTimeoutInSeconds = builder.containerStartupHealthCheckTimeoutInSeconds;
    }

    /**
     * <p>
     * The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the
     * individual inference instance associated with this inference component.
     * </p>
     * 
     * @return The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to
     *         the individual inference instance associated with this inference component.
     */
    public final Integer modelDataDownloadTimeoutInSeconds() {
        return modelDataDownloadTimeoutInSeconds;
    }

    /**
     * <p>
     * The timeout value, in seconds, for your inference container to pass health check by Amazon S3 Hosting. For more
     * information about health check, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests"
     * >How Your Container Should Respond to Health Check (Ping) Requests</a>.
     * </p>
     * 
     * @return The timeout value, in seconds, for your inference container to pass health check by Amazon S3 Hosting.
     *         For more information about health check, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests"
     *         >How Your Container Should Respond to Health Check (Ping) Requests</a>.
     */
    public final Integer containerStartupHealthCheckTimeoutInSeconds() {
        return containerStartupHealthCheckTimeoutInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelDataDownloadTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(containerStartupHealthCheckTimeoutInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentStartupParameters)) {
            return false;
        }
        InferenceComponentStartupParameters other = (InferenceComponentStartupParameters) obj;
        return Objects.equals(modelDataDownloadTimeoutInSeconds(), other.modelDataDownloadTimeoutInSeconds())
                && Objects.equals(containerStartupHealthCheckTimeoutInSeconds(),
                        other.containerStartupHealthCheckTimeoutInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceComponentStartupParameters")
                .add("ModelDataDownloadTimeoutInSeconds", modelDataDownloadTimeoutInSeconds())
                .add("ContainerStartupHealthCheckTimeoutInSeconds", containerStartupHealthCheckTimeoutInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelDataDownloadTimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(modelDataDownloadTimeoutInSeconds()));
        case "ContainerStartupHealthCheckTimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(containerStartupHealthCheckTimeoutInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelDataDownloadTimeoutInSeconds", MODEL_DATA_DOWNLOAD_TIMEOUT_IN_SECONDS_FIELD);
        map.put("ContainerStartupHealthCheckTimeoutInSeconds", CONTAINER_STARTUP_HEALTH_CHECK_TIMEOUT_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceComponentStartupParameters, T> g) {
        return obj -> g.apply((InferenceComponentStartupParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceComponentStartupParameters> {
        /**
         * <p>
         * The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the
         * individual inference instance associated with this inference component.
         * </p>
         * 
         * @param modelDataDownloadTimeoutInSeconds
         *        The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3
         *        to the individual inference instance associated with this inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDataDownloadTimeoutInSeconds(Integer modelDataDownloadTimeoutInSeconds);

        /**
         * <p>
         * The timeout value, in seconds, for your inference container to pass health check by Amazon S3 Hosting. For
         * more information about health check, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests"
         * >How Your Container Should Respond to Health Check (Ping) Requests</a>.
         * </p>
         * 
         * @param containerStartupHealthCheckTimeoutInSeconds
         *        The timeout value, in seconds, for your inference container to pass health check by Amazon S3 Hosting.
         *        For more information about health check, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests"
         *        >How Your Container Should Respond to Health Check (Ping) Requests</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerStartupHealthCheckTimeoutInSeconds(Integer containerStartupHealthCheckTimeoutInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer modelDataDownloadTimeoutInSeconds;

        private Integer containerStartupHealthCheckTimeoutInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceComponentStartupParameters model) {
            modelDataDownloadTimeoutInSeconds(model.modelDataDownloadTimeoutInSeconds);
            containerStartupHealthCheckTimeoutInSeconds(model.containerStartupHealthCheckTimeoutInSeconds);
        }

        public final Integer getModelDataDownloadTimeoutInSeconds() {
            return modelDataDownloadTimeoutInSeconds;
        }

        public final void setModelDataDownloadTimeoutInSeconds(Integer modelDataDownloadTimeoutInSeconds) {
            this.modelDataDownloadTimeoutInSeconds = modelDataDownloadTimeoutInSeconds;
        }

        @Override
        public final Builder modelDataDownloadTimeoutInSeconds(Integer modelDataDownloadTimeoutInSeconds) {
            this.modelDataDownloadTimeoutInSeconds = modelDataDownloadTimeoutInSeconds;
            return this;
        }

        public final Integer getContainerStartupHealthCheckTimeoutInSeconds() {
            return containerStartupHealthCheckTimeoutInSeconds;
        }

        public final void setContainerStartupHealthCheckTimeoutInSeconds(Integer containerStartupHealthCheckTimeoutInSeconds) {
            this.containerStartupHealthCheckTimeoutInSeconds = containerStartupHealthCheckTimeoutInSeconds;
        }

        @Override
        public final Builder containerStartupHealthCheckTimeoutInSeconds(Integer containerStartupHealthCheckTimeoutInSeconds) {
            this.containerStartupHealthCheckTimeoutInSeconds = containerStartupHealthCheckTimeoutInSeconds;
            return this;
        }

        @Override
        public InferenceComponentStartupParameters build() {
            return new InferenceComponentStartupParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
