/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon S3 location and configuration for storing inference request and response data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceExperimentDataStorageConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceExperimentDataStorageConfig.Builder, InferenceExperimentDataStorageConfig> {
    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(InferenceExperimentDataStorageConfig::destination))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KmsKey")
            .getter(getter(InferenceExperimentDataStorageConfig::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()).build();

    private static final SdkField<CaptureContentTypeHeader> CONTENT_TYPE_FIELD = SdkField
            .<CaptureContentTypeHeader> builder(MarshallingType.SDK_POJO).memberName("ContentType")
            .getter(getter(InferenceExperimentDataStorageConfig::contentType)).setter(setter(Builder::contentType))
            .constructor(CaptureContentTypeHeader::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD,
            KMS_KEY_FIELD, CONTENT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destination;

    private final String kmsKey;

    private final CaptureContentTypeHeader contentType;

    private InferenceExperimentDataStorageConfig(BuilderImpl builder) {
        this.destination = builder.destination;
        this.kmsKey = builder.kmsKey;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The Amazon S3 bucket where the inference request and response data is stored.
     * </p>
     * 
     * @return The Amazon S3 bucket where the inference request and response data is stored.
     */
    public final String destination() {
        return destination;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt captured data at rest
     * using Amazon S3 server-side encryption.
     * </p>
     * 
     * @return The Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt captured data at
     *         rest using Amazon S3 server-side encryption.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * Returns the value of the ContentType property for this object.
     * 
     * @return The value of the ContentType property for this object.
     */
    public final CaptureContentTypeHeader contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceExperimentDataStorageConfig)) {
            return false;
        }
        InferenceExperimentDataStorageConfig other = (InferenceExperimentDataStorageConfig) obj;
        return Objects.equals(destination(), other.destination()) && Objects.equals(kmsKey(), other.kmsKey())
                && Objects.equals(contentType(), other.contentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceExperimentDataStorageConfig").add("Destination", destination()).add("KmsKey", kmsKey())
                .add("ContentType", contentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "KmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Destination", DESTINATION_FIELD);
        map.put("KmsKey", KMS_KEY_FIELD);
        map.put("ContentType", CONTENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceExperimentDataStorageConfig, T> g) {
        return obj -> g.apply((InferenceExperimentDataStorageConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceExperimentDataStorageConfig> {
        /**
         * <p>
         * The Amazon S3 bucket where the inference request and response data is stored.
         * </p>
         * 
         * @param destination
         *        The Amazon S3 bucket where the inference request and response data is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt captured data at
         * rest using Amazon S3 server-side encryption.
         * </p>
         * 
         * @param kmsKey
         *        The Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt captured data
         *        at rest using Amazon S3 server-side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * Sets the value of the ContentType property for this object.
         *
         * @param contentType
         *        The new value for the ContentType property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(CaptureContentTypeHeader contentType);

        /**
         * Sets the value of the ContentType property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CaptureContentTypeHeader.Builder}
         * avoiding the need to create one manually via {@link CaptureContentTypeHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CaptureContentTypeHeader.Builder#build()} is called immediately
         * and its result is passed to {@link #contentType(CaptureContentTypeHeader)}.
         * 
         * @param contentType
         *        a consumer that will call methods on {@link CaptureContentTypeHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentType(CaptureContentTypeHeader)
         */
        default Builder contentType(Consumer<CaptureContentTypeHeader.Builder> contentType) {
            return contentType(CaptureContentTypeHeader.builder().applyMutation(contentType).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String destination;

        private String kmsKey;

        private CaptureContentTypeHeader contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceExperimentDataStorageConfig model) {
            destination(model.destination);
            kmsKey(model.kmsKey);
            contentType(model.contentType);
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final CaptureContentTypeHeader.Builder getContentType() {
            return contentType != null ? contentType.toBuilder() : null;
        }

        public final void setContentType(CaptureContentTypeHeader.BuilderImpl contentType) {
            this.contentType = contentType != null ? contentType.build() : null;
        }

        @Override
        public final Builder contentType(CaptureContentTypeHeader contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public InferenceExperimentDataStorageConfig build() {
            return new InferenceExperimentDataStorageConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
