/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHubContentsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListHubContentsRequest.Builder, ListHubContentsRequest> {
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubName").getter(getter(ListHubContentsRequest::hubName)).setter(setter(Builder::hubName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()).build();

    private static final SdkField<String> HUB_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentType").getter(getter(ListHubContentsRequest::hubContentTypeAsString))
            .setter(setter(Builder::hubContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentType").build()).build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameContains").getter(getter(ListHubContentsRequest::nameContains))
            .setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<String> MAX_SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxSchemaVersion").getter(getter(ListHubContentsRequest::maxSchemaVersion))
            .setter(setter(Builder::maxSchemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSchemaVersion").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListHubContentsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListHubContentsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListHubContentsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListHubContentsRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListHubContentsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListHubContentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_NAME_FIELD,
            HUB_CONTENT_TYPE_FIELD, NAME_CONTAINS_FIELD, MAX_SCHEMA_VERSION_FIELD, CREATION_TIME_BEFORE_FIELD,
            CREATION_TIME_AFTER_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hubName;

    private final String hubContentType;

    private final String nameContains;

    private final String maxSchemaVersion;

    private final Instant creationTimeBefore;

    private final Instant creationTimeAfter;

    private final String sortBy;

    private final String sortOrder;

    private final Integer maxResults;

    private final String nextToken;

    private ListHubContentsRequest(BuilderImpl builder) {
        super(builder);
        this.hubName = builder.hubName;
        this.hubContentType = builder.hubContentType;
        this.nameContains = builder.nameContains;
        this.maxSchemaVersion = builder.maxSchemaVersion;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the hub to list the contents of.
     * </p>
     * 
     * @return The name of the hub to list the contents of.
     */
    public final String hubName() {
        return hubName;
    }

    /**
     * <p>
     * The type of hub content to list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubContentType}
     * will return {@link HubContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubContentTypeAsString}.
     * </p>
     * 
     * @return The type of hub content to list.
     * @see HubContentType
     */
    public final HubContentType hubContentType() {
        return HubContentType.fromValue(hubContentType);
    }

    /**
     * <p>
     * The type of hub content to list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubContentType}
     * will return {@link HubContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubContentTypeAsString}.
     * </p>
     * 
     * @return The type of hub content to list.
     * @see HubContentType
     */
    public final String hubContentTypeAsString() {
        return hubContentType;
    }

    /**
     * <p>
     * Only list hub content if the name contains the specified string.
     * </p>
     * 
     * @return Only list hub content if the name contains the specified string.
     */
    public final String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * The upper bound of the hub content schema verion.
     * </p>
     * 
     * @return The upper bound of the hub content schema verion.
     */
    public final String maxSchemaVersion() {
        return maxSchemaVersion;
    }

    /**
     * <p>
     * Only list hub content that was created before the time specified.
     * </p>
     * 
     * @return Only list hub content that was created before the time specified.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * Only list hub content that was created after the time specified.
     * </p>
     * 
     * @return Only list hub content that was created after the time specified.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * Sort hub content versions by either name or creation time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link HubContentSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return Sort hub content versions by either name or creation time.
     * @see HubContentSortBy
     */
    public final HubContentSortBy sortBy() {
        return HubContentSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * Sort hub content versions by either name or creation time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link HubContentSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return Sort hub content versions by either name or creation time.
     * @see HubContentSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * Sort hubs by ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Sort hubs by ascending or descending order.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Sort hubs by ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Sort hubs by ascending or descending order.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The maximum amount of hub content to list.
     * </p>
     * 
     * @return The maximum amount of hub content to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the response to a previous <code>ListHubContents</code> request was truncated, the response includes a
     * <code>NextToken</code>. To retrieve the next set of hub content, use the token in the next request.
     * </p>
     * 
     * @return If the response to a previous <code>ListHubContents</code> request was truncated, the response includes a
     *         <code>NextToken</code>. To retrieve the next set of hub content, use the token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hubName());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(maxSchemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHubContentsRequest)) {
            return false;
        }
        ListHubContentsRequest other = (ListHubContentsRequest) obj;
        return Objects.equals(hubName(), other.hubName())
                && Objects.equals(hubContentTypeAsString(), other.hubContentTypeAsString())
                && Objects.equals(nameContains(), other.nameContains())
                && Objects.equals(maxSchemaVersion(), other.maxSchemaVersion())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHubContentsRequest").add("HubName", hubName())
                .add("HubContentType", hubContentTypeAsString()).add("NameContains", nameContains())
                .add("MaxSchemaVersion", maxSchemaVersion()).add("CreationTimeBefore", creationTimeBefore())
                .add("CreationTimeAfter", creationTimeAfter()).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubName":
            return Optional.ofNullable(clazz.cast(hubName()));
        case "HubContentType":
            return Optional.ofNullable(clazz.cast(hubContentTypeAsString()));
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "MaxSchemaVersion":
            return Optional.ofNullable(clazz.cast(maxSchemaVersion()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HubName", HUB_NAME_FIELD);
        map.put("HubContentType", HUB_CONTENT_TYPE_FIELD);
        map.put("NameContains", NAME_CONTAINS_FIELD);
        map.put("MaxSchemaVersion", MAX_SCHEMA_VERSION_FIELD);
        map.put("CreationTimeBefore", CREATION_TIME_BEFORE_FIELD);
        map.put("CreationTimeAfter", CREATION_TIME_AFTER_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListHubContentsRequest, T> g) {
        return obj -> g.apply((ListHubContentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListHubContentsRequest> {
        /**
         * <p>
         * The name of the hub to list the contents of.
         * </p>
         * 
         * @param hubName
         *        The name of the hub to list the contents of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubName(String hubName);

        /**
         * <p>
         * The type of hub content to list.
         * </p>
         * 
         * @param hubContentType
         *        The type of hub content to list.
         * @see HubContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentType
         */
        Builder hubContentType(String hubContentType);

        /**
         * <p>
         * The type of hub content to list.
         * </p>
         * 
         * @param hubContentType
         *        The type of hub content to list.
         * @see HubContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentType
         */
        Builder hubContentType(HubContentType hubContentType);

        /**
         * <p>
         * Only list hub content if the name contains the specified string.
         * </p>
         * 
         * @param nameContains
         *        Only list hub content if the name contains the specified string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * The upper bound of the hub content schema verion.
         * </p>
         * 
         * @param maxSchemaVersion
         *        The upper bound of the hub content schema verion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSchemaVersion(String maxSchemaVersion);

        /**
         * <p>
         * Only list hub content that was created before the time specified.
         * </p>
         * 
         * @param creationTimeBefore
         *        Only list hub content that was created before the time specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * Only list hub content that was created after the time specified.
         * </p>
         * 
         * @param creationTimeAfter
         *        Only list hub content that was created after the time specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * Sort hub content versions by either name or creation time.
         * </p>
         * 
         * @param sortBy
         *        Sort hub content versions by either name or creation time.
         * @see HubContentSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Sort hub content versions by either name or creation time.
         * </p>
         * 
         * @param sortBy
         *        Sort hub content versions by either name or creation time.
         * @see HubContentSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentSortBy
         */
        Builder sortBy(HubContentSortBy sortBy);

        /**
         * <p>
         * Sort hubs by ascending or descending order.
         * </p>
         * 
         * @param sortOrder
         *        Sort hubs by ascending or descending order.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Sort hubs by ascending or descending order.
         * </p>
         * 
         * @param sortOrder
         *        Sort hubs by ascending or descending order.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The maximum amount of hub content to list.
         * </p>
         * 
         * @param maxResults
         *        The maximum amount of hub content to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the response to a previous <code>ListHubContents</code> request was truncated, the response includes a
         * <code>NextToken</code>. To retrieve the next set of hub content, use the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response to a previous <code>ListHubContents</code> request was truncated, the response
         *        includes a <code>NextToken</code>. To retrieve the next set of hub content, use the token in the next
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String hubName;

        private String hubContentType;

        private String nameContains;

        private String maxSchemaVersion;

        private Instant creationTimeBefore;

        private Instant creationTimeAfter;

        private String sortBy;

        private String sortOrder;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHubContentsRequest model) {
            super(model);
            hubName(model.hubName);
            hubContentType(model.hubContentType);
            nameContains(model.nameContains);
            maxSchemaVersion(model.maxSchemaVersion);
            creationTimeBefore(model.creationTimeBefore);
            creationTimeAfter(model.creationTimeAfter);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getHubName() {
            return hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubContentType() {
            return hubContentType;
        }

        public final void setHubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
        }

        @Override
        public final Builder hubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
            return this;
        }

        @Override
        public final Builder hubContentType(HubContentType hubContentType) {
            this.hubContentType(hubContentType == null ? null : hubContentType.toString());
            return this;
        }

        public final String getNameContains() {
            return nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final String getMaxSchemaVersion() {
            return maxSchemaVersion;
        }

        public final void setMaxSchemaVersion(String maxSchemaVersion) {
            this.maxSchemaVersion = maxSchemaVersion;
        }

        @Override
        public final Builder maxSchemaVersion(String maxSchemaVersion) {
            this.maxSchemaVersion = maxSchemaVersion;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(HubContentSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListHubContentsRequest build() {
            return new ListHubContentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
