/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMlflowTrackingServersRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListMlflowTrackingServersRequest.Builder, ListMlflowTrackingServersRequest> {
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAfter").getter(getter(ListMlflowTrackingServersRequest::createdAfter))
            .setter(setter(Builder::createdAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAfter").build()).build();

    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedBefore").getter(getter(ListMlflowTrackingServersRequest::createdBefore))
            .setter(setter(Builder::createdBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBefore").build()).build();

    private static final SdkField<String> TRACKING_SERVER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackingServerStatus").getter(getter(ListMlflowTrackingServersRequest::trackingServerStatusAsString))
            .setter(setter(Builder::trackingServerStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerStatus").build())
            .build();

    private static final SdkField<String> MLFLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MlflowVersion").getter(getter(ListMlflowTrackingServersRequest::mlflowVersion))
            .setter(setter(Builder::mlflowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlflowVersion").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListMlflowTrackingServersRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListMlflowTrackingServersRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMlflowTrackingServersRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListMlflowTrackingServersRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AFTER_FIELD,
            CREATED_BEFORE_FIELD, TRACKING_SERVER_STATUS_FIELD, MLFLOW_VERSION_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createdAfter;

    private final Instant createdBefore;

    private final String trackingServerStatus;

    private final String mlflowVersion;

    private final String sortBy;

    private final String sortOrder;

    private final String nextToken;

    private final Integer maxResults;

    private ListMlflowTrackingServersRequest(BuilderImpl builder) {
        super(builder);
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.trackingServerStatus = builder.trackingServerStatus;
        this.mlflowVersion = builder.mlflowVersion;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Use the <code>CreatedAfter</code> filter to only list tracking servers created after a specific date and time.
     * Listed tracking servers are shown with a date and time such as <code>"2024-03-16T01:46:56+00:00"</code>. The
     * <code>CreatedAfter</code> parameter takes in a Unix timestamp. To convert a date and time into a Unix timestamp,
     * see <a href="https://www.epochconverter.com/">EpochConverter</a>.
     * </p>
     * 
     * @return Use the <code>CreatedAfter</code> filter to only list tracking servers created after a specific date and
     *         time. Listed tracking servers are shown with a date and time such as
     *         <code>"2024-03-16T01:46:56+00:00"</code>. The <code>CreatedAfter</code> parameter takes in a Unix
     *         timestamp. To convert a date and time into a Unix timestamp, see <a
     *         href="https://www.epochconverter.com/">EpochConverter</a>.
     */
    public final Instant createdAfter() {
        return createdAfter;
    }

    /**
     * <p>
     * Use the <code>CreatedBefore</code> filter to only list tracking servers created before a specific date and time.
     * Listed tracking servers are shown with a date and time such as <code>"2024-03-16T01:46:56+00:00"</code>. The
     * <code>CreatedBefore</code> parameter takes in a Unix timestamp. To convert a date and time into a Unix timestamp,
     * see <a href="https://www.epochconverter.com/">EpochConverter</a>.
     * </p>
     * 
     * @return Use the <code>CreatedBefore</code> filter to only list tracking servers created before a specific date
     *         and time. Listed tracking servers are shown with a date and time such as
     *         <code>"2024-03-16T01:46:56+00:00"</code>. The <code>CreatedBefore</code> parameter takes in a Unix
     *         timestamp. To convert a date and time into a Unix timestamp, see <a
     *         href="https://www.epochconverter.com/">EpochConverter</a>.
     */
    public final Instant createdBefore() {
        return createdBefore;
    }

    /**
     * <p>
     * Filter for tracking servers with a specified creation status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trackingServerStatus} will return {@link TrackingServerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trackingServerStatusAsString}.
     * </p>
     * 
     * @return Filter for tracking servers with a specified creation status.
     * @see TrackingServerStatus
     */
    public final TrackingServerStatus trackingServerStatus() {
        return TrackingServerStatus.fromValue(trackingServerStatus);
    }

    /**
     * <p>
     * Filter for tracking servers with a specified creation status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trackingServerStatus} will return {@link TrackingServerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trackingServerStatusAsString}.
     * </p>
     * 
     * @return Filter for tracking servers with a specified creation status.
     * @see TrackingServerStatus
     */
    public final String trackingServerStatusAsString() {
        return trackingServerStatus;
    }

    /**
     * <p>
     * Filter for tracking servers using the specified MLflow version.
     * </p>
     * 
     * @return Filter for tracking servers using the specified MLflow version.
     */
    public final String mlflowVersion() {
        return mlflowVersion;
    }

    /**
     * <p>
     * Filter for trackings servers sorting by name, creation time, or creation status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortTrackingServerBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return Filter for trackings servers sorting by name, creation time, or creation status.
     * @see SortTrackingServerBy
     */
    public final SortTrackingServerBy sortBy() {
        return SortTrackingServerBy.fromValue(sortBy);
    }

    /**
     * <p>
     * Filter for trackings servers sorting by name, creation time, or creation status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortTrackingServerBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return Filter for trackings servers sorting by name, creation time, or creation status.
     * @see SortTrackingServerBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * Change the order of the listed tracking servers. By default, tracking servers are listed in
     * <code>Descending</code> order by creation time. To change the list order, you can specify <code>SortOrder</code>
     * to be <code>Ascending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Change the order of the listed tracking servers. By default, tracking servers are listed in
     *         <code>Descending</code> order by creation time. To change the list order, you can specify
     *         <code>SortOrder</code> to be <code>Ascending</code>.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Change the order of the listed tracking servers. By default, tracking servers are listed in
     * <code>Descending</code> order by creation time. To change the list order, you can specify <code>SortOrder</code>
     * to be <code>Ascending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Change the order of the listed tracking servers. By default, tracking servers are listed in
     *         <code>Descending</code> order by creation time. To change the list order, you can specify
     *         <code>SortOrder</code> to be <code>Ascending</code>.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * If the previous response was truncated, you will receive this token. Use it in your next request to receive the
     * next set of results.
     * </p>
     * 
     * @return If the previous response was truncated, you will receive this token. Use it in your next request to
     *         receive the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of tracking servers to list.
     * </p>
     * 
     * @return The maximum number of tracking servers to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(trackingServerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mlflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMlflowTrackingServersRequest)) {
            return false;
        }
        ListMlflowTrackingServersRequest other = (ListMlflowTrackingServersRequest) obj;
        return Objects.equals(createdAfter(), other.createdAfter()) && Objects.equals(createdBefore(), other.createdBefore())
                && Objects.equals(trackingServerStatusAsString(), other.trackingServerStatusAsString())
                && Objects.equals(mlflowVersion(), other.mlflowVersion())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMlflowTrackingServersRequest").add("CreatedAfter", createdAfter())
                .add("CreatedBefore", createdBefore()).add("TrackingServerStatus", trackingServerStatusAsString())
                .add("MlflowVersion", mlflowVersion()).add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAfter":
            return Optional.ofNullable(clazz.cast(createdAfter()));
        case "CreatedBefore":
            return Optional.ofNullable(clazz.cast(createdBefore()));
        case "TrackingServerStatus":
            return Optional.ofNullable(clazz.cast(trackingServerStatusAsString()));
        case "MlflowVersion":
            return Optional.ofNullable(clazz.cast(mlflowVersion()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreatedAfter", CREATED_AFTER_FIELD);
        map.put("CreatedBefore", CREATED_BEFORE_FIELD);
        map.put("TrackingServerStatus", TRACKING_SERVER_STATUS_FIELD);
        map.put("MlflowVersion", MLFLOW_VERSION_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMlflowTrackingServersRequest, T> g) {
        return obj -> g.apply((ListMlflowTrackingServersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMlflowTrackingServersRequest> {
        /**
         * <p>
         * Use the <code>CreatedAfter</code> filter to only list tracking servers created after a specific date and
         * time. Listed tracking servers are shown with a date and time such as <code>"2024-03-16T01:46:56+00:00"</code>
         * . The <code>CreatedAfter</code> parameter takes in a Unix timestamp. To convert a date and time into a Unix
         * timestamp, see <a href="https://www.epochconverter.com/">EpochConverter</a>.
         * </p>
         * 
         * @param createdAfter
         *        Use the <code>CreatedAfter</code> filter to only list tracking servers created after a specific date
         *        and time. Listed tracking servers are shown with a date and time such as
         *        <code>"2024-03-16T01:46:56+00:00"</code>. The <code>CreatedAfter</code> parameter takes in a Unix
         *        timestamp. To convert a date and time into a Unix timestamp, see <a
         *        href="https://www.epochconverter.com/">EpochConverter</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAfter(Instant createdAfter);

        /**
         * <p>
         * Use the <code>CreatedBefore</code> filter to only list tracking servers created before a specific date and
         * time. Listed tracking servers are shown with a date and time such as <code>"2024-03-16T01:46:56+00:00"</code>
         * . The <code>CreatedBefore</code> parameter takes in a Unix timestamp. To convert a date and time into a Unix
         * timestamp, see <a href="https://www.epochconverter.com/">EpochConverter</a>.
         * </p>
         * 
         * @param createdBefore
         *        Use the <code>CreatedBefore</code> filter to only list tracking servers created before a specific date
         *        and time. Listed tracking servers are shown with a date and time such as
         *        <code>"2024-03-16T01:46:56+00:00"</code>. The <code>CreatedBefore</code> parameter takes in a Unix
         *        timestamp. To convert a date and time into a Unix timestamp, see <a
         *        href="https://www.epochconverter.com/">EpochConverter</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBefore(Instant createdBefore);

        /**
         * <p>
         * Filter for tracking servers with a specified creation status.
         * </p>
         * 
         * @param trackingServerStatus
         *        Filter for tracking servers with a specified creation status.
         * @see TrackingServerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrackingServerStatus
         */
        Builder trackingServerStatus(String trackingServerStatus);

        /**
         * <p>
         * Filter for tracking servers with a specified creation status.
         * </p>
         * 
         * @param trackingServerStatus
         *        Filter for tracking servers with a specified creation status.
         * @see TrackingServerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrackingServerStatus
         */
        Builder trackingServerStatus(TrackingServerStatus trackingServerStatus);

        /**
         * <p>
         * Filter for tracking servers using the specified MLflow version.
         * </p>
         * 
         * @param mlflowVersion
         *        Filter for tracking servers using the specified MLflow version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlflowVersion(String mlflowVersion);

        /**
         * <p>
         * Filter for trackings servers sorting by name, creation time, or creation status.
         * </p>
         * 
         * @param sortBy
         *        Filter for trackings servers sorting by name, creation time, or creation status.
         * @see SortTrackingServerBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortTrackingServerBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Filter for trackings servers sorting by name, creation time, or creation status.
         * </p>
         * 
         * @param sortBy
         *        Filter for trackings servers sorting by name, creation time, or creation status.
         * @see SortTrackingServerBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortTrackingServerBy
         */
        Builder sortBy(SortTrackingServerBy sortBy);

        /**
         * <p>
         * Change the order of the listed tracking servers. By default, tracking servers are listed in
         * <code>Descending</code> order by creation time. To change the list order, you can specify
         * <code>SortOrder</code> to be <code>Ascending</code>.
         * </p>
         * 
         * @param sortOrder
         *        Change the order of the listed tracking servers. By default, tracking servers are listed in
         *        <code>Descending</code> order by creation time. To change the list order, you can specify
         *        <code>SortOrder</code> to be <code>Ascending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Change the order of the listed tracking servers. By default, tracking servers are listed in
         * <code>Descending</code> order by creation time. To change the list order, you can specify
         * <code>SortOrder</code> to be <code>Ascending</code>.
         * </p>
         * 
         * @param sortOrder
         *        Change the order of the listed tracking servers. By default, tracking servers are listed in
         *        <code>Descending</code> order by creation time. To change the list order, you can specify
         *        <code>SortOrder</code> to be <code>Ascending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * If the previous response was truncated, you will receive this token. Use it in your next request to receive
         * the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was truncated, you will receive this token. Use it in your next request to
         *        receive the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of tracking servers to list.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of tracking servers to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private Instant createdAfter;

        private Instant createdBefore;

        private String trackingServerStatus;

        private String mlflowVersion;

        private String sortBy;

        private String sortOrder;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMlflowTrackingServersRequest model) {
            super(model);
            createdAfter(model.createdAfter);
            createdBefore(model.createdBefore);
            trackingServerStatus(model.trackingServerStatus);
            mlflowVersion(model.mlflowVersion);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Instant getCreatedAfter() {
            return createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final Instant getCreatedBefore() {
            return createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final String getTrackingServerStatus() {
            return trackingServerStatus;
        }

        public final void setTrackingServerStatus(String trackingServerStatus) {
            this.trackingServerStatus = trackingServerStatus;
        }

        @Override
        public final Builder trackingServerStatus(String trackingServerStatus) {
            this.trackingServerStatus = trackingServerStatus;
            return this;
        }

        @Override
        public final Builder trackingServerStatus(TrackingServerStatus trackingServerStatus) {
            this.trackingServerStatus(trackingServerStatus == null ? null : trackingServerStatus.toString());
            return this;
        }

        public final String getMlflowVersion() {
            return mlflowVersion;
        }

        public final void setMlflowVersion(String mlflowVersion) {
            this.mlflowVersion = mlflowVersion;
        }

        @Override
        public final Builder mlflowVersion(String mlflowVersion) {
            this.mlflowVersion = mlflowVersion;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortTrackingServerBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMlflowTrackingServersRequest build() {
            return new ListMlflowTrackingServersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
