/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkforcesResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListWorkforcesResponse.Builder, ListWorkforcesResponse> {
    private static final SdkField<List<Workforce>> WORKFORCES_FIELD = SdkField
            .<List<Workforce>> builder(MarshallingType.LIST)
            .memberName("Workforces")
            .getter(getter(ListWorkforcesResponse::workforces))
            .setter(setter(Builder::workforces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workforces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Workforce> builder(MarshallingType.SDK_POJO)
                                            .constructor(Workforce::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListWorkforcesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFORCES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Workforce> workforces;

    private final String nextToken;

    private ListWorkforcesResponse(BuilderImpl builder) {
        super(builder);
        this.workforces = builder.workforces;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Workforces property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorkforces() {
        return workforces != null && !(workforces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing information about your workforce.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkforces} method.
     * </p>
     * 
     * @return A list containing information about your workforce.
     */
    public final List<Workforce> workforces() {
        return workforces;
    }

    /**
     * <p>
     * A token to resume pagination.
     * </p>
     * 
     * @return A token to resume pagination.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkforces() ? workforces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkforcesResponse)) {
            return false;
        }
        ListWorkforcesResponse other = (ListWorkforcesResponse) obj;
        return hasWorkforces() == other.hasWorkforces() && Objects.equals(workforces(), other.workforces())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkforcesResponse").add("Workforces", hasWorkforces() ? workforces() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Workforces":
            return Optional.ofNullable(clazz.cast(workforces()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Workforces", WORKFORCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkforcesResponse, T> g) {
        return obj -> g.apply((ListWorkforcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWorkforcesResponse> {
        /**
         * <p>
         * A list containing information about your workforce.
         * </p>
         * 
         * @param workforces
         *        A list containing information about your workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workforces(Collection<Workforce> workforces);

        /**
         * <p>
         * A list containing information about your workforce.
         * </p>
         * 
         * @param workforces
         *        A list containing information about your workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workforces(Workforce... workforces);

        /**
         * <p>
         * A list containing information about your workforce.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Workforce.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sagemaker.model.Workforce#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Workforce.Builder#build()} is called immediately and
         * its result is passed to {@link #workforces(List<Workforce>)}.
         * 
         * @param workforces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Workforce.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workforces(java.util.Collection<Workforce>)
         */
        Builder workforces(Consumer<Workforce.Builder>... workforces);

        /**
         * <p>
         * A token to resume pagination.
         * </p>
         * 
         * @param nextToken
         *        A token to resume pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<Workforce> workforces = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkforcesResponse model) {
            super(model);
            workforces(model.workforces);
            nextToken(model.nextToken);
        }

        public final List<Workforce.Builder> getWorkforces() {
            List<Workforce.Builder> result = WorkforcesCopier.copyToBuilder(this.workforces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkforces(Collection<Workforce.BuilderImpl> workforces) {
            this.workforces = WorkforcesCopier.copyFromBuilder(workforces);
        }

        @Override
        public final Builder workforces(Collection<Workforce> workforces) {
            this.workforces = WorkforcesCopier.copy(workforces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workforces(Workforce... workforces) {
            workforces(Arrays.asList(workforces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workforces(Consumer<Workforce.Builder>... workforces) {
            workforces(Stream.of(workforces).map(c -> Workforce.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWorkforcesResponse build() {
            return new ListWorkforcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
