/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the metric for a candidate produced by an AutoML job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricDatum implements SdkPojo, Serializable, ToCopyableBuilder<MetricDatum.Builder, MetricDatum> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(MetricDatum::metricNameAsString)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> STANDARD_METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StandardMetricName").getter(getter(MetricDatum::standardMetricNameAsString))
            .setter(setter(Builder::standardMetricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardMetricName").build())
            .build();

    private static final SdkField<Float> VALUE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Value")
            .getter(getter(MetricDatum::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> SET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Set")
            .getter(getter(MetricDatum::setAsString)).setter(setter(Builder::set))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Set").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            STANDARD_METRIC_NAME_FIELD, VALUE_FIELD, SET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String metricName;

    private final String standardMetricName;

    private final Float value;

    private final String set;

    private MetricDatum(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.standardMetricName = builder.standardMetricName;
        this.value = builder.value;
        this.set = builder.set;
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link AutoMLMetricEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricNameAsString}.
     * </p>
     * 
     * @return The name of the metric.
     * @see AutoMLMetricEnum
     */
    public final AutoMLMetricEnum metricName() {
        return AutoMLMetricEnum.fromValue(metricName);
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link AutoMLMetricEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricNameAsString}.
     * </p>
     * 
     * @return The name of the metric.
     * @see AutoMLMetricEnum
     */
    public final String metricNameAsString() {
        return metricName;
    }

    /**
     * <p>
     * The name of the standard metric.
     * </p>
     * <note>
     * <p>
     * For definitions of the standard metrics, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-metrics">
     * <code>Autopilot candidate metrics</code> </a>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #standardMetricName} will return {@link AutoMLMetricExtendedEnum#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #standardMetricNameAsString}.
     * </p>
     * 
     * @return The name of the standard metric. </p> <note>
     *         <p>
     *         For definitions of the standard metrics, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-metrics"
     *         > <code>Autopilot candidate metrics</code> </a>.
     *         </p>
     * @see AutoMLMetricExtendedEnum
     */
    public final AutoMLMetricExtendedEnum standardMetricName() {
        return AutoMLMetricExtendedEnum.fromValue(standardMetricName);
    }

    /**
     * <p>
     * The name of the standard metric.
     * </p>
     * <note>
     * <p>
     * For definitions of the standard metrics, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-metrics">
     * <code>Autopilot candidate metrics</code> </a>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #standardMetricName} will return {@link AutoMLMetricExtendedEnum#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #standardMetricNameAsString}.
     * </p>
     * 
     * @return The name of the standard metric. </p> <note>
     *         <p>
     *         For definitions of the standard metrics, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-metrics"
     *         > <code>Autopilot candidate metrics</code> </a>.
     *         </p>
     * @see AutoMLMetricExtendedEnum
     */
    public final String standardMetricNameAsString() {
        return standardMetricName;
    }

    /**
     * <p>
     * The value of the metric.
     * </p>
     * 
     * @return The value of the metric.
     */
    public final Float value() {
        return value;
    }

    /**
     * <p>
     * The dataset split from which the AutoML job produced the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #set} will return
     * {@link MetricSetSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #setAsString}.
     * </p>
     * 
     * @return The dataset split from which the AutoML job produced the metric.
     * @see MetricSetSource
     */
    public final MetricSetSource set() {
        return MetricSetSource.fromValue(set);
    }

    /**
     * <p>
     * The dataset split from which the AutoML job produced the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #set} will return
     * {@link MetricSetSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #setAsString}.
     * </p>
     * 
     * @return The dataset split from which the AutoML job produced the metric.
     * @see MetricSetSource
     */
    public final String setAsString() {
        return set;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(standardMetricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(setAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDatum)) {
            return false;
        }
        MetricDatum other = (MetricDatum) obj;
        return Objects.equals(metricNameAsString(), other.metricNameAsString())
                && Objects.equals(standardMetricNameAsString(), other.standardMetricNameAsString())
                && Objects.equals(value(), other.value()) && Objects.equals(setAsString(), other.setAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricDatum").add("MetricName", metricNameAsString())
                .add("StandardMetricName", standardMetricNameAsString()).add("Value", value()).add("Set", setAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricNameAsString()));
        case "StandardMetricName":
            return Optional.ofNullable(clazz.cast(standardMetricNameAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Set":
            return Optional.ofNullable(clazz.cast(setAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("StandardMetricName", STANDARD_METRIC_NAME_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("Set", SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricDatum, T> g) {
        return obj -> g.apply((MetricDatum) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricDatum> {
        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param metricName
         *        The name of the metric.
         * @see AutoMLMetricEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLMetricEnum
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param metricName
         *        The name of the metric.
         * @see AutoMLMetricEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLMetricEnum
         */
        Builder metricName(AutoMLMetricEnum metricName);

        /**
         * <p>
         * The name of the standard metric.
         * </p>
         * <note>
         * <p>
         * For definitions of the standard metrics, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-metrics">
         * <code>Autopilot candidate metrics</code> </a>.
         * </p>
         * </note>
         * 
         * @param standardMetricName
         *        The name of the standard metric. </p> <note>
         *        <p>
         *        For definitions of the standard metrics, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-metrics"
         *        > <code>Autopilot candidate metrics</code> </a>.
         *        </p>
         * @see AutoMLMetricExtendedEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLMetricExtendedEnum
         */
        Builder standardMetricName(String standardMetricName);

        /**
         * <p>
         * The name of the standard metric.
         * </p>
         * <note>
         * <p>
         * For definitions of the standard metrics, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-metrics">
         * <code>Autopilot candidate metrics</code> </a>.
         * </p>
         * </note>
         * 
         * @param standardMetricName
         *        The name of the standard metric. </p> <note>
         *        <p>
         *        For definitions of the standard metrics, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-metrics"
         *        > <code>Autopilot candidate metrics</code> </a>.
         *        </p>
         * @see AutoMLMetricExtendedEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLMetricExtendedEnum
         */
        Builder standardMetricName(AutoMLMetricExtendedEnum standardMetricName);

        /**
         * <p>
         * The value of the metric.
         * </p>
         * 
         * @param value
         *        The value of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Float value);

        /**
         * <p>
         * The dataset split from which the AutoML job produced the metric.
         * </p>
         * 
         * @param set
         *        The dataset split from which the AutoML job produced the metric.
         * @see MetricSetSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricSetSource
         */
        Builder set(String set);

        /**
         * <p>
         * The dataset split from which the AutoML job produced the metric.
         * </p>
         * 
         * @param set
         *        The dataset split from which the AutoML job produced the metric.
         * @see MetricSetSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricSetSource
         */
        Builder set(MetricSetSource set);
    }

    static final class BuilderImpl implements Builder {
        private String metricName;

        private String standardMetricName;

        private Float value;

        private String set;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDatum model) {
            metricName(model.metricName);
            standardMetricName(model.standardMetricName);
            value(model.value);
            set(model.set);
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(AutoMLMetricEnum metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final String getStandardMetricName() {
            return standardMetricName;
        }

        public final void setStandardMetricName(String standardMetricName) {
            this.standardMetricName = standardMetricName;
        }

        @Override
        public final Builder standardMetricName(String standardMetricName) {
            this.standardMetricName = standardMetricName;
            return this;
        }

        @Override
        public final Builder standardMetricName(AutoMLMetricExtendedEnum standardMetricName) {
            this.standardMetricName(standardMetricName == null ? null : standardMetricName.toString());
            return this;
        }

        public final Float getValue() {
            return value;
        }

        public final void setValue(Float value) {
            this.value = value;
        }

        @Override
        public final Builder value(Float value) {
            this.value = value;
            return this;
        }

        public final String getSet() {
            return set;
        }

        public final void setSet(String set) {
            this.set = set;
        }

        @Override
        @Transient
        public final Builder set(String set) {
            this.set = set;
            return this;
        }

        @Override
        @Transient
        public final Builder set(MetricSetSource set) {
            this.set(set == null ? null : set.toString());
            return this;
        }

        @Override
        public MetricDatum build() {
            return new MetricDatum(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
