/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class MetricDefinitionListCopier {
    static List<MetricDefinition> copy(Collection<? extends MetricDefinition> metricDefinitionListParam) {
        List<MetricDefinition> list;
        if (metricDefinitionListParam == null || metricDefinitionListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MetricDefinition> modifiableList = new ArrayList<>(metricDefinitionListParam.size());
            metricDefinitionListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MetricDefinition> copyFromBuilder(Collection<? extends MetricDefinition.Builder> metricDefinitionListParam) {
        List<MetricDefinition> list;
        if (metricDefinitionListParam == null || metricDefinitionListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MetricDefinition> modifiableList = new ArrayList<>(metricDefinitionListParam.size());
            metricDefinitionListParam.forEach(entry -> {
                MetricDefinition member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MetricDefinition.Builder> copyToBuilder(Collection<? extends MetricDefinition> metricDefinitionListParam) {
        List<MetricDefinition.Builder> list;
        if (metricDefinitionListParam == null || metricDefinitionListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MetricDefinition.Builder> modifiableList = new ArrayList<>(metricDefinitionListParam.size());
            metricDefinitionListParam.forEach(entry -> {
                MetricDefinition.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
