/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The access configuration file to control access to the ML model. You can explicitly accept the model end-user license
 * agreement (EULA) within the <code>ModelAccessConfig</code>.
 * </p>
 * <ul>
 * <li>
 * <p>
 * If you are a Jumpstart user, see the <a href=
 * "https://docs.aws.amazon.com/sagemaker/latest/dg/jumpstart-foundation-models-choose.html#jumpstart-foundation-models-choose-eula"
 * >End-user license agreements</a> section for more details on accepting the EULA.
 * </p>
 * </li>
 * <li>
 * <p>
 * If you are an AutoML user, see the <i>Optional Parameters</i> section of <i>Create an AutoML job to fine-tune text
 * generation models using the API</i> for details on <a href=
 * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-create-experiment-finetune-llms.html#autopilot-llms-finetuning-api-optional-params"
 * >How to set the EULA acceptance when fine-tuning a model using the AutoML API</a>.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelAccessConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelAccessConfig.Builder, ModelAccessConfig> {
    private static final SdkField<Boolean> ACCEPT_EULA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AcceptEula").getter(getter(ModelAccessConfig::acceptEula)).setter(setter(Builder::acceptEula))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptEula").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_EULA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean acceptEula;

    private ModelAccessConfig(BuilderImpl builder) {
        this.acceptEula = builder.acceptEula;
    }

    /**
     * <p>
     * Specifies agreement to the model end-user license agreement (EULA). The <code>AcceptEula</code> value must be
     * explicitly defined as <code>True</code> in order to accept the EULA that this model requires. You are responsible
     * for reviewing and complying with any applicable license terms and making sure they are acceptable for your use
     * case before downloading or using a model.
     * </p>
     * 
     * @return Specifies agreement to the model end-user license agreement (EULA). The <code>AcceptEula</code> value
     *         must be explicitly defined as <code>True</code> in order to accept the EULA that this model requires. You
     *         are responsible for reviewing and complying with any applicable license terms and making sure they are
     *         acceptable for your use case before downloading or using a model.
     */
    public final Boolean acceptEula() {
        return acceptEula;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acceptEula());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelAccessConfig)) {
            return false;
        }
        ModelAccessConfig other = (ModelAccessConfig) obj;
        return Objects.equals(acceptEula(), other.acceptEula());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelAccessConfig").add("AcceptEula", acceptEula()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptEula":
            return Optional.ofNullable(clazz.cast(acceptEula()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AcceptEula", ACCEPT_EULA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelAccessConfig, T> g) {
        return obj -> g.apply((ModelAccessConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelAccessConfig> {
        /**
         * <p>
         * Specifies agreement to the model end-user license agreement (EULA). The <code>AcceptEula</code> value must be
         * explicitly defined as <code>True</code> in order to accept the EULA that this model requires. You are
         * responsible for reviewing and complying with any applicable license terms and making sure they are acceptable
         * for your use case before downloading or using a model.
         * </p>
         * 
         * @param acceptEula
         *        Specifies agreement to the model end-user license agreement (EULA). The <code>AcceptEula</code> value
         *        must be explicitly defined as <code>True</code> in order to accept the EULA that this model requires.
         *        You are responsible for reviewing and complying with any applicable license terms and making sure they
         *        are acceptable for your use case before downloading or using a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptEula(Boolean acceptEula);
    }

    static final class BuilderImpl implements Builder {
        private Boolean acceptEula;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelAccessConfig model) {
            acceptEula(model.acceptEula);
        }

        public final Boolean getAcceptEula() {
            return acceptEula;
        }

        public final void setAcceptEula(Boolean acceptEula) {
            this.acceptEula = acceptEula;
        }

        @Override
        public final Builder acceptEula(Boolean acceptEula) {
            this.acceptEula = acceptEula;
            return this;
        }

        @Override
        public ModelAccessConfig build() {
            return new ModelAccessConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
