/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the Amazon SageMaker Model Card export job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelCardExportJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelCardExportJobSummary.Builder, ModelCardExportJobSummary> {
    private static final SdkField<String> MODEL_CARD_EXPORT_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardExportJobName").getter(getter(ModelCardExportJobSummary::modelCardExportJobName))
            .setter(setter(Builder::modelCardExportJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardExportJobName").build())
            .build();

    private static final SdkField<String> MODEL_CARD_EXPORT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardExportJobArn").getter(getter(ModelCardExportJobSummary::modelCardExportJobArn))
            .setter(setter(Builder::modelCardExportJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardExportJobArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ModelCardExportJobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MODEL_CARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardName").getter(getter(ModelCardExportJobSummary::modelCardName))
            .setter(setter(Builder::modelCardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardName").build()).build();

    private static final SdkField<Integer> MODEL_CARD_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ModelCardVersion").getter(getter(ModelCardExportJobSummary::modelCardVersion))
            .setter(setter(Builder::modelCardVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardVersion").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(ModelCardExportJobSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedAt").getter(getter(ModelCardExportJobSummary::lastModifiedAt))
            .setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MODEL_CARD_EXPORT_JOB_NAME_FIELD, MODEL_CARD_EXPORT_JOB_ARN_FIELD, STATUS_FIELD, MODEL_CARD_NAME_FIELD,
            MODEL_CARD_VERSION_FIELD, CREATED_AT_FIELD, LAST_MODIFIED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelCardExportJobName;

    private final String modelCardExportJobArn;

    private final String status;

    private final String modelCardName;

    private final Integer modelCardVersion;

    private final Instant createdAt;

    private final Instant lastModifiedAt;

    private ModelCardExportJobSummary(BuilderImpl builder) {
        this.modelCardExportJobName = builder.modelCardExportJobName;
        this.modelCardExportJobArn = builder.modelCardExportJobArn;
        this.status = builder.status;
        this.modelCardName = builder.modelCardName;
        this.modelCardVersion = builder.modelCardVersion;
        this.createdAt = builder.createdAt;
        this.lastModifiedAt = builder.lastModifiedAt;
    }

    /**
     * <p>
     * The name of the model card export job.
     * </p>
     * 
     * @return The name of the model card export job.
     */
    public final String modelCardExportJobName() {
        return modelCardExportJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model card export job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model card export job.
     */
    public final String modelCardExportJobArn() {
        return modelCardExportJobArn;
    }

    /**
     * <p>
     * The completion status of the model card export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelCardExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The completion status of the model card export job.
     * @see ModelCardExportJobStatus
     */
    public final ModelCardExportJobStatus status() {
        return ModelCardExportJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The completion status of the model card export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelCardExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The completion status of the model card export job.
     * @see ModelCardExportJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The name of the model card that the export job exports.
     * </p>
     * 
     * @return The name of the model card that the export job exports.
     */
    public final String modelCardName() {
        return modelCardName;
    }

    /**
     * <p>
     * The version of the model card that the export job exports.
     * </p>
     * 
     * @return The version of the model card that the export job exports.
     */
    public final Integer modelCardVersion() {
        return modelCardVersion;
    }

    /**
     * <p>
     * The date and time that the model card export job was created.
     * </p>
     * 
     * @return The date and time that the model card export job was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time that the model card export job was last modified..
     * </p>
     * 
     * @return The date and time that the model card export job was last modified..
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelCardExportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardExportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardName());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardVersion());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelCardExportJobSummary)) {
            return false;
        }
        ModelCardExportJobSummary other = (ModelCardExportJobSummary) obj;
        return Objects.equals(modelCardExportJobName(), other.modelCardExportJobName())
                && Objects.equals(modelCardExportJobArn(), other.modelCardExportJobArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(modelCardName(), other.modelCardName())
                && Objects.equals(modelCardVersion(), other.modelCardVersion()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastModifiedAt(), other.lastModifiedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelCardExportJobSummary").add("ModelCardExportJobName", modelCardExportJobName())
                .add("ModelCardExportJobArn", modelCardExportJobArn()).add("Status", statusAsString())
                .add("ModelCardName", modelCardName()).add("ModelCardVersion", modelCardVersion()).add("CreatedAt", createdAt())
                .add("LastModifiedAt", lastModifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelCardExportJobName":
            return Optional.ofNullable(clazz.cast(modelCardExportJobName()));
        case "ModelCardExportJobArn":
            return Optional.ofNullable(clazz.cast(modelCardExportJobArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ModelCardName":
            return Optional.ofNullable(clazz.cast(modelCardName()));
        case "ModelCardVersion":
            return Optional.ofNullable(clazz.cast(modelCardVersion()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelCardExportJobName", MODEL_CARD_EXPORT_JOB_NAME_FIELD);
        map.put("ModelCardExportJobArn", MODEL_CARD_EXPORT_JOB_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ModelCardName", MODEL_CARD_NAME_FIELD);
        map.put("ModelCardVersion", MODEL_CARD_VERSION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastModifiedAt", LAST_MODIFIED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelCardExportJobSummary, T> g) {
        return obj -> g.apply((ModelCardExportJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelCardExportJobSummary> {
        /**
         * <p>
         * The name of the model card export job.
         * </p>
         * 
         * @param modelCardExportJobName
         *        The name of the model card export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardExportJobName(String modelCardExportJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model card export job.
         * </p>
         * 
         * @param modelCardExportJobArn
         *        The Amazon Resource Name (ARN) of the model card export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardExportJobArn(String modelCardExportJobArn);

        /**
         * <p>
         * The completion status of the model card export job.
         * </p>
         * 
         * @param status
         *        The completion status of the model card export job.
         * @see ModelCardExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardExportJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The completion status of the model card export job.
         * </p>
         * 
         * @param status
         *        The completion status of the model card export job.
         * @see ModelCardExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardExportJobStatus
         */
        Builder status(ModelCardExportJobStatus status);

        /**
         * <p>
         * The name of the model card that the export job exports.
         * </p>
         * 
         * @param modelCardName
         *        The name of the model card that the export job exports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardName(String modelCardName);

        /**
         * <p>
         * The version of the model card that the export job exports.
         * </p>
         * 
         * @param modelCardVersion
         *        The version of the model card that the export job exports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardVersion(Integer modelCardVersion);

        /**
         * <p>
         * The date and time that the model card export job was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the model card export job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time that the model card export job was last modified..
         * </p>
         * 
         * @param lastModifiedAt
         *        The date and time that the model card export job was last modified..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);
    }

    static final class BuilderImpl implements Builder {
        private String modelCardExportJobName;

        private String modelCardExportJobArn;

        private String status;

        private String modelCardName;

        private Integer modelCardVersion;

        private Instant createdAt;

        private Instant lastModifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelCardExportJobSummary model) {
            modelCardExportJobName(model.modelCardExportJobName);
            modelCardExportJobArn(model.modelCardExportJobArn);
            status(model.status);
            modelCardName(model.modelCardName);
            modelCardVersion(model.modelCardVersion);
            createdAt(model.createdAt);
            lastModifiedAt(model.lastModifiedAt);
        }

        public final String getModelCardExportJobName() {
            return modelCardExportJobName;
        }

        public final void setModelCardExportJobName(String modelCardExportJobName) {
            this.modelCardExportJobName = modelCardExportJobName;
        }

        @Override
        public final Builder modelCardExportJobName(String modelCardExportJobName) {
            this.modelCardExportJobName = modelCardExportJobName;
            return this;
        }

        public final String getModelCardExportJobArn() {
            return modelCardExportJobArn;
        }

        public final void setModelCardExportJobArn(String modelCardExportJobArn) {
            this.modelCardExportJobArn = modelCardExportJobArn;
        }

        @Override
        public final Builder modelCardExportJobArn(String modelCardExportJobArn) {
            this.modelCardExportJobArn = modelCardExportJobArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelCardExportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getModelCardName() {
            return modelCardName;
        }

        public final void setModelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
        }

        @Override
        public final Builder modelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
            return this;
        }

        public final Integer getModelCardVersion() {
            return modelCardVersion;
        }

        public final void setModelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
        }

        @Override
        public final Builder modelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        @Override
        public ModelCardExportJobSummary build() {
            return new ModelCardExportJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
