/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The model card for a model displayed in the Amazon SageMaker Model Dashboard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelDashboardModelCard implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelDashboardModelCard.Builder, ModelDashboardModelCard> {
    private static final SdkField<String> MODEL_CARD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardArn").getter(getter(ModelDashboardModelCard::modelCardArn))
            .setter(setter(Builder::modelCardArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardArn").build()).build();

    private static final SdkField<String> MODEL_CARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardName").getter(getter(ModelDashboardModelCard::modelCardName))
            .setter(setter(Builder::modelCardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardName").build()).build();

    private static final SdkField<Integer> MODEL_CARD_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ModelCardVersion").getter(getter(ModelDashboardModelCard::modelCardVersion))
            .setter(setter(Builder::modelCardVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardVersion").build()).build();

    private static final SdkField<String> MODEL_CARD_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardStatus").getter(getter(ModelDashboardModelCard::modelCardStatusAsString))
            .setter(setter(Builder::modelCardStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardStatus").build()).build();

    private static final SdkField<ModelCardSecurityConfig> SECURITY_CONFIG_FIELD = SdkField
            .<ModelCardSecurityConfig> builder(MarshallingType.SDK_POJO).memberName("SecurityConfig")
            .getter(getter(ModelDashboardModelCard::securityConfig)).setter(setter(Builder::securityConfig))
            .constructor(ModelCardSecurityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfig").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ModelDashboardModelCard::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(ModelDashboardModelCard::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(ModelDashboardModelCard::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(ModelDashboardModelCard::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ModelDashboardModelCard::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelId").getter(getter(ModelDashboardModelCard::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelId").build()).build();

    private static final SdkField<String> RISK_RATING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RiskRating").getter(getter(ModelDashboardModelCard::riskRating)).setter(setter(Builder::riskRating))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskRating").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CARD_ARN_FIELD,
            MODEL_CARD_NAME_FIELD, MODEL_CARD_VERSION_FIELD, MODEL_CARD_STATUS_FIELD, SECURITY_CONFIG_FIELD, CREATION_TIME_FIELD,
            CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, TAGS_FIELD, MODEL_ID_FIELD, RISK_RATING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelCardArn;

    private final String modelCardName;

    private final Integer modelCardVersion;

    private final String modelCardStatus;

    private final ModelCardSecurityConfig securityConfig;

    private final Instant creationTime;

    private final UserContext createdBy;

    private final Instant lastModifiedTime;

    private final UserContext lastModifiedBy;

    private final List<Tag> tags;

    private final String modelId;

    private final String riskRating;

    private ModelDashboardModelCard(BuilderImpl builder) {
        this.modelCardArn = builder.modelCardArn;
        this.modelCardName = builder.modelCardName;
        this.modelCardVersion = builder.modelCardVersion;
        this.modelCardStatus = builder.modelCardStatus;
        this.securityConfig = builder.securityConfig;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.tags = builder.tags;
        this.modelId = builder.modelId;
        this.riskRating = builder.riskRating;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for a model card.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for a model card.
     */
    public final String modelCardArn() {
        return modelCardArn;
    }

    /**
     * <p>
     * The name of a model card.
     * </p>
     * 
     * @return The name of a model card.
     */
    public final String modelCardName() {
        return modelCardName;
    }

    /**
     * <p>
     * The model card version.
     * </p>
     * 
     * @return The model card version.
     */
    public final Integer modelCardVersion() {
        return modelCardVersion;
    }

    /**
     * <p>
     * The model card status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelCardStatus}
     * will return {@link ModelCardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modelCardStatusAsString}.
     * </p>
     * 
     * @return The model card status.
     * @see ModelCardStatus
     */
    public final ModelCardStatus modelCardStatus() {
        return ModelCardStatus.fromValue(modelCardStatus);
    }

    /**
     * <p>
     * The model card status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelCardStatus}
     * will return {@link ModelCardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modelCardStatusAsString}.
     * </p>
     * 
     * @return The model card status.
     * @see ModelCardStatus
     */
    public final String modelCardStatusAsString() {
        return modelCardStatus;
    }

    /**
     * <p>
     * The KMS Key ID (<code>KMSKeyId</code>) for encryption of model card information.
     * </p>
     * 
     * @return The KMS Key ID (<code>KMSKeyId</code>) for encryption of model card information.
     */
    public final ModelCardSecurityConfig securityConfig() {
        return securityConfig;
    }

    /**
     * <p>
     * A timestamp that indicates when the model card was created.
     * </p>
     * 
     * @return A timestamp that indicates when the model card was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * A timestamp that indicates when the model card was last updated.
     * </p>
     * 
     * @return A timestamp that indicates when the model card was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with a model card.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with a model card.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * For models created in SageMaker, this is the model ARN. For models created outside of SageMaker, this is a
     * user-customized string.
     * </p>
     * 
     * @return For models created in SageMaker, this is the model ARN. For models created outside of SageMaker, this is
     *         a user-customized string.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * A model card's risk rating. Can be low, medium, or high.
     * </p>
     * 
     * @return A model card's risk rating. Can be low, medium, or high.
     */
    public final String riskRating() {
        return riskRating;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelCardArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardName());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardVersion());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(riskRating());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelDashboardModelCard)) {
            return false;
        }
        ModelDashboardModelCard other = (ModelDashboardModelCard) obj;
        return Objects.equals(modelCardArn(), other.modelCardArn()) && Objects.equals(modelCardName(), other.modelCardName())
                && Objects.equals(modelCardVersion(), other.modelCardVersion())
                && Objects.equals(modelCardStatusAsString(), other.modelCardStatusAsString())
                && Objects.equals(securityConfig(), other.securityConfig())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(modelId(), other.modelId())
                && Objects.equals(riskRating(), other.riskRating());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelDashboardModelCard").add("ModelCardArn", modelCardArn())
                .add("ModelCardName", modelCardName()).add("ModelCardVersion", modelCardVersion())
                .add("ModelCardStatus", modelCardStatusAsString()).add("SecurityConfig", securityConfig())
                .add("CreationTime", creationTime()).add("CreatedBy", createdBy()).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedBy", lastModifiedBy()).add("Tags", hasTags() ? tags() : null).add("ModelId", modelId())
                .add("RiskRating", riskRating()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelCardArn":
            return Optional.ofNullable(clazz.cast(modelCardArn()));
        case "ModelCardName":
            return Optional.ofNullable(clazz.cast(modelCardName()));
        case "ModelCardVersion":
            return Optional.ofNullable(clazz.cast(modelCardVersion()));
        case "ModelCardStatus":
            return Optional.ofNullable(clazz.cast(modelCardStatusAsString()));
        case "SecurityConfig":
            return Optional.ofNullable(clazz.cast(securityConfig()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ModelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "RiskRating":
            return Optional.ofNullable(clazz.cast(riskRating()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelCardArn", MODEL_CARD_ARN_FIELD);
        map.put("ModelCardName", MODEL_CARD_NAME_FIELD);
        map.put("ModelCardVersion", MODEL_CARD_VERSION_FIELD);
        map.put("ModelCardStatus", MODEL_CARD_STATUS_FIELD);
        map.put("SecurityConfig", SECURITY_CONFIG_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ModelId", MODEL_ID_FIELD);
        map.put("RiskRating", RISK_RATING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelDashboardModelCard, T> g) {
        return obj -> g.apply((ModelDashboardModelCard) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelDashboardModelCard> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for a model card.
         * </p>
         * 
         * @param modelCardArn
         *        The Amazon Resource Name (ARN) for a model card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardArn(String modelCardArn);

        /**
         * <p>
         * The name of a model card.
         * </p>
         * 
         * @param modelCardName
         *        The name of a model card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardName(String modelCardName);

        /**
         * <p>
         * The model card version.
         * </p>
         * 
         * @param modelCardVersion
         *        The model card version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardVersion(Integer modelCardVersion);

        /**
         * <p>
         * The model card status.
         * </p>
         * 
         * @param modelCardStatus
         *        The model card status.
         * @see ModelCardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardStatus
         */
        Builder modelCardStatus(String modelCardStatus);

        /**
         * <p>
         * The model card status.
         * </p>
         * 
         * @param modelCardStatus
         *        The model card status.
         * @see ModelCardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardStatus
         */
        Builder modelCardStatus(ModelCardStatus modelCardStatus);

        /**
         * <p>
         * The KMS Key ID (<code>KMSKeyId</code>) for encryption of model card information.
         * </p>
         * 
         * @param securityConfig
         *        The KMS Key ID (<code>KMSKeyId</code>) for encryption of model card information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfig(ModelCardSecurityConfig securityConfig);

        /**
         * <p>
         * The KMS Key ID (<code>KMSKeyId</code>) for encryption of model card information.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelCardSecurityConfig.Builder} avoiding
         * the need to create one manually via {@link ModelCardSecurityConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelCardSecurityConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #securityConfig(ModelCardSecurityConfig)}.
         * 
         * @param securityConfig
         *        a consumer that will call methods on {@link ModelCardSecurityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityConfig(ModelCardSecurityConfig)
         */
        default Builder securityConfig(Consumer<ModelCardSecurityConfig.Builder> securityConfig) {
            return securityConfig(ModelCardSecurityConfig.builder().applyMutation(securityConfig).build());
        }

        /**
         * <p>
         * A timestamp that indicates when the model card was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that indicates when the model card was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * A timestamp that indicates when the model card was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        A timestamp that indicates when the model card was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }

        /**
         * <p>
         * The tags associated with a model card.
         * </p>
         * 
         * @param tags
         *        The tags associated with a model card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with a model card.
         * </p>
         * 
         * @param tags
         *        The tags associated with a model card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with a model card.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * For models created in SageMaker, this is the model ARN. For models created outside of SageMaker, this is a
         * user-customized string.
         * </p>
         * 
         * @param modelId
         *        For models created in SageMaker, this is the model ARN. For models created outside of SageMaker, this
         *        is a user-customized string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * A model card's risk rating. Can be low, medium, or high.
         * </p>
         * 
         * @param riskRating
         *        A model card's risk rating. Can be low, medium, or high.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskRating(String riskRating);
    }

    static final class BuilderImpl implements Builder {
        private String modelCardArn;

        private String modelCardName;

        private Integer modelCardVersion;

        private String modelCardStatus;

        private ModelCardSecurityConfig securityConfig;

        private Instant creationTime;

        private UserContext createdBy;

        private Instant lastModifiedTime;

        private UserContext lastModifiedBy;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String modelId;

        private String riskRating;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelDashboardModelCard model) {
            modelCardArn(model.modelCardArn);
            modelCardName(model.modelCardName);
            modelCardVersion(model.modelCardVersion);
            modelCardStatus(model.modelCardStatus);
            securityConfig(model.securityConfig);
            creationTime(model.creationTime);
            createdBy(model.createdBy);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
            tags(model.tags);
            modelId(model.modelId);
            riskRating(model.riskRating);
        }

        public final String getModelCardArn() {
            return modelCardArn;
        }

        public final void setModelCardArn(String modelCardArn) {
            this.modelCardArn = modelCardArn;
        }

        @Override
        public final Builder modelCardArn(String modelCardArn) {
            this.modelCardArn = modelCardArn;
            return this;
        }

        public final String getModelCardName() {
            return modelCardName;
        }

        public final void setModelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
        }

        @Override
        public final Builder modelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
            return this;
        }

        public final Integer getModelCardVersion() {
            return modelCardVersion;
        }

        public final void setModelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
        }

        @Override
        public final Builder modelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
            return this;
        }

        public final String getModelCardStatus() {
            return modelCardStatus;
        }

        public final void setModelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
        }

        @Override
        public final Builder modelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
            return this;
        }

        @Override
        public final Builder modelCardStatus(ModelCardStatus modelCardStatus) {
            this.modelCardStatus(modelCardStatus == null ? null : modelCardStatus.toString());
            return this;
        }

        public final ModelCardSecurityConfig.Builder getSecurityConfig() {
            return securityConfig != null ? securityConfig.toBuilder() : null;
        }

        public final void setSecurityConfig(ModelCardSecurityConfig.BuilderImpl securityConfig) {
            this.securityConfig = securityConfig != null ? securityConfig.build() : null;
        }

        @Override
        public final Builder securityConfig(ModelCardSecurityConfig securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getRiskRating() {
            return riskRating;
        }

        public final void setRiskRating(String riskRating) {
            this.riskRating = riskRating;
        }

        @Override
        public final Builder riskRating(String riskRating) {
            this.riskRating = riskRating;
            return this;
        }

        @Override
        public ModelDashboardModelCard build() {
            return new ModelDashboardModelCard(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
