/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A group of versioned models in the Model Registry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelPackageGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelPackageGroup.Builder, ModelPackageGroup> {
    private static final SdkField<String> MODEL_PACKAGE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageGroupName").getter(getter(ModelPackageGroup::modelPackageGroupName))
            .setter(setter(Builder::modelPackageGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupName").build())
            .build();

    private static final SdkField<String> MODEL_PACKAGE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageGroupArn").getter(getter(ModelPackageGroup::modelPackageGroupArn))
            .setter(setter(Builder::modelPackageGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupArn").build())
            .build();

    private static final SdkField<String> MODEL_PACKAGE_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageGroupDescription")
            .getter(getter(ModelPackageGroup::modelPackageGroupDescription))
            .setter(setter(Builder::modelPackageGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupDescription")
                    .build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ModelPackageGroup::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(ModelPackageGroup::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<String> MODEL_PACKAGE_GROUP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageGroupStatus").getter(getter(ModelPackageGroup::modelPackageGroupStatusAsString))
            .setter(setter(Builder::modelPackageGroupStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupStatus").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ModelPackageGroup::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MODEL_PACKAGE_GROUP_NAME_FIELD, MODEL_PACKAGE_GROUP_ARN_FIELD, MODEL_PACKAGE_GROUP_DESCRIPTION_FIELD,
            CREATION_TIME_FIELD, CREATED_BY_FIELD, MODEL_PACKAGE_GROUP_STATUS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelPackageGroupName;

    private final String modelPackageGroupArn;

    private final String modelPackageGroupDescription;

    private final Instant creationTime;

    private final UserContext createdBy;

    private final String modelPackageGroupStatus;

    private final List<Tag> tags;

    private ModelPackageGroup(BuilderImpl builder) {
        this.modelPackageGroupName = builder.modelPackageGroupName;
        this.modelPackageGroupArn = builder.modelPackageGroupArn;
        this.modelPackageGroupDescription = builder.modelPackageGroupDescription;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.modelPackageGroupStatus = builder.modelPackageGroupStatus;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the model group.
     * </p>
     * 
     * @return The name of the model group.
     */
    public final String modelPackageGroupName() {
        return modelPackageGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model group.
     */
    public final String modelPackageGroupArn() {
        return modelPackageGroupArn;
    }

    /**
     * <p>
     * The description for the model group.
     * </p>
     * 
     * @return The description for the model group.
     */
    public final String modelPackageGroupDescription() {
        return modelPackageGroupDescription;
    }

    /**
     * <p>
     * The time that the model group was created.
     * </p>
     * 
     * @return The time that the model group was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The status of the model group. This can be one of the following values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> - The model group is pending being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - The model group is in the process of being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> - The model group was successfully created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The model group failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The model group is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code> - SageMaker failed to delete the model group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelPackageGroupStatus} will return {@link ModelPackageGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #modelPackageGroupStatusAsString}.
     * </p>
     * 
     * @return The status of the model group. This can be one of the following values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - The model group is pending being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - The model group is in the process of being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> - The model group was successfully created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The model group failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The model group is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code> - SageMaker failed to delete the model group.
     *         </p>
     *         </li>
     * @see ModelPackageGroupStatus
     */
    public final ModelPackageGroupStatus modelPackageGroupStatus() {
        return ModelPackageGroupStatus.fromValue(modelPackageGroupStatus);
    }

    /**
     * <p>
     * The status of the model group. This can be one of the following values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> - The model group is pending being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - The model group is in the process of being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> - The model group was successfully created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The model group failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The model group is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code> - SageMaker failed to delete the model group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelPackageGroupStatus} will return {@link ModelPackageGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #modelPackageGroupStatusAsString}.
     * </p>
     * 
     * @return The status of the model group. This can be one of the following values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - The model group is pending being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - The model group is in the process of being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> - The model group was successfully created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The model group failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The model group is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code> - SageMaker failed to delete the model group.
     *         </p>
     *         </li>
     * @see ModelPackageGroupStatus
     */
    public final String modelPackageGroupStatusAsString() {
        return modelPackageGroupStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the tags associated with the model group. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * in the <i>Amazon Web Services General Reference Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of the tags associated with the model group. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageGroupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageGroup)) {
            return false;
        }
        ModelPackageGroup other = (ModelPackageGroup) obj;
        return Objects.equals(modelPackageGroupName(), other.modelPackageGroupName())
                && Objects.equals(modelPackageGroupArn(), other.modelPackageGroupArn())
                && Objects.equals(modelPackageGroupDescription(), other.modelPackageGroupDescription())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(modelPackageGroupStatusAsString(), other.modelPackageGroupStatusAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelPackageGroup").add("ModelPackageGroupName", modelPackageGroupName())
                .add("ModelPackageGroupArn", modelPackageGroupArn())
                .add("ModelPackageGroupDescription", modelPackageGroupDescription()).add("CreationTime", creationTime())
                .add("CreatedBy", createdBy()).add("ModelPackageGroupStatus", modelPackageGroupStatusAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackageGroupName":
            return Optional.ofNullable(clazz.cast(modelPackageGroupName()));
        case "ModelPackageGroupArn":
            return Optional.ofNullable(clazz.cast(modelPackageGroupArn()));
        case "ModelPackageGroupDescription":
            return Optional.ofNullable(clazz.cast(modelPackageGroupDescription()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "ModelPackageGroupStatus":
            return Optional.ofNullable(clazz.cast(modelPackageGroupStatusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelPackageGroupName", MODEL_PACKAGE_GROUP_NAME_FIELD);
        map.put("ModelPackageGroupArn", MODEL_PACKAGE_GROUP_ARN_FIELD);
        map.put("ModelPackageGroupDescription", MODEL_PACKAGE_GROUP_DESCRIPTION_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("ModelPackageGroupStatus", MODEL_PACKAGE_GROUP_STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageGroup, T> g) {
        return obj -> g.apply((ModelPackageGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelPackageGroup> {
        /**
         * <p>
         * The name of the model group.
         * </p>
         * 
         * @param modelPackageGroupName
         *        The name of the model group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageGroupName(String modelPackageGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model group.
         * </p>
         * 
         * @param modelPackageGroupArn
         *        The Amazon Resource Name (ARN) of the model group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageGroupArn(String modelPackageGroupArn);

        /**
         * <p>
         * The description for the model group.
         * </p>
         * 
         * @param modelPackageGroupDescription
         *        The description for the model group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageGroupDescription(String modelPackageGroupDescription);

        /**
         * <p>
         * The time that the model group was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the model group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * The status of the model group. This can be one of the following values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> - The model group is pending being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - The model group is in the process of being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code> - The model group was successfully created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The model group failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The model group is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code> - SageMaker failed to delete the model group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelPackageGroupStatus
         *        The status of the model group. This can be one of the following values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - The model group is pending being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - The model group is in the process of being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> - The model group was successfully created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The model group failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The model group is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code> - SageMaker failed to delete the model group.
         *        </p>
         *        </li>
         * @see ModelPackageGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackageGroupStatus
         */
        Builder modelPackageGroupStatus(String modelPackageGroupStatus);

        /**
         * <p>
         * The status of the model group. This can be one of the following values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> - The model group is pending being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - The model group is in the process of being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code> - The model group was successfully created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The model group failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The model group is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code> - SageMaker failed to delete the model group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelPackageGroupStatus
         *        The status of the model group. This can be one of the following values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - The model group is pending being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - The model group is in the process of being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> - The model group was successfully created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The model group failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The model group is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code> - SageMaker failed to delete the model group.
         *        </p>
         *        </li>
         * @see ModelPackageGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackageGroupStatus
         */
        Builder modelPackageGroupStatus(ModelPackageGroupStatus modelPackageGroupStatus);

        /**
         * <p>
         * A list of the tags associated with the model group. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of the tags associated with the model group. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of the tags associated with the model group. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of the tags associated with the model group. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of the tags associated with the model group. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String modelPackageGroupName;

        private String modelPackageGroupArn;

        private String modelPackageGroupDescription;

        private Instant creationTime;

        private UserContext createdBy;

        private String modelPackageGroupStatus;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageGroup model) {
            modelPackageGroupName(model.modelPackageGroupName);
            modelPackageGroupArn(model.modelPackageGroupArn);
            modelPackageGroupDescription(model.modelPackageGroupDescription);
            creationTime(model.creationTime);
            createdBy(model.createdBy);
            modelPackageGroupStatus(model.modelPackageGroupStatus);
            tags(model.tags);
        }

        public final String getModelPackageGroupName() {
            return modelPackageGroupName;
        }

        public final void setModelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
        }

        @Override
        public final Builder modelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
            return this;
        }

        public final String getModelPackageGroupArn() {
            return modelPackageGroupArn;
        }

        public final void setModelPackageGroupArn(String modelPackageGroupArn) {
            this.modelPackageGroupArn = modelPackageGroupArn;
        }

        @Override
        public final Builder modelPackageGroupArn(String modelPackageGroupArn) {
            this.modelPackageGroupArn = modelPackageGroupArn;
            return this;
        }

        public final String getModelPackageGroupDescription() {
            return modelPackageGroupDescription;
        }

        public final void setModelPackageGroupDescription(String modelPackageGroupDescription) {
            this.modelPackageGroupDescription = modelPackageGroupDescription;
        }

        @Override
        public final Builder modelPackageGroupDescription(String modelPackageGroupDescription) {
            this.modelPackageGroupDescription = modelPackageGroupDescription;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getModelPackageGroupStatus() {
            return modelPackageGroupStatus;
        }

        public final void setModelPackageGroupStatus(String modelPackageGroupStatus) {
            this.modelPackageGroupStatus = modelPackageGroupStatus;
        }

        @Override
        public final Builder modelPackageGroupStatus(String modelPackageGroupStatus) {
            this.modelPackageGroupStatus = modelPackageGroupStatus;
            return this;
        }

        @Override
        public final Builder modelPackageGroupStatus(ModelPackageGroupStatus modelPackageGroupStatus) {
            this.modelPackageGroupStatus(modelPackageGroupStatus == null ? null : modelPackageGroupStatus.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ModelPackageGroup build() {
            return new ModelPackageGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
