/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The model card associated with the model package. Since <code>ModelPackageModelCard</code> is tied to a model
 * package, it is a specific usage of a model card and its schema is simplified compared to the schema of
 * <code>ModelCard</code>. The <code>ModelPackageModelCard</code> schema does not include
 * <code>model_package_details</code>, and <code>model_overview</code> is composed of the <code>model_creator</code> and
 * <code>model_artifact</code> properties. For more information about the model package model card schema, see <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema">Model package
 * model card schema</a>. For more information about the model card associated with the model package, see <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html">View the Details of a Model
 * Version</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelPackageModelCard implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelPackageModelCard.Builder, ModelPackageModelCard> {
    private static final SdkField<String> MODEL_CARD_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardContent").getter(getter(ModelPackageModelCard::modelCardContent))
            .setter(setter(Builder::modelCardContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardContent").build()).build();

    private static final SdkField<String> MODEL_CARD_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardStatus").getter(getter(ModelPackageModelCard::modelCardStatusAsString))
            .setter(setter(Builder::modelCardStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CARD_CONTENT_FIELD,
            MODEL_CARD_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelCardContent;

    private final String modelCardStatus;

    private ModelPackageModelCard(BuilderImpl builder) {
        this.modelCardContent = builder.modelCardContent;
        this.modelCardStatus = builder.modelCardStatus;
    }

    /**
     * <p>
     * The content of the model card. The content must follow the schema described in <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema">Model
     * Package Model Card Schema</a>.
     * </p>
     * 
     * @return The content of the model card. The content must follow the schema described in <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema"
     *         >Model Package Model Card Schema</a>.
     */
    public final String modelCardContent() {
        return modelCardContent;
    }

    /**
     * <p>
     * The approval status of the model card within your organization. Different organizations might have different
     * criteria for model card review and approval.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Draft</code>: The model card is a work in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PendingReview</code>: The model card is pending review.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Approved</code>: The model card is approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Archived</code>: The model card is archived. No more updates can be made to the model card content. If you
     * try to update the model card content, you will receive the message <code>Model Card is in Archived state</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelCardStatus}
     * will return {@link ModelCardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modelCardStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model card within your organization. Different organizations might have
     *         different criteria for model card review and approval.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Draft</code>: The model card is a work in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PendingReview</code>: The model card is pending review.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Approved</code>: The model card is approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Archived</code>: The model card is archived. No more updates can be made to the model card content.
     *         If you try to update the model card content, you will receive the message
     *         <code>Model Card is in Archived state</code>.
     *         </p>
     *         </li>
     * @see ModelCardStatus
     */
    public final ModelCardStatus modelCardStatus() {
        return ModelCardStatus.fromValue(modelCardStatus);
    }

    /**
     * <p>
     * The approval status of the model card within your organization. Different organizations might have different
     * criteria for model card review and approval.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Draft</code>: The model card is a work in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PendingReview</code>: The model card is pending review.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Approved</code>: The model card is approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Archived</code>: The model card is archived. No more updates can be made to the model card content. If you
     * try to update the model card content, you will receive the message <code>Model Card is in Archived state</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelCardStatus}
     * will return {@link ModelCardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modelCardStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model card within your organization. Different organizations might have
     *         different criteria for model card review and approval.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Draft</code>: The model card is a work in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PendingReview</code>: The model card is pending review.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Approved</code>: The model card is approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Archived</code>: The model card is archived. No more updates can be made to the model card content.
     *         If you try to update the model card content, you will receive the message
     *         <code>Model Card is in Archived state</code>.
     *         </p>
     *         </li>
     * @see ModelCardStatus
     */
    public final String modelCardStatusAsString() {
        return modelCardStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelCardContent());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageModelCard)) {
            return false;
        }
        ModelPackageModelCard other = (ModelPackageModelCard) obj;
        return Objects.equals(modelCardContent(), other.modelCardContent())
                && Objects.equals(modelCardStatusAsString(), other.modelCardStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelPackageModelCard")
                .add("ModelCardContent", modelCardContent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ModelCardStatus", modelCardStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelCardContent":
            return Optional.ofNullable(clazz.cast(modelCardContent()));
        case "ModelCardStatus":
            return Optional.ofNullable(clazz.cast(modelCardStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelCardContent", MODEL_CARD_CONTENT_FIELD);
        map.put("ModelCardStatus", MODEL_CARD_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageModelCard, T> g) {
        return obj -> g.apply((ModelPackageModelCard) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelPackageModelCard> {
        /**
         * <p>
         * The content of the model card. The content must follow the schema described in <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema">Model
         * Package Model Card Schema</a>.
         * </p>
         * 
         * @param modelCardContent
         *        The content of the model card. The content must follow the schema described in <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema"
         *        >Model Package Model Card Schema</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardContent(String modelCardContent);

        /**
         * <p>
         * The approval status of the model card within your organization. Different organizations might have different
         * criteria for model card review and approval.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Draft</code>: The model card is a work in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PendingReview</code>: The model card is pending review.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Approved</code>: The model card is approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Archived</code>: The model card is archived. No more updates can be made to the model card content. If
         * you try to update the model card content, you will receive the message
         * <code>Model Card is in Archived state</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelCardStatus
         *        The approval status of the model card within your organization. Different organizations might have
         *        different criteria for model card review and approval.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Draft</code>: The model card is a work in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PendingReview</code>: The model card is pending review.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Approved</code>: The model card is approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Archived</code>: The model card is archived. No more updates can be made to the model card
         *        content. If you try to update the model card content, you will receive the message
         *        <code>Model Card is in Archived state</code>.
         *        </p>
         *        </li>
         * @see ModelCardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardStatus
         */
        Builder modelCardStatus(String modelCardStatus);

        /**
         * <p>
         * The approval status of the model card within your organization. Different organizations might have different
         * criteria for model card review and approval.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Draft</code>: The model card is a work in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PendingReview</code>: The model card is pending review.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Approved</code>: The model card is approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Archived</code>: The model card is archived. No more updates can be made to the model card content. If
         * you try to update the model card content, you will receive the message
         * <code>Model Card is in Archived state</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelCardStatus
         *        The approval status of the model card within your organization. Different organizations might have
         *        different criteria for model card review and approval.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Draft</code>: The model card is a work in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PendingReview</code>: The model card is pending review.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Approved</code>: The model card is approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Archived</code>: The model card is archived. No more updates can be made to the model card
         *        content. If you try to update the model card content, you will receive the message
         *        <code>Model Card is in Archived state</code>.
         *        </p>
         *        </li>
         * @see ModelCardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardStatus
         */
        Builder modelCardStatus(ModelCardStatus modelCardStatus);
    }

    static final class BuilderImpl implements Builder {
        private String modelCardContent;

        private String modelCardStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageModelCard model) {
            modelCardContent(model.modelCardContent);
            modelCardStatus(model.modelCardStatus);
        }

        public final String getModelCardContent() {
            return modelCardContent;
        }

        public final void setModelCardContent(String modelCardContent) {
            this.modelCardContent = modelCardContent;
        }

        @Override
        public final Builder modelCardContent(String modelCardContent) {
            this.modelCardContent = modelCardContent;
            return this;
        }

        public final String getModelCardStatus() {
            return modelCardStatus;
        }

        public final void setModelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
        }

        @Override
        public final Builder modelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
            return this;
        }

        @Override
        public final Builder modelCardStatus(ModelCardStatus modelCardStatus) {
            this.modelCardStatus(modelCardStatus == null ? null : modelCardStatus.toString());
            return this;
        }

        @Override
        public ModelPackageModelCard build() {
            return new ModelPackageModelCard(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
