/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information of an alert's history.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringAlertHistorySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringAlertHistorySummary.Builder, MonitoringAlertHistorySummary> {
    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringScheduleName").getter(getter(MonitoringAlertHistorySummary::monitoringScheduleName))
            .setter(setter(Builder::monitoringScheduleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build())
            .build();

    private static final SdkField<String> MONITORING_ALERT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringAlertName").getter(getter(MonitoringAlertHistorySummary::monitoringAlertName))
            .setter(setter(Builder::monitoringAlertName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringAlertName").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(MonitoringAlertHistorySummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> ALERT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlertStatus").getter(getter(MonitoringAlertHistorySummary::alertStatusAsString))
            .setter(setter(Builder::alertStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONITORING_SCHEDULE_NAME_FIELD, MONITORING_ALERT_NAME_FIELD, CREATION_TIME_FIELD, ALERT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String monitoringScheduleName;

    private final String monitoringAlertName;

    private final Instant creationTime;

    private final String alertStatus;

    private MonitoringAlertHistorySummary(BuilderImpl builder) {
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.monitoringAlertName = builder.monitoringAlertName;
        this.creationTime = builder.creationTime;
        this.alertStatus = builder.alertStatus;
    }

    /**
     * <p>
     * The name of a monitoring schedule.
     * </p>
     * 
     * @return The name of a monitoring schedule.
     */
    public final String monitoringScheduleName() {
        return monitoringScheduleName;
    }

    /**
     * <p>
     * The name of a monitoring alert.
     * </p>
     * 
     * @return The name of a monitoring alert.
     */
    public final String monitoringAlertName() {
        return monitoringAlertName;
    }

    /**
     * <p>
     * A timestamp that indicates when the first alert transition occurred in an alert history. An alert transition can
     * be from status <code>InAlert</code> to <code>OK</code>, or from <code>OK</code> to <code>InAlert</code>.
     * </p>
     * 
     * @return A timestamp that indicates when the first alert transition occurred in an alert history. An alert
     *         transition can be from status <code>InAlert</code> to <code>OK</code>, or from <code>OK</code> to
     *         <code>InAlert</code>.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The current alert status of an alert.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alertStatus} will
     * return {@link MonitoringAlertStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #alertStatusAsString}.
     * </p>
     * 
     * @return The current alert status of an alert.
     * @see MonitoringAlertStatus
     */
    public final MonitoringAlertStatus alertStatus() {
        return MonitoringAlertStatus.fromValue(alertStatus);
    }

    /**
     * <p>
     * The current alert status of an alert.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alertStatus} will
     * return {@link MonitoringAlertStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #alertStatusAsString}.
     * </p>
     * 
     * @return The current alert status of an alert.
     * @see MonitoringAlertStatus
     */
    public final String alertStatusAsString() {
        return alertStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringAlertName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(alertStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringAlertHistorySummary)) {
            return false;
        }
        MonitoringAlertHistorySummary other = (MonitoringAlertHistorySummary) obj;
        return Objects.equals(monitoringScheduleName(), other.monitoringScheduleName())
                && Objects.equals(monitoringAlertName(), other.monitoringAlertName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(alertStatusAsString(), other.alertStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringAlertHistorySummary").add("MonitoringScheduleName", monitoringScheduleName())
                .add("MonitoringAlertName", monitoringAlertName()).add("CreationTime", creationTime())
                .add("AlertStatus", alertStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringScheduleName":
            return Optional.ofNullable(clazz.cast(monitoringScheduleName()));
        case "MonitoringAlertName":
            return Optional.ofNullable(clazz.cast(monitoringAlertName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "AlertStatus":
            return Optional.ofNullable(clazz.cast(alertStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MonitoringScheduleName", MONITORING_SCHEDULE_NAME_FIELD);
        map.put("MonitoringAlertName", MONITORING_ALERT_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("AlertStatus", ALERT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitoringAlertHistorySummary, T> g) {
        return obj -> g.apply((MonitoringAlertHistorySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringAlertHistorySummary> {
        /**
         * <p>
         * The name of a monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleName
         *        The name of a monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleName(String monitoringScheduleName);

        /**
         * <p>
         * The name of a monitoring alert.
         * </p>
         * 
         * @param monitoringAlertName
         *        The name of a monitoring alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringAlertName(String monitoringAlertName);

        /**
         * <p>
         * A timestamp that indicates when the first alert transition occurred in an alert history. An alert transition
         * can be from status <code>InAlert</code> to <code>OK</code>, or from <code>OK</code> to <code>InAlert</code>.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that indicates when the first alert transition occurred in an alert history. An alert
         *        transition can be from status <code>InAlert</code> to <code>OK</code>, or from <code>OK</code> to
         *        <code>InAlert</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The current alert status of an alert.
         * </p>
         * 
         * @param alertStatus
         *        The current alert status of an alert.
         * @see MonitoringAlertStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringAlertStatus
         */
        Builder alertStatus(String alertStatus);

        /**
         * <p>
         * The current alert status of an alert.
         * </p>
         * 
         * @param alertStatus
         *        The current alert status of an alert.
         * @see MonitoringAlertStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringAlertStatus
         */
        Builder alertStatus(MonitoringAlertStatus alertStatus);
    }

    static final class BuilderImpl implements Builder {
        private String monitoringScheduleName;

        private String monitoringAlertName;

        private Instant creationTime;

        private String alertStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringAlertHistorySummary model) {
            monitoringScheduleName(model.monitoringScheduleName);
            monitoringAlertName(model.monitoringAlertName);
            creationTime(model.creationTime);
            alertStatus(model.alertStatus);
        }

        public final String getMonitoringScheduleName() {
            return monitoringScheduleName;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final String getMonitoringAlertName() {
            return monitoringAlertName;
        }

        public final void setMonitoringAlertName(String monitoringAlertName) {
            this.monitoringAlertName = monitoringAlertName;
        }

        @Override
        public final Builder monitoringAlertName(String monitoringAlertName) {
            this.monitoringAlertName = monitoringAlertName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getAlertStatus() {
            return alertStatus;
        }

        public final void setAlertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
        }

        @Override
        public final Builder alertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
            return this;
        }

        @Override
        public final Builder alertStatus(MonitoringAlertStatus alertStatus) {
            this.alertStatus(alertStatus == null ? null : alertStatus.toString());
            return this;
        }

        @Override
        public MonitoringAlertHistorySummary build() {
            return new MonitoringAlertHistorySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
