/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ProcessingInstanceType {
    ML_T3_MEDIUM("ml.t3.medium"),

    ML_T3_LARGE("ml.t3.large"),

    ML_T3_XLARGE("ml.t3.xlarge"),

    ML_T3_2_XLARGE("ml.t3.2xlarge"),

    ML_M4_XLARGE("ml.m4.xlarge"),

    ML_M4_2_XLARGE("ml.m4.2xlarge"),

    ML_M4_4_XLARGE("ml.m4.4xlarge"),

    ML_M4_10_XLARGE("ml.m4.10xlarge"),

    ML_M4_16_XLARGE("ml.m4.16xlarge"),

    ML_C4_XLARGE("ml.c4.xlarge"),

    ML_C4_2_XLARGE("ml.c4.2xlarge"),

    ML_C4_4_XLARGE("ml.c4.4xlarge"),

    ML_C4_8_XLARGE("ml.c4.8xlarge"),

    ML_P2_XLARGE("ml.p2.xlarge"),

    ML_P2_8_XLARGE("ml.p2.8xlarge"),

    ML_P2_16_XLARGE("ml.p2.16xlarge"),

    ML_P3_2_XLARGE("ml.p3.2xlarge"),

    ML_P3_8_XLARGE("ml.p3.8xlarge"),

    ML_P3_16_XLARGE("ml.p3.16xlarge"),

    ML_C5_XLARGE("ml.c5.xlarge"),

    ML_C5_2_XLARGE("ml.c5.2xlarge"),

    ML_C5_4_XLARGE("ml.c5.4xlarge"),

    ML_C5_9_XLARGE("ml.c5.9xlarge"),

    ML_C5_18_XLARGE("ml.c5.18xlarge"),

    ML_M5_LARGE("ml.m5.large"),

    ML_M5_XLARGE("ml.m5.xlarge"),

    ML_M5_2_XLARGE("ml.m5.2xlarge"),

    ML_M5_4_XLARGE("ml.m5.4xlarge"),

    ML_M5_12_XLARGE("ml.m5.12xlarge"),

    ML_M5_24_XLARGE("ml.m5.24xlarge"),

    ML_R5_LARGE("ml.r5.large"),

    ML_R5_XLARGE("ml.r5.xlarge"),

    ML_R5_2_XLARGE("ml.r5.2xlarge"),

    ML_R5_4_XLARGE("ml.r5.4xlarge"),

    ML_R5_8_XLARGE("ml.r5.8xlarge"),

    ML_R5_12_XLARGE("ml.r5.12xlarge"),

    ML_R5_16_XLARGE("ml.r5.16xlarge"),

    ML_R5_24_XLARGE("ml.r5.24xlarge"),

    ML_G4_DN_XLARGE("ml.g4dn.xlarge"),

    ML_G4_DN_2_XLARGE("ml.g4dn.2xlarge"),

    ML_G4_DN_4_XLARGE("ml.g4dn.4xlarge"),

    ML_G4_DN_8_XLARGE("ml.g4dn.8xlarge"),

    ML_G4_DN_12_XLARGE("ml.g4dn.12xlarge"),

    ML_G4_DN_16_XLARGE("ml.g4dn.16xlarge"),

    ML_G5_XLARGE("ml.g5.xlarge"),

    ML_G5_2_XLARGE("ml.g5.2xlarge"),

    ML_G5_4_XLARGE("ml.g5.4xlarge"),

    ML_G5_8_XLARGE("ml.g5.8xlarge"),

    ML_G5_16_XLARGE("ml.g5.16xlarge"),

    ML_G5_12_XLARGE("ml.g5.12xlarge"),

    ML_G5_24_XLARGE("ml.g5.24xlarge"),

    ML_G5_48_XLARGE("ml.g5.48xlarge"),

    ML_R5_D_LARGE("ml.r5d.large"),

    ML_R5_D_XLARGE("ml.r5d.xlarge"),

    ML_R5_D_2_XLARGE("ml.r5d.2xlarge"),

    ML_R5_D_4_XLARGE("ml.r5d.4xlarge"),

    ML_R5_D_8_XLARGE("ml.r5d.8xlarge"),

    ML_R5_D_12_XLARGE("ml.r5d.12xlarge"),

    ML_R5_D_16_XLARGE("ml.r5d.16xlarge"),

    ML_R5_D_24_XLARGE("ml.r5d.24xlarge"),

    ML_G6_XLARGE("ml.g6.xlarge"),

    ML_G6_2_XLARGE("ml.g6.2xlarge"),

    ML_G6_4_XLARGE("ml.g6.4xlarge"),

    ML_G6_8_XLARGE("ml.g6.8xlarge"),

    ML_G6_12_XLARGE("ml.g6.12xlarge"),

    ML_G6_16_XLARGE("ml.g6.16xlarge"),

    ML_G6_24_XLARGE("ml.g6.24xlarge"),

    ML_G6_48_XLARGE("ml.g6.48xlarge"),

    ML_G6_E_XLARGE("ml.g6e.xlarge"),

    ML_G6_E_2_XLARGE("ml.g6e.2xlarge"),

    ML_G6_E_4_XLARGE("ml.g6e.4xlarge"),

    ML_G6_E_8_XLARGE("ml.g6e.8xlarge"),

    ML_G6_E_12_XLARGE("ml.g6e.12xlarge"),

    ML_G6_E_16_XLARGE("ml.g6e.16xlarge"),

    ML_G6_E_24_XLARGE("ml.g6e.24xlarge"),

    ML_G6_E_48_XLARGE("ml.g6e.48xlarge"),

    ML_M6_I_LARGE("ml.m6i.large"),

    ML_M6_I_XLARGE("ml.m6i.xlarge"),

    ML_M6_I_2_XLARGE("ml.m6i.2xlarge"),

    ML_M6_I_4_XLARGE("ml.m6i.4xlarge"),

    ML_M6_I_8_XLARGE("ml.m6i.8xlarge"),

    ML_M6_I_12_XLARGE("ml.m6i.12xlarge"),

    ML_M6_I_16_XLARGE("ml.m6i.16xlarge"),

    ML_M6_I_24_XLARGE("ml.m6i.24xlarge"),

    ML_M6_I_32_XLARGE("ml.m6i.32xlarge"),

    ML_C6_I_XLARGE("ml.c6i.xlarge"),

    ML_C6_I_2_XLARGE("ml.c6i.2xlarge"),

    ML_C6_I_4_XLARGE("ml.c6i.4xlarge"),

    ML_C6_I_8_XLARGE("ml.c6i.8xlarge"),

    ML_C6_I_12_XLARGE("ml.c6i.12xlarge"),

    ML_C6_I_16_XLARGE("ml.c6i.16xlarge"),

    ML_C6_I_24_XLARGE("ml.c6i.24xlarge"),

    ML_C6_I_32_XLARGE("ml.c6i.32xlarge"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProcessingInstanceType> VALUE_MAP = EnumUtils.uniqueIndex(ProcessingInstanceType.class,
            ProcessingInstanceType::toString);

    private final String value;

    private ProcessingInstanceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ProcessingInstanceType corresponding to the value
     */
    public static ProcessingInstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ProcessingInstanceType}s
     */
    public static Set<ProcessingInstanceType> knownValues() {
        Set<ProcessingInstanceType> knownValues = EnumSet.allOf(ProcessingInstanceType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
