/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an ML capacity reservation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProductionVariantCapacityReservationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProductionVariantCapacityReservationSummary.Builder, ProductionVariantCapacityReservationSummary> {
    private static final SdkField<String> ML_RESERVATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MlReservationArn").getter(getter(ProductionVariantCapacityReservationSummary::mlReservationArn))
            .setter(setter(Builder::mlReservationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlReservationArn").build()).build();

    private static final SdkField<String> CAPACITY_RESERVATION_PREFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationPreference")
            .getter(getter(ProductionVariantCapacityReservationSummary::capacityReservationPreferenceAsString))
            .setter(setter(Builder::capacityReservationPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationPreference")
                    .build()).build();

    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalInstanceCount").getter(getter(ProductionVariantCapacityReservationSummary::totalInstanceCount))
            .setter(setter(Builder::totalInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount").build())
            .build();

    private static final SdkField<Integer> AVAILABLE_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailableInstanceCount")
            .getter(getter(ProductionVariantCapacityReservationSummary::availableInstanceCount))
            .setter(setter(Builder::availableInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCount").build())
            .build();

    private static final SdkField<Integer> USED_BY_CURRENT_ENDPOINT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UsedByCurrentEndpoint")
            .getter(getter(ProductionVariantCapacityReservationSummary::usedByCurrentEndpoint))
            .setter(setter(Builder::usedByCurrentEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsedByCurrentEndpoint").build())
            .build();

    private static final SdkField<List<Ec2CapacityReservation>> EC2_CAPACITY_RESERVATIONS_FIELD = SdkField
            .<List<Ec2CapacityReservation>> builder(MarshallingType.LIST)
            .memberName("Ec2CapacityReservations")
            .getter(getter(ProductionVariantCapacityReservationSummary::ec2CapacityReservations))
            .setter(setter(Builder::ec2CapacityReservations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2CapacityReservations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Ec2CapacityReservation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ec2CapacityReservation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ML_RESERVATION_ARN_FIELD,
            CAPACITY_RESERVATION_PREFERENCE_FIELD, TOTAL_INSTANCE_COUNT_FIELD, AVAILABLE_INSTANCE_COUNT_FIELD,
            USED_BY_CURRENT_ENDPOINT_FIELD, EC2_CAPACITY_RESERVATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mlReservationArn;

    private final String capacityReservationPreference;

    private final Integer totalInstanceCount;

    private final Integer availableInstanceCount;

    private final Integer usedByCurrentEndpoint;

    private final List<Ec2CapacityReservation> ec2CapacityReservations;

    private ProductionVariantCapacityReservationSummary(BuilderImpl builder) {
        this.mlReservationArn = builder.mlReservationArn;
        this.capacityReservationPreference = builder.capacityReservationPreference;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.usedByCurrentEndpoint = builder.usedByCurrentEndpoint;
        this.ec2CapacityReservations = builder.ec2CapacityReservations;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the ML capacity reservation that SageMaker AI applies
     * when it deploys the endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies the ML capacity reservation that SageMaker AI
     *         applies when it deploys the endpoint.
     */
    public final String mlReservationArn() {
        return mlReservationArn;
    }

    /**
     * <p>
     * The option that you chose for the capacity reservation. SageMaker AI supports the following options:
     * </p>
     * <dl>
     * <dt>capacity-reservations-only</dt>
     * <dd>
     * <p>
     * SageMaker AI launches instances only into an ML capacity reservation. If no capacity is available, the instances
     * fail to launch.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityReservationPreference} will return {@link CapacityReservationPreference#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #capacityReservationPreferenceAsString}.
     * </p>
     * 
     * @return The option that you chose for the capacity reservation. SageMaker AI supports the following options:</p>
     *         <dl>
     *         <dt>capacity-reservations-only</dt>
     *         <dd>
     *         <p>
     *         SageMaker AI launches instances only into an ML capacity reservation. If no capacity is available, the
     *         instances fail to launch.
     *         </p>
     *         </dd>
     * @see CapacityReservationPreference
     */
    public final CapacityReservationPreference capacityReservationPreference() {
        return CapacityReservationPreference.fromValue(capacityReservationPreference);
    }

    /**
     * <p>
     * The option that you chose for the capacity reservation. SageMaker AI supports the following options:
     * </p>
     * <dl>
     * <dt>capacity-reservations-only</dt>
     * <dd>
     * <p>
     * SageMaker AI launches instances only into an ML capacity reservation. If no capacity is available, the instances
     * fail to launch.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityReservationPreference} will return {@link CapacityReservationPreference#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #capacityReservationPreferenceAsString}.
     * </p>
     * 
     * @return The option that you chose for the capacity reservation. SageMaker AI supports the following options:</p>
     *         <dl>
     *         <dt>capacity-reservations-only</dt>
     *         <dd>
     *         <p>
     *         SageMaker AI launches instances only into an ML capacity reservation. If no capacity is available, the
     *         instances fail to launch.
     *         </p>
     *         </dd>
     * @see CapacityReservationPreference
     */
    public final String capacityReservationPreferenceAsString() {
        return capacityReservationPreference;
    }

    /**
     * <p>
     * The number of instances that you allocated to the ML capacity reservation.
     * </p>
     * 
     * @return The number of instances that you allocated to the ML capacity reservation.
     */
    public final Integer totalInstanceCount() {
        return totalInstanceCount;
    }

    /**
     * <p>
     * The number of instances that are currently available in the ML capacity reservation.
     * </p>
     * 
     * @return The number of instances that are currently available in the ML capacity reservation.
     */
    public final Integer availableInstanceCount() {
        return availableInstanceCount;
    }

    /**
     * <p>
     * The number of instances from the ML capacity reservation that are being used by the endpoint.
     * </p>
     * 
     * @return The number of instances from the ML capacity reservation that are being used by the endpoint.
     */
    public final Integer usedByCurrentEndpoint() {
        return usedByCurrentEndpoint;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ec2CapacityReservations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEc2CapacityReservations() {
        return ec2CapacityReservations != null && !(ec2CapacityReservations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The EC2 capacity reservations that are shared to this ML capacity reservation, if any.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2CapacityReservations} method.
     * </p>
     * 
     * @return The EC2 capacity reservations that are shared to this ML capacity reservation, if any.
     */
    public final List<Ec2CapacityReservation> ec2CapacityReservations() {
        return ec2CapacityReservations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mlReservationArn());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(usedByCurrentEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2CapacityReservations() ? ec2CapacityReservations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariantCapacityReservationSummary)) {
            return false;
        }
        ProductionVariantCapacityReservationSummary other = (ProductionVariantCapacityReservationSummary) obj;
        return Objects.equals(mlReservationArn(), other.mlReservationArn())
                && Objects.equals(capacityReservationPreferenceAsString(), other.capacityReservationPreferenceAsString())
                && Objects.equals(totalInstanceCount(), other.totalInstanceCount())
                && Objects.equals(availableInstanceCount(), other.availableInstanceCount())
                && Objects.equals(usedByCurrentEndpoint(), other.usedByCurrentEndpoint())
                && hasEc2CapacityReservations() == other.hasEc2CapacityReservations()
                && Objects.equals(ec2CapacityReservations(), other.ec2CapacityReservations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProductionVariantCapacityReservationSummary").add("MlReservationArn", mlReservationArn())
                .add("CapacityReservationPreference", capacityReservationPreferenceAsString())
                .add("TotalInstanceCount", totalInstanceCount()).add("AvailableInstanceCount", availableInstanceCount())
                .add("UsedByCurrentEndpoint", usedByCurrentEndpoint())
                .add("Ec2CapacityReservations", hasEc2CapacityReservations() ? ec2CapacityReservations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MlReservationArn":
            return Optional.ofNullable(clazz.cast(mlReservationArn()));
        case "CapacityReservationPreference":
            return Optional.ofNullable(clazz.cast(capacityReservationPreferenceAsString()));
        case "TotalInstanceCount":
            return Optional.ofNullable(clazz.cast(totalInstanceCount()));
        case "AvailableInstanceCount":
            return Optional.ofNullable(clazz.cast(availableInstanceCount()));
        case "UsedByCurrentEndpoint":
            return Optional.ofNullable(clazz.cast(usedByCurrentEndpoint()));
        case "Ec2CapacityReservations":
            return Optional.ofNullable(clazz.cast(ec2CapacityReservations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MlReservationArn", ML_RESERVATION_ARN_FIELD);
        map.put("CapacityReservationPreference", CAPACITY_RESERVATION_PREFERENCE_FIELD);
        map.put("TotalInstanceCount", TOTAL_INSTANCE_COUNT_FIELD);
        map.put("AvailableInstanceCount", AVAILABLE_INSTANCE_COUNT_FIELD);
        map.put("UsedByCurrentEndpoint", USED_BY_CURRENT_ENDPOINT_FIELD);
        map.put("Ec2CapacityReservations", EC2_CAPACITY_RESERVATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProductionVariantCapacityReservationSummary, T> g) {
        return obj -> g.apply((ProductionVariantCapacityReservationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProductionVariantCapacityReservationSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the ML capacity reservation that SageMaker AI applies
         * when it deploys the endpoint.
         * </p>
         * 
         * @param mlReservationArn
         *        The Amazon Resource Name (ARN) that uniquely identifies the ML capacity reservation that SageMaker AI
         *        applies when it deploys the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlReservationArn(String mlReservationArn);

        /**
         * <p>
         * The option that you chose for the capacity reservation. SageMaker AI supports the following options:
         * </p>
         * <dl>
         * <dt>capacity-reservations-only</dt>
         * <dd>
         * <p>
         * SageMaker AI launches instances only into an ML capacity reservation. If no capacity is available, the
         * instances fail to launch.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param capacityReservationPreference
         *        The option that you chose for the capacity reservation. SageMaker AI supports the following
         *        options:</p>
         *        <dl>
         *        <dt>capacity-reservations-only</dt>
         *        <dd>
         *        <p>
         *        SageMaker AI launches instances only into an ML capacity reservation. If no capacity is available, the
         *        instances fail to launch.
         *        </p>
         *        </dd>
         * @see CapacityReservationPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationPreference
         */
        Builder capacityReservationPreference(String capacityReservationPreference);

        /**
         * <p>
         * The option that you chose for the capacity reservation. SageMaker AI supports the following options:
         * </p>
         * <dl>
         * <dt>capacity-reservations-only</dt>
         * <dd>
         * <p>
         * SageMaker AI launches instances only into an ML capacity reservation. If no capacity is available, the
         * instances fail to launch.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param capacityReservationPreference
         *        The option that you chose for the capacity reservation. SageMaker AI supports the following
         *        options:</p>
         *        <dl>
         *        <dt>capacity-reservations-only</dt>
         *        <dd>
         *        <p>
         *        SageMaker AI launches instances only into an ML capacity reservation. If no capacity is available, the
         *        instances fail to launch.
         *        </p>
         *        </dd>
         * @see CapacityReservationPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationPreference
         */
        Builder capacityReservationPreference(CapacityReservationPreference capacityReservationPreference);

        /**
         * <p>
         * The number of instances that you allocated to the ML capacity reservation.
         * </p>
         * 
         * @param totalInstanceCount
         *        The number of instances that you allocated to the ML capacity reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalInstanceCount(Integer totalInstanceCount);

        /**
         * <p>
         * The number of instances that are currently available in the ML capacity reservation.
         * </p>
         * 
         * @param availableInstanceCount
         *        The number of instances that are currently available in the ML capacity reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableInstanceCount(Integer availableInstanceCount);

        /**
         * <p>
         * The number of instances from the ML capacity reservation that are being used by the endpoint.
         * </p>
         * 
         * @param usedByCurrentEndpoint
         *        The number of instances from the ML capacity reservation that are being used by the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usedByCurrentEndpoint(Integer usedByCurrentEndpoint);

        /**
         * <p>
         * The EC2 capacity reservations that are shared to this ML capacity reservation, if any.
         * </p>
         * 
         * @param ec2CapacityReservations
         *        The EC2 capacity reservations that are shared to this ML capacity reservation, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2CapacityReservations(Collection<Ec2CapacityReservation> ec2CapacityReservations);

        /**
         * <p>
         * The EC2 capacity reservations that are shared to this ML capacity reservation, if any.
         * </p>
         * 
         * @param ec2CapacityReservations
         *        The EC2 capacity reservations that are shared to this ML capacity reservation, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2CapacityReservations(Ec2CapacityReservation... ec2CapacityReservations);

        /**
         * <p>
         * The EC2 capacity reservations that are shared to this ML capacity reservation, if any.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Ec2CapacityReservation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.Ec2CapacityReservation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Ec2CapacityReservation.Builder#build()} is called
         * immediately and its result is passed to {@link #ec2CapacityReservations(List<Ec2CapacityReservation>)}.
         * 
         * @param ec2CapacityReservations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Ec2CapacityReservation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2CapacityReservations(java.util.Collection<Ec2CapacityReservation>)
         */
        Builder ec2CapacityReservations(Consumer<Ec2CapacityReservation.Builder>... ec2CapacityReservations);
    }

    static final class BuilderImpl implements Builder {
        private String mlReservationArn;

        private String capacityReservationPreference;

        private Integer totalInstanceCount;

        private Integer availableInstanceCount;

        private Integer usedByCurrentEndpoint;

        private List<Ec2CapacityReservation> ec2CapacityReservations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionVariantCapacityReservationSummary model) {
            mlReservationArn(model.mlReservationArn);
            capacityReservationPreference(model.capacityReservationPreference);
            totalInstanceCount(model.totalInstanceCount);
            availableInstanceCount(model.availableInstanceCount);
            usedByCurrentEndpoint(model.usedByCurrentEndpoint);
            ec2CapacityReservations(model.ec2CapacityReservations);
        }

        public final String getMlReservationArn() {
            return mlReservationArn;
        }

        public final void setMlReservationArn(String mlReservationArn) {
            this.mlReservationArn = mlReservationArn;
        }

        @Override
        public final Builder mlReservationArn(String mlReservationArn) {
            this.mlReservationArn = mlReservationArn;
            return this;
        }

        public final String getCapacityReservationPreference() {
            return capacityReservationPreference;
        }

        public final void setCapacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
        }

        @Override
        public final Builder capacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
            return this;
        }

        @Override
        public final Builder capacityReservationPreference(CapacityReservationPreference capacityReservationPreference) {
            this.capacityReservationPreference(capacityReservationPreference == null ? null : capacityReservationPreference
                    .toString());
            return this;
        }

        public final Integer getTotalInstanceCount() {
            return totalInstanceCount;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final Integer getAvailableInstanceCount() {
            return availableInstanceCount;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final Integer getUsedByCurrentEndpoint() {
            return usedByCurrentEndpoint;
        }

        public final void setUsedByCurrentEndpoint(Integer usedByCurrentEndpoint) {
            this.usedByCurrentEndpoint = usedByCurrentEndpoint;
        }

        @Override
        public final Builder usedByCurrentEndpoint(Integer usedByCurrentEndpoint) {
            this.usedByCurrentEndpoint = usedByCurrentEndpoint;
            return this;
        }

        public final List<Ec2CapacityReservation.Builder> getEc2CapacityReservations() {
            List<Ec2CapacityReservation.Builder> result = Ec2CapacityReservationsListCopier
                    .copyToBuilder(this.ec2CapacityReservations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2CapacityReservations(Collection<Ec2CapacityReservation.BuilderImpl> ec2CapacityReservations) {
            this.ec2CapacityReservations = Ec2CapacityReservationsListCopier.copyFromBuilder(ec2CapacityReservations);
        }

        @Override
        public final Builder ec2CapacityReservations(Collection<Ec2CapacityReservation> ec2CapacityReservations) {
            this.ec2CapacityReservations = Ec2CapacityReservationsListCopier.copy(ec2CapacityReservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2CapacityReservations(Ec2CapacityReservation... ec2CapacityReservations) {
            ec2CapacityReservations(Arrays.asList(ec2CapacityReservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2CapacityReservations(Consumer<Ec2CapacityReservation.Builder>... ec2CapacityReservations) {
            ec2CapacityReservations(Stream.of(ec2CapacityReservations)
                    .map(c -> Ec2CapacityReservation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ProductionVariantCapacityReservationSummary build() {
            return new ProductionVariantCapacityReservationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
