/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the payload for a recommendation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationJobPayloadConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationJobPayloadConfig.Builder, RecommendationJobPayloadConfig> {
    private static final SdkField<String> SAMPLE_PAYLOAD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SamplePayloadUrl").getter(getter(RecommendationJobPayloadConfig::samplePayloadUrl))
            .setter(setter(Builder::samplePayloadUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplePayloadUrl").build()).build();

    private static final SdkField<List<String>> SUPPORTED_CONTENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedContentTypes")
            .getter(getter(RecommendationJobPayloadConfig::supportedContentTypes))
            .setter(setter(Builder::supportedContentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedContentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLE_PAYLOAD_URL_FIELD,
            SUPPORTED_CONTENT_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String samplePayloadUrl;

    private final List<String> supportedContentTypes;

    private RecommendationJobPayloadConfig(BuilderImpl builder) {
        this.samplePayloadUrl = builder.samplePayloadUrl;
        this.supportedContentTypes = builder.supportedContentTypes;
    }

    /**
     * <p>
     * The Amazon Simple Storage Service (Amazon S3) path where the sample payload is stored. This path must point to a
     * single gzip compressed tar archive (.tar.gz suffix).
     * </p>
     * 
     * @return The Amazon Simple Storage Service (Amazon S3) path where the sample payload is stored. This path must
     *         point to a single gzip compressed tar archive (.tar.gz suffix).
     */
    public final String samplePayloadUrl() {
        return samplePayloadUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedContentTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedContentTypes() {
        return supportedContentTypes != null && !(supportedContentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported MIME types for the input data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedContentTypes} method.
     * </p>
     * 
     * @return The supported MIME types for the input data.
     */
    public final List<String> supportedContentTypes() {
        return supportedContentTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(samplePayloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedContentTypes() ? supportedContentTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationJobPayloadConfig)) {
            return false;
        }
        RecommendationJobPayloadConfig other = (RecommendationJobPayloadConfig) obj;
        return Objects.equals(samplePayloadUrl(), other.samplePayloadUrl())
                && hasSupportedContentTypes() == other.hasSupportedContentTypes()
                && Objects.equals(supportedContentTypes(), other.supportedContentTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationJobPayloadConfig").add("SamplePayloadUrl", samplePayloadUrl())
                .add("SupportedContentTypes", hasSupportedContentTypes() ? supportedContentTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SamplePayloadUrl":
            return Optional.ofNullable(clazz.cast(samplePayloadUrl()));
        case "SupportedContentTypes":
            return Optional.ofNullable(clazz.cast(supportedContentTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SamplePayloadUrl", SAMPLE_PAYLOAD_URL_FIELD);
        map.put("SupportedContentTypes", SUPPORTED_CONTENT_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationJobPayloadConfig, T> g) {
        return obj -> g.apply((RecommendationJobPayloadConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationJobPayloadConfig> {
        /**
         * <p>
         * The Amazon Simple Storage Service (Amazon S3) path where the sample payload is stored. This path must point
         * to a single gzip compressed tar archive (.tar.gz suffix).
         * </p>
         * 
         * @param samplePayloadUrl
         *        The Amazon Simple Storage Service (Amazon S3) path where the sample payload is stored. This path must
         *        point to a single gzip compressed tar archive (.tar.gz suffix).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplePayloadUrl(String samplePayloadUrl);

        /**
         * <p>
         * The supported MIME types for the input data.
         * </p>
         * 
         * @param supportedContentTypes
         *        The supported MIME types for the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedContentTypes(Collection<String> supportedContentTypes);

        /**
         * <p>
         * The supported MIME types for the input data.
         * </p>
         * 
         * @param supportedContentTypes
         *        The supported MIME types for the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedContentTypes(String... supportedContentTypes);
    }

    static final class BuilderImpl implements Builder {
        private String samplePayloadUrl;

        private List<String> supportedContentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationJobPayloadConfig model) {
            samplePayloadUrl(model.samplePayloadUrl);
            supportedContentTypes(model.supportedContentTypes);
        }

        public final String getSamplePayloadUrl() {
            return samplePayloadUrl;
        }

        public final void setSamplePayloadUrl(String samplePayloadUrl) {
            this.samplePayloadUrl = samplePayloadUrl;
        }

        @Override
        public final Builder samplePayloadUrl(String samplePayloadUrl) {
            this.samplePayloadUrl = samplePayloadUrl;
            return this;
        }

        public final Collection<String> getSupportedContentTypes() {
            if (supportedContentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedContentTypes;
        }

        public final void setSupportedContentTypes(Collection<String> supportedContentTypes) {
            this.supportedContentTypes = RecommendationJobSupportedContentTypesCopier.copy(supportedContentTypes);
        }

        @Override
        public final Builder supportedContentTypes(Collection<String> supportedContentTypes) {
            this.supportedContentTypes = RecommendationJobSupportedContentTypesCopier.copy(supportedContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedContentTypes(String... supportedContentTypes) {
            supportedContentTypes(Arrays.asList(supportedContentTypes));
            return this;
        }

        @Override
        public RecommendationJobPayloadConfig build() {
            return new RecommendationJobPayloadConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
