/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RenderUiTemplateResponse extends SageMakerResponse implements
        ToCopyableBuilder<RenderUiTemplateResponse.Builder, RenderUiTemplateResponse> {
    private static final SdkField<String> RENDERED_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RenderedContent").getter(getter(RenderUiTemplateResponse::renderedContent))
            .setter(setter(Builder::renderedContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenderedContent").build()).build();

    private static final SdkField<List<RenderingError>> ERRORS_FIELD = SdkField
            .<List<RenderingError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(RenderUiTemplateResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RenderingError> builder(MarshallingType.SDK_POJO)
                                            .constructor(RenderingError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENDERED_CONTENT_FIELD,
            ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String renderedContent;

    private final List<RenderingError> errors;

    private RenderUiTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.renderedContent = builder.renderedContent;
        this.errors = builder.errors;
    }

    /**
     * <p>
     * A Liquid template that renders the HTML for the worker UI.
     * </p>
     * 
     * @return A Liquid template that renders the HTML for the worker UI.
     */
    public final String renderedContent() {
        return renderedContent;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one or more <code>RenderingError</code> objects if any were encountered while rendering the template.
     * If there were no errors, the list is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of one or more <code>RenderingError</code> objects if any were encountered while rendering the
     *         template. If there were no errors, the list is empty.
     */
    public final List<RenderingError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(renderedContent());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenderUiTemplateResponse)) {
            return false;
        }
        RenderUiTemplateResponse other = (RenderUiTemplateResponse) obj;
        return Objects.equals(renderedContent(), other.renderedContent()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RenderUiTemplateResponse").add("RenderedContent", renderedContent())
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RenderedContent":
            return Optional.ofNullable(clazz.cast(renderedContent()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RenderedContent", RENDERED_CONTENT_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RenderUiTemplateResponse, T> g) {
        return obj -> g.apply((RenderUiTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, RenderUiTemplateResponse> {
        /**
         * <p>
         * A Liquid template that renders the HTML for the worker UI.
         * </p>
         * 
         * @param renderedContent
         *        A Liquid template that renders the HTML for the worker UI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renderedContent(String renderedContent);

        /**
         * <p>
         * A list of one or more <code>RenderingError</code> objects if any were encountered while rendering the
         * template. If there were no errors, the list is empty.
         * </p>
         * 
         * @param errors
         *        A list of one or more <code>RenderingError</code> objects if any were encountered while rendering the
         *        template. If there were no errors, the list is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<RenderingError> errors);

        /**
         * <p>
         * A list of one or more <code>RenderingError</code> objects if any were encountered while rendering the
         * template. If there were no errors, the list is empty.
         * </p>
         * 
         * @param errors
         *        A list of one or more <code>RenderingError</code> objects if any were encountered while rendering the
         *        template. If there were no errors, the list is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(RenderingError... errors);

        /**
         * <p>
         * A list of one or more <code>RenderingError</code> objects if any were encountered while rendering the
         * template. If there were no errors, the list is empty.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.RenderingError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.sagemaker.model.RenderingError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.RenderingError.Builder#build()} is called immediately
         * and its result is passed to {@link #errors(List<RenderingError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.RenderingError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<RenderingError>)
         */
        Builder errors(Consumer<RenderingError.Builder>... errors);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String renderedContent;

        private List<RenderingError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RenderUiTemplateResponse model) {
            super(model);
            renderedContent(model.renderedContent);
            errors(model.errors);
        }

        public final String getRenderedContent() {
            return renderedContent;
        }

        public final void setRenderedContent(String renderedContent) {
            this.renderedContent = renderedContent;
        }

        @Override
        public final Builder renderedContent(String renderedContent) {
            this.renderedContent = renderedContent;
            return this;
        }

        public final List<RenderingError.Builder> getErrors() {
            List<RenderingError.Builder> result = RenderingErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<RenderingError.BuilderImpl> errors) {
            this.errors = RenderingErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<RenderingError> errors) {
            this.errors = RenderingErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(RenderingError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<RenderingError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> RenderingError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RenderUiTemplateResponse build() {
            return new RenderUiTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
