/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ReservedCapacityInstanceType {
    ML_P4_D_24_XLARGE("ml.p4d.24xlarge"),

    ML_P5_48_XLARGE("ml.p5.48xlarge"),

    ML_P5_E_48_XLARGE("ml.p5e.48xlarge"),

    ML_P5_EN_48_XLARGE("ml.p5en.48xlarge"),

    ML_TRN1_32_XLARGE("ml.trn1.32xlarge"),

    ML_TRN2_48_XLARGE("ml.trn2.48xlarge"),

    ML_P6_B200_48_XLARGE("ml.p6-b200.48xlarge"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReservedCapacityInstanceType> VALUE_MAP = EnumUtils.uniqueIndex(
            ReservedCapacityInstanceType.class, ReservedCapacityInstanceType::toString);

    private final String value;

    private ReservedCapacityInstanceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ReservedCapacityInstanceType corresponding to the value
     */
    public static ReservedCapacityInstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ReservedCapacityInstanceType}s
     */
    public static Set<ReservedCapacityInstanceType> knownValues() {
        Set<ReservedCapacityInstanceType> knownValues = EnumSet.allOf(ReservedCapacityInstanceType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
