/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Resource sharing configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceSharingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceSharingConfig.Builder, ResourceSharingConfig> {
    private static final SdkField<String> STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Strategy").getter(getter(ResourceSharingConfig::strategyAsString)).setter(setter(Builder::strategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy").build()).build();

    private static final SdkField<Integer> BORROW_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BorrowLimit").getter(getter(ResourceSharingConfig::borrowLimit)).setter(setter(Builder::borrowLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorrowLimit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRATEGY_FIELD,
            BORROW_LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String strategy;

    private final Integer borrowLimit;

    private ResourceSharingConfig(BuilderImpl builder) {
        this.strategy = builder.strategy;
        this.borrowLimit = builder.borrowLimit;
    }

    /**
     * <p>
     * The strategy of how idle compute is shared within the cluster. The following are the options of strategies.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DontLend</code>: entities do not lend idle compute.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Lend</code>: entities can lend idle compute to entities that can borrow.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LendandBorrow</code>: entities can lend idle compute and borrow idle compute from other entities.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default is <code>LendandBorrow</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link ResourceSharingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #strategyAsString}.
     * </p>
     * 
     * @return The strategy of how idle compute is shared within the cluster. The following are the options of
     *         strategies.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DontLend</code>: entities do not lend idle compute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Lend</code>: entities can lend idle compute to entities that can borrow.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LendandBorrow</code>: entities can lend idle compute and borrow idle compute from other entities.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default is <code>LendandBorrow</code>.
     * @see ResourceSharingStrategy
     */
    public final ResourceSharingStrategy strategy() {
        return ResourceSharingStrategy.fromValue(strategy);
    }

    /**
     * <p>
     * The strategy of how idle compute is shared within the cluster. The following are the options of strategies.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DontLend</code>: entities do not lend idle compute.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Lend</code>: entities can lend idle compute to entities that can borrow.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LendandBorrow</code>: entities can lend idle compute and borrow idle compute from other entities.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default is <code>LendandBorrow</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link ResourceSharingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #strategyAsString}.
     * </p>
     * 
     * @return The strategy of how idle compute is shared within the cluster. The following are the options of
     *         strategies.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DontLend</code>: entities do not lend idle compute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Lend</code>: entities can lend idle compute to entities that can borrow.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LendandBorrow</code>: entities can lend idle compute and borrow idle compute from other entities.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default is <code>LendandBorrow</code>.
     * @see ResourceSharingStrategy
     */
    public final String strategyAsString() {
        return strategy;
    }

    /**
     * <p>
     * The limit on how much idle compute can be borrowed.The values can be 1 - 500 percent of idle compute that the
     * team is allowed to borrow.
     * </p>
     * <p>
     * Default is <code>50</code>.
     * </p>
     * 
     * @return The limit on how much idle compute can be borrowed.The values can be 1 - 500 percent of idle compute that
     *         the team is allowed to borrow.</p>
     *         <p>
     *         Default is <code>50</code>.
     */
    public final Integer borrowLimit() {
        return borrowLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(borrowLimit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSharingConfig)) {
            return false;
        }
        ResourceSharingConfig other = (ResourceSharingConfig) obj;
        return Objects.equals(strategyAsString(), other.strategyAsString()) && Objects.equals(borrowLimit(), other.borrowLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceSharingConfig").add("Strategy", strategyAsString()).add("BorrowLimit", borrowLimit())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Strategy":
            return Optional.ofNullable(clazz.cast(strategyAsString()));
        case "BorrowLimit":
            return Optional.ofNullable(clazz.cast(borrowLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Strategy", STRATEGY_FIELD);
        map.put("BorrowLimit", BORROW_LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceSharingConfig, T> g) {
        return obj -> g.apply((ResourceSharingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceSharingConfig> {
        /**
         * <p>
         * The strategy of how idle compute is shared within the cluster. The following are the options of strategies.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DontLend</code>: entities do not lend idle compute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Lend</code>: entities can lend idle compute to entities that can borrow.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LendandBorrow</code>: entities can lend idle compute and borrow idle compute from other entities.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default is <code>LendandBorrow</code>.
         * </p>
         * 
         * @param strategy
         *        The strategy of how idle compute is shared within the cluster. The following are the options of
         *        strategies.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DontLend</code>: entities do not lend idle compute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Lend</code>: entities can lend idle compute to entities that can borrow.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LendandBorrow</code>: entities can lend idle compute and borrow idle compute from other
         *        entities.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default is <code>LendandBorrow</code>.
         * @see ResourceSharingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSharingStrategy
         */
        Builder strategy(String strategy);

        /**
         * <p>
         * The strategy of how idle compute is shared within the cluster. The following are the options of strategies.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DontLend</code>: entities do not lend idle compute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Lend</code>: entities can lend idle compute to entities that can borrow.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LendandBorrow</code>: entities can lend idle compute and borrow idle compute from other entities.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default is <code>LendandBorrow</code>.
         * </p>
         * 
         * @param strategy
         *        The strategy of how idle compute is shared within the cluster. The following are the options of
         *        strategies.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DontLend</code>: entities do not lend idle compute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Lend</code>: entities can lend idle compute to entities that can borrow.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LendandBorrow</code>: entities can lend idle compute and borrow idle compute from other
         *        entities.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default is <code>LendandBorrow</code>.
         * @see ResourceSharingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSharingStrategy
         */
        Builder strategy(ResourceSharingStrategy strategy);

        /**
         * <p>
         * The limit on how much idle compute can be borrowed.The values can be 1 - 500 percent of idle compute that the
         * team is allowed to borrow.
         * </p>
         * <p>
         * Default is <code>50</code>.
         * </p>
         * 
         * @param borrowLimit
         *        The limit on how much idle compute can be borrowed.The values can be 1 - 500 percent of idle compute
         *        that the team is allowed to borrow.</p>
         *        <p>
         *        Default is <code>50</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder borrowLimit(Integer borrowLimit);
    }

    static final class BuilderImpl implements Builder {
        private String strategy;

        private Integer borrowLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSharingConfig model) {
            strategy(model.strategy);
            borrowLimit(model.borrowLimit);
        }

        public final String getStrategy() {
            return strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(ResourceSharingStrategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public final Integer getBorrowLimit() {
            return borrowLimit;
        }

        public final void setBorrowLimit(Integer borrowLimit) {
            this.borrowLimit = borrowLimit;
        }

        @Override
        public final Builder borrowLimit(Integer borrowLimit) {
            this.borrowLimit = borrowLimit;
            return this;
        }

        @Override
        public ResourceSharingConfig build() {
            return new ResourceSharingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
