/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configurations that SageMaker uses when updating the AMI versions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RollingDeploymentPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<RollingDeploymentPolicy.Builder, RollingDeploymentPolicy> {
    private static final SdkField<CapacitySizeConfig> MAXIMUM_BATCH_SIZE_FIELD = SdkField
            .<CapacitySizeConfig> builder(MarshallingType.SDK_POJO).memberName("MaximumBatchSize")
            .getter(getter(RollingDeploymentPolicy::maximumBatchSize)).setter(setter(Builder::maximumBatchSize))
            .constructor(CapacitySizeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchSize").build()).build();

    private static final SdkField<CapacitySizeConfig> ROLLBACK_MAXIMUM_BATCH_SIZE_FIELD = SdkField
            .<CapacitySizeConfig> builder(MarshallingType.SDK_POJO).memberName("RollbackMaximumBatchSize")
            .getter(getter(RollingDeploymentPolicy::rollbackMaximumBatchSize)).setter(setter(Builder::rollbackMaximumBatchSize))
            .constructor(CapacitySizeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackMaximumBatchSize").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_BATCH_SIZE_FIELD,
            ROLLBACK_MAXIMUM_BATCH_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CapacitySizeConfig maximumBatchSize;

    private final CapacitySizeConfig rollbackMaximumBatchSize;

    private RollingDeploymentPolicy(BuilderImpl builder) {
        this.maximumBatchSize = builder.maximumBatchSize;
        this.rollbackMaximumBatchSize = builder.rollbackMaximumBatchSize;
    }

    /**
     * <p>
     * The maximum amount of instances in the cluster that SageMaker can update at a time.
     * </p>
     * 
     * @return The maximum amount of instances in the cluster that SageMaker can update at a time.
     */
    public final CapacitySizeConfig maximumBatchSize() {
        return maximumBatchSize;
    }

    /**
     * <p>
     * The maximum amount of instances in the cluster that SageMaker can roll back at a time.
     * </p>
     * 
     * @return The maximum amount of instances in the cluster that SageMaker can roll back at a time.
     */
    public final CapacitySizeConfig rollbackMaximumBatchSize() {
        return rollbackMaximumBatchSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumBatchSize());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackMaximumBatchSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RollingDeploymentPolicy)) {
            return false;
        }
        RollingDeploymentPolicy other = (RollingDeploymentPolicy) obj;
        return Objects.equals(maximumBatchSize(), other.maximumBatchSize())
                && Objects.equals(rollbackMaximumBatchSize(), other.rollbackMaximumBatchSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RollingDeploymentPolicy").add("MaximumBatchSize", maximumBatchSize())
                .add("RollbackMaximumBatchSize", rollbackMaximumBatchSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaximumBatchSize":
            return Optional.ofNullable(clazz.cast(maximumBatchSize()));
        case "RollbackMaximumBatchSize":
            return Optional.ofNullable(clazz.cast(rollbackMaximumBatchSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaximumBatchSize", MAXIMUM_BATCH_SIZE_FIELD);
        map.put("RollbackMaximumBatchSize", ROLLBACK_MAXIMUM_BATCH_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RollingDeploymentPolicy, T> g) {
        return obj -> g.apply((RollingDeploymentPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RollingDeploymentPolicy> {
        /**
         * <p>
         * The maximum amount of instances in the cluster that SageMaker can update at a time.
         * </p>
         * 
         * @param maximumBatchSize
         *        The maximum amount of instances in the cluster that SageMaker can update at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBatchSize(CapacitySizeConfig maximumBatchSize);

        /**
         * <p>
         * The maximum amount of instances in the cluster that SageMaker can update at a time.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacitySizeConfig.Builder} avoiding the
         * need to create one manually via {@link CapacitySizeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacitySizeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #maximumBatchSize(CapacitySizeConfig)}.
         * 
         * @param maximumBatchSize
         *        a consumer that will call methods on {@link CapacitySizeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maximumBatchSize(CapacitySizeConfig)
         */
        default Builder maximumBatchSize(Consumer<CapacitySizeConfig.Builder> maximumBatchSize) {
            return maximumBatchSize(CapacitySizeConfig.builder().applyMutation(maximumBatchSize).build());
        }

        /**
         * <p>
         * The maximum amount of instances in the cluster that SageMaker can roll back at a time.
         * </p>
         * 
         * @param rollbackMaximumBatchSize
         *        The maximum amount of instances in the cluster that SageMaker can roll back at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackMaximumBatchSize(CapacitySizeConfig rollbackMaximumBatchSize);

        /**
         * <p>
         * The maximum amount of instances in the cluster that SageMaker can roll back at a time.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacitySizeConfig.Builder} avoiding the
         * need to create one manually via {@link CapacitySizeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacitySizeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #rollbackMaximumBatchSize(CapacitySizeConfig)}.
         * 
         * @param rollbackMaximumBatchSize
         *        a consumer that will call methods on {@link CapacitySizeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollbackMaximumBatchSize(CapacitySizeConfig)
         */
        default Builder rollbackMaximumBatchSize(Consumer<CapacitySizeConfig.Builder> rollbackMaximumBatchSize) {
            return rollbackMaximumBatchSize(CapacitySizeConfig.builder().applyMutation(rollbackMaximumBatchSize).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CapacitySizeConfig maximumBatchSize;

        private CapacitySizeConfig rollbackMaximumBatchSize;

        private BuilderImpl() {
        }

        private BuilderImpl(RollingDeploymentPolicy model) {
            maximumBatchSize(model.maximumBatchSize);
            rollbackMaximumBatchSize(model.rollbackMaximumBatchSize);
        }

        public final CapacitySizeConfig.Builder getMaximumBatchSize() {
            return maximumBatchSize != null ? maximumBatchSize.toBuilder() : null;
        }

        public final void setMaximumBatchSize(CapacitySizeConfig.BuilderImpl maximumBatchSize) {
            this.maximumBatchSize = maximumBatchSize != null ? maximumBatchSize.build() : null;
        }

        @Override
        public final Builder maximumBatchSize(CapacitySizeConfig maximumBatchSize) {
            this.maximumBatchSize = maximumBatchSize;
            return this;
        }

        public final CapacitySizeConfig.Builder getRollbackMaximumBatchSize() {
            return rollbackMaximumBatchSize != null ? rollbackMaximumBatchSize.toBuilder() : null;
        }

        public final void setRollbackMaximumBatchSize(CapacitySizeConfig.BuilderImpl rollbackMaximumBatchSize) {
            this.rollbackMaximumBatchSize = rollbackMaximumBatchSize != null ? rollbackMaximumBatchSize.build() : null;
        }

        @Override
        public final Builder rollbackMaximumBatchSize(CapacitySizeConfig rollbackMaximumBatchSize) {
            this.rollbackMaximumBatchSize = rollbackMaximumBatchSize;
            return this;
        }

        @Override
        public RollingDeploymentPolicy build() {
            return new RollingDeploymentPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
