/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Cluster policy configuration. This policy is used for task prioritization and fair-share allocation. This helps
 * prioritize critical workloads and distributes idle compute across entities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchedulerConfig implements SdkPojo, Serializable, ToCopyableBuilder<SchedulerConfig.Builder, SchedulerConfig> {
    private static final SdkField<List<PriorityClass>> PRIORITY_CLASSES_FIELD = SdkField
            .<List<PriorityClass>> builder(MarshallingType.LIST)
            .memberName("PriorityClasses")
            .getter(getter(SchedulerConfig::priorityClasses))
            .setter(setter(Builder::priorityClasses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriorityClasses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PriorityClass> builder(MarshallingType.SDK_POJO)
                                            .constructor(PriorityClass::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FAIR_SHARE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FairShare").getter(getter(SchedulerConfig::fairShareAsString)).setter(setter(Builder::fairShare))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FairShare").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIORITY_CLASSES_FIELD,
            FAIR_SHARE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<PriorityClass> priorityClasses;

    private final String fairShare;

    private SchedulerConfig(BuilderImpl builder) {
        this.priorityClasses = builder.priorityClasses;
        this.fairShare = builder.fairShare;
    }

    /**
     * For responses, this returns true if the service returned a value for the PriorityClasses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPriorityClasses() {
        return priorityClasses != null && !(priorityClasses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the priority classes, <code>PriorityClass</code>, of the cluster policy. When specified, these class
     * configurations define how tasks are queued.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPriorityClasses} method.
     * </p>
     * 
     * @return List of the priority classes, <code>PriorityClass</code>, of the cluster policy. When specified, these
     *         class configurations define how tasks are queued.
     */
    public final List<PriorityClass> priorityClasses() {
        return priorityClasses;
    }

    /**
     * <p>
     * When enabled, entities borrow idle compute based on their assigned <code>FairShareWeight</code>.
     * </p>
     * <p>
     * When disabled, entities borrow idle compute based on a first-come first-serve basis.
     * </p>
     * <p>
     * Default is <code>Enabled</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fairShare} will
     * return {@link FairShare#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fairShareAsString}.
     * </p>
     * 
     * @return When enabled, entities borrow idle compute based on their assigned <code>FairShareWeight</code>.</p>
     *         <p>
     *         When disabled, entities borrow idle compute based on a first-come first-serve basis.
     *         </p>
     *         <p>
     *         Default is <code>Enabled</code>.
     * @see FairShare
     */
    public final FairShare fairShare() {
        return FairShare.fromValue(fairShare);
    }

    /**
     * <p>
     * When enabled, entities borrow idle compute based on their assigned <code>FairShareWeight</code>.
     * </p>
     * <p>
     * When disabled, entities borrow idle compute based on a first-come first-serve basis.
     * </p>
     * <p>
     * Default is <code>Enabled</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fairShare} will
     * return {@link FairShare#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fairShareAsString}.
     * </p>
     * 
     * @return When enabled, entities borrow idle compute based on their assigned <code>FairShareWeight</code>.</p>
     *         <p>
     *         When disabled, entities borrow idle compute based on a first-come first-serve basis.
     *         </p>
     *         <p>
     *         Default is <code>Enabled</code>.
     * @see FairShare
     */
    public final String fairShareAsString() {
        return fairShare;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPriorityClasses() ? priorityClasses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fairShareAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchedulerConfig)) {
            return false;
        }
        SchedulerConfig other = (SchedulerConfig) obj;
        return hasPriorityClasses() == other.hasPriorityClasses() && Objects.equals(priorityClasses(), other.priorityClasses())
                && Objects.equals(fairShareAsString(), other.fairShareAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchedulerConfig").add("PriorityClasses", hasPriorityClasses() ? priorityClasses() : null)
                .add("FairShare", fairShareAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PriorityClasses":
            return Optional.ofNullable(clazz.cast(priorityClasses()));
        case "FairShare":
            return Optional.ofNullable(clazz.cast(fairShareAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PriorityClasses", PRIORITY_CLASSES_FIELD);
        map.put("FairShare", FAIR_SHARE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchedulerConfig, T> g) {
        return obj -> g.apply((SchedulerConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchedulerConfig> {
        /**
         * <p>
         * List of the priority classes, <code>PriorityClass</code>, of the cluster policy. When specified, these class
         * configurations define how tasks are queued.
         * </p>
         * 
         * @param priorityClasses
         *        List of the priority classes, <code>PriorityClass</code>, of the cluster policy. When specified, these
         *        class configurations define how tasks are queued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priorityClasses(Collection<PriorityClass> priorityClasses);

        /**
         * <p>
         * List of the priority classes, <code>PriorityClass</code>, of the cluster policy. When specified, these class
         * configurations define how tasks are queued.
         * </p>
         * 
         * @param priorityClasses
         *        List of the priority classes, <code>PriorityClass</code>, of the cluster policy. When specified, these
         *        class configurations define how tasks are queued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priorityClasses(PriorityClass... priorityClasses);

        /**
         * <p>
         * List of the priority classes, <code>PriorityClass</code>, of the cluster policy. When specified, these class
         * configurations define how tasks are queued.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.PriorityClass.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sagemaker.model.PriorityClass#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.PriorityClass.Builder#build()} is called immediately
         * and its result is passed to {@link #priorityClasses(List<PriorityClass>)}.
         * 
         * @param priorityClasses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.PriorityClass.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #priorityClasses(java.util.Collection<PriorityClass>)
         */
        Builder priorityClasses(Consumer<PriorityClass.Builder>... priorityClasses);

        /**
         * <p>
         * When enabled, entities borrow idle compute based on their assigned <code>FairShareWeight</code>.
         * </p>
         * <p>
         * When disabled, entities borrow idle compute based on a first-come first-serve basis.
         * </p>
         * <p>
         * Default is <code>Enabled</code>.
         * </p>
         * 
         * @param fairShare
         *        When enabled, entities borrow idle compute based on their assigned <code>FairShareWeight</code>.</p>
         *        <p>
         *        When disabled, entities borrow idle compute based on a first-come first-serve basis.
         *        </p>
         *        <p>
         *        Default is <code>Enabled</code>.
         * @see FairShare
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FairShare
         */
        Builder fairShare(String fairShare);

        /**
         * <p>
         * When enabled, entities borrow idle compute based on their assigned <code>FairShareWeight</code>.
         * </p>
         * <p>
         * When disabled, entities borrow idle compute based on a first-come first-serve basis.
         * </p>
         * <p>
         * Default is <code>Enabled</code>.
         * </p>
         * 
         * @param fairShare
         *        When enabled, entities borrow idle compute based on their assigned <code>FairShareWeight</code>.</p>
         *        <p>
         *        When disabled, entities borrow idle compute based on a first-come first-serve basis.
         *        </p>
         *        <p>
         *        Default is <code>Enabled</code>.
         * @see FairShare
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FairShare
         */
        Builder fairShare(FairShare fairShare);
    }

    static final class BuilderImpl implements Builder {
        private List<PriorityClass> priorityClasses = DefaultSdkAutoConstructList.getInstance();

        private String fairShare;

        private BuilderImpl() {
        }

        private BuilderImpl(SchedulerConfig model) {
            priorityClasses(model.priorityClasses);
            fairShare(model.fairShare);
        }

        public final List<PriorityClass.Builder> getPriorityClasses() {
            List<PriorityClass.Builder> result = PriorityClassListCopier.copyToBuilder(this.priorityClasses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPriorityClasses(Collection<PriorityClass.BuilderImpl> priorityClasses) {
            this.priorityClasses = PriorityClassListCopier.copyFromBuilder(priorityClasses);
        }

        @Override
        public final Builder priorityClasses(Collection<PriorityClass> priorityClasses) {
            this.priorityClasses = PriorityClassListCopier.copy(priorityClasses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priorityClasses(PriorityClass... priorityClasses) {
            priorityClasses(Arrays.asList(priorityClasses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priorityClasses(Consumer<PriorityClass.Builder>... priorityClasses) {
            priorityClasses(Stream.of(priorityClasses).map(c -> PriorityClass.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getFairShare() {
            return fairShare;
        }

        public final void setFairShare(String fairShare) {
            this.fairShare = fairShare;
        }

        @Override
        public final Builder fairShare(String fairShare) {
            this.fairShare = fairShare;
            return this;
        }

        @Override
        public final Builder fairShare(FairShare fairShare) {
            this.fairShare(fairShare == null ? null : fairShare.toString());
            return this;
        }

        @Override
        public SchedulerConfig build() {
            return new SchedulerConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
