/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchTrainingPlanOfferingsRequest extends SageMakerRequest implements
        ToCopyableBuilder<SearchTrainingPlanOfferingsRequest.Builder, SearchTrainingPlanOfferingsRequest> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(SearchTrainingPlanOfferingsRequest::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount").getter(getter(SearchTrainingPlanOfferingsRequest::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final SdkField<Instant> START_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTimeAfter").getter(getter(SearchTrainingPlanOfferingsRequest::startTimeAfter))
            .setter(setter(Builder::startTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimeAfter").build()).build();

    private static final SdkField<Instant> END_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTimeBefore").getter(getter(SearchTrainingPlanOfferingsRequest::endTimeBefore))
            .setter(setter(Builder::endTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimeBefore").build()).build();

    private static final SdkField<Long> DURATION_HOURS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationHours").getter(getter(SearchTrainingPlanOfferingsRequest::durationHours))
            .setter(setter(Builder::durationHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationHours").build()).build();

    private static final SdkField<List<String>> TARGET_RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetResources")
            .getter(getter(SearchTrainingPlanOfferingsRequest::targetResourcesAsStrings))
            .setter(setter(Builder::targetResourcesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD,
            INSTANCE_COUNT_FIELD, START_TIME_AFTER_FIELD, END_TIME_BEFORE_FIELD, DURATION_HOURS_FIELD, TARGET_RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceType;

    private final Integer instanceCount;

    private final Instant startTimeAfter;

    private final Instant endTimeBefore;

    private final Long durationHours;

    private final List<String> targetResources;

    private SearchTrainingPlanOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.startTimeAfter = builder.startTimeAfter;
        this.endTimeBefore = builder.endTimeBefore;
        this.durationHours = builder.durationHours;
        this.targetResources = builder.targetResources;
    }

    /**
     * <p>
     * The type of instance you want to search for in the available training plan offerings. This field allows you to
     * filter the search results based on the specific compute resources you require for your SageMaker training jobs or
     * SageMaker HyperPod clusters. When searching for training plan offerings, specifying the instance type helps you
     * find Reserved Instances that match your computational needs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ReservedCapacityInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type of instance you want to search for in the available training plan offerings. This field allows
     *         you to filter the search results based on the specific compute resources you require for your SageMaker
     *         training jobs or SageMaker HyperPod clusters. When searching for training plan offerings, specifying the
     *         instance type helps you find Reserved Instances that match your computational needs.
     * @see ReservedCapacityInstanceType
     */
    public final ReservedCapacityInstanceType instanceType() {
        return ReservedCapacityInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The type of instance you want to search for in the available training plan offerings. This field allows you to
     * filter the search results based on the specific compute resources you require for your SageMaker training jobs or
     * SageMaker HyperPod clusters. When searching for training plan offerings, specifying the instance type helps you
     * find Reserved Instances that match your computational needs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ReservedCapacityInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type of instance you want to search for in the available training plan offerings. This field allows
     *         you to filter the search results based on the specific compute resources you require for your SageMaker
     *         training jobs or SageMaker HyperPod clusters. When searching for training plan offerings, specifying the
     *         instance type helps you find Reserved Instances that match your computational needs.
     * @see ReservedCapacityInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The number of instances you want to reserve in the training plan offerings. This allows you to specify the
     * quantity of compute resources needed for your SageMaker training jobs or SageMaker HyperPod clusters, helping you
     * find reserved capacity offerings that match your requirements.
     * </p>
     * 
     * @return The number of instances you want to reserve in the training plan offerings. This allows you to specify
     *         the quantity of compute resources needed for your SageMaker training jobs or SageMaker HyperPod clusters,
     *         helping you find reserved capacity offerings that match your requirements.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * A filter to search for training plan offerings with a start time after a specified date.
     * </p>
     * 
     * @return A filter to search for training plan offerings with a start time after a specified date.
     */
    public final Instant startTimeAfter() {
        return startTimeAfter;
    }

    /**
     * <p>
     * A filter to search for reserved capacity offerings with an end time before a specified date.
     * </p>
     * 
     * @return A filter to search for reserved capacity offerings with an end time before a specified date.
     */
    public final Instant endTimeBefore() {
        return endTimeBefore;
    }

    /**
     * <p>
     * The desired duration in hours for the training plan offerings.
     * </p>
     * 
     * @return The desired duration in hours for the training plan offerings.
     */
    public final Long durationHours() {
        return durationHours;
    }

    /**
     * <p>
     * The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) to search for in the offerings.
     * </p>
     * <p>
     * Training plans are specific to their target resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's
     * instance group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetResources} method.
     * </p>
     * 
     * @return The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) to search for in the
     *         offerings.</p>
     *         <p>
     *         Training plans are specific to their target resource.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's
     *         instance group.
     *         </p>
     *         </li>
     */
    public final List<SageMakerResourceName> targetResources() {
        return SageMakerResourceNamesCopier.copyStringToEnum(targetResources);
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetResources() {
        return targetResources != null && !(targetResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) to search for in the offerings.
     * </p>
     * <p>
     * Training plans are specific to their target resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's
     * instance group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetResources} method.
     * </p>
     * 
     * @return The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) to search for in the
     *         offerings.</p>
     *         <p>
     *         Training plans are specific to their target resource.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's
     *         instance group.
     *         </p>
     *         </li>
     */
    public final List<String> targetResourcesAsStrings() {
        return targetResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(endTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(durationHours());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetResources() ? targetResourcesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTrainingPlanOfferingsRequest)) {
            return false;
        }
        SearchTrainingPlanOfferingsRequest other = (SearchTrainingPlanOfferingsRequest) obj;
        return Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(startTimeAfter(), other.startTimeAfter())
                && Objects.equals(endTimeBefore(), other.endTimeBefore())
                && Objects.equals(durationHours(), other.durationHours()) && hasTargetResources() == other.hasTargetResources()
                && Objects.equals(targetResourcesAsStrings(), other.targetResourcesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchTrainingPlanOfferingsRequest").add("InstanceType", instanceTypeAsString())
                .add("InstanceCount", instanceCount()).add("StartTimeAfter", startTimeAfter())
                .add("EndTimeBefore", endTimeBefore()).add("DurationHours", durationHours())
                .add("TargetResources", hasTargetResources() ? targetResourcesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "StartTimeAfter":
            return Optional.ofNullable(clazz.cast(startTimeAfter()));
        case "EndTimeBefore":
            return Optional.ofNullable(clazz.cast(endTimeBefore()));
        case "DurationHours":
            return Optional.ofNullable(clazz.cast(durationHours()));
        case "TargetResources":
            return Optional.ofNullable(clazz.cast(targetResourcesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("StartTimeAfter", START_TIME_AFTER_FIELD);
        map.put("EndTimeBefore", END_TIME_BEFORE_FIELD);
        map.put("DurationHours", DURATION_HOURS_FIELD);
        map.put("TargetResources", TARGET_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchTrainingPlanOfferingsRequest, T> g) {
        return obj -> g.apply((SearchTrainingPlanOfferingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchTrainingPlanOfferingsRequest> {
        /**
         * <p>
         * The type of instance you want to search for in the available training plan offerings. This field allows you
         * to filter the search results based on the specific compute resources you require for your SageMaker training
         * jobs or SageMaker HyperPod clusters. When searching for training plan offerings, specifying the instance type
         * helps you find Reserved Instances that match your computational needs.
         * </p>
         * 
         * @param instanceType
         *        The type of instance you want to search for in the available training plan offerings. This field
         *        allows you to filter the search results based on the specific compute resources you require for your
         *        SageMaker training jobs or SageMaker HyperPod clusters. When searching for training plan offerings,
         *        specifying the instance type helps you find Reserved Instances that match your computational needs.
         * @see ReservedCapacityInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type of instance you want to search for in the available training plan offerings. This field allows you
         * to filter the search results based on the specific compute resources you require for your SageMaker training
         * jobs or SageMaker HyperPod clusters. When searching for training plan offerings, specifying the instance type
         * helps you find Reserved Instances that match your computational needs.
         * </p>
         * 
         * @param instanceType
         *        The type of instance you want to search for in the available training plan offerings. This field
         *        allows you to filter the search results based on the specific compute resources you require for your
         *        SageMaker training jobs or SageMaker HyperPod clusters. When searching for training plan offerings,
         *        specifying the instance type helps you find Reserved Instances that match your computational needs.
         * @see ReservedCapacityInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityInstanceType
         */
        Builder instanceType(ReservedCapacityInstanceType instanceType);

        /**
         * <p>
         * The number of instances you want to reserve in the training plan offerings. This allows you to specify the
         * quantity of compute resources needed for your SageMaker training jobs or SageMaker HyperPod clusters, helping
         * you find reserved capacity offerings that match your requirements.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances you want to reserve in the training plan offerings. This allows you to specify
         *        the quantity of compute resources needed for your SageMaker training jobs or SageMaker HyperPod
         *        clusters, helping you find reserved capacity offerings that match your requirements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * A filter to search for training plan offerings with a start time after a specified date.
         * </p>
         * 
         * @param startTimeAfter
         *        A filter to search for training plan offerings with a start time after a specified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeAfter(Instant startTimeAfter);

        /**
         * <p>
         * A filter to search for reserved capacity offerings with an end time before a specified date.
         * </p>
         * 
         * @param endTimeBefore
         *        A filter to search for reserved capacity offerings with an end time before a specified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimeBefore(Instant endTimeBefore);

        /**
         * <p>
         * The desired duration in hours for the training plan offerings.
         * </p>
         * 
         * @param durationHours
         *        The desired duration in hours for the training plan offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationHours(Long durationHours);

        /**
         * <p>
         * The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) to search for in the offerings.
         * </p>
         * <p>
         * Training plans are specific to their target resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's
         * instance group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetResources
         *        The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) to search for in the
         *        offerings.</p>
         *        <p>
         *        Training plans are specific to their target resource.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A training plan designed for SageMaker training jobs can only be used to schedule and run training
         *        jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A training plan for HyperPod clusters can be used exclusively to provide compute resources to a
         *        cluster's instance group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourcesWithStrings(Collection<String> targetResources);

        /**
         * <p>
         * The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) to search for in the offerings.
         * </p>
         * <p>
         * Training plans are specific to their target resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's
         * instance group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetResources
         *        The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) to search for in the
         *        offerings.</p>
         *        <p>
         *        Training plans are specific to their target resource.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A training plan designed for SageMaker training jobs can only be used to schedule and run training
         *        jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A training plan for HyperPod clusters can be used exclusively to provide compute resources to a
         *        cluster's instance group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourcesWithStrings(String... targetResources);

        /**
         * <p>
         * The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) to search for in the offerings.
         * </p>
         * <p>
         * Training plans are specific to their target resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's
         * instance group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetResources
         *        The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) to search for in the
         *        offerings.</p>
         *        <p>
         *        Training plans are specific to their target resource.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A training plan designed for SageMaker training jobs can only be used to schedule and run training
         *        jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A training plan for HyperPod clusters can be used exclusively to provide compute resources to a
         *        cluster's instance group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResources(Collection<SageMakerResourceName> targetResources);

        /**
         * <p>
         * The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) to search for in the offerings.
         * </p>
         * <p>
         * Training plans are specific to their target resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's
         * instance group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetResources
         *        The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) to search for in the
         *        offerings.</p>
         *        <p>
         *        Training plans are specific to their target resource.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A training plan designed for SageMaker training jobs can only be used to schedule and run training
         *        jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A training plan for HyperPod clusters can be used exclusively to provide compute resources to a
         *        cluster's instance group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResources(SageMakerResourceName... targetResources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String instanceType;

        private Integer instanceCount;

        private Instant startTimeAfter;

        private Instant endTimeBefore;

        private Long durationHours;

        private List<String> targetResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTrainingPlanOfferingsRequest model) {
            super(model);
            instanceType(model.instanceType);
            instanceCount(model.instanceCount);
            startTimeAfter(model.startTimeAfter);
            endTimeBefore(model.endTimeBefore);
            durationHours(model.durationHours);
            targetResourcesWithStrings(model.targetResources);
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ReservedCapacityInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Instant getStartTimeAfter() {
            return startTimeAfter;
        }

        public final void setStartTimeAfter(Instant startTimeAfter) {
            this.startTimeAfter = startTimeAfter;
        }

        @Override
        public final Builder startTimeAfter(Instant startTimeAfter) {
            this.startTimeAfter = startTimeAfter;
            return this;
        }

        public final Instant getEndTimeBefore() {
            return endTimeBefore;
        }

        public final void setEndTimeBefore(Instant endTimeBefore) {
            this.endTimeBefore = endTimeBefore;
        }

        @Override
        public final Builder endTimeBefore(Instant endTimeBefore) {
            this.endTimeBefore = endTimeBefore;
            return this;
        }

        public final Long getDurationHours() {
            return durationHours;
        }

        public final void setDurationHours(Long durationHours) {
            this.durationHours = durationHours;
        }

        @Override
        public final Builder durationHours(Long durationHours) {
            this.durationHours = durationHours;
            return this;
        }

        public final Collection<String> getTargetResources() {
            if (targetResources instanceof SdkAutoConstructList) {
                return null;
            }
            return targetResources;
        }

        public final void setTargetResources(Collection<String> targetResources) {
            this.targetResources = SageMakerResourceNamesCopier.copy(targetResources);
        }

        @Override
        public final Builder targetResourcesWithStrings(Collection<String> targetResources) {
            this.targetResources = SageMakerResourceNamesCopier.copy(targetResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourcesWithStrings(String... targetResources) {
            targetResourcesWithStrings(Arrays.asList(targetResources));
            return this;
        }

        @Override
        public final Builder targetResources(Collection<SageMakerResourceName> targetResources) {
            this.targetResources = SageMakerResourceNamesCopier.copyEnumToString(targetResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResources(SageMakerResourceName... targetResources) {
            targetResources(Arrays.asList(targetResources));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchTrainingPlanOfferingsRequest build() {
            return new SearchTrainingPlanOfferingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
