/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the stairs traffic pattern for an Inference Recommender load test. This pattern type consists of multiple
 * steps where the number of users increases at each step.
 * </p>
 * <p>
 * Specify either the stairs or phases traffic pattern.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Stairs implements SdkPojo, Serializable, ToCopyableBuilder<Stairs.Builder, Stairs> {
    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationInSeconds").getter(getter(Stairs::durationInSeconds)).setter(setter(Builder::durationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()).build();

    private static final SdkField<Integer> NUMBER_OF_STEPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfSteps").getter(getter(Stairs::numberOfSteps)).setter(setter(Builder::numberOfSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfSteps").build()).build();

    private static final SdkField<Integer> USERS_PER_STEP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UsersPerStep").getter(getter(Stairs::usersPerStep)).setter(setter(Builder::usersPerStep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsersPerStep").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_IN_SECONDS_FIELD,
            NUMBER_OF_STEPS_FIELD, USERS_PER_STEP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer durationInSeconds;

    private final Integer numberOfSteps;

    private final Integer usersPerStep;

    private Stairs(BuilderImpl builder) {
        this.durationInSeconds = builder.durationInSeconds;
        this.numberOfSteps = builder.numberOfSteps;
        this.usersPerStep = builder.usersPerStep;
    }

    /**
     * <p>
     * Defines how long each traffic step should be.
     * </p>
     * 
     * @return Defines how long each traffic step should be.
     */
    public final Integer durationInSeconds() {
        return durationInSeconds;
    }

    /**
     * <p>
     * Specifies how many steps to perform during traffic.
     * </p>
     * 
     * @return Specifies how many steps to perform during traffic.
     */
    public final Integer numberOfSteps() {
        return numberOfSteps;
    }

    /**
     * <p>
     * Specifies how many new users to spawn in each step.
     * </p>
     * 
     * @return Specifies how many new users to spawn in each step.
     */
    public final Integer usersPerStep() {
        return usersPerStep;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfSteps());
        hashCode = 31 * hashCode + Objects.hashCode(usersPerStep());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stairs)) {
            return false;
        }
        Stairs other = (Stairs) obj;
        return Objects.equals(durationInSeconds(), other.durationInSeconds())
                && Objects.equals(numberOfSteps(), other.numberOfSteps()) && Objects.equals(usersPerStep(), other.usersPerStep());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Stairs").add("DurationInSeconds", durationInSeconds()).add("NumberOfSteps", numberOfSteps())
                .add("UsersPerStep", usersPerStep()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurationInSeconds":
            return Optional.ofNullable(clazz.cast(durationInSeconds()));
        case "NumberOfSteps":
            return Optional.ofNullable(clazz.cast(numberOfSteps()));
        case "UsersPerStep":
            return Optional.ofNullable(clazz.cast(usersPerStep()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DurationInSeconds", DURATION_IN_SECONDS_FIELD);
        map.put("NumberOfSteps", NUMBER_OF_STEPS_FIELD);
        map.put("UsersPerStep", USERS_PER_STEP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Stairs, T> g) {
        return obj -> g.apply((Stairs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Stairs> {
        /**
         * <p>
         * Defines how long each traffic step should be.
         * </p>
         * 
         * @param durationInSeconds
         *        Defines how long each traffic step should be.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Integer durationInSeconds);

        /**
         * <p>
         * Specifies how many steps to perform during traffic.
         * </p>
         * 
         * @param numberOfSteps
         *        Specifies how many steps to perform during traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfSteps(Integer numberOfSteps);

        /**
         * <p>
         * Specifies how many new users to spawn in each step.
         * </p>
         * 
         * @param usersPerStep
         *        Specifies how many new users to spawn in each step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usersPerStep(Integer usersPerStep);
    }

    static final class BuilderImpl implements Builder {
        private Integer durationInSeconds;

        private Integer numberOfSteps;

        private Integer usersPerStep;

        private BuilderImpl() {
        }

        private BuilderImpl(Stairs model) {
            durationInSeconds(model.durationInSeconds);
            numberOfSteps(model.numberOfSteps);
            usersPerStep(model.usersPerStep);
        }

        public final Integer getDurationInSeconds() {
            return durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final Integer getNumberOfSteps() {
            return numberOfSteps;
        }

        public final void setNumberOfSteps(Integer numberOfSteps) {
            this.numberOfSteps = numberOfSteps;
        }

        @Override
        public final Builder numberOfSteps(Integer numberOfSteps) {
            this.numberOfSteps = numberOfSteps;
            return this;
        }

        public final Integer getUsersPerStep() {
            return usersPerStep;
        }

        public final void setUsersPerStep(Integer usersPerStep) {
            this.usersPerStep = usersPerStep;
        }

        @Override
        public final Builder usersPerStep(Integer usersPerStep) {
            this.usersPerStep = usersPerStep;
            return this;
        }

        @Override
        public Stairs build() {
            return new Stairs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
