/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resolved attributes specific to the tabular problem type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TabularResolvedAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<TabularResolvedAttributes.Builder, TabularResolvedAttributes> {
    private static final SdkField<String> PROBLEM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProblemType").getter(getter(TabularResolvedAttributes::problemTypeAsString))
            .setter(setter(Builder::problemType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProblemType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROBLEM_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String problemType;

    private TabularResolvedAttributes(BuilderImpl builder) {
        this.problemType = builder.problemType;
    }

    /**
     * <p>
     * The type of supervised learning problem available for the model candidates of the AutoML job V2 (Binary
     * Classification, Multiclass Classification, Regression). For more information, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types">
     * SageMaker Autopilot problem types</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #problemType} will
     * return {@link ProblemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #problemTypeAsString}.
     * </p>
     * 
     * @return The type of supervised learning problem available for the model candidates of the AutoML job V2 (Binary
     *         Classification, Multiclass Classification, Regression). For more information, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types"
     *         > SageMaker Autopilot problem types</a>.
     * @see ProblemType
     */
    public final ProblemType problemType() {
        return ProblemType.fromValue(problemType);
    }

    /**
     * <p>
     * The type of supervised learning problem available for the model candidates of the AutoML job V2 (Binary
     * Classification, Multiclass Classification, Regression). For more information, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types">
     * SageMaker Autopilot problem types</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #problemType} will
     * return {@link ProblemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #problemTypeAsString}.
     * </p>
     * 
     * @return The type of supervised learning problem available for the model candidates of the AutoML job V2 (Binary
     *         Classification, Multiclass Classification, Regression). For more information, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types"
     *         > SageMaker Autopilot problem types</a>.
     * @see ProblemType
     */
    public final String problemTypeAsString() {
        return problemType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(problemTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TabularResolvedAttributes)) {
            return false;
        }
        TabularResolvedAttributes other = (TabularResolvedAttributes) obj;
        return Objects.equals(problemTypeAsString(), other.problemTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TabularResolvedAttributes").add("ProblemType", problemTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProblemType":
            return Optional.ofNullable(clazz.cast(problemTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProblemType", PROBLEM_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TabularResolvedAttributes, T> g) {
        return obj -> g.apply((TabularResolvedAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TabularResolvedAttributes> {
        /**
         * <p>
         * The type of supervised learning problem available for the model candidates of the AutoML job V2 (Binary
         * Classification, Multiclass Classification, Regression). For more information, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types"
         * > SageMaker Autopilot problem types</a>.
         * </p>
         * 
         * @param problemType
         *        The type of supervised learning problem available for the model candidates of the AutoML job V2
         *        (Binary Classification, Multiclass Classification, Regression). For more information, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types"
         *        > SageMaker Autopilot problem types</a>.
         * @see ProblemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProblemType
         */
        Builder problemType(String problemType);

        /**
         * <p>
         * The type of supervised learning problem available for the model candidates of the AutoML job V2 (Binary
         * Classification, Multiclass Classification, Regression). For more information, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types"
         * > SageMaker Autopilot problem types</a>.
         * </p>
         * 
         * @param problemType
         *        The type of supervised learning problem available for the model candidates of the AutoML job V2
         *        (Binary Classification, Multiclass Classification, Regression). For more information, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types"
         *        > SageMaker Autopilot problem types</a>.
         * @see ProblemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProblemType
         */
        Builder problemType(ProblemType problemType);
    }

    static final class BuilderImpl implements Builder {
        private String problemType;

        private BuilderImpl() {
        }

        private BuilderImpl(TabularResolvedAttributes model) {
            problemType(model.problemType);
        }

        public final String getProblemType() {
            return problemType;
        }

        public final void setProblemType(String problemType) {
            this.problemType = problemType;
        }

        @Override
        public final Builder problemType(String problemType) {
            this.problemType = problemType;
            return this;
        }

        @Override
        public final Builder problemType(ProblemType problemType) {
            this.problemType(problemType == null ? null : problemType.toString());
            return this;
        }

        @Override
        public TabularResolvedAttributes build() {
            return new TabularResolvedAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
