/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a target platform that you want your model to run on, such as OS, architecture, and
 * accelerators. It is an alternative of <code>TargetDevice</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetPlatform implements SdkPojo, Serializable, ToCopyableBuilder<TargetPlatform.Builder, TargetPlatform> {
    private static final SdkField<String> OS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Os")
            .getter(getter(TargetPlatform::osAsString)).setter(setter(Builder::os))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Os").build()).build();

    private static final SdkField<String> ARCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arch")
            .getter(getter(TargetPlatform::archAsString)).setter(setter(Builder::arch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arch").build()).build();

    private static final SdkField<String> ACCELERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Accelerator").getter(getter(TargetPlatform::acceleratorAsString)).setter(setter(Builder::accelerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accelerator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OS_FIELD, ARCH_FIELD,
            ACCELERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String os;

    private final String arch;

    private final String accelerator;

    private TargetPlatform(BuilderImpl builder) {
        this.os = builder.os;
        this.arch = builder.arch;
        this.accelerator = builder.accelerator;
    }

    /**
     * <p>
     * Specifies a target platform OS.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LINUX</code>: Linux-based operating systems.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ANDROID</code>: Android operating systems. Android API level can be specified using the
     * <code>ANDROID_PLATFORM</code> compiler option. For example,
     * <code>"CompilerOptions": {'ANDROID_PLATFORM': 28}</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #os} will return
     * {@link TargetPlatformOs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #osAsString}.
     * </p>
     * 
     * @return Specifies a target platform OS.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LINUX</code>: Linux-based operating systems.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ANDROID</code>: Android operating systems. Android API level can be specified using the
     *         <code>ANDROID_PLATFORM</code> compiler option. For example,
     *         <code>"CompilerOptions": {'ANDROID_PLATFORM': 28}</code>
     *         </p>
     *         </li>
     * @see TargetPlatformOs
     */
    public final TargetPlatformOs os() {
        return TargetPlatformOs.fromValue(os);
    }

    /**
     * <p>
     * Specifies a target platform OS.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LINUX</code>: Linux-based operating systems.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ANDROID</code>: Android operating systems. Android API level can be specified using the
     * <code>ANDROID_PLATFORM</code> compiler option. For example,
     * <code>"CompilerOptions": {'ANDROID_PLATFORM': 28}</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #os} will return
     * {@link TargetPlatformOs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #osAsString}.
     * </p>
     * 
     * @return Specifies a target platform OS.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LINUX</code>: Linux-based operating systems.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ANDROID</code>: Android operating systems. Android API level can be specified using the
     *         <code>ANDROID_PLATFORM</code> compiler option. For example,
     *         <code>"CompilerOptions": {'ANDROID_PLATFORM': 28}</code>
     *         </p>
     *         </li>
     * @see TargetPlatformOs
     */
    public final String osAsString() {
        return os;
    }

    /**
     * <p>
     * Specifies a target platform architecture.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>X86_64</code>: 64-bit version of the x86 instruction set.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>X86</code>: 32-bit version of the x86 instruction set.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARM64</code>: ARMv8 64-bit CPU.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARM_EABIHF</code>: ARMv7 32-bit, Hard Float.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARM_EABI</code>: ARMv7 32-bit, Soft Float. Used by Android 32-bit ARM platform.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #arch} will return
     * {@link TargetPlatformArch#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #archAsString}.
     * </p>
     * 
     * @return Specifies a target platform architecture.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>X86_64</code>: 64-bit version of the x86 instruction set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>X86</code>: 32-bit version of the x86 instruction set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARM64</code>: ARMv8 64-bit CPU.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARM_EABIHF</code>: ARMv7 32-bit, Hard Float.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARM_EABI</code>: ARMv7 32-bit, Soft Float. Used by Android 32-bit ARM platform.
     *         </p>
     *         </li>
     * @see TargetPlatformArch
     */
    public final TargetPlatformArch arch() {
        return TargetPlatformArch.fromValue(arch);
    }

    /**
     * <p>
     * Specifies a target platform architecture.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>X86_64</code>: 64-bit version of the x86 instruction set.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>X86</code>: 32-bit version of the x86 instruction set.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARM64</code>: ARMv8 64-bit CPU.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARM_EABIHF</code>: ARMv7 32-bit, Hard Float.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARM_EABI</code>: ARMv7 32-bit, Soft Float. Used by Android 32-bit ARM platform.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #arch} will return
     * {@link TargetPlatformArch#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #archAsString}.
     * </p>
     * 
     * @return Specifies a target platform architecture.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>X86_64</code>: 64-bit version of the x86 instruction set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>X86</code>: 32-bit version of the x86 instruction set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARM64</code>: ARMv8 64-bit CPU.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARM_EABIHF</code>: ARMv7 32-bit, Hard Float.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARM_EABI</code>: ARMv7 32-bit, Soft Float. Used by Android 32-bit ARM platform.
     *         </p>
     *         </li>
     * @see TargetPlatformArch
     */
    public final String archAsString() {
        return arch;
    }

    /**
     * <p>
     * Specifies a target platform accelerator (optional).
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NVIDIA</code>: Nvidia graphics processing unit. It also requires <code>gpu-code</code>,
     * <code>trt-ver</code>, <code>cuda-ver</code> compiler options
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MALI</code>: ARM Mali graphics processor
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTEL_GRAPHICS</code>: Integrated Intel graphics
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accelerator} will
     * return {@link TargetPlatformAccelerator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #acceleratorAsString}.
     * </p>
     * 
     * @return Specifies a target platform accelerator (optional).</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NVIDIA</code>: Nvidia graphics processing unit. It also requires <code>gpu-code</code>,
     *         <code>trt-ver</code>, <code>cuda-ver</code> compiler options
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MALI</code>: ARM Mali graphics processor
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTEL_GRAPHICS</code>: Integrated Intel graphics
     *         </p>
     *         </li>
     * @see TargetPlatformAccelerator
     */
    public final TargetPlatformAccelerator accelerator() {
        return TargetPlatformAccelerator.fromValue(accelerator);
    }

    /**
     * <p>
     * Specifies a target platform accelerator (optional).
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NVIDIA</code>: Nvidia graphics processing unit. It also requires <code>gpu-code</code>,
     * <code>trt-ver</code>, <code>cuda-ver</code> compiler options
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MALI</code>: ARM Mali graphics processor
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTEL_GRAPHICS</code>: Integrated Intel graphics
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accelerator} will
     * return {@link TargetPlatformAccelerator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #acceleratorAsString}.
     * </p>
     * 
     * @return Specifies a target platform accelerator (optional).</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NVIDIA</code>: Nvidia graphics processing unit. It also requires <code>gpu-code</code>,
     *         <code>trt-ver</code>, <code>cuda-ver</code> compiler options
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MALI</code>: ARM Mali graphics processor
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTEL_GRAPHICS</code>: Integrated Intel graphics
     *         </p>
     *         </li>
     * @see TargetPlatformAccelerator
     */
    public final String acceleratorAsString() {
        return accelerator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(osAsString());
        hashCode = 31 * hashCode + Objects.hashCode(archAsString());
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetPlatform)) {
            return false;
        }
        TargetPlatform other = (TargetPlatform) obj;
        return Objects.equals(osAsString(), other.osAsString()) && Objects.equals(archAsString(), other.archAsString())
                && Objects.equals(acceleratorAsString(), other.acceleratorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetPlatform").add("Os", osAsString()).add("Arch", archAsString())
                .add("Accelerator", acceleratorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Os":
            return Optional.ofNullable(clazz.cast(osAsString()));
        case "Arch":
            return Optional.ofNullable(clazz.cast(archAsString()));
        case "Accelerator":
            return Optional.ofNullable(clazz.cast(acceleratorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Os", OS_FIELD);
        map.put("Arch", ARCH_FIELD);
        map.put("Accelerator", ACCELERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetPlatform, T> g) {
        return obj -> g.apply((TargetPlatform) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetPlatform> {
        /**
         * <p>
         * Specifies a target platform OS.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LINUX</code>: Linux-based operating systems.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ANDROID</code>: Android operating systems. Android API level can be specified using the
         * <code>ANDROID_PLATFORM</code> compiler option. For example,
         * <code>"CompilerOptions": {'ANDROID_PLATFORM': 28}</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param os
         *        Specifies a target platform OS.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LINUX</code>: Linux-based operating systems.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ANDROID</code>: Android operating systems. Android API level can be specified using the
         *        <code>ANDROID_PLATFORM</code> compiler option. For example,
         *        <code>"CompilerOptions": {'ANDROID_PLATFORM': 28}</code>
         *        </p>
         *        </li>
         * @see TargetPlatformOs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformOs
         */
        Builder os(String os);

        /**
         * <p>
         * Specifies a target platform OS.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LINUX</code>: Linux-based operating systems.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ANDROID</code>: Android operating systems. Android API level can be specified using the
         * <code>ANDROID_PLATFORM</code> compiler option. For example,
         * <code>"CompilerOptions": {'ANDROID_PLATFORM': 28}</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param os
         *        Specifies a target platform OS.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LINUX</code>: Linux-based operating systems.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ANDROID</code>: Android operating systems. Android API level can be specified using the
         *        <code>ANDROID_PLATFORM</code> compiler option. For example,
         *        <code>"CompilerOptions": {'ANDROID_PLATFORM': 28}</code>
         *        </p>
         *        </li>
         * @see TargetPlatformOs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformOs
         */
        Builder os(TargetPlatformOs os);

        /**
         * <p>
         * Specifies a target platform architecture.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>X86_64</code>: 64-bit version of the x86 instruction set.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>X86</code>: 32-bit version of the x86 instruction set.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARM64</code>: ARMv8 64-bit CPU.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARM_EABIHF</code>: ARMv7 32-bit, Hard Float.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARM_EABI</code>: ARMv7 32-bit, Soft Float. Used by Android 32-bit ARM platform.
         * </p>
         * </li>
         * </ul>
         * 
         * @param arch
         *        Specifies a target platform architecture.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>X86_64</code>: 64-bit version of the x86 instruction set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>X86</code>: 32-bit version of the x86 instruction set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARM64</code>: ARMv8 64-bit CPU.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARM_EABIHF</code>: ARMv7 32-bit, Hard Float.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARM_EABI</code>: ARMv7 32-bit, Soft Float. Used by Android 32-bit ARM platform.
         *        </p>
         *        </li>
         * @see TargetPlatformArch
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformArch
         */
        Builder arch(String arch);

        /**
         * <p>
         * Specifies a target platform architecture.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>X86_64</code>: 64-bit version of the x86 instruction set.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>X86</code>: 32-bit version of the x86 instruction set.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARM64</code>: ARMv8 64-bit CPU.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARM_EABIHF</code>: ARMv7 32-bit, Hard Float.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARM_EABI</code>: ARMv7 32-bit, Soft Float. Used by Android 32-bit ARM platform.
         * </p>
         * </li>
         * </ul>
         * 
         * @param arch
         *        Specifies a target platform architecture.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>X86_64</code>: 64-bit version of the x86 instruction set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>X86</code>: 32-bit version of the x86 instruction set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARM64</code>: ARMv8 64-bit CPU.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARM_EABIHF</code>: ARMv7 32-bit, Hard Float.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARM_EABI</code>: ARMv7 32-bit, Soft Float. Used by Android 32-bit ARM platform.
         *        </p>
         *        </li>
         * @see TargetPlatformArch
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformArch
         */
        Builder arch(TargetPlatformArch arch);

        /**
         * <p>
         * Specifies a target platform accelerator (optional).
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NVIDIA</code>: Nvidia graphics processing unit. It also requires <code>gpu-code</code>,
         * <code>trt-ver</code>, <code>cuda-ver</code> compiler options
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MALI</code>: ARM Mali graphics processor
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTEL_GRAPHICS</code>: Integrated Intel graphics
         * </p>
         * </li>
         * </ul>
         * 
         * @param accelerator
         *        Specifies a target platform accelerator (optional).</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NVIDIA</code>: Nvidia graphics processing unit. It also requires <code>gpu-code</code>,
         *        <code>trt-ver</code>, <code>cuda-ver</code> compiler options
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MALI</code>: ARM Mali graphics processor
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTEL_GRAPHICS</code>: Integrated Intel graphics
         *        </p>
         *        </li>
         * @see TargetPlatformAccelerator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformAccelerator
         */
        Builder accelerator(String accelerator);

        /**
         * <p>
         * Specifies a target platform accelerator (optional).
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NVIDIA</code>: Nvidia graphics processing unit. It also requires <code>gpu-code</code>,
         * <code>trt-ver</code>, <code>cuda-ver</code> compiler options
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MALI</code>: ARM Mali graphics processor
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTEL_GRAPHICS</code>: Integrated Intel graphics
         * </p>
         * </li>
         * </ul>
         * 
         * @param accelerator
         *        Specifies a target platform accelerator (optional).</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NVIDIA</code>: Nvidia graphics processing unit. It also requires <code>gpu-code</code>,
         *        <code>trt-ver</code>, <code>cuda-ver</code> compiler options
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MALI</code>: ARM Mali graphics processor
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTEL_GRAPHICS</code>: Integrated Intel graphics
         *        </p>
         *        </li>
         * @see TargetPlatformAccelerator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformAccelerator
         */
        Builder accelerator(TargetPlatformAccelerator accelerator);
    }

    static final class BuilderImpl implements Builder {
        private String os;

        private String arch;

        private String accelerator;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetPlatform model) {
            os(model.os);
            arch(model.arch);
            accelerator(model.accelerator);
        }

        public final String getOs() {
            return os;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        @Override
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        @Override
        public final Builder os(TargetPlatformOs os) {
            this.os(os == null ? null : os.toString());
            return this;
        }

        public final String getArch() {
            return arch;
        }

        public final void setArch(String arch) {
            this.arch = arch;
        }

        @Override
        public final Builder arch(String arch) {
            this.arch = arch;
            return this;
        }

        @Override
        public final Builder arch(TargetPlatformArch arch) {
            this.arch(arch == null ? null : arch.toString());
            return this;
        }

        public final String getAccelerator() {
            return accelerator;
        }

        public final void setAccelerator(String accelerator) {
            this.accelerator = accelerator;
        }

        @Override
        public final Builder accelerator(String accelerator) {
            this.accelerator = accelerator;
            return this;
        }

        @Override
        public final Builder accelerator(TargetPlatformAccelerator accelerator) {
            this.accelerator(accelerator == null ? null : accelerator.toString());
            return this;
        }

        @Override
        public TargetPlatform build() {
            return new TargetPlatform(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
