/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Transformations allowed on the dataset. Supported transformations are <code>Filling</code> and
 * <code>Aggregation</code>. <code>Filling</code> specifies how to add values to missing values in the dataset.
 * <code>Aggregation</code> defines how to aggregate data that does not align with forecast frequency.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeSeriesTransformations implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeSeriesTransformations.Builder, TimeSeriesTransformations> {
    private static final SdkField<Map<String, Map<String, String>>> FILLING_FIELD = SdkField
            .<Map<String, Map<String, String>>> builder(MarshallingType.MAP)
            .memberName("Filling")
            .getter(getter(TimeSeriesTransformations::fillingAsStrings))
            .setter(setter(Builder::fillingWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filling").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Map<String, String>> AGGREGATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Aggregation")
            .getter(getter(TimeSeriesTransformations::aggregationAsStrings))
            .setter(setter(Builder::aggregationWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILLING_FIELD,
            AGGREGATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, Map<String, String>> filling;

    private final Map<String, String> aggregation;

    private TimeSeriesTransformations(BuilderImpl builder) {
        this.filling = builder.filling;
        this.aggregation = builder.aggregation;
    }

    /**
     * <p>
     * A key value pair defining the filling method for a column, where the key is the column name and the value is an
     * object which defines the filling logic. You can specify multiple filling methods for a single column.
     * </p>
     * <p>
     * The supported filling methods and their corresponding options are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>frontfill</code>: <code>none</code> (Supported only for target column)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     * <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     * <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     * <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To set a filling method to a specific value, set the fill parameter to the chosen filling method value (for
     * example <code>"backfill" : "value"</code>), and define the filling value in an additional parameter prefixed with
     * "_value". For example, to set <code>backfill</code> to a value of <code>2</code>, you must include two
     * parameters: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilling} method.
     * </p>
     * 
     * @return A key value pair defining the filling method for a column, where the key is the column name and the value
     *         is an object which defines the filling logic. You can specify multiple filling methods for a single
     *         column.</p>
     *         <p>
     *         The supported filling methods and their corresponding options are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>frontfill</code>: <code>none</code> (Supported only for target column)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     *         <code>min</code>, <code>max</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     *         <code>min</code>, <code>max</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     *         <code>min</code>, <code>max</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To set a filling method to a specific value, set the fill parameter to the chosen filling method value
     *         (for example <code>"backfill" : "value"</code>), and define the filling value in an additional parameter
     *         prefixed with "_value". For example, to set <code>backfill</code> to a value of <code>2</code>, you must
     *         include two parameters: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>.
     */
    public final Map<String, Map<FillingType, String>> filling() {
        return FillingTransformationsCopier.copyStringToEnum(filling);
    }

    /**
     * For responses, this returns true if the service returned a value for the Filling property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilling() {
        return filling != null && !(filling instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key value pair defining the filling method for a column, where the key is the column name and the value is an
     * object which defines the filling logic. You can specify multiple filling methods for a single column.
     * </p>
     * <p>
     * The supported filling methods and their corresponding options are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>frontfill</code>: <code>none</code> (Supported only for target column)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     * <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     * <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     * <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To set a filling method to a specific value, set the fill parameter to the chosen filling method value (for
     * example <code>"backfill" : "value"</code>), and define the filling value in an additional parameter prefixed with
     * "_value". For example, to set <code>backfill</code> to a value of <code>2</code>, you must include two
     * parameters: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilling} method.
     * </p>
     * 
     * @return A key value pair defining the filling method for a column, where the key is the column name and the value
     *         is an object which defines the filling logic. You can specify multiple filling methods for a single
     *         column.</p>
     *         <p>
     *         The supported filling methods and their corresponding options are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>frontfill</code>: <code>none</code> (Supported only for target column)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     *         <code>min</code>, <code>max</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     *         <code>min</code>, <code>max</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     *         <code>min</code>, <code>max</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To set a filling method to a specific value, set the fill parameter to the chosen filling method value
     *         (for example <code>"backfill" : "value"</code>), and define the filling value in an additional parameter
     *         prefixed with "_value". For example, to set <code>backfill</code> to a value of <code>2</code>, you must
     *         include two parameters: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>.
     */
    public final Map<String, Map<String, String>> fillingAsStrings() {
        return filling;
    }

    /**
     * <p>
     * A key value pair defining the aggregation method for a column, where the key is the column name and the value is
     * the aggregation method.
     * </p>
     * <p>
     * The supported aggregation methods are <code>sum</code> (default), <code>avg</code>, <code>first</code>,
     * <code>min</code>, <code>max</code>.
     * </p>
     * <note>
     * <p>
     * Aggregation is only supported for the target column.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregation} method.
     * </p>
     * 
     * @return A key value pair defining the aggregation method for a column, where the key is the column name and the
     *         value is the aggregation method.</p>
     *         <p>
     *         The supported aggregation methods are <code>sum</code> (default), <code>avg</code>, <code>first</code>,
     *         <code>min</code>, <code>max</code>.
     *         </p>
     *         <note>
     *         <p>
     *         Aggregation is only supported for the target column.
     *         </p>
     */
    public final Map<String, AggregationTransformationValue> aggregation() {
        return AggregationTransformationsCopier.copyStringToEnum(aggregation);
    }

    /**
     * For responses, this returns true if the service returned a value for the Aggregation property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAggregation() {
        return aggregation != null && !(aggregation instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key value pair defining the aggregation method for a column, where the key is the column name and the value is
     * the aggregation method.
     * </p>
     * <p>
     * The supported aggregation methods are <code>sum</code> (default), <code>avg</code>, <code>first</code>,
     * <code>min</code>, <code>max</code>.
     * </p>
     * <note>
     * <p>
     * Aggregation is only supported for the target column.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregation} method.
     * </p>
     * 
     * @return A key value pair defining the aggregation method for a column, where the key is the column name and the
     *         value is the aggregation method.</p>
     *         <p>
     *         The supported aggregation methods are <code>sum</code> (default), <code>avg</code>, <code>first</code>,
     *         <code>min</code>, <code>max</code>.
     *         </p>
     *         <note>
     *         <p>
     *         Aggregation is only supported for the target column.
     *         </p>
     */
    public final Map<String, String> aggregationAsStrings() {
        return aggregation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFilling() ? fillingAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregation() ? aggregationAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesTransformations)) {
            return false;
        }
        TimeSeriesTransformations other = (TimeSeriesTransformations) obj;
        return hasFilling() == other.hasFilling() && Objects.equals(fillingAsStrings(), other.fillingAsStrings())
                && hasAggregation() == other.hasAggregation()
                && Objects.equals(aggregationAsStrings(), other.aggregationAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeSeriesTransformations").add("Filling", hasFilling() ? fillingAsStrings() : null)
                .add("Aggregation", hasAggregation() ? aggregationAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filling":
            return Optional.ofNullable(clazz.cast(fillingAsStrings()));
        case "Aggregation":
            return Optional.ofNullable(clazz.cast(aggregationAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Filling", FILLING_FIELD);
        map.put("Aggregation", AGGREGATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesTransformations, T> g) {
        return obj -> g.apply((TimeSeriesTransformations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeSeriesTransformations> {
        /**
         * <p>
         * A key value pair defining the filling method for a column, where the key is the column name and the value is
         * an object which defines the filling logic. You can specify multiple filling methods for a single column.
         * </p>
         * <p>
         * The supported filling methods and their corresponding options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>frontfill</code>: <code>none</code> (Supported only for target column)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
         * <code>min</code>, <code>max</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
         * <code>min</code>, <code>max</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
         * <code>min</code>, <code>max</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * To set a filling method to a specific value, set the fill parameter to the chosen filling method value (for
         * example <code>"backfill" : "value"</code>), and define the filling value in an additional parameter prefixed
         * with "_value". For example, to set <code>backfill</code> to a value of <code>2</code>, you must include two
         * parameters: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>.
         * </p>
         * 
         * @param filling
         *        A key value pair defining the filling method for a column, where the key is the column name and the
         *        value is an object which defines the filling logic. You can specify multiple filling methods for a
         *        single column.</p>
         *        <p>
         *        The supported filling methods and their corresponding options are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>frontfill</code>: <code>none</code> (Supported only for target column)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
         *        <code>min</code>, <code>max</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To set a filling method to a specific value, set the fill parameter to the chosen filling method value
         *        (for example <code>"backfill" : "value"</code>), and define the filling value in an additional
         *        parameter prefixed with "_value". For example, to set <code>backfill</code> to a value of
         *        <code>2</code>, you must include two parameters: <code>"backfill": "value"</code> and
         *        <code>"backfill_value":"2"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fillingWithStrings(Map<String, ? extends Map<String, String>> filling);

        /**
         * <p>
         * A key value pair defining the aggregation method for a column, where the key is the column name and the value
         * is the aggregation method.
         * </p>
         * <p>
         * The supported aggregation methods are <code>sum</code> (default), <code>avg</code>, <code>first</code>,
         * <code>min</code>, <code>max</code>.
         * </p>
         * <note>
         * <p>
         * Aggregation is only supported for the target column.
         * </p>
         * </note>
         * 
         * @param aggregation
         *        A key value pair defining the aggregation method for a column, where the key is the column name and
         *        the value is the aggregation method.</p>
         *        <p>
         *        The supported aggregation methods are <code>sum</code> (default), <code>avg</code>, <code>first</code>, <code>min</code>, <code>max</code>.
         *        </p>
         *        <note>
         *        <p>
         *        Aggregation is only supported for the target column.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationWithStrings(Map<String, String> aggregation);

        /**
         * <p>
         * A key value pair defining the aggregation method for a column, where the key is the column name and the value
         * is the aggregation method.
         * </p>
         * <p>
         * The supported aggregation methods are <code>sum</code> (default), <code>avg</code>, <code>first</code>,
         * <code>min</code>, <code>max</code>.
         * </p>
         * <note>
         * <p>
         * Aggregation is only supported for the target column.
         * </p>
         * </note>
         * 
         * @param aggregation
         *        A key value pair defining the aggregation method for a column, where the key is the column name and
         *        the value is the aggregation method.</p>
         *        <p>
         *        The supported aggregation methods are <code>sum</code> (default), <code>avg</code>, <code>first</code>, <code>min</code>, <code>max</code>.
         *        </p>
         *        <note>
         *        <p>
         *        Aggregation is only supported for the target column.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregation(Map<String, AggregationTransformationValue> aggregation);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Map<String, String>> filling = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> aggregation = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesTransformations model) {
            fillingWithStrings(model.filling);
            aggregationWithStrings(model.aggregation);
        }

        public final Map<String, ? extends Map<String, String>> getFilling() {
            if (filling instanceof SdkAutoConstructMap) {
                return null;
            }
            return filling;
        }

        public final void setFilling(Map<String, ? extends Map<String, String>> filling) {
            this.filling = FillingTransformationsCopier.copy(filling);
        }

        @Override
        public final Builder fillingWithStrings(Map<String, ? extends Map<String, String>> filling) {
            this.filling = FillingTransformationsCopier.copy(filling);
            return this;
        }

        public final Map<String, String> getAggregation() {
            if (aggregation instanceof SdkAutoConstructMap) {
                return null;
            }
            return aggregation;
        }

        public final void setAggregation(Map<String, String> aggregation) {
            this.aggregation = AggregationTransformationsCopier.copy(aggregation);
        }

        @Override
        public final Builder aggregationWithStrings(Map<String, String> aggregation) {
            this.aggregation = AggregationTransformationsCopier.copy(aggregation);
            return this;
        }

        @Override
        public final Builder aggregation(Map<String, AggregationTransformationValue> aggregation) {
            this.aggregation = AggregationTransformationsCopier.copyEnumToString(aggregation);
            return this;
        }

        @Override
        public TimeSeriesTransformations build() {
            return new TimeSeriesTransformations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
