/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the total number of matching results and indicates how accurate that count is.
 * </p>
 * <p>
 * The <code>Value</code> field provides the count, which may be exact or estimated. The <code>Relation</code> field
 * indicates whether it's an exact figure or a lower bound. This helps understand the full scope of search results,
 * especially when dealing with large result sets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TotalHits implements SdkPojo, Serializable, ToCopyableBuilder<TotalHits.Builder, TotalHits> {
    private static final SdkField<Long> VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Value")
            .getter(getter(TotalHits::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> RELATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Relation").getter(getter(TotalHits::relationAsString)).setter(setter(Builder::relation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, RELATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long value;

    private final String relation;

    private TotalHits(BuilderImpl builder) {
        this.value = builder.value;
        this.relation = builder.relation;
    }

    /**
     * <p>
     * The total number of matching results. This value may be exact or an estimate, depending on the
     * <code>Relation</code> field.
     * </p>
     * 
     * @return The total number of matching results. This value may be exact or an estimate, depending on the
     *         <code>Relation</code> field.
     */
    public final Long value() {
        return value;
    }

    /**
     * <p>
     * Indicates the relationship between the returned <code>Value</code> and the actual total number of matching
     * results. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EqualTo</code>: The <code>Value</code> is the exact count of matching results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GreaterThanOrEqualTo</code>: The <code>Value</code> is a lower bound of the actual count of matching
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relation} will
     * return {@link Relation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #relationAsString}.
     * </p>
     * 
     * @return Indicates the relationship between the returned <code>Value</code> and the actual total number of
     *         matching results. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EqualTo</code>: The <code>Value</code> is the exact count of matching results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GreaterThanOrEqualTo</code>: The <code>Value</code> is a lower bound of the actual count of
     *         matching results.
     *         </p>
     *         </li>
     * @see Relation
     */
    public final Relation relation() {
        return Relation.fromValue(relation);
    }

    /**
     * <p>
     * Indicates the relationship between the returned <code>Value</code> and the actual total number of matching
     * results. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EqualTo</code>: The <code>Value</code> is the exact count of matching results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GreaterThanOrEqualTo</code>: The <code>Value</code> is a lower bound of the actual count of matching
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relation} will
     * return {@link Relation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #relationAsString}.
     * </p>
     * 
     * @return Indicates the relationship between the returned <code>Value</code> and the actual total number of
     *         matching results. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EqualTo</code>: The <code>Value</code> is the exact count of matching results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GreaterThanOrEqualTo</code>: The <code>Value</code> is a lower bound of the actual count of
     *         matching results.
     *         </p>
     *         </li>
     * @see Relation
     */
    public final String relationAsString() {
        return relation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(relationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TotalHits)) {
            return false;
        }
        TotalHits other = (TotalHits) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(relationAsString(), other.relationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TotalHits").add("Value", value()).add("Relation", relationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Relation":
            return Optional.ofNullable(clazz.cast(relationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        map.put("Relation", RELATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TotalHits, T> g) {
        return obj -> g.apply((TotalHits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TotalHits> {
        /**
         * <p>
         * The total number of matching results. This value may be exact or an estimate, depending on the
         * <code>Relation</code> field.
         * </p>
         * 
         * @param value
         *        The total number of matching results. This value may be exact or an estimate, depending on the
         *        <code>Relation</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Long value);

        /**
         * <p>
         * Indicates the relationship between the returned <code>Value</code> and the actual total number of matching
         * results. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EqualTo</code>: The <code>Value</code> is the exact count of matching results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GreaterThanOrEqualTo</code>: The <code>Value</code> is a lower bound of the actual count of matching
         * results.
         * </p>
         * </li>
         * </ul>
         * 
         * @param relation
         *        Indicates the relationship between the returned <code>Value</code> and the actual total number of
         *        matching results. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EqualTo</code>: The <code>Value</code> is the exact count of matching results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GreaterThanOrEqualTo</code>: The <code>Value</code> is a lower bound of the actual count of
         *        matching results.
         *        </p>
         *        </li>
         * @see Relation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Relation
         */
        Builder relation(String relation);

        /**
         * <p>
         * Indicates the relationship between the returned <code>Value</code> and the actual total number of matching
         * results. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EqualTo</code>: The <code>Value</code> is the exact count of matching results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GreaterThanOrEqualTo</code>: The <code>Value</code> is a lower bound of the actual count of matching
         * results.
         * </p>
         * </li>
         * </ul>
         * 
         * @param relation
         *        Indicates the relationship between the returned <code>Value</code> and the actual total number of
         *        matching results. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EqualTo</code>: The <code>Value</code> is the exact count of matching results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GreaterThanOrEqualTo</code>: The <code>Value</code> is a lower bound of the actual count of
         *        matching results.
         *        </p>
         *        </li>
         * @see Relation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Relation
         */
        Builder relation(Relation relation);
    }

    static final class BuilderImpl implements Builder {
        private Long value;

        private String relation;

        private BuilderImpl() {
        }

        private BuilderImpl(TotalHits model) {
            value(model.value);
            relation(model.relation);
        }

        public final Long getValue() {
            return value;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        public final String getRelation() {
            return relation;
        }

        public final void setRelation(String relation) {
            this.relation = relation;
        }

        @Override
        public final Builder relation(String relation) {
            this.relation = relation;
            return this;
        }

        @Override
        public final Builder relation(Relation relation) {
            this.relation(relation == null ? null : relation.toString());
            return this;
        }

        @Override
        public TotalHits build() {
            return new TotalHits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
