/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings that apply to an Amazon SageMaker AI domain when you use it in Amazon SageMaker Unified Studio.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnifiedStudioSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<UnifiedStudioSettings.Builder, UnifiedStudioSettings> {
    private static final SdkField<String> STUDIO_WEB_PORTAL_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StudioWebPortalAccess").getter(getter(UnifiedStudioSettings::studioWebPortalAccessAsString))
            .setter(setter(Builder::studioWebPortalAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioWebPortalAccess").build())
            .build();

    private static final SdkField<String> DOMAIN_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainAccountId").getter(getter(UnifiedStudioSettings::domainAccountId))
            .setter(setter(Builder::domainAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainAccountId").build()).build();

    private static final SdkField<String> DOMAIN_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainRegion").getter(getter(UnifiedStudioSettings::domainRegion)).setter(setter(Builder::domainRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainRegion").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(UnifiedStudioSettings::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectId").getter(getter(UnifiedStudioSettings::projectId)).setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectId").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentId").getter(getter(UnifiedStudioSettings::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()).build();

    private static final SdkField<String> PROJECT_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectS3Path").getter(getter(UnifiedStudioSettings::projectS3Path))
            .setter(setter(Builder::projectS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectS3Path").build()).build();

    private static final SdkField<String> SINGLE_SIGN_ON_APPLICATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SingleSignOnApplicationArn")
            .getter(getter(UnifiedStudioSettings::singleSignOnApplicationArn))
            .setter(setter(Builder::singleSignOnApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSignOnApplicationArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STUDIO_WEB_PORTAL_ACCESS_FIELD, DOMAIN_ACCOUNT_ID_FIELD, DOMAIN_REGION_FIELD, DOMAIN_ID_FIELD, PROJECT_ID_FIELD,
            ENVIRONMENT_ID_FIELD, PROJECT_S3_PATH_FIELD, SINGLE_SIGN_ON_APPLICATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String studioWebPortalAccess;

    private final String domainAccountId;

    private final String domainRegion;

    private final String domainId;

    private final String projectId;

    private final String environmentId;

    private final String projectS3Path;

    private final String singleSignOnApplicationArn;

    private UnifiedStudioSettings(BuilderImpl builder) {
        this.studioWebPortalAccess = builder.studioWebPortalAccess;
        this.domainAccountId = builder.domainAccountId;
        this.domainRegion = builder.domainRegion;
        this.domainId = builder.domainId;
        this.projectId = builder.projectId;
        this.environmentId = builder.environmentId;
        this.projectS3Path = builder.projectS3Path;
        this.singleSignOnApplicationArn = builder.singleSignOnApplicationArn;
    }

    /**
     * <p>
     * Sets whether you can access the domain in Amazon SageMaker Studio:
     * </p>
     * <dl>
     * <dt>ENABLED</dt>
     * <dd>
     * <p>
     * You can access the domain in Amazon SageMaker Studio. If you migrate the domain to Amazon SageMaker Unified
     * Studio, you can access it in both studio interfaces.
     * </p>
     * </dd>
     * <dt>DISABLED</dt>
     * <dd>
     * <p>
     * You can't access the domain in Amazon SageMaker Studio. If you migrate the domain to Amazon SageMaker Unified
     * Studio, you can access it only in that studio interface.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * To migrate a domain to Amazon SageMaker Unified Studio, you specify the UnifiedStudioSettings data type when you
     * use the UpdateDomain action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #studioWebPortalAccess} will return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #studioWebPortalAccessAsString}.
     * </p>
     * 
     * @return Sets whether you can access the domain in Amazon SageMaker Studio:</p>
     *         <dl>
     *         <dt>ENABLED</dt>
     *         <dd>
     *         <p>
     *         You can access the domain in Amazon SageMaker Studio. If you migrate the domain to Amazon SageMaker
     *         Unified Studio, you can access it in both studio interfaces.
     *         </p>
     *         </dd>
     *         <dt>DISABLED</dt>
     *         <dd>
     *         <p>
     *         You can't access the domain in Amazon SageMaker Studio. If you migrate the domain to Amazon SageMaker
     *         Unified Studio, you can access it only in that studio interface.
     *         </p>
     *         </dd>
     *         </dl>
     *         <p>
     *         To migrate a domain to Amazon SageMaker Unified Studio, you specify the UnifiedStudioSettings data type
     *         when you use the UpdateDomain action.
     * @see FeatureStatus
     */
    public final FeatureStatus studioWebPortalAccess() {
        return FeatureStatus.fromValue(studioWebPortalAccess);
    }

    /**
     * <p>
     * Sets whether you can access the domain in Amazon SageMaker Studio:
     * </p>
     * <dl>
     * <dt>ENABLED</dt>
     * <dd>
     * <p>
     * You can access the domain in Amazon SageMaker Studio. If you migrate the domain to Amazon SageMaker Unified
     * Studio, you can access it in both studio interfaces.
     * </p>
     * </dd>
     * <dt>DISABLED</dt>
     * <dd>
     * <p>
     * You can't access the domain in Amazon SageMaker Studio. If you migrate the domain to Amazon SageMaker Unified
     * Studio, you can access it only in that studio interface.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * To migrate a domain to Amazon SageMaker Unified Studio, you specify the UnifiedStudioSettings data type when you
     * use the UpdateDomain action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #studioWebPortalAccess} will return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #studioWebPortalAccessAsString}.
     * </p>
     * 
     * @return Sets whether you can access the domain in Amazon SageMaker Studio:</p>
     *         <dl>
     *         <dt>ENABLED</dt>
     *         <dd>
     *         <p>
     *         You can access the domain in Amazon SageMaker Studio. If you migrate the domain to Amazon SageMaker
     *         Unified Studio, you can access it in both studio interfaces.
     *         </p>
     *         </dd>
     *         <dt>DISABLED</dt>
     *         <dd>
     *         <p>
     *         You can't access the domain in Amazon SageMaker Studio. If you migrate the domain to Amazon SageMaker
     *         Unified Studio, you can access it only in that studio interface.
     *         </p>
     *         </dd>
     *         </dl>
     *         <p>
     *         To migrate a domain to Amazon SageMaker Unified Studio, you specify the UnifiedStudioSettings data type
     *         when you use the UpdateDomain action.
     * @see FeatureStatus
     */
    public final String studioWebPortalAccessAsString() {
        return studioWebPortalAccess;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that has the Amazon SageMaker Unified Studio domain. The default value,
     * if you don't specify an ID, is the ID of the account that has the Amazon SageMaker AI domain.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that has the Amazon SageMaker Unified Studio domain. The
     *         default value, if you don't specify an ID, is the ID of the account that has the Amazon SageMaker AI
     *         domain.
     */
    public final String domainAccountId() {
        return domainAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the domain is located in Amazon SageMaker Unified Studio. The default value,
     * if you don't specify a Region, is the Region where the Amazon SageMaker AI domain is located.
     * </p>
     * 
     * @return The Amazon Web Services Region where the domain is located in Amazon SageMaker Unified Studio. The
     *         default value, if you don't specify a Region, is the Region where the Amazon SageMaker AI domain is
     *         located.
     */
    public final String domainRegion() {
        return domainRegion;
    }

    /**
     * <p>
     * The ID of the Amazon SageMaker Unified Studio domain associated with this domain.
     * </p>
     * 
     * @return The ID of the Amazon SageMaker Unified Studio domain associated with this domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The ID of the Amazon SageMaker Unified Studio project that corresponds to the domain.
     * </p>
     * 
     * @return The ID of the Amazon SageMaker Unified Studio project that corresponds to the domain.
     */
    public final String projectId() {
        return projectId;
    }

    /**
     * <p>
     * The ID of the environment that Amazon SageMaker Unified Studio associates with the domain.
     * </p>
     * 
     * @return The ID of the environment that Amazon SageMaker Unified Studio associates with the domain.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The location where Amazon S3 stores temporary execution data and other artifacts for the project that corresponds
     * to the domain.
     * </p>
     * 
     * @return The location where Amazon S3 stores temporary execution data and other artifacts for the project that
     *         corresponds to the domain.
     */
    public final String projectS3Path() {
        return projectS3Path;
    }

    /**
     * <p>
     * The ARN of the application managed by SageMaker AI and SageMaker Unified Studio in the Amazon Web Services IAM
     * Identity Center.
     * </p>
     * 
     * @return The ARN of the application managed by SageMaker AI and SageMaker Unified Studio in the Amazon Web
     *         Services IAM Identity Center.
     */
    public final String singleSignOnApplicationArn() {
        return singleSignOnApplicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(studioWebPortalAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(domainAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(domainRegion());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(projectS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(singleSignOnApplicationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnifiedStudioSettings)) {
            return false;
        }
        UnifiedStudioSettings other = (UnifiedStudioSettings) obj;
        return Objects.equals(studioWebPortalAccessAsString(), other.studioWebPortalAccessAsString())
                && Objects.equals(domainAccountId(), other.domainAccountId())
                && Objects.equals(domainRegion(), other.domainRegion()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(projectId(), other.projectId()) && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(projectS3Path(), other.projectS3Path())
                && Objects.equals(singleSignOnApplicationArn(), other.singleSignOnApplicationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnifiedStudioSettings").add("StudioWebPortalAccess", studioWebPortalAccessAsString())
                .add("DomainAccountId", domainAccountId()).add("DomainRegion", domainRegion()).add("DomainId", domainId())
                .add("ProjectId", projectId()).add("EnvironmentId", environmentId()).add("ProjectS3Path", projectS3Path())
                .add("SingleSignOnApplicationArn", singleSignOnApplicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StudioWebPortalAccess":
            return Optional.ofNullable(clazz.cast(studioWebPortalAccessAsString()));
        case "DomainAccountId":
            return Optional.ofNullable(clazz.cast(domainAccountId()));
        case "DomainRegion":
            return Optional.ofNullable(clazz.cast(domainRegion()));
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "ProjectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "ProjectS3Path":
            return Optional.ofNullable(clazz.cast(projectS3Path()));
        case "SingleSignOnApplicationArn":
            return Optional.ofNullable(clazz.cast(singleSignOnApplicationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StudioWebPortalAccess", STUDIO_WEB_PORTAL_ACCESS_FIELD);
        map.put("DomainAccountId", DOMAIN_ACCOUNT_ID_FIELD);
        map.put("DomainRegion", DOMAIN_REGION_FIELD);
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("ProjectId", PROJECT_ID_FIELD);
        map.put("EnvironmentId", ENVIRONMENT_ID_FIELD);
        map.put("ProjectS3Path", PROJECT_S3_PATH_FIELD);
        map.put("SingleSignOnApplicationArn", SINGLE_SIGN_ON_APPLICATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnifiedStudioSettings, T> g) {
        return obj -> g.apply((UnifiedStudioSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnifiedStudioSettings> {
        /**
         * <p>
         * Sets whether you can access the domain in Amazon SageMaker Studio:
         * </p>
         * <dl>
         * <dt>ENABLED</dt>
         * <dd>
         * <p>
         * You can access the domain in Amazon SageMaker Studio. If you migrate the domain to Amazon SageMaker Unified
         * Studio, you can access it in both studio interfaces.
         * </p>
         * </dd>
         * <dt>DISABLED</dt>
         * <dd>
         * <p>
         * You can't access the domain in Amazon SageMaker Studio. If you migrate the domain to Amazon SageMaker Unified
         * Studio, you can access it only in that studio interface.
         * </p>
         * </dd>
         * </dl>
         * <p>
         * To migrate a domain to Amazon SageMaker Unified Studio, you specify the UnifiedStudioSettings data type when
         * you use the UpdateDomain action.
         * </p>
         * 
         * @param studioWebPortalAccess
         *        Sets whether you can access the domain in Amazon SageMaker Studio:</p>
         *        <dl>
         *        <dt>ENABLED</dt>
         *        <dd>
         *        <p>
         *        You can access the domain in Amazon SageMaker Studio. If you migrate the domain to Amazon SageMaker
         *        Unified Studio, you can access it in both studio interfaces.
         *        </p>
         *        </dd>
         *        <dt>DISABLED</dt>
         *        <dd>
         *        <p>
         *        You can't access the domain in Amazon SageMaker Studio. If you migrate the domain to Amazon SageMaker
         *        Unified Studio, you can access it only in that studio interface.
         *        </p>
         *        </dd>
         *        </dl>
         *        <p>
         *        To migrate a domain to Amazon SageMaker Unified Studio, you specify the UnifiedStudioSettings data
         *        type when you use the UpdateDomain action.
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder studioWebPortalAccess(String studioWebPortalAccess);

        /**
         * <p>
         * Sets whether you can access the domain in Amazon SageMaker Studio:
         * </p>
         * <dl>
         * <dt>ENABLED</dt>
         * <dd>
         * <p>
         * You can access the domain in Amazon SageMaker Studio. If you migrate the domain to Amazon SageMaker Unified
         * Studio, you can access it in both studio interfaces.
         * </p>
         * </dd>
         * <dt>DISABLED</dt>
         * <dd>
         * <p>
         * You can't access the domain in Amazon SageMaker Studio. If you migrate the domain to Amazon SageMaker Unified
         * Studio, you can access it only in that studio interface.
         * </p>
         * </dd>
         * </dl>
         * <p>
         * To migrate a domain to Amazon SageMaker Unified Studio, you specify the UnifiedStudioSettings data type when
         * you use the UpdateDomain action.
         * </p>
         * 
         * @param studioWebPortalAccess
         *        Sets whether you can access the domain in Amazon SageMaker Studio:</p>
         *        <dl>
         *        <dt>ENABLED</dt>
         *        <dd>
         *        <p>
         *        You can access the domain in Amazon SageMaker Studio. If you migrate the domain to Amazon SageMaker
         *        Unified Studio, you can access it in both studio interfaces.
         *        </p>
         *        </dd>
         *        <dt>DISABLED</dt>
         *        <dd>
         *        <p>
         *        You can't access the domain in Amazon SageMaker Studio. If you migrate the domain to Amazon SageMaker
         *        Unified Studio, you can access it only in that studio interface.
         *        </p>
         *        </dd>
         *        </dl>
         *        <p>
         *        To migrate a domain to Amazon SageMaker Unified Studio, you specify the UnifiedStudioSettings data
         *        type when you use the UpdateDomain action.
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder studioWebPortalAccess(FeatureStatus studioWebPortalAccess);

        /**
         * <p>
         * The ID of the Amazon Web Services account that has the Amazon SageMaker Unified Studio domain. The default
         * value, if you don't specify an ID, is the ID of the account that has the Amazon SageMaker AI domain.
         * </p>
         * 
         * @param domainAccountId
         *        The ID of the Amazon Web Services account that has the Amazon SageMaker Unified Studio domain. The
         *        default value, if you don't specify an ID, is the ID of the account that has the Amazon SageMaker AI
         *        domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainAccountId(String domainAccountId);

        /**
         * <p>
         * The Amazon Web Services Region where the domain is located in Amazon SageMaker Unified Studio. The default
         * value, if you don't specify a Region, is the Region where the Amazon SageMaker AI domain is located.
         * </p>
         * 
         * @param domainRegion
         *        The Amazon Web Services Region where the domain is located in Amazon SageMaker Unified Studio. The
         *        default value, if you don't specify a Region, is the Region where the Amazon SageMaker AI domain is
         *        located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainRegion(String domainRegion);

        /**
         * <p>
         * The ID of the Amazon SageMaker Unified Studio domain associated with this domain.
         * </p>
         * 
         * @param domainId
         *        The ID of the Amazon SageMaker Unified Studio domain associated with this domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The ID of the Amazon SageMaker Unified Studio project that corresponds to the domain.
         * </p>
         * 
         * @param projectId
         *        The ID of the Amazon SageMaker Unified Studio project that corresponds to the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * The ID of the environment that Amazon SageMaker Unified Studio associates with the domain.
         * </p>
         * 
         * @param environmentId
         *        The ID of the environment that Amazon SageMaker Unified Studio associates with the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The location where Amazon S3 stores temporary execution data and other artifacts for the project that
         * corresponds to the domain.
         * </p>
         * 
         * @param projectS3Path
         *        The location where Amazon S3 stores temporary execution data and other artifacts for the project that
         *        corresponds to the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectS3Path(String projectS3Path);

        /**
         * <p>
         * The ARN of the application managed by SageMaker AI and SageMaker Unified Studio in the Amazon Web Services
         * IAM Identity Center.
         * </p>
         * 
         * @param singleSignOnApplicationArn
         *        The ARN of the application managed by SageMaker AI and SageMaker Unified Studio in the Amazon Web
         *        Services IAM Identity Center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleSignOnApplicationArn(String singleSignOnApplicationArn);
    }

    static final class BuilderImpl implements Builder {
        private String studioWebPortalAccess;

        private String domainAccountId;

        private String domainRegion;

        private String domainId;

        private String projectId;

        private String environmentId;

        private String projectS3Path;

        private String singleSignOnApplicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UnifiedStudioSettings model) {
            studioWebPortalAccess(model.studioWebPortalAccess);
            domainAccountId(model.domainAccountId);
            domainRegion(model.domainRegion);
            domainId(model.domainId);
            projectId(model.projectId);
            environmentId(model.environmentId);
            projectS3Path(model.projectS3Path);
            singleSignOnApplicationArn(model.singleSignOnApplicationArn);
        }

        public final String getStudioWebPortalAccess() {
            return studioWebPortalAccess;
        }

        public final void setStudioWebPortalAccess(String studioWebPortalAccess) {
            this.studioWebPortalAccess = studioWebPortalAccess;
        }

        @Override
        public final Builder studioWebPortalAccess(String studioWebPortalAccess) {
            this.studioWebPortalAccess = studioWebPortalAccess;
            return this;
        }

        @Override
        public final Builder studioWebPortalAccess(FeatureStatus studioWebPortalAccess) {
            this.studioWebPortalAccess(studioWebPortalAccess == null ? null : studioWebPortalAccess.toString());
            return this;
        }

        public final String getDomainAccountId() {
            return domainAccountId;
        }

        public final void setDomainAccountId(String domainAccountId) {
            this.domainAccountId = domainAccountId;
        }

        @Override
        public final Builder domainAccountId(String domainAccountId) {
            this.domainAccountId = domainAccountId;
            return this;
        }

        public final String getDomainRegion() {
            return domainRegion;
        }

        public final void setDomainRegion(String domainRegion) {
            this.domainRegion = domainRegion;
        }

        @Override
        public final Builder domainRegion(String domainRegion) {
            this.domainRegion = domainRegion;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getProjectId() {
            return projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getProjectS3Path() {
            return projectS3Path;
        }

        public final void setProjectS3Path(String projectS3Path) {
            this.projectS3Path = projectS3Path;
        }

        @Override
        public final Builder projectS3Path(String projectS3Path) {
            this.projectS3Path = projectS3Path;
            return this;
        }

        public final String getSingleSignOnApplicationArn() {
            return singleSignOnApplicationArn;
        }

        public final void setSingleSignOnApplicationArn(String singleSignOnApplicationArn) {
            this.singleSignOnApplicationArn = singleSignOnApplicationArn;
        }

        @Override
        public final Builder singleSignOnApplicationArn(String singleSignOnApplicationArn) {
            this.singleSignOnApplicationArn = singleSignOnApplicationArn;
            return this;
        }

        @Override
        public UnifiedStudioSettings build() {
            return new UnifiedStudioSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
