/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration that describes specifications of the instance groups to update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClusterSoftwareInstanceGroupSpecification
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<UpdateClusterSoftwareInstanceGroupSpecification.Builder, UpdateClusterSoftwareInstanceGroupSpecification> {
    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceGroupName").getter(getter(UpdateClusterSoftwareInstanceGroupSpecification::instanceGroupName))
            .setter(setter(Builder::instanceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_GROUP_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceGroupName;

    private UpdateClusterSoftwareInstanceGroupSpecification(BuilderImpl builder) {
        this.instanceGroupName = builder.instanceGroupName;
    }

    /**
     * <p>
     * The name of the instance group to update.
     * </p>
     * 
     * @return The name of the instance group to update.
     */
    public final String instanceGroupName() {
        return instanceGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterSoftwareInstanceGroupSpecification)) {
            return false;
        }
        UpdateClusterSoftwareInstanceGroupSpecification other = (UpdateClusterSoftwareInstanceGroupSpecification) obj;
        return Objects.equals(instanceGroupName(), other.instanceGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClusterSoftwareInstanceGroupSpecification").add("InstanceGroupName", instanceGroupName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceGroupName":
            return Optional.ofNullable(clazz.cast(instanceGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceGroupName", INSTANCE_GROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterSoftwareInstanceGroupSpecification, T> g) {
        return obj -> g.apply((UpdateClusterSoftwareInstanceGroupSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateClusterSoftwareInstanceGroupSpecification> {
        /**
         * <p>
         * The name of the instance group to update.
         * </p>
         * 
         * @param instanceGroupName
         *        The name of the instance group to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupName(String instanceGroupName);
    }

    static final class BuilderImpl implements Builder {
        private String instanceGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterSoftwareInstanceGroupSpecification model) {
            instanceGroupName(model.instanceGroupName);
        }

        public final String getInstanceGroupName() {
            return instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        @Override
        public UpdateClusterSoftwareInstanceGroupSpecification build() {
            return new UpdateClusterSoftwareInstanceGroupSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
