/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateComputeQuotaRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateComputeQuotaRequest.Builder, UpdateComputeQuotaRequest> {
    private static final SdkField<String> COMPUTE_QUOTA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputeQuotaId").getter(getter(UpdateComputeQuotaRequest::computeQuotaId))
            .setter(setter(Builder::computeQuotaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaId").build()).build();

    private static final SdkField<Integer> TARGET_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetVersion").getter(getter(UpdateComputeQuotaRequest::targetVersion))
            .setter(setter(Builder::targetVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVersion").build()).build();

    private static final SdkField<ComputeQuotaConfig> COMPUTE_QUOTA_CONFIG_FIELD = SdkField
            .<ComputeQuotaConfig> builder(MarshallingType.SDK_POJO).memberName("ComputeQuotaConfig")
            .getter(getter(UpdateComputeQuotaRequest::computeQuotaConfig)).setter(setter(Builder::computeQuotaConfig))
            .constructor(ComputeQuotaConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaConfig").build())
            .build();

    private static final SdkField<ComputeQuotaTarget> COMPUTE_QUOTA_TARGET_FIELD = SdkField
            .<ComputeQuotaTarget> builder(MarshallingType.SDK_POJO).memberName("ComputeQuotaTarget")
            .getter(getter(UpdateComputeQuotaRequest::computeQuotaTarget)).setter(setter(Builder::computeQuotaTarget))
            .constructor(ComputeQuotaTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaTarget").build())
            .build();

    private static final SdkField<String> ACTIVATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActivationState").getter(getter(UpdateComputeQuotaRequest::activationStateAsString))
            .setter(setter(Builder::activationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationState").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateComputeQuotaRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_QUOTA_ID_FIELD,
            TARGET_VERSION_FIELD, COMPUTE_QUOTA_CONFIG_FIELD, COMPUTE_QUOTA_TARGET_FIELD, ACTIVATION_STATE_FIELD,
            DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String computeQuotaId;

    private final Integer targetVersion;

    private final ComputeQuotaConfig computeQuotaConfig;

    private final ComputeQuotaTarget computeQuotaTarget;

    private final String activationState;

    private final String description;

    private UpdateComputeQuotaRequest(BuilderImpl builder) {
        super(builder);
        this.computeQuotaId = builder.computeQuotaId;
        this.targetVersion = builder.targetVersion;
        this.computeQuotaConfig = builder.computeQuotaConfig;
        this.computeQuotaTarget = builder.computeQuotaTarget;
        this.activationState = builder.activationState;
        this.description = builder.description;
    }

    /**
     * <p>
     * ID of the compute allocation definition.
     * </p>
     * 
     * @return ID of the compute allocation definition.
     */
    public final String computeQuotaId() {
        return computeQuotaId;
    }

    /**
     * <p>
     * Target version.
     * </p>
     * 
     * @return Target version.
     */
    public final Integer targetVersion() {
        return targetVersion;
    }

    /**
     * <p>
     * Configuration of the compute allocation definition. This includes the resource sharing option, and the setting to
     * preempt low priority tasks.
     * </p>
     * 
     * @return Configuration of the compute allocation definition. This includes the resource sharing option, and the
     *         setting to preempt low priority tasks.
     */
    public final ComputeQuotaConfig computeQuotaConfig() {
        return computeQuotaConfig;
    }

    /**
     * <p>
     * The target entity to allocate compute resources to.
     * </p>
     * 
     * @return The target entity to allocate compute resources to.
     */
    public final ComputeQuotaTarget computeQuotaTarget() {
        return computeQuotaTarget;
    }

    /**
     * <p>
     * The state of the compute allocation being described. Use to enable or disable compute allocation.
     * </p>
     * <p>
     * Default is <code>Enabled</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activationState}
     * will return {@link ActivationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #activationStateAsString}.
     * </p>
     * 
     * @return The state of the compute allocation being described. Use to enable or disable compute allocation.</p>
     *         <p>
     *         Default is <code>Enabled</code>.
     * @see ActivationState
     */
    public final ActivationState activationState() {
        return ActivationState.fromValue(activationState);
    }

    /**
     * <p>
     * The state of the compute allocation being described. Use to enable or disable compute allocation.
     * </p>
     * <p>
     * Default is <code>Enabled</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activationState}
     * will return {@link ActivationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #activationStateAsString}.
     * </p>
     * 
     * @return The state of the compute allocation being described. Use to enable or disable compute allocation.</p>
     *         <p>
     *         Default is <code>Enabled</code>.
     * @see ActivationState
     */
    public final String activationStateAsString() {
        return activationState;
    }

    /**
     * <p>
     * Description of the compute allocation definition.
     * </p>
     * 
     * @return Description of the compute allocation definition.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(computeQuotaId());
        hashCode = 31 * hashCode + Objects.hashCode(targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(computeQuotaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(computeQuotaTarget());
        hashCode = 31 * hashCode + Objects.hashCode(activationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComputeQuotaRequest)) {
            return false;
        }
        UpdateComputeQuotaRequest other = (UpdateComputeQuotaRequest) obj;
        return Objects.equals(computeQuotaId(), other.computeQuotaId()) && Objects.equals(targetVersion(), other.targetVersion())
                && Objects.equals(computeQuotaConfig(), other.computeQuotaConfig())
                && Objects.equals(computeQuotaTarget(), other.computeQuotaTarget())
                && Objects.equals(activationStateAsString(), other.activationStateAsString())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateComputeQuotaRequest").add("ComputeQuotaId", computeQuotaId())
                .add("TargetVersion", targetVersion()).add("ComputeQuotaConfig", computeQuotaConfig())
                .add("ComputeQuotaTarget", computeQuotaTarget()).add("ActivationState", activationStateAsString())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComputeQuotaId":
            return Optional.ofNullable(clazz.cast(computeQuotaId()));
        case "TargetVersion":
            return Optional.ofNullable(clazz.cast(targetVersion()));
        case "ComputeQuotaConfig":
            return Optional.ofNullable(clazz.cast(computeQuotaConfig()));
        case "ComputeQuotaTarget":
            return Optional.ofNullable(clazz.cast(computeQuotaTarget()));
        case "ActivationState":
            return Optional.ofNullable(clazz.cast(activationStateAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComputeQuotaId", COMPUTE_QUOTA_ID_FIELD);
        map.put("TargetVersion", TARGET_VERSION_FIELD);
        map.put("ComputeQuotaConfig", COMPUTE_QUOTA_CONFIG_FIELD);
        map.put("ComputeQuotaTarget", COMPUTE_QUOTA_TARGET_FIELD);
        map.put("ActivationState", ACTIVATION_STATE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateComputeQuotaRequest, T> g) {
        return obj -> g.apply((UpdateComputeQuotaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateComputeQuotaRequest> {
        /**
         * <p>
         * ID of the compute allocation definition.
         * </p>
         * 
         * @param computeQuotaId
         *        ID of the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaId(String computeQuotaId);

        /**
         * <p>
         * Target version.
         * </p>
         * 
         * @param targetVersion
         *        Target version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVersion(Integer targetVersion);

        /**
         * <p>
         * Configuration of the compute allocation definition. This includes the resource sharing option, and the
         * setting to preempt low priority tasks.
         * </p>
         * 
         * @param computeQuotaConfig
         *        Configuration of the compute allocation definition. This includes the resource sharing option, and the
         *        setting to preempt low priority tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaConfig(ComputeQuotaConfig computeQuotaConfig);

        /**
         * <p>
         * Configuration of the compute allocation definition. This includes the resource sharing option, and the
         * setting to preempt low priority tasks.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeQuotaConfig.Builder} avoiding the
         * need to create one manually via {@link ComputeQuotaConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeQuotaConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #computeQuotaConfig(ComputeQuotaConfig)}.
         * 
         * @param computeQuotaConfig
         *        a consumer that will call methods on {@link ComputeQuotaConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeQuotaConfig(ComputeQuotaConfig)
         */
        default Builder computeQuotaConfig(Consumer<ComputeQuotaConfig.Builder> computeQuotaConfig) {
            return computeQuotaConfig(ComputeQuotaConfig.builder().applyMutation(computeQuotaConfig).build());
        }

        /**
         * <p>
         * The target entity to allocate compute resources to.
         * </p>
         * 
         * @param computeQuotaTarget
         *        The target entity to allocate compute resources to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaTarget(ComputeQuotaTarget computeQuotaTarget);

        /**
         * <p>
         * The target entity to allocate compute resources to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeQuotaTarget.Builder} avoiding the
         * need to create one manually via {@link ComputeQuotaTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeQuotaTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #computeQuotaTarget(ComputeQuotaTarget)}.
         * 
         * @param computeQuotaTarget
         *        a consumer that will call methods on {@link ComputeQuotaTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeQuotaTarget(ComputeQuotaTarget)
         */
        default Builder computeQuotaTarget(Consumer<ComputeQuotaTarget.Builder> computeQuotaTarget) {
            return computeQuotaTarget(ComputeQuotaTarget.builder().applyMutation(computeQuotaTarget).build());
        }

        /**
         * <p>
         * The state of the compute allocation being described. Use to enable or disable compute allocation.
         * </p>
         * <p>
         * Default is <code>Enabled</code>.
         * </p>
         * 
         * @param activationState
         *        The state of the compute allocation being described. Use to enable or disable compute allocation.</p>
         *        <p>
         *        Default is <code>Enabled</code>.
         * @see ActivationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivationState
         */
        Builder activationState(String activationState);

        /**
         * <p>
         * The state of the compute allocation being described. Use to enable or disable compute allocation.
         * </p>
         * <p>
         * Default is <code>Enabled</code>.
         * </p>
         * 
         * @param activationState
         *        The state of the compute allocation being described. Use to enable or disable compute allocation.</p>
         *        <p>
         *        Default is <code>Enabled</code>.
         * @see ActivationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivationState
         */
        Builder activationState(ActivationState activationState);

        /**
         * <p>
         * Description of the compute allocation definition.
         * </p>
         * 
         * @param description
         *        Description of the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String computeQuotaId;

        private Integer targetVersion;

        private ComputeQuotaConfig computeQuotaConfig;

        private ComputeQuotaTarget computeQuotaTarget;

        private String activationState;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComputeQuotaRequest model) {
            super(model);
            computeQuotaId(model.computeQuotaId);
            targetVersion(model.targetVersion);
            computeQuotaConfig(model.computeQuotaConfig);
            computeQuotaTarget(model.computeQuotaTarget);
            activationState(model.activationState);
            description(model.description);
        }

        public final String getComputeQuotaId() {
            return computeQuotaId;
        }

        public final void setComputeQuotaId(String computeQuotaId) {
            this.computeQuotaId = computeQuotaId;
        }

        @Override
        public final Builder computeQuotaId(String computeQuotaId) {
            this.computeQuotaId = computeQuotaId;
            return this;
        }

        public final Integer getTargetVersion() {
            return targetVersion;
        }

        public final void setTargetVersion(Integer targetVersion) {
            this.targetVersion = targetVersion;
        }

        @Override
        public final Builder targetVersion(Integer targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final ComputeQuotaConfig.Builder getComputeQuotaConfig() {
            return computeQuotaConfig != null ? computeQuotaConfig.toBuilder() : null;
        }

        public final void setComputeQuotaConfig(ComputeQuotaConfig.BuilderImpl computeQuotaConfig) {
            this.computeQuotaConfig = computeQuotaConfig != null ? computeQuotaConfig.build() : null;
        }

        @Override
        public final Builder computeQuotaConfig(ComputeQuotaConfig computeQuotaConfig) {
            this.computeQuotaConfig = computeQuotaConfig;
            return this;
        }

        public final ComputeQuotaTarget.Builder getComputeQuotaTarget() {
            return computeQuotaTarget != null ? computeQuotaTarget.toBuilder() : null;
        }

        public final void setComputeQuotaTarget(ComputeQuotaTarget.BuilderImpl computeQuotaTarget) {
            this.computeQuotaTarget = computeQuotaTarget != null ? computeQuotaTarget.build() : null;
        }

        @Override
        public final Builder computeQuotaTarget(ComputeQuotaTarget computeQuotaTarget) {
            this.computeQuotaTarget = computeQuotaTarget;
            return this;
        }

        public final String getActivationState() {
            return activationState;
        }

        public final void setActivationState(String activationState) {
            this.activationState = activationState;
        }

        @Override
        public final Builder activationState(String activationState) {
            this.activationState = activationState;
            return this;
        }

        @Override
        public final Builder activationState(ActivationState activationState) {
            this.activationState(activationState == null ? null : activationState.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateComputeQuotaRequest build() {
            return new UpdateComputeQuotaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
