/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateComputeQuotaResponse extends SageMakerResponse implements
        ToCopyableBuilder<UpdateComputeQuotaResponse.Builder, UpdateComputeQuotaResponse> {
    private static final SdkField<String> COMPUTE_QUOTA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputeQuotaArn").getter(getter(UpdateComputeQuotaResponse::computeQuotaArn))
            .setter(setter(Builder::computeQuotaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaArn").build()).build();

    private static final SdkField<Integer> COMPUTE_QUOTA_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ComputeQuotaVersion").getter(getter(UpdateComputeQuotaResponse::computeQuotaVersion))
            .setter(setter(Builder::computeQuotaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_QUOTA_ARN_FIELD,
            COMPUTE_QUOTA_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String computeQuotaArn;

    private final Integer computeQuotaVersion;

    private UpdateComputeQuotaResponse(BuilderImpl builder) {
        super(builder);
        this.computeQuotaArn = builder.computeQuotaArn;
        this.computeQuotaVersion = builder.computeQuotaVersion;
    }

    /**
     * <p>
     * ARN of the compute allocation definition.
     * </p>
     * 
     * @return ARN of the compute allocation definition.
     */
    public final String computeQuotaArn() {
        return computeQuotaArn;
    }

    /**
     * <p>
     * Version of the compute allocation definition.
     * </p>
     * 
     * @return Version of the compute allocation definition.
     */
    public final Integer computeQuotaVersion() {
        return computeQuotaVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(computeQuotaArn());
        hashCode = 31 * hashCode + Objects.hashCode(computeQuotaVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComputeQuotaResponse)) {
            return false;
        }
        UpdateComputeQuotaResponse other = (UpdateComputeQuotaResponse) obj;
        return Objects.equals(computeQuotaArn(), other.computeQuotaArn())
                && Objects.equals(computeQuotaVersion(), other.computeQuotaVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateComputeQuotaResponse").add("ComputeQuotaArn", computeQuotaArn())
                .add("ComputeQuotaVersion", computeQuotaVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComputeQuotaArn":
            return Optional.ofNullable(clazz.cast(computeQuotaArn()));
        case "ComputeQuotaVersion":
            return Optional.ofNullable(clazz.cast(computeQuotaVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComputeQuotaArn", COMPUTE_QUOTA_ARN_FIELD);
        map.put("ComputeQuotaVersion", COMPUTE_QUOTA_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateComputeQuotaResponse, T> g) {
        return obj -> g.apply((UpdateComputeQuotaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateComputeQuotaResponse> {
        /**
         * <p>
         * ARN of the compute allocation definition.
         * </p>
         * 
         * @param computeQuotaArn
         *        ARN of the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaArn(String computeQuotaArn);

        /**
         * <p>
         * Version of the compute allocation definition.
         * </p>
         * 
         * @param computeQuotaVersion
         *        Version of the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaVersion(Integer computeQuotaVersion);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String computeQuotaArn;

        private Integer computeQuotaVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComputeQuotaResponse model) {
            super(model);
            computeQuotaArn(model.computeQuotaArn);
            computeQuotaVersion(model.computeQuotaVersion);
        }

        public final String getComputeQuotaArn() {
            return computeQuotaArn;
        }

        public final void setComputeQuotaArn(String computeQuotaArn) {
            this.computeQuotaArn = computeQuotaArn;
        }

        @Override
        public final Builder computeQuotaArn(String computeQuotaArn) {
            this.computeQuotaArn = computeQuotaArn;
            return this;
        }

        public final Integer getComputeQuotaVersion() {
            return computeQuotaVersion;
        }

        public final void setComputeQuotaVersion(Integer computeQuotaVersion) {
            this.computeQuotaVersion = computeQuotaVersion;
        }

        @Override
        public final Builder computeQuotaVersion(Integer computeQuotaVersion) {
            this.computeQuotaVersion = computeQuotaVersion;
            return this;
        }

        @Override
        public UpdateComputeQuotaResponse build() {
            return new UpdateComputeQuotaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
