/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFeatureGroupRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateFeatureGroupRequest.Builder, UpdateFeatureGroupRequest> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupName").getter(getter(UpdateFeatureGroupRequest::featureGroupName))
            .setter(setter(Builder::featureGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()).build();

    private static final SdkField<List<FeatureDefinition>> FEATURE_ADDITIONS_FIELD = SdkField
            .<List<FeatureDefinition>> builder(MarshallingType.LIST)
            .memberName("FeatureAdditions")
            .getter(getter(UpdateFeatureGroupRequest::featureAdditions))
            .setter(setter(Builder::featureAdditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureAdditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeatureDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeatureDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OnlineStoreConfigUpdate> ONLINE_STORE_CONFIG_FIELD = SdkField
            .<OnlineStoreConfigUpdate> builder(MarshallingType.SDK_POJO).memberName("OnlineStoreConfig")
            .getter(getter(UpdateFeatureGroupRequest::onlineStoreConfig)).setter(setter(Builder::onlineStoreConfig))
            .constructor(OnlineStoreConfigUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnlineStoreConfig").build()).build();

    private static final SdkField<ThroughputConfigUpdate> THROUGHPUT_CONFIG_FIELD = SdkField
            .<ThroughputConfigUpdate> builder(MarshallingType.SDK_POJO).memberName("ThroughputConfig")
            .getter(getter(UpdateFeatureGroupRequest::throughputConfig)).setter(setter(Builder::throughputConfig))
            .constructor(ThroughputConfigUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD,
            FEATURE_ADDITIONS_FIELD, ONLINE_STORE_CONFIG_FIELD, THROUGHPUT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String featureGroupName;

    private final List<FeatureDefinition> featureAdditions;

    private final OnlineStoreConfigUpdate onlineStoreConfig;

    private final ThroughputConfigUpdate throughputConfig;

    private UpdateFeatureGroupRequest(BuilderImpl builder) {
        super(builder);
        this.featureGroupName = builder.featureGroupName;
        this.featureAdditions = builder.featureAdditions;
        this.onlineStoreConfig = builder.onlineStoreConfig;
        this.throughputConfig = builder.throughputConfig;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the feature group that you're updating.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the feature group that you're updating.
     */
    public final String featureGroupName() {
        return featureGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the FeatureAdditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFeatureAdditions() {
        return featureAdditions != null && !(featureAdditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Updates the feature group. Updating a feature group is an asynchronous operation. When you get an HTTP 200
     * response, you've made a valid request. It takes some time after you've made a valid request for Feature Store to
     * update the feature group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatureAdditions} method.
     * </p>
     * 
     * @return Updates the feature group. Updating a feature group is an asynchronous operation. When you get an HTTP
     *         200 response, you've made a valid request. It takes some time after you've made a valid request for
     *         Feature Store to update the feature group.
     */
    public final List<FeatureDefinition> featureAdditions() {
        return featureAdditions;
    }

    /**
     * <p>
     * Updates the feature group online store configuration.
     * </p>
     * 
     * @return Updates the feature group online store configuration.
     */
    public final OnlineStoreConfigUpdate onlineStoreConfig() {
        return onlineStoreConfig;
    }

    /**
     * Returns the value of the ThroughputConfig property for this object.
     * 
     * @return The value of the ThroughputConfig property for this object.
     */
    public final ThroughputConfigUpdate throughputConfig() {
        return throughputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatureAdditions() ? featureAdditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(onlineStoreConfig());
        hashCode = 31 * hashCode + Objects.hashCode(throughputConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFeatureGroupRequest)) {
            return false;
        }
        UpdateFeatureGroupRequest other = (UpdateFeatureGroupRequest) obj;
        return Objects.equals(featureGroupName(), other.featureGroupName())
                && hasFeatureAdditions() == other.hasFeatureAdditions()
                && Objects.equals(featureAdditions(), other.featureAdditions())
                && Objects.equals(onlineStoreConfig(), other.onlineStoreConfig())
                && Objects.equals(throughputConfig(), other.throughputConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFeatureGroupRequest").add("FeatureGroupName", featureGroupName())
                .add("FeatureAdditions", hasFeatureAdditions() ? featureAdditions() : null)
                .add("OnlineStoreConfig", onlineStoreConfig()).add("ThroughputConfig", throughputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureGroupName":
            return Optional.ofNullable(clazz.cast(featureGroupName()));
        case "FeatureAdditions":
            return Optional.ofNullable(clazz.cast(featureAdditions()));
        case "OnlineStoreConfig":
            return Optional.ofNullable(clazz.cast(onlineStoreConfig()));
        case "ThroughputConfig":
            return Optional.ofNullable(clazz.cast(throughputConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FeatureGroupName", FEATURE_GROUP_NAME_FIELD);
        map.put("FeatureAdditions", FEATURE_ADDITIONS_FIELD);
        map.put("OnlineStoreConfig", ONLINE_STORE_CONFIG_FIELD);
        map.put("ThroughputConfig", THROUGHPUT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFeatureGroupRequest, T> g) {
        return obj -> g.apply((UpdateFeatureGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFeatureGroupRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the feature group that you're updating.
         * </p>
         * 
         * @param featureGroupName
         *        The name or Amazon Resource Name (ARN) of the feature group that you're updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupName(String featureGroupName);

        /**
         * <p>
         * Updates the feature group. Updating a feature group is an asynchronous operation. When you get an HTTP 200
         * response, you've made a valid request. It takes some time after you've made a valid request for Feature Store
         * to update the feature group.
         * </p>
         * 
         * @param featureAdditions
         *        Updates the feature group. Updating a feature group is an asynchronous operation. When you get an HTTP
         *        200 response, you've made a valid request. It takes some time after you've made a valid request for
         *        Feature Store to update the feature group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureAdditions(Collection<FeatureDefinition> featureAdditions);

        /**
         * <p>
         * Updates the feature group. Updating a feature group is an asynchronous operation. When you get an HTTP 200
         * response, you've made a valid request. It takes some time after you've made a valid request for Feature Store
         * to update the feature group.
         * </p>
         * 
         * @param featureAdditions
         *        Updates the feature group. Updating a feature group is an asynchronous operation. When you get an HTTP
         *        200 response, you've made a valid request. It takes some time after you've made a valid request for
         *        Feature Store to update the feature group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureAdditions(FeatureDefinition... featureAdditions);

        /**
         * <p>
         * Updates the feature group. Updating a feature group is an asynchronous operation. When you get an HTTP 200
         * response, you've made a valid request. It takes some time after you've made a valid request for Feature Store
         * to update the feature group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.FeatureDefinition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.sagemaker.model.FeatureDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.FeatureDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #featureAdditions(List<FeatureDefinition>)}.
         * 
         * @param featureAdditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.FeatureDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featureAdditions(java.util.Collection<FeatureDefinition>)
         */
        Builder featureAdditions(Consumer<FeatureDefinition.Builder>... featureAdditions);

        /**
         * <p>
         * Updates the feature group online store configuration.
         * </p>
         * 
         * @param onlineStoreConfig
         *        Updates the feature group online store configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onlineStoreConfig(OnlineStoreConfigUpdate onlineStoreConfig);

        /**
         * <p>
         * Updates the feature group online store configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnlineStoreConfigUpdate.Builder} avoiding
         * the need to create one manually via {@link OnlineStoreConfigUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnlineStoreConfigUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #onlineStoreConfig(OnlineStoreConfigUpdate)}.
         * 
         * @param onlineStoreConfig
         *        a consumer that will call methods on {@link OnlineStoreConfigUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onlineStoreConfig(OnlineStoreConfigUpdate)
         */
        default Builder onlineStoreConfig(Consumer<OnlineStoreConfigUpdate.Builder> onlineStoreConfig) {
            return onlineStoreConfig(OnlineStoreConfigUpdate.builder().applyMutation(onlineStoreConfig).build());
        }

        /**
         * Sets the value of the ThroughputConfig property for this object.
         *
         * @param throughputConfig
         *        The new value for the ThroughputConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughputConfig(ThroughputConfigUpdate throughputConfig);

        /**
         * Sets the value of the ThroughputConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ThroughputConfigUpdate.Builder} avoiding
         * the need to create one manually via {@link ThroughputConfigUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ThroughputConfigUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #throughputConfig(ThroughputConfigUpdate)}.
         * 
         * @param throughputConfig
         *        a consumer that will call methods on {@link ThroughputConfigUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #throughputConfig(ThroughputConfigUpdate)
         */
        default Builder throughputConfig(Consumer<ThroughputConfigUpdate.Builder> throughputConfig) {
            return throughputConfig(ThroughputConfigUpdate.builder().applyMutation(throughputConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String featureGroupName;

        private List<FeatureDefinition> featureAdditions = DefaultSdkAutoConstructList.getInstance();

        private OnlineStoreConfigUpdate onlineStoreConfig;

        private ThroughputConfigUpdate throughputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFeatureGroupRequest model) {
            super(model);
            featureGroupName(model.featureGroupName);
            featureAdditions(model.featureAdditions);
            onlineStoreConfig(model.onlineStoreConfig);
            throughputConfig(model.throughputConfig);
        }

        public final String getFeatureGroupName() {
            return featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final List<FeatureDefinition.Builder> getFeatureAdditions() {
            List<FeatureDefinition.Builder> result = FeatureAdditionsCopier.copyToBuilder(this.featureAdditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatureAdditions(Collection<FeatureDefinition.BuilderImpl> featureAdditions) {
            this.featureAdditions = FeatureAdditionsCopier.copyFromBuilder(featureAdditions);
        }

        @Override
        public final Builder featureAdditions(Collection<FeatureDefinition> featureAdditions) {
            this.featureAdditions = FeatureAdditionsCopier.copy(featureAdditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureAdditions(FeatureDefinition... featureAdditions) {
            featureAdditions(Arrays.asList(featureAdditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureAdditions(Consumer<FeatureDefinition.Builder>... featureAdditions) {
            featureAdditions(Stream.of(featureAdditions).map(c -> FeatureDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final OnlineStoreConfigUpdate.Builder getOnlineStoreConfig() {
            return onlineStoreConfig != null ? onlineStoreConfig.toBuilder() : null;
        }

        public final void setOnlineStoreConfig(OnlineStoreConfigUpdate.BuilderImpl onlineStoreConfig) {
            this.onlineStoreConfig = onlineStoreConfig != null ? onlineStoreConfig.build() : null;
        }

        @Override
        public final Builder onlineStoreConfig(OnlineStoreConfigUpdate onlineStoreConfig) {
            this.onlineStoreConfig = onlineStoreConfig;
            return this;
        }

        public final ThroughputConfigUpdate.Builder getThroughputConfig() {
            return throughputConfig != null ? throughputConfig.toBuilder() : null;
        }

        public final void setThroughputConfig(ThroughputConfigUpdate.BuilderImpl throughputConfig) {
            this.throughputConfig = throughputConfig != null ? throughputConfig.build() : null;
        }

        @Override
        public final Builder throughputConfig(ThroughputConfigUpdate throughputConfig) {
            this.throughputConfig = throughputConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFeatureGroupRequest build() {
            return new UpdateFeatureGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
