/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateHubContentReferenceRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateHubContentReferenceRequest.Builder, UpdateHubContentReferenceRequest> {
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubName").getter(getter(UpdateHubContentReferenceRequest::hubName)).setter(setter(Builder::hubName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()).build();

    private static final SdkField<String> HUB_CONTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentName").getter(getter(UpdateHubContentReferenceRequest::hubContentName))
            .setter(setter(Builder::hubContentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentName").build()).build();

    private static final SdkField<String> HUB_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentType").getter(getter(UpdateHubContentReferenceRequest::hubContentTypeAsString))
            .setter(setter(Builder::hubContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentType").build()).build();

    private static final SdkField<String> MIN_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MinVersion").getter(getter(UpdateHubContentReferenceRequest::minVersion))
            .setter(setter(Builder::minVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_NAME_FIELD,
            HUB_CONTENT_NAME_FIELD, HUB_CONTENT_TYPE_FIELD, MIN_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hubName;

    private final String hubContentName;

    private final String hubContentType;

    private final String minVersion;

    private UpdateHubContentReferenceRequest(BuilderImpl builder) {
        super(builder);
        this.hubName = builder.hubName;
        this.hubContentName = builder.hubContentName;
        this.hubContentType = builder.hubContentType;
        this.minVersion = builder.minVersion;
    }

    /**
     * <p>
     * The name of the SageMaker hub that contains the hub content you want to update. You can optionally use the hub
     * ARN instead.
     * </p>
     * 
     * @return The name of the SageMaker hub that contains the hub content you want to update. You can optionally use
     *         the hub ARN instead.
     */
    public final String hubName() {
        return hubName;
    }

    /**
     * <p>
     * The name of the hub content resource that you want to update.
     * </p>
     * 
     * @return The name of the hub content resource that you want to update.
     */
    public final String hubContentName() {
        return hubContentName;
    }

    /**
     * <p>
     * The content type of the resource that you want to update. Only specify a <code>ModelReference</code> resource for
     * this API. To update a <code>Model</code> or <code>Notebook</code> resource, use the <code>UpdateHubContent</code>
     * API instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubContentType}
     * will return {@link HubContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubContentTypeAsString}.
     * </p>
     * 
     * @return The content type of the resource that you want to update. Only specify a <code>ModelReference</code>
     *         resource for this API. To update a <code>Model</code> or <code>Notebook</code> resource, use the
     *         <code>UpdateHubContent</code> API instead.
     * @see HubContentType
     */
    public final HubContentType hubContentType() {
        return HubContentType.fromValue(hubContentType);
    }

    /**
     * <p>
     * The content type of the resource that you want to update. Only specify a <code>ModelReference</code> resource for
     * this API. To update a <code>Model</code> or <code>Notebook</code> resource, use the <code>UpdateHubContent</code>
     * API instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubContentType}
     * will return {@link HubContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubContentTypeAsString}.
     * </p>
     * 
     * @return The content type of the resource that you want to update. Only specify a <code>ModelReference</code>
     *         resource for this API. To update a <code>Model</code> or <code>Notebook</code> resource, use the
     *         <code>UpdateHubContent</code> API instead.
     * @see HubContentType
     */
    public final String hubContentTypeAsString() {
        return hubContentType;
    }

    /**
     * <p>
     * The minimum hub content version of the referenced model that you want to use. The minimum version must be older
     * than the latest available version of the referenced model. To support all versions of a model, set the value to
     * <code>1.0.0</code>.
     * </p>
     * 
     * @return The minimum hub content version of the referenced model that you want to use. The minimum version must be
     *         older than the latest available version of the referenced model. To support all versions of a model, set
     *         the value to <code>1.0.0</code>.
     */
    public final String minVersion() {
        return minVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hubName());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentName());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHubContentReferenceRequest)) {
            return false;
        }
        UpdateHubContentReferenceRequest other = (UpdateHubContentReferenceRequest) obj;
        return Objects.equals(hubName(), other.hubName()) && Objects.equals(hubContentName(), other.hubContentName())
                && Objects.equals(hubContentTypeAsString(), other.hubContentTypeAsString())
                && Objects.equals(minVersion(), other.minVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateHubContentReferenceRequest").add("HubName", hubName())
                .add("HubContentName", hubContentName()).add("HubContentType", hubContentTypeAsString())
                .add("MinVersion", minVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubName":
            return Optional.ofNullable(clazz.cast(hubName()));
        case "HubContentName":
            return Optional.ofNullable(clazz.cast(hubContentName()));
        case "HubContentType":
            return Optional.ofNullable(clazz.cast(hubContentTypeAsString()));
        case "MinVersion":
            return Optional.ofNullable(clazz.cast(minVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HubName", HUB_NAME_FIELD);
        map.put("HubContentName", HUB_CONTENT_NAME_FIELD);
        map.put("HubContentType", HUB_CONTENT_TYPE_FIELD);
        map.put("MinVersion", MIN_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateHubContentReferenceRequest, T> g) {
        return obj -> g.apply((UpdateHubContentReferenceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateHubContentReferenceRequest> {
        /**
         * <p>
         * The name of the SageMaker hub that contains the hub content you want to update. You can optionally use the
         * hub ARN instead.
         * </p>
         * 
         * @param hubName
         *        The name of the SageMaker hub that contains the hub content you want to update. You can optionally use
         *        the hub ARN instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubName(String hubName);

        /**
         * <p>
         * The name of the hub content resource that you want to update.
         * </p>
         * 
         * @param hubContentName
         *        The name of the hub content resource that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentName(String hubContentName);

        /**
         * <p>
         * The content type of the resource that you want to update. Only specify a <code>ModelReference</code> resource
         * for this API. To update a <code>Model</code> or <code>Notebook</code> resource, use the
         * <code>UpdateHubContent</code> API instead.
         * </p>
         * 
         * @param hubContentType
         *        The content type of the resource that you want to update. Only specify a <code>ModelReference</code>
         *        resource for this API. To update a <code>Model</code> or <code>Notebook</code> resource, use the
         *        <code>UpdateHubContent</code> API instead.
         * @see HubContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentType
         */
        Builder hubContentType(String hubContentType);

        /**
         * <p>
         * The content type of the resource that you want to update. Only specify a <code>ModelReference</code> resource
         * for this API. To update a <code>Model</code> or <code>Notebook</code> resource, use the
         * <code>UpdateHubContent</code> API instead.
         * </p>
         * 
         * @param hubContentType
         *        The content type of the resource that you want to update. Only specify a <code>ModelReference</code>
         *        resource for this API. To update a <code>Model</code> or <code>Notebook</code> resource, use the
         *        <code>UpdateHubContent</code> API instead.
         * @see HubContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentType
         */
        Builder hubContentType(HubContentType hubContentType);

        /**
         * <p>
         * The minimum hub content version of the referenced model that you want to use. The minimum version must be
         * older than the latest available version of the referenced model. To support all versions of a model, set the
         * value to <code>1.0.0</code>.
         * </p>
         * 
         * @param minVersion
         *        The minimum hub content version of the referenced model that you want to use. The minimum version must
         *        be older than the latest available version of the referenced model. To support all versions of a
         *        model, set the value to <code>1.0.0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minVersion(String minVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String hubName;

        private String hubContentName;

        private String hubContentType;

        private String minVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHubContentReferenceRequest model) {
            super(model);
            hubName(model.hubName);
            hubContentName(model.hubContentName);
            hubContentType(model.hubContentType);
            minVersion(model.minVersion);
        }

        public final String getHubName() {
            return hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubContentName() {
            return hubContentName;
        }

        public final void setHubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
        }

        @Override
        public final Builder hubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
            return this;
        }

        public final String getHubContentType() {
            return hubContentType;
        }

        public final void setHubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
        }

        @Override
        public final Builder hubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
            return this;
        }

        @Override
        public final Builder hubContentType(HubContentType hubContentType) {
            this.hubContentType(hubContentType == null ? null : hubContentType.toString());
            return this;
        }

        public final String getMinVersion() {
            return minVersion;
        }

        public final void setMinVersion(String minVersion) {
            this.minVersion = minVersion;
        }

        @Override
        public final Builder minVersion(String minVersion) {
            this.minVersion = minVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHubContentReferenceRequest build() {
            return new UpdateHubContentReferenceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
