/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateHubContentRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateHubContentRequest.Builder, UpdateHubContentRequest> {
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubName").getter(getter(UpdateHubContentRequest::hubName)).setter(setter(Builder::hubName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()).build();

    private static final SdkField<String> HUB_CONTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentName").getter(getter(UpdateHubContentRequest::hubContentName))
            .setter(setter(Builder::hubContentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentName").build()).build();

    private static final SdkField<String> HUB_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentType").getter(getter(UpdateHubContentRequest::hubContentTypeAsString))
            .setter(setter(Builder::hubContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentType").build()).build();

    private static final SdkField<String> HUB_CONTENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentVersion").getter(getter(UpdateHubContentRequest::hubContentVersion))
            .setter(setter(Builder::hubContentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentVersion").build()).build();

    private static final SdkField<String> HUB_CONTENT_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentDisplayName").getter(getter(UpdateHubContentRequest::hubContentDisplayName))
            .setter(setter(Builder::hubContentDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDisplayName").build())
            .build();

    private static final SdkField<String> HUB_CONTENT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentDescription").getter(getter(UpdateHubContentRequest::hubContentDescription))
            .setter(setter(Builder::hubContentDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDescription").build())
            .build();

    private static final SdkField<String> HUB_CONTENT_MARKDOWN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentMarkdown").getter(getter(UpdateHubContentRequest::hubContentMarkdown))
            .setter(setter(Builder::hubContentMarkdown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentMarkdown").build())
            .build();

    private static final SdkField<List<String>> HUB_CONTENT_SEARCH_KEYWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HubContentSearchKeywords")
            .getter(getter(UpdateHubContentRequest::hubContentSearchKeywords))
            .setter(setter(Builder::hubContentSearchKeywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentSearchKeywords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUPPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupportStatus").getter(getter(UpdateHubContentRequest::supportStatusAsString))
            .setter(setter(Builder::supportStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_NAME_FIELD,
            HUB_CONTENT_NAME_FIELD, HUB_CONTENT_TYPE_FIELD, HUB_CONTENT_VERSION_FIELD, HUB_CONTENT_DISPLAY_NAME_FIELD,
            HUB_CONTENT_DESCRIPTION_FIELD, HUB_CONTENT_MARKDOWN_FIELD, HUB_CONTENT_SEARCH_KEYWORDS_FIELD, SUPPORT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hubName;

    private final String hubContentName;

    private final String hubContentType;

    private final String hubContentVersion;

    private final String hubContentDisplayName;

    private final String hubContentDescription;

    private final String hubContentMarkdown;

    private final List<String> hubContentSearchKeywords;

    private final String supportStatus;

    private UpdateHubContentRequest(BuilderImpl builder) {
        super(builder);
        this.hubName = builder.hubName;
        this.hubContentName = builder.hubContentName;
        this.hubContentType = builder.hubContentType;
        this.hubContentVersion = builder.hubContentVersion;
        this.hubContentDisplayName = builder.hubContentDisplayName;
        this.hubContentDescription = builder.hubContentDescription;
        this.hubContentMarkdown = builder.hubContentMarkdown;
        this.hubContentSearchKeywords = builder.hubContentSearchKeywords;
        this.supportStatus = builder.supportStatus;
    }

    /**
     * <p>
     * The name of the SageMaker hub that contains the hub content you want to update. You can optionally use the hub
     * ARN instead.
     * </p>
     * 
     * @return The name of the SageMaker hub that contains the hub content you want to update. You can optionally use
     *         the hub ARN instead.
     */
    public final String hubName() {
        return hubName;
    }

    /**
     * <p>
     * The name of the hub content resource that you want to update.
     * </p>
     * 
     * @return The name of the hub content resource that you want to update.
     */
    public final String hubContentName() {
        return hubContentName;
    }

    /**
     * <p>
     * The content type of the resource that you want to update. Only specify a <code>Model</code> or
     * <code>Notebook</code> resource for this API. To update a <code>ModelReference</code>, use the
     * <code>UpdateHubContentReference</code> API instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubContentType}
     * will return {@link HubContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubContentTypeAsString}.
     * </p>
     * 
     * @return The content type of the resource that you want to update. Only specify a <code>Model</code> or
     *         <code>Notebook</code> resource for this API. To update a <code>ModelReference</code>, use the
     *         <code>UpdateHubContentReference</code> API instead.
     * @see HubContentType
     */
    public final HubContentType hubContentType() {
        return HubContentType.fromValue(hubContentType);
    }

    /**
     * <p>
     * The content type of the resource that you want to update. Only specify a <code>Model</code> or
     * <code>Notebook</code> resource for this API. To update a <code>ModelReference</code>, use the
     * <code>UpdateHubContentReference</code> API instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubContentType}
     * will return {@link HubContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubContentTypeAsString}.
     * </p>
     * 
     * @return The content type of the resource that you want to update. Only specify a <code>Model</code> or
     *         <code>Notebook</code> resource for this API. To update a <code>ModelReference</code>, use the
     *         <code>UpdateHubContentReference</code> API instead.
     * @see HubContentType
     */
    public final String hubContentTypeAsString() {
        return hubContentType;
    }

    /**
     * <p>
     * The hub content version that you want to update. For example, if you have two versions of a resource in your hub,
     * you can update the second version.
     * </p>
     * 
     * @return The hub content version that you want to update. For example, if you have two versions of a resource in
     *         your hub, you can update the second version.
     */
    public final String hubContentVersion() {
        return hubContentVersion;
    }

    /**
     * <p>
     * The display name of the hub content.
     * </p>
     * 
     * @return The display name of the hub content.
     */
    public final String hubContentDisplayName() {
        return hubContentDisplayName;
    }

    /**
     * <p>
     * The description of the hub content.
     * </p>
     * 
     * @return The description of the hub content.
     */
    public final String hubContentDescription() {
        return hubContentDescription;
    }

    /**
     * <p>
     * A string that provides a description of the hub content. This string can include links, tables, and standard
     * markdown formatting.
     * </p>
     * 
     * @return A string that provides a description of the hub content. This string can include links, tables, and
     *         standard markdown formatting.
     */
    public final String hubContentMarkdown() {
        return hubContentMarkdown;
    }

    /**
     * For responses, this returns true if the service returned a value for the HubContentSearchKeywords property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasHubContentSearchKeywords() {
        return hubContentSearchKeywords != null && !(hubContentSearchKeywords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The searchable keywords of the hub content.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHubContentSearchKeywords} method.
     * </p>
     * 
     * @return The searchable keywords of the hub content.
     */
    public final List<String> hubContentSearchKeywords() {
        return hubContentSearchKeywords;
    }

    /**
     * <p>
     * Indicates the current status of the hub content resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #supportStatus}
     * will return {@link HubContentSupportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #supportStatusAsString}.
     * </p>
     * 
     * @return Indicates the current status of the hub content resource.
     * @see HubContentSupportStatus
     */
    public final HubContentSupportStatus supportStatus() {
        return HubContentSupportStatus.fromValue(supportStatus);
    }

    /**
     * <p>
     * Indicates the current status of the hub content resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #supportStatus}
     * will return {@link HubContentSupportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #supportStatusAsString}.
     * </p>
     * 
     * @return Indicates the current status of the hub content resource.
     * @see HubContentSupportStatus
     */
    public final String supportStatusAsString() {
        return supportStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hubName());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentName());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentMarkdown());
        hashCode = 31 * hashCode + Objects.hashCode(hasHubContentSearchKeywords() ? hubContentSearchKeywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(supportStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHubContentRequest)) {
            return false;
        }
        UpdateHubContentRequest other = (UpdateHubContentRequest) obj;
        return Objects.equals(hubName(), other.hubName()) && Objects.equals(hubContentName(), other.hubContentName())
                && Objects.equals(hubContentTypeAsString(), other.hubContentTypeAsString())
                && Objects.equals(hubContentVersion(), other.hubContentVersion())
                && Objects.equals(hubContentDisplayName(), other.hubContentDisplayName())
                && Objects.equals(hubContentDescription(), other.hubContentDescription())
                && Objects.equals(hubContentMarkdown(), other.hubContentMarkdown())
                && hasHubContentSearchKeywords() == other.hasHubContentSearchKeywords()
                && Objects.equals(hubContentSearchKeywords(), other.hubContentSearchKeywords())
                && Objects.equals(supportStatusAsString(), other.supportStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateHubContentRequest").add("HubName", hubName()).add("HubContentName", hubContentName())
                .add("HubContentType", hubContentTypeAsString()).add("HubContentVersion", hubContentVersion())
                .add("HubContentDisplayName", hubContentDisplayName()).add("HubContentDescription", hubContentDescription())
                .add("HubContentMarkdown", hubContentMarkdown())
                .add("HubContentSearchKeywords", hasHubContentSearchKeywords() ? hubContentSearchKeywords() : null)
                .add("SupportStatus", supportStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubName":
            return Optional.ofNullable(clazz.cast(hubName()));
        case "HubContentName":
            return Optional.ofNullable(clazz.cast(hubContentName()));
        case "HubContentType":
            return Optional.ofNullable(clazz.cast(hubContentTypeAsString()));
        case "HubContentVersion":
            return Optional.ofNullable(clazz.cast(hubContentVersion()));
        case "HubContentDisplayName":
            return Optional.ofNullable(clazz.cast(hubContentDisplayName()));
        case "HubContentDescription":
            return Optional.ofNullable(clazz.cast(hubContentDescription()));
        case "HubContentMarkdown":
            return Optional.ofNullable(clazz.cast(hubContentMarkdown()));
        case "HubContentSearchKeywords":
            return Optional.ofNullable(clazz.cast(hubContentSearchKeywords()));
        case "SupportStatus":
            return Optional.ofNullable(clazz.cast(supportStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HubName", HUB_NAME_FIELD);
        map.put("HubContentName", HUB_CONTENT_NAME_FIELD);
        map.put("HubContentType", HUB_CONTENT_TYPE_FIELD);
        map.put("HubContentVersion", HUB_CONTENT_VERSION_FIELD);
        map.put("HubContentDisplayName", HUB_CONTENT_DISPLAY_NAME_FIELD);
        map.put("HubContentDescription", HUB_CONTENT_DESCRIPTION_FIELD);
        map.put("HubContentMarkdown", HUB_CONTENT_MARKDOWN_FIELD);
        map.put("HubContentSearchKeywords", HUB_CONTENT_SEARCH_KEYWORDS_FIELD);
        map.put("SupportStatus", SUPPORT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateHubContentRequest, T> g) {
        return obj -> g.apply((UpdateHubContentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateHubContentRequest> {
        /**
         * <p>
         * The name of the SageMaker hub that contains the hub content you want to update. You can optionally use the
         * hub ARN instead.
         * </p>
         * 
         * @param hubName
         *        The name of the SageMaker hub that contains the hub content you want to update. You can optionally use
         *        the hub ARN instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubName(String hubName);

        /**
         * <p>
         * The name of the hub content resource that you want to update.
         * </p>
         * 
         * @param hubContentName
         *        The name of the hub content resource that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentName(String hubContentName);

        /**
         * <p>
         * The content type of the resource that you want to update. Only specify a <code>Model</code> or
         * <code>Notebook</code> resource for this API. To update a <code>ModelReference</code>, use the
         * <code>UpdateHubContentReference</code> API instead.
         * </p>
         * 
         * @param hubContentType
         *        The content type of the resource that you want to update. Only specify a <code>Model</code> or
         *        <code>Notebook</code> resource for this API. To update a <code>ModelReference</code>, use the
         *        <code>UpdateHubContentReference</code> API instead.
         * @see HubContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentType
         */
        Builder hubContentType(String hubContentType);

        /**
         * <p>
         * The content type of the resource that you want to update. Only specify a <code>Model</code> or
         * <code>Notebook</code> resource for this API. To update a <code>ModelReference</code>, use the
         * <code>UpdateHubContentReference</code> API instead.
         * </p>
         * 
         * @param hubContentType
         *        The content type of the resource that you want to update. Only specify a <code>Model</code> or
         *        <code>Notebook</code> resource for this API. To update a <code>ModelReference</code>, use the
         *        <code>UpdateHubContentReference</code> API instead.
         * @see HubContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentType
         */
        Builder hubContentType(HubContentType hubContentType);

        /**
         * <p>
         * The hub content version that you want to update. For example, if you have two versions of a resource in your
         * hub, you can update the second version.
         * </p>
         * 
         * @param hubContentVersion
         *        The hub content version that you want to update. For example, if you have two versions of a resource
         *        in your hub, you can update the second version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentVersion(String hubContentVersion);

        /**
         * <p>
         * The display name of the hub content.
         * </p>
         * 
         * @param hubContentDisplayName
         *        The display name of the hub content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentDisplayName(String hubContentDisplayName);

        /**
         * <p>
         * The description of the hub content.
         * </p>
         * 
         * @param hubContentDescription
         *        The description of the hub content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentDescription(String hubContentDescription);

        /**
         * <p>
         * A string that provides a description of the hub content. This string can include links, tables, and standard
         * markdown formatting.
         * </p>
         * 
         * @param hubContentMarkdown
         *        A string that provides a description of the hub content. This string can include links, tables, and
         *        standard markdown formatting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentMarkdown(String hubContentMarkdown);

        /**
         * <p>
         * The searchable keywords of the hub content.
         * </p>
         * 
         * @param hubContentSearchKeywords
         *        The searchable keywords of the hub content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentSearchKeywords(Collection<String> hubContentSearchKeywords);

        /**
         * <p>
         * The searchable keywords of the hub content.
         * </p>
         * 
         * @param hubContentSearchKeywords
         *        The searchable keywords of the hub content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentSearchKeywords(String... hubContentSearchKeywords);

        /**
         * <p>
         * Indicates the current status of the hub content resource.
         * </p>
         * 
         * @param supportStatus
         *        Indicates the current status of the hub content resource.
         * @see HubContentSupportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentSupportStatus
         */
        Builder supportStatus(String supportStatus);

        /**
         * <p>
         * Indicates the current status of the hub content resource.
         * </p>
         * 
         * @param supportStatus
         *        Indicates the current status of the hub content resource.
         * @see HubContentSupportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentSupportStatus
         */
        Builder supportStatus(HubContentSupportStatus supportStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String hubName;

        private String hubContentName;

        private String hubContentType;

        private String hubContentVersion;

        private String hubContentDisplayName;

        private String hubContentDescription;

        private String hubContentMarkdown;

        private List<String> hubContentSearchKeywords = DefaultSdkAutoConstructList.getInstance();

        private String supportStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHubContentRequest model) {
            super(model);
            hubName(model.hubName);
            hubContentName(model.hubContentName);
            hubContentType(model.hubContentType);
            hubContentVersion(model.hubContentVersion);
            hubContentDisplayName(model.hubContentDisplayName);
            hubContentDescription(model.hubContentDescription);
            hubContentMarkdown(model.hubContentMarkdown);
            hubContentSearchKeywords(model.hubContentSearchKeywords);
            supportStatus(model.supportStatus);
        }

        public final String getHubName() {
            return hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubContentName() {
            return hubContentName;
        }

        public final void setHubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
        }

        @Override
        public final Builder hubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
            return this;
        }

        public final String getHubContentType() {
            return hubContentType;
        }

        public final void setHubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
        }

        @Override
        public final Builder hubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
            return this;
        }

        @Override
        public final Builder hubContentType(HubContentType hubContentType) {
            this.hubContentType(hubContentType == null ? null : hubContentType.toString());
            return this;
        }

        public final String getHubContentVersion() {
            return hubContentVersion;
        }

        public final void setHubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
        }

        @Override
        public final Builder hubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
            return this;
        }

        public final String getHubContentDisplayName() {
            return hubContentDisplayName;
        }

        public final void setHubContentDisplayName(String hubContentDisplayName) {
            this.hubContentDisplayName = hubContentDisplayName;
        }

        @Override
        public final Builder hubContentDisplayName(String hubContentDisplayName) {
            this.hubContentDisplayName = hubContentDisplayName;
            return this;
        }

        public final String getHubContentDescription() {
            return hubContentDescription;
        }

        public final void setHubContentDescription(String hubContentDescription) {
            this.hubContentDescription = hubContentDescription;
        }

        @Override
        public final Builder hubContentDescription(String hubContentDescription) {
            this.hubContentDescription = hubContentDescription;
            return this;
        }

        public final String getHubContentMarkdown() {
            return hubContentMarkdown;
        }

        public final void setHubContentMarkdown(String hubContentMarkdown) {
            this.hubContentMarkdown = hubContentMarkdown;
        }

        @Override
        public final Builder hubContentMarkdown(String hubContentMarkdown) {
            this.hubContentMarkdown = hubContentMarkdown;
            return this;
        }

        public final Collection<String> getHubContentSearchKeywords() {
            if (hubContentSearchKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return hubContentSearchKeywords;
        }

        public final void setHubContentSearchKeywords(Collection<String> hubContentSearchKeywords) {
            this.hubContentSearchKeywords = HubContentSearchKeywordListCopier.copy(hubContentSearchKeywords);
        }

        @Override
        public final Builder hubContentSearchKeywords(Collection<String> hubContentSearchKeywords) {
            this.hubContentSearchKeywords = HubContentSearchKeywordListCopier.copy(hubContentSearchKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubContentSearchKeywords(String... hubContentSearchKeywords) {
            hubContentSearchKeywords(Arrays.asList(hubContentSearchKeywords));
            return this;
        }

        public final String getSupportStatus() {
            return supportStatus;
        }

        public final void setSupportStatus(String supportStatus) {
            this.supportStatus = supportStatus;
        }

        @Override
        public final Builder supportStatus(String supportStatus) {
            this.supportStatus = supportStatus;
            return this;
        }

        @Override
        public final Builder supportStatus(HubContentSupportStatus supportStatus) {
            this.supportStatus(supportStatus == null ? null : supportStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHubContentRequest build() {
            return new UpdateHubContentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
