/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInferenceComponentRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateInferenceComponentRequest.Builder, UpdateInferenceComponentRequest> {
    private static final SdkField<String> INFERENCE_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceComponentName").getter(getter(UpdateInferenceComponentRequest::inferenceComponentName))
            .setter(setter(Builder::inferenceComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentName").build())
            .build();

    private static final SdkField<InferenceComponentSpecification> SPECIFICATION_FIELD = SdkField
            .<InferenceComponentSpecification> builder(MarshallingType.SDK_POJO).memberName("Specification")
            .getter(getter(UpdateInferenceComponentRequest::specification)).setter(setter(Builder::specification))
            .constructor(InferenceComponentSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Specification").build()).build();

    private static final SdkField<InferenceComponentRuntimeConfig> RUNTIME_CONFIG_FIELD = SdkField
            .<InferenceComponentRuntimeConfig> builder(MarshallingType.SDK_POJO).memberName("RuntimeConfig")
            .getter(getter(UpdateInferenceComponentRequest::runtimeConfig)).setter(setter(Builder::runtimeConfig))
            .constructor(InferenceComponentRuntimeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeConfig").build()).build();

    private static final SdkField<InferenceComponentDeploymentConfig> DEPLOYMENT_CONFIG_FIELD = SdkField
            .<InferenceComponentDeploymentConfig> builder(MarshallingType.SDK_POJO).memberName("DeploymentConfig")
            .getter(getter(UpdateInferenceComponentRequest::deploymentConfig)).setter(setter(Builder::deploymentConfig))
            .constructor(InferenceComponentDeploymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INFERENCE_COMPONENT_NAME_FIELD, SPECIFICATION_FIELD, RUNTIME_CONFIG_FIELD, DEPLOYMENT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String inferenceComponentName;

    private final InferenceComponentSpecification specification;

    private final InferenceComponentRuntimeConfig runtimeConfig;

    private final InferenceComponentDeploymentConfig deploymentConfig;

    private UpdateInferenceComponentRequest(BuilderImpl builder) {
        super(builder);
        this.inferenceComponentName = builder.inferenceComponentName;
        this.specification = builder.specification;
        this.runtimeConfig = builder.runtimeConfig;
        this.deploymentConfig = builder.deploymentConfig;
    }

    /**
     * <p>
     * The name of the inference component.
     * </p>
     * 
     * @return The name of the inference component.
     */
    public final String inferenceComponentName() {
        return inferenceComponentName;
    }

    /**
     * <p>
     * Details about the resources to deploy with this inference component, including the model, container, and compute
     * resources.
     * </p>
     * 
     * @return Details about the resources to deploy with this inference component, including the model, container, and
     *         compute resources.
     */
    public final InferenceComponentSpecification specification() {
        return specification;
    }

    /**
     * <p>
     * Runtime settings for a model that is deployed with an inference component.
     * </p>
     * 
     * @return Runtime settings for a model that is deployed with an inference component.
     */
    public final InferenceComponentRuntimeConfig runtimeConfig() {
        return runtimeConfig;
    }

    /**
     * <p>
     * The deployment configuration for the inference component. The configuration contains the desired deployment
     * strategy and rollback settings.
     * </p>
     * 
     * @return The deployment configuration for the inference component. The configuration contains the desired
     *         deployment strategy and rollback settings.
     */
    public final InferenceComponentDeploymentConfig deploymentConfig() {
        return deploymentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inferenceComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(specification());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInferenceComponentRequest)) {
            return false;
        }
        UpdateInferenceComponentRequest other = (UpdateInferenceComponentRequest) obj;
        return Objects.equals(inferenceComponentName(), other.inferenceComponentName())
                && Objects.equals(specification(), other.specification())
                && Objects.equals(runtimeConfig(), other.runtimeConfig())
                && Objects.equals(deploymentConfig(), other.deploymentConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInferenceComponentRequest").add("InferenceComponentName", inferenceComponentName())
                .add("Specification", specification()).add("RuntimeConfig", runtimeConfig())
                .add("DeploymentConfig", deploymentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InferenceComponentName":
            return Optional.ofNullable(clazz.cast(inferenceComponentName()));
        case "Specification":
            return Optional.ofNullable(clazz.cast(specification()));
        case "RuntimeConfig":
            return Optional.ofNullable(clazz.cast(runtimeConfig()));
        case "DeploymentConfig":
            return Optional.ofNullable(clazz.cast(deploymentConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InferenceComponentName", INFERENCE_COMPONENT_NAME_FIELD);
        map.put("Specification", SPECIFICATION_FIELD);
        map.put("RuntimeConfig", RUNTIME_CONFIG_FIELD);
        map.put("DeploymentConfig", DEPLOYMENT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateInferenceComponentRequest, T> g) {
        return obj -> g.apply((UpdateInferenceComponentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateInferenceComponentRequest> {
        /**
         * <p>
         * The name of the inference component.
         * </p>
         * 
         * @param inferenceComponentName
         *        The name of the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceComponentName(String inferenceComponentName);

        /**
         * <p>
         * Details about the resources to deploy with this inference component, including the model, container, and
         * compute resources.
         * </p>
         * 
         * @param specification
         *        Details about the resources to deploy with this inference component, including the model, container,
         *        and compute resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specification(InferenceComponentSpecification specification);

        /**
         * <p>
         * Details about the resources to deploy with this inference component, including the model, container, and
         * compute resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceComponentSpecification.Builder}
         * avoiding the need to create one manually via {@link InferenceComponentSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #specification(InferenceComponentSpecification)}.
         * 
         * @param specification
         *        a consumer that will call methods on {@link InferenceComponentSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #specification(InferenceComponentSpecification)
         */
        default Builder specification(Consumer<InferenceComponentSpecification.Builder> specification) {
            return specification(InferenceComponentSpecification.builder().applyMutation(specification).build());
        }

        /**
         * <p>
         * Runtime settings for a model that is deployed with an inference component.
         * </p>
         * 
         * @param runtimeConfig
         *        Runtime settings for a model that is deployed with an inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeConfig(InferenceComponentRuntimeConfig runtimeConfig);

        /**
         * <p>
         * Runtime settings for a model that is deployed with an inference component.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceComponentRuntimeConfig.Builder}
         * avoiding the need to create one manually via {@link InferenceComponentRuntimeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentRuntimeConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #runtimeConfig(InferenceComponentRuntimeConfig)}.
         * 
         * @param runtimeConfig
         *        a consumer that will call methods on {@link InferenceComponentRuntimeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimeConfig(InferenceComponentRuntimeConfig)
         */
        default Builder runtimeConfig(Consumer<InferenceComponentRuntimeConfig.Builder> runtimeConfig) {
            return runtimeConfig(InferenceComponentRuntimeConfig.builder().applyMutation(runtimeConfig).build());
        }

        /**
         * <p>
         * The deployment configuration for the inference component. The configuration contains the desired deployment
         * strategy and rollback settings.
         * </p>
         * 
         * @param deploymentConfig
         *        The deployment configuration for the inference component. The configuration contains the desired
         *        deployment strategy and rollback settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfig(InferenceComponentDeploymentConfig deploymentConfig);

        /**
         * <p>
         * The deployment configuration for the inference component. The configuration contains the desired deployment
         * strategy and rollback settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InferenceComponentDeploymentConfig.Builder} avoiding the need to create one manually via
         * {@link InferenceComponentDeploymentConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentDeploymentConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #deploymentConfig(InferenceComponentDeploymentConfig)}.
         * 
         * @param deploymentConfig
         *        a consumer that will call methods on {@link InferenceComponentDeploymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfig(InferenceComponentDeploymentConfig)
         */
        default Builder deploymentConfig(Consumer<InferenceComponentDeploymentConfig.Builder> deploymentConfig) {
            return deploymentConfig(InferenceComponentDeploymentConfig.builder().applyMutation(deploymentConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String inferenceComponentName;

        private InferenceComponentSpecification specification;

        private InferenceComponentRuntimeConfig runtimeConfig;

        private InferenceComponentDeploymentConfig deploymentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInferenceComponentRequest model) {
            super(model);
            inferenceComponentName(model.inferenceComponentName);
            specification(model.specification);
            runtimeConfig(model.runtimeConfig);
            deploymentConfig(model.deploymentConfig);
        }

        public final String getInferenceComponentName() {
            return inferenceComponentName;
        }

        public final void setInferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
        }

        @Override
        public final Builder inferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
            return this;
        }

        public final InferenceComponentSpecification.Builder getSpecification() {
            return specification != null ? specification.toBuilder() : null;
        }

        public final void setSpecification(InferenceComponentSpecification.BuilderImpl specification) {
            this.specification = specification != null ? specification.build() : null;
        }

        @Override
        public final Builder specification(InferenceComponentSpecification specification) {
            this.specification = specification;
            return this;
        }

        public final InferenceComponentRuntimeConfig.Builder getRuntimeConfig() {
            return runtimeConfig != null ? runtimeConfig.toBuilder() : null;
        }

        public final void setRuntimeConfig(InferenceComponentRuntimeConfig.BuilderImpl runtimeConfig) {
            this.runtimeConfig = runtimeConfig != null ? runtimeConfig.build() : null;
        }

        @Override
        public final Builder runtimeConfig(InferenceComponentRuntimeConfig runtimeConfig) {
            this.runtimeConfig = runtimeConfig;
            return this;
        }

        public final InferenceComponentDeploymentConfig.Builder getDeploymentConfig() {
            return deploymentConfig != null ? deploymentConfig.toBuilder() : null;
        }

        public final void setDeploymentConfig(InferenceComponentDeploymentConfig.BuilderImpl deploymentConfig) {
            this.deploymentConfig = deploymentConfig != null ? deploymentConfig.build() : null;
        }

        @Override
        public final Builder deploymentConfig(InferenceComponentDeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInferenceComponentRequest build() {
            return new UpdateInferenceComponentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
