/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMlflowTrackingServerRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateMlflowTrackingServerRequest.Builder, UpdateMlflowTrackingServerRequest> {
    private static final SdkField<String> TRACKING_SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackingServerName").getter(getter(UpdateMlflowTrackingServerRequest::trackingServerName))
            .setter(setter(Builder::trackingServerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerName").build())
            .build();

    private static final SdkField<String> ARTIFACT_STORE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactStoreUri").getter(getter(UpdateMlflowTrackingServerRequest::artifactStoreUri))
            .setter(setter(Builder::artifactStoreUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactStoreUri").build()).build();

    private static final SdkField<String> TRACKING_SERVER_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackingServerSize").getter(getter(UpdateMlflowTrackingServerRequest::trackingServerSizeAsString))
            .setter(setter(Builder::trackingServerSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerSize").build())
            .build();

    private static final SdkField<Boolean> AUTOMATIC_MODEL_REGISTRATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutomaticModelRegistration")
            .getter(getter(UpdateMlflowTrackingServerRequest::automaticModelRegistration))
            .setter(setter(Builder::automaticModelRegistration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticModelRegistration").build())
            .build();

    private static final SdkField<String> WEEKLY_MAINTENANCE_WINDOW_START_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WeeklyMaintenanceWindowStart")
            .getter(getter(UpdateMlflowTrackingServerRequest::weeklyMaintenanceWindowStart))
            .setter(setter(Builder::weeklyMaintenanceWindowStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceWindowStart")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_SERVER_NAME_FIELD,
            ARTIFACT_STORE_URI_FIELD, TRACKING_SERVER_SIZE_FIELD, AUTOMATIC_MODEL_REGISTRATION_FIELD,
            WEEKLY_MAINTENANCE_WINDOW_START_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trackingServerName;

    private final String artifactStoreUri;

    private final String trackingServerSize;

    private final Boolean automaticModelRegistration;

    private final String weeklyMaintenanceWindowStart;

    private UpdateMlflowTrackingServerRequest(BuilderImpl builder) {
        super(builder);
        this.trackingServerName = builder.trackingServerName;
        this.artifactStoreUri = builder.artifactStoreUri;
        this.trackingServerSize = builder.trackingServerSize;
        this.automaticModelRegistration = builder.automaticModelRegistration;
        this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
    }

    /**
     * <p>
     * The name of the MLflow Tracking Server to update.
     * </p>
     * 
     * @return The name of the MLflow Tracking Server to update.
     */
    public final String trackingServerName() {
        return trackingServerName;
    }

    /**
     * <p>
     * The new S3 URI for the general purpose bucket to use as the artifact store for the MLflow Tracking Server.
     * </p>
     * 
     * @return The new S3 URI for the general purpose bucket to use as the artifact store for the MLflow Tracking
     *         Server.
     */
    public final String artifactStoreUri() {
        return artifactStoreUri;
    }

    /**
     * <p>
     * The new size for the MLflow Tracking Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trackingServerSize} will return {@link TrackingServerSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #trackingServerSizeAsString}.
     * </p>
     * 
     * @return The new size for the MLflow Tracking Server.
     * @see TrackingServerSize
     */
    public final TrackingServerSize trackingServerSize() {
        return TrackingServerSize.fromValue(trackingServerSize);
    }

    /**
     * <p>
     * The new size for the MLflow Tracking Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trackingServerSize} will return {@link TrackingServerSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #trackingServerSizeAsString}.
     * </p>
     * 
     * @return The new size for the MLflow Tracking Server.
     * @see TrackingServerSize
     */
    public final String trackingServerSizeAsString() {
        return trackingServerSize;
    }

    /**
     * <p>
     * Whether to enable or disable automatic registration of new MLflow models to the SageMaker Model Registry. To
     * enable automatic model registration, set this value to <code>True</code>. To disable automatic model
     * registration, set this value to <code>False</code>. If not specified, <code>AutomaticModelRegistration</code>
     * defaults to <code>False</code>
     * </p>
     * 
     * @return Whether to enable or disable automatic registration of new MLflow models to the SageMaker Model Registry.
     *         To enable automatic model registration, set this value to <code>True</code>. To disable automatic model
     *         registration, set this value to <code>False</code>. If not specified,
     *         <code>AutomaticModelRegistration</code> defaults to <code>False</code>
     */
    public final Boolean automaticModelRegistration() {
        return automaticModelRegistration;
    }

    /**
     * <p>
     * The new weekly maintenance window start day and time to update. The maintenance window day and time should be in
     * Coordinated Universal Time (UTC) 24-hour standard time. For example: TUE:03:30.
     * </p>
     * 
     * @return The new weekly maintenance window start day and time to update. The maintenance window day and time
     *         should be in Coordinated Universal Time (UTC) 24-hour standard time. For example: TUE:03:30.
     */
    public final String weeklyMaintenanceWindowStart() {
        return weeklyMaintenanceWindowStart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trackingServerName());
        hashCode = 31 * hashCode + Objects.hashCode(artifactStoreUri());
        hashCode = 31 * hashCode + Objects.hashCode(trackingServerSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(automaticModelRegistration());
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceWindowStart());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMlflowTrackingServerRequest)) {
            return false;
        }
        UpdateMlflowTrackingServerRequest other = (UpdateMlflowTrackingServerRequest) obj;
        return Objects.equals(trackingServerName(), other.trackingServerName())
                && Objects.equals(artifactStoreUri(), other.artifactStoreUri())
                && Objects.equals(trackingServerSizeAsString(), other.trackingServerSizeAsString())
                && Objects.equals(automaticModelRegistration(), other.automaticModelRegistration())
                && Objects.equals(weeklyMaintenanceWindowStart(), other.weeklyMaintenanceWindowStart());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMlflowTrackingServerRequest").add("TrackingServerName", trackingServerName())
                .add("ArtifactStoreUri", artifactStoreUri()).add("TrackingServerSize", trackingServerSizeAsString())
                .add("AutomaticModelRegistration", automaticModelRegistration())
                .add("WeeklyMaintenanceWindowStart", weeklyMaintenanceWindowStart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrackingServerName":
            return Optional.ofNullable(clazz.cast(trackingServerName()));
        case "ArtifactStoreUri":
            return Optional.ofNullable(clazz.cast(artifactStoreUri()));
        case "TrackingServerSize":
            return Optional.ofNullable(clazz.cast(trackingServerSizeAsString()));
        case "AutomaticModelRegistration":
            return Optional.ofNullable(clazz.cast(automaticModelRegistration()));
        case "WeeklyMaintenanceWindowStart":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceWindowStart()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrackingServerName", TRACKING_SERVER_NAME_FIELD);
        map.put("ArtifactStoreUri", ARTIFACT_STORE_URI_FIELD);
        map.put("TrackingServerSize", TRACKING_SERVER_SIZE_FIELD);
        map.put("AutomaticModelRegistration", AUTOMATIC_MODEL_REGISTRATION_FIELD);
        map.put("WeeklyMaintenanceWindowStart", WEEKLY_MAINTENANCE_WINDOW_START_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMlflowTrackingServerRequest, T> g) {
        return obj -> g.apply((UpdateMlflowTrackingServerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMlflowTrackingServerRequest> {
        /**
         * <p>
         * The name of the MLflow Tracking Server to update.
         * </p>
         * 
         * @param trackingServerName
         *        The name of the MLflow Tracking Server to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingServerName(String trackingServerName);

        /**
         * <p>
         * The new S3 URI for the general purpose bucket to use as the artifact store for the MLflow Tracking Server.
         * </p>
         * 
         * @param artifactStoreUri
         *        The new S3 URI for the general purpose bucket to use as the artifact store for the MLflow Tracking
         *        Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactStoreUri(String artifactStoreUri);

        /**
         * <p>
         * The new size for the MLflow Tracking Server.
         * </p>
         * 
         * @param trackingServerSize
         *        The new size for the MLflow Tracking Server.
         * @see TrackingServerSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrackingServerSize
         */
        Builder trackingServerSize(String trackingServerSize);

        /**
         * <p>
         * The new size for the MLflow Tracking Server.
         * </p>
         * 
         * @param trackingServerSize
         *        The new size for the MLflow Tracking Server.
         * @see TrackingServerSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrackingServerSize
         */
        Builder trackingServerSize(TrackingServerSize trackingServerSize);

        /**
         * <p>
         * Whether to enable or disable automatic registration of new MLflow models to the SageMaker Model Registry. To
         * enable automatic model registration, set this value to <code>True</code>. To disable automatic model
         * registration, set this value to <code>False</code>. If not specified, <code>AutomaticModelRegistration</code>
         * defaults to <code>False</code>
         * </p>
         * 
         * @param automaticModelRegistration
         *        Whether to enable or disable automatic registration of new MLflow models to the SageMaker Model
         *        Registry. To enable automatic model registration, set this value to <code>True</code>. To disable
         *        automatic model registration, set this value to <code>False</code>. If not specified,
         *        <code>AutomaticModelRegistration</code> defaults to <code>False</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticModelRegistration(Boolean automaticModelRegistration);

        /**
         * <p>
         * The new weekly maintenance window start day and time to update. The maintenance window day and time should be
         * in Coordinated Universal Time (UTC) 24-hour standard time. For example: TUE:03:30.
         * </p>
         * 
         * @param weeklyMaintenanceWindowStart
         *        The new weekly maintenance window start day and time to update. The maintenance window day and time
         *        should be in Coordinated Universal Time (UTC) 24-hour standard time. For example: TUE:03:30.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String trackingServerName;

        private String artifactStoreUri;

        private String trackingServerSize;

        private Boolean automaticModelRegistration;

        private String weeklyMaintenanceWindowStart;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMlflowTrackingServerRequest model) {
            super(model);
            trackingServerName(model.trackingServerName);
            artifactStoreUri(model.artifactStoreUri);
            trackingServerSize(model.trackingServerSize);
            automaticModelRegistration(model.automaticModelRegistration);
            weeklyMaintenanceWindowStart(model.weeklyMaintenanceWindowStart);
        }

        public final String getTrackingServerName() {
            return trackingServerName;
        }

        public final void setTrackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
        }

        @Override
        public final Builder trackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
            return this;
        }

        public final String getArtifactStoreUri() {
            return artifactStoreUri;
        }

        public final void setArtifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
        }

        @Override
        public final Builder artifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
            return this;
        }

        public final String getTrackingServerSize() {
            return trackingServerSize;
        }

        public final void setTrackingServerSize(String trackingServerSize) {
            this.trackingServerSize = trackingServerSize;
        }

        @Override
        public final Builder trackingServerSize(String trackingServerSize) {
            this.trackingServerSize = trackingServerSize;
            return this;
        }

        @Override
        public final Builder trackingServerSize(TrackingServerSize trackingServerSize) {
            this.trackingServerSize(trackingServerSize == null ? null : trackingServerSize.toString());
            return this;
        }

        public final Boolean getAutomaticModelRegistration() {
            return automaticModelRegistration;
        }

        public final void setAutomaticModelRegistration(Boolean automaticModelRegistration) {
            this.automaticModelRegistration = automaticModelRegistration;
        }

        @Override
        public final Builder automaticModelRegistration(Boolean automaticModelRegistration) {
            this.automaticModelRegistration = automaticModelRegistration;
            return this;
        }

        public final String getWeeklyMaintenanceWindowStart() {
            return weeklyMaintenanceWindowStart;
        }

        public final void setWeeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
        }

        @Override
        public final Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMlflowTrackingServerRequest build() {
            return new UpdateMlflowTrackingServerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
