/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePipelineExecutionRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdatePipelineExecutionRequest.Builder, UpdatePipelineExecutionRequest> {
    private static final SdkField<String> PIPELINE_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineExecutionArn").getter(getter(UpdatePipelineExecutionRequest::pipelineExecutionArn))
            .setter(setter(Builder::pipelineExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionArn").build())
            .build();

    private static final SdkField<String> PIPELINE_EXECUTION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PipelineExecutionDescription")
            .getter(getter(UpdatePipelineExecutionRequest::pipelineExecutionDescription))
            .setter(setter(Builder::pipelineExecutionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionDescription")
                    .build()).build();

    private static final SdkField<String> PIPELINE_EXECUTION_DISPLAY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PipelineExecutionDisplayName")
            .getter(getter(UpdatePipelineExecutionRequest::pipelineExecutionDisplayName))
            .setter(setter(Builder::pipelineExecutionDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionDisplayName")
                    .build()).build();

    private static final SdkField<ParallelismConfiguration> PARALLELISM_CONFIGURATION_FIELD = SdkField
            .<ParallelismConfiguration> builder(MarshallingType.SDK_POJO).memberName("ParallelismConfiguration")
            .getter(getter(UpdatePipelineExecutionRequest::parallelismConfiguration))
            .setter(setter(Builder::parallelismConfiguration)).constructor(ParallelismConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_EXECUTION_ARN_FIELD,
            PIPELINE_EXECUTION_DESCRIPTION_FIELD, PIPELINE_EXECUTION_DISPLAY_NAME_FIELD, PARALLELISM_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String pipelineExecutionArn;

    private final String pipelineExecutionDescription;

    private final String pipelineExecutionDisplayName;

    private final ParallelismConfiguration parallelismConfiguration;

    private UpdatePipelineExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineExecutionArn = builder.pipelineExecutionArn;
        this.pipelineExecutionDescription = builder.pipelineExecutionDescription;
        this.pipelineExecutionDisplayName = builder.pipelineExecutionDisplayName;
        this.parallelismConfiguration = builder.parallelismConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline execution.
     */
    public final String pipelineExecutionArn() {
        return pipelineExecutionArn;
    }

    /**
     * <p>
     * The description of the pipeline execution.
     * </p>
     * 
     * @return The description of the pipeline execution.
     */
    public final String pipelineExecutionDescription() {
        return pipelineExecutionDescription;
    }

    /**
     * <p>
     * The display name of the pipeline execution.
     * </p>
     * 
     * @return The display name of the pipeline execution.
     */
    public final String pipelineExecutionDisplayName() {
        return pipelineExecutionDisplayName;
    }

    /**
     * <p>
     * This configuration, if specified, overrides the parallelism configuration of the parent pipeline for this
     * specific run.
     * </p>
     * 
     * @return This configuration, if specified, overrides the parallelism configuration of the parent pipeline for this
     *         specific run.
     */
    public final ParallelismConfiguration parallelismConfiguration() {
        return parallelismConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(parallelismConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipelineExecutionRequest)) {
            return false;
        }
        UpdatePipelineExecutionRequest other = (UpdatePipelineExecutionRequest) obj;
        return Objects.equals(pipelineExecutionArn(), other.pipelineExecutionArn())
                && Objects.equals(pipelineExecutionDescription(), other.pipelineExecutionDescription())
                && Objects.equals(pipelineExecutionDisplayName(), other.pipelineExecutionDisplayName())
                && Objects.equals(parallelismConfiguration(), other.parallelismConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePipelineExecutionRequest").add("PipelineExecutionArn", pipelineExecutionArn())
                .add("PipelineExecutionDescription", pipelineExecutionDescription())
                .add("PipelineExecutionDisplayName", pipelineExecutionDisplayName())
                .add("ParallelismConfiguration", parallelismConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineExecutionArn":
            return Optional.ofNullable(clazz.cast(pipelineExecutionArn()));
        case "PipelineExecutionDescription":
            return Optional.ofNullable(clazz.cast(pipelineExecutionDescription()));
        case "PipelineExecutionDisplayName":
            return Optional.ofNullable(clazz.cast(pipelineExecutionDisplayName()));
        case "ParallelismConfiguration":
            return Optional.ofNullable(clazz.cast(parallelismConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PipelineExecutionArn", PIPELINE_EXECUTION_ARN_FIELD);
        map.put("PipelineExecutionDescription", PIPELINE_EXECUTION_DESCRIPTION_FIELD);
        map.put("PipelineExecutionDisplayName", PIPELINE_EXECUTION_DISPLAY_NAME_FIELD);
        map.put("ParallelismConfiguration", PARALLELISM_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipelineExecutionRequest, T> g) {
        return obj -> g.apply((UpdatePipelineExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePipelineExecutionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline execution.
         * </p>
         * 
         * @param pipelineExecutionArn
         *        The Amazon Resource Name (ARN) of the pipeline execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionArn(String pipelineExecutionArn);

        /**
         * <p>
         * The description of the pipeline execution.
         * </p>
         * 
         * @param pipelineExecutionDescription
         *        The description of the pipeline execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionDescription(String pipelineExecutionDescription);

        /**
         * <p>
         * The display name of the pipeline execution.
         * </p>
         * 
         * @param pipelineExecutionDisplayName
         *        The display name of the pipeline execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionDisplayName(String pipelineExecutionDisplayName);

        /**
         * <p>
         * This configuration, if specified, overrides the parallelism configuration of the parent pipeline for this
         * specific run.
         * </p>
         * 
         * @param parallelismConfiguration
         *        This configuration, if specified, overrides the parallelism configuration of the parent pipeline for
         *        this specific run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelismConfiguration(ParallelismConfiguration parallelismConfiguration);

        /**
         * <p>
         * This configuration, if specified, overrides the parallelism configuration of the parent pipeline for this
         * specific run.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParallelismConfiguration.Builder}
         * avoiding the need to create one manually via {@link ParallelismConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParallelismConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #parallelismConfiguration(ParallelismConfiguration)}.
         * 
         * @param parallelismConfiguration
         *        a consumer that will call methods on {@link ParallelismConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parallelismConfiguration(ParallelismConfiguration)
         */
        default Builder parallelismConfiguration(Consumer<ParallelismConfiguration.Builder> parallelismConfiguration) {
            return parallelismConfiguration(ParallelismConfiguration.builder().applyMutation(parallelismConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String pipelineExecutionArn;

        private String pipelineExecutionDescription;

        private String pipelineExecutionDisplayName;

        private ParallelismConfiguration parallelismConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipelineExecutionRequest model) {
            super(model);
            pipelineExecutionArn(model.pipelineExecutionArn);
            pipelineExecutionDescription(model.pipelineExecutionDescription);
            pipelineExecutionDisplayName(model.pipelineExecutionDisplayName);
            parallelismConfiguration(model.parallelismConfiguration);
        }

        public final String getPipelineExecutionArn() {
            return pipelineExecutionArn;
        }

        public final void setPipelineExecutionArn(String pipelineExecutionArn) {
            this.pipelineExecutionArn = pipelineExecutionArn;
        }

        @Override
        public final Builder pipelineExecutionArn(String pipelineExecutionArn) {
            this.pipelineExecutionArn = pipelineExecutionArn;
            return this;
        }

        public final String getPipelineExecutionDescription() {
            return pipelineExecutionDescription;
        }

        public final void setPipelineExecutionDescription(String pipelineExecutionDescription) {
            this.pipelineExecutionDescription = pipelineExecutionDescription;
        }

        @Override
        public final Builder pipelineExecutionDescription(String pipelineExecutionDescription) {
            this.pipelineExecutionDescription = pipelineExecutionDescription;
            return this;
        }

        public final String getPipelineExecutionDisplayName() {
            return pipelineExecutionDisplayName;
        }

        public final void setPipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
            this.pipelineExecutionDisplayName = pipelineExecutionDisplayName;
        }

        @Override
        public final Builder pipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
            this.pipelineExecutionDisplayName = pipelineExecutionDisplayName;
            return this;
        }

        public final ParallelismConfiguration.Builder getParallelismConfiguration() {
            return parallelismConfiguration != null ? parallelismConfiguration.toBuilder() : null;
        }

        public final void setParallelismConfiguration(ParallelismConfiguration.BuilderImpl parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration != null ? parallelismConfiguration.build() : null;
        }

        @Override
        public final Builder parallelismConfiguration(ParallelismConfiguration parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePipelineExecutionRequest build() {
            return new UpdatePipelineExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
