/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status and billing information about the warm pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WarmPoolStatus implements SdkPojo, Serializable, ToCopyableBuilder<WarmPoolStatus.Builder, WarmPoolStatus> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(WarmPoolStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> RESOURCE_RETAINED_BILLABLE_TIME_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResourceRetainedBillableTimeInSeconds")
            .getter(getter(WarmPoolStatus::resourceRetainedBillableTimeInSeconds))
            .setter(setter(Builder::resourceRetainedBillableTimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ResourceRetainedBillableTimeInSeconds").build()).build();

    private static final SdkField<String> REUSED_BY_JOB_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReusedByJob").getter(getter(WarmPoolStatus::reusedByJob)).setter(setter(Builder::reusedByJob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReusedByJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            RESOURCE_RETAINED_BILLABLE_TIME_IN_SECONDS_FIELD, REUSED_BY_JOB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Integer resourceRetainedBillableTimeInSeconds;

    private final String reusedByJob;

    private WarmPoolStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.resourceRetainedBillableTimeInSeconds = builder.resourceRetainedBillableTimeInSeconds;
        this.reusedByJob = builder.reusedByJob;
    }

    /**
     * <p>
     * The status of the warm pool.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>InUse</code>: The warm pool is in use for the training job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Available</code>: The warm pool is available to reuse for a matching training job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Reused</code>: The warm pool moved to a matching training job for reuse.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Terminated</code>: The warm pool is no longer available. Warm pools are unavailable if they are terminated
     * by a user, terminated for a patch update, or terminated for exceeding the specified
     * <code>KeepAlivePeriodInSeconds</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WarmPoolResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the warm pool.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>InUse</code>: The warm pool is in use for the training job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Available</code>: The warm pool is available to reuse for a matching training job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Reused</code>: The warm pool moved to a matching training job for reuse.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Terminated</code>: The warm pool is no longer available. Warm pools are unavailable if they are
     *         terminated by a user, terminated for a patch update, or terminated for exceeding the specified
     *         <code>KeepAlivePeriodInSeconds</code>.
     *         </p>
     *         </li>
     * @see WarmPoolResourceStatus
     */
    public final WarmPoolResourceStatus status() {
        return WarmPoolResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the warm pool.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>InUse</code>: The warm pool is in use for the training job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Available</code>: The warm pool is available to reuse for a matching training job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Reused</code>: The warm pool moved to a matching training job for reuse.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Terminated</code>: The warm pool is no longer available. Warm pools are unavailable if they are terminated
     * by a user, terminated for a patch update, or terminated for exceeding the specified
     * <code>KeepAlivePeriodInSeconds</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WarmPoolResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the warm pool.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>InUse</code>: The warm pool is in use for the training job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Available</code>: The warm pool is available to reuse for a matching training job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Reused</code>: The warm pool moved to a matching training job for reuse.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Terminated</code>: The warm pool is no longer available. Warm pools are unavailable if they are
     *         terminated by a user, terminated for a patch update, or terminated for exceeding the specified
     *         <code>KeepAlivePeriodInSeconds</code>.
     *         </p>
     *         </li>
     * @see WarmPoolResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The billable time in seconds used by the warm pool. Billable time refers to the absolute wall-clock time.
     * </p>
     * <p>
     * Multiply <code>ResourceRetainedBillableTimeInSeconds</code> by the number of instances (
     * <code>InstanceCount</code>) in your training cluster to get the total compute time SageMaker bills you if you run
     * warm pool training. The formula is as follows: <code>ResourceRetainedBillableTimeInSeconds * InstanceCount</code>
     * .
     * </p>
     * 
     * @return The billable time in seconds used by the warm pool. Billable time refers to the absolute wall-clock
     *         time.</p>
     *         <p>
     *         Multiply <code>ResourceRetainedBillableTimeInSeconds</code> by the number of instances (
     *         <code>InstanceCount</code>) in your training cluster to get the total compute time SageMaker bills you if
     *         you run warm pool training. The formula is as follows:
     *         <code>ResourceRetainedBillableTimeInSeconds * InstanceCount</code>.
     */
    public final Integer resourceRetainedBillableTimeInSeconds() {
        return resourceRetainedBillableTimeInSeconds;
    }

    /**
     * <p>
     * The name of the matching training job that reused the warm pool.
     * </p>
     * 
     * @return The name of the matching training job that reused the warm pool.
     */
    public final String reusedByJob() {
        return reusedByJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRetainedBillableTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(reusedByJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WarmPoolStatus)) {
            return false;
        }
        WarmPoolStatus other = (WarmPoolStatus) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(resourceRetainedBillableTimeInSeconds(), other.resourceRetainedBillableTimeInSeconds())
                && Objects.equals(reusedByJob(), other.reusedByJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WarmPoolStatus").add("Status", statusAsString())
                .add("ResourceRetainedBillableTimeInSeconds", resourceRetainedBillableTimeInSeconds())
                .add("ReusedByJob", reusedByJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ResourceRetainedBillableTimeInSeconds":
            return Optional.ofNullable(clazz.cast(resourceRetainedBillableTimeInSeconds()));
        case "ReusedByJob":
            return Optional.ofNullable(clazz.cast(reusedByJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("ResourceRetainedBillableTimeInSeconds", RESOURCE_RETAINED_BILLABLE_TIME_IN_SECONDS_FIELD);
        map.put("ReusedByJob", REUSED_BY_JOB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WarmPoolStatus, T> g) {
        return obj -> g.apply((WarmPoolStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WarmPoolStatus> {
        /**
         * <p>
         * The status of the warm pool.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>InUse</code>: The warm pool is in use for the training job.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Available</code>: The warm pool is available to reuse for a matching training job.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Reused</code>: The warm pool moved to a matching training job for reuse.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Terminated</code>: The warm pool is no longer available. Warm pools are unavailable if they are
         * terminated by a user, terminated for a patch update, or terminated for exceeding the specified
         * <code>KeepAlivePeriodInSeconds</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the warm pool.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>InUse</code>: The warm pool is in use for the training job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Available</code>: The warm pool is available to reuse for a matching training job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Reused</code>: The warm pool moved to a matching training job for reuse.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Terminated</code>: The warm pool is no longer available. Warm pools are unavailable if they are
         *        terminated by a user, terminated for a patch update, or terminated for exceeding the specified
         *        <code>KeepAlivePeriodInSeconds</code>.
         *        </p>
         *        </li>
         * @see WarmPoolResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WarmPoolResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the warm pool.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>InUse</code>: The warm pool is in use for the training job.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Available</code>: The warm pool is available to reuse for a matching training job.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Reused</code>: The warm pool moved to a matching training job for reuse.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Terminated</code>: The warm pool is no longer available. Warm pools are unavailable if they are
         * terminated by a user, terminated for a patch update, or terminated for exceeding the specified
         * <code>KeepAlivePeriodInSeconds</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the warm pool.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>InUse</code>: The warm pool is in use for the training job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Available</code>: The warm pool is available to reuse for a matching training job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Reused</code>: The warm pool moved to a matching training job for reuse.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Terminated</code>: The warm pool is no longer available. Warm pools are unavailable if they are
         *        terminated by a user, terminated for a patch update, or terminated for exceeding the specified
         *        <code>KeepAlivePeriodInSeconds</code>.
         *        </p>
         *        </li>
         * @see WarmPoolResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WarmPoolResourceStatus
         */
        Builder status(WarmPoolResourceStatus status);

        /**
         * <p>
         * The billable time in seconds used by the warm pool. Billable time refers to the absolute wall-clock time.
         * </p>
         * <p>
         * Multiply <code>ResourceRetainedBillableTimeInSeconds</code> by the number of instances (
         * <code>InstanceCount</code>) in your training cluster to get the total compute time SageMaker bills you if you
         * run warm pool training. The formula is as follows:
         * <code>ResourceRetainedBillableTimeInSeconds * InstanceCount</code>.
         * </p>
         * 
         * @param resourceRetainedBillableTimeInSeconds
         *        The billable time in seconds used by the warm pool. Billable time refers to the absolute wall-clock
         *        time.</p>
         *        <p>
         *        Multiply <code>ResourceRetainedBillableTimeInSeconds</code> by the number of instances (
         *        <code>InstanceCount</code>) in your training cluster to get the total compute time SageMaker bills you
         *        if you run warm pool training. The formula is as follows:
         *        <code>ResourceRetainedBillableTimeInSeconds * InstanceCount</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRetainedBillableTimeInSeconds(Integer resourceRetainedBillableTimeInSeconds);

        /**
         * <p>
         * The name of the matching training job that reused the warm pool.
         * </p>
         * 
         * @param reusedByJob
         *        The name of the matching training job that reused the warm pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reusedByJob(String reusedByJob);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Integer resourceRetainedBillableTimeInSeconds;

        private String reusedByJob;

        private BuilderImpl() {
        }

        private BuilderImpl(WarmPoolStatus model) {
            status(model.status);
            resourceRetainedBillableTimeInSeconds(model.resourceRetainedBillableTimeInSeconds);
            reusedByJob(model.reusedByJob);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WarmPoolResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getResourceRetainedBillableTimeInSeconds() {
            return resourceRetainedBillableTimeInSeconds;
        }

        public final void setResourceRetainedBillableTimeInSeconds(Integer resourceRetainedBillableTimeInSeconds) {
            this.resourceRetainedBillableTimeInSeconds = resourceRetainedBillableTimeInSeconds;
        }

        @Override
        public final Builder resourceRetainedBillableTimeInSeconds(Integer resourceRetainedBillableTimeInSeconds) {
            this.resourceRetainedBillableTimeInSeconds = resourceRetainedBillableTimeInSeconds;
            return this;
        }

        public final String getReusedByJob() {
            return reusedByJob;
        }

        public final void setReusedByJob(String reusedByJob) {
            this.reusedByJob = reusedByJob;
        }

        @Override
        public final Builder reusedByJob(String reusedByJob) {
            this.reusedByJob = reusedByJob;
            return this;
        }

        @Override
        public WarmPoolStatus build() {
            return new WarmPoolStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
