/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.FeatureAdditionsCopier;
import software.amazon.awssdk.services.sagemaker.model.FeatureDefinition;
import software.amazon.awssdk.services.sagemaker.model.OnlineStoreConfigUpdate;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.ThroughputConfigUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFeatureGroupRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateFeatureGroupRequest> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupName").getter(UpdateFeatureGroupRequest.getter(UpdateFeatureGroupRequest::featureGroupName)).setter(UpdateFeatureGroupRequest.setter(Builder::featureGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()}).build();
    private static final SdkField<List<FeatureDefinition>> FEATURE_ADDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeatureAdditions").getter(UpdateFeatureGroupRequest.getter(UpdateFeatureGroupRequest::featureAdditions)).setter(UpdateFeatureGroupRequest.setter(Builder::featureAdditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureAdditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FeatureDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OnlineStoreConfigUpdate> ONLINE_STORE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnlineStoreConfig").getter(UpdateFeatureGroupRequest.getter(UpdateFeatureGroupRequest::onlineStoreConfig)).setter(UpdateFeatureGroupRequest.setter(Builder::onlineStoreConfig)).constructor(OnlineStoreConfigUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnlineStoreConfig").build()}).build();
    private static final SdkField<ThroughputConfigUpdate> THROUGHPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ThroughputConfig").getter(UpdateFeatureGroupRequest.getter(UpdateFeatureGroupRequest::throughputConfig)).setter(UpdateFeatureGroupRequest.setter(Builder::throughputConfig)).constructor(ThroughputConfigUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD, FEATURE_ADDITIONS_FIELD, ONLINE_STORE_CONFIG_FIELD, THROUGHPUT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFeatureGroupRequest.memberNameToFieldInitializer();
    private final String featureGroupName;
    private final List<FeatureDefinition> featureAdditions;
    private final OnlineStoreConfigUpdate onlineStoreConfig;
    private final ThroughputConfigUpdate throughputConfig;

    private UpdateFeatureGroupRequest(BuilderImpl builder) {
        super(builder);
        this.featureGroupName = builder.featureGroupName;
        this.featureAdditions = builder.featureAdditions;
        this.onlineStoreConfig = builder.onlineStoreConfig;
        this.throughputConfig = builder.throughputConfig;
    }

    public final String featureGroupName() {
        return this.featureGroupName;
    }

    public final boolean hasFeatureAdditions() {
        return this.featureAdditions != null && !(this.featureAdditions instanceof SdkAutoConstructList);
    }

    public final List<FeatureDefinition> featureAdditions() {
        return this.featureAdditions;
    }

    public final OnlineStoreConfigUpdate onlineStoreConfig() {
        return this.onlineStoreConfig;
    }

    public final ThroughputConfigUpdate throughputConfig() {
        return this.throughputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureAdditions() ? this.featureAdditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineStoreConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFeatureGroupRequest)) {
            return false;
        }
        UpdateFeatureGroupRequest other = (UpdateFeatureGroupRequest)((Object)obj);
        return Objects.equals(this.featureGroupName(), other.featureGroupName()) && this.hasFeatureAdditions() == other.hasFeatureAdditions() && Objects.equals(this.featureAdditions(), other.featureAdditions()) && Objects.equals(this.onlineStoreConfig(), other.onlineStoreConfig()) && Objects.equals(this.throughputConfig(), other.throughputConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFeatureGroupRequest").add("FeatureGroupName", (Object)this.featureGroupName()).add("FeatureAdditions", this.hasFeatureAdditions() ? this.featureAdditions() : null).add("OnlineStoreConfig", (Object)this.onlineStoreConfig()).add("ThroughputConfig", (Object)this.throughputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeatureGroupName": {
                return Optional.ofNullable(clazz.cast(this.featureGroupName()));
            }
            case "FeatureAdditions": {
                return Optional.ofNullable(clazz.cast(this.featureAdditions()));
            }
            case "OnlineStoreConfig": {
                return Optional.ofNullable(clazz.cast(this.onlineStoreConfig()));
            }
            case "ThroughputConfig": {
                return Optional.ofNullable(clazz.cast(this.throughputConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FeatureGroupName", FEATURE_GROUP_NAME_FIELD);
        map.put("FeatureAdditions", FEATURE_ADDITIONS_FIELD);
        map.put("OnlineStoreConfig", ONLINE_STORE_CONFIG_FIELD);
        map.put("ThroughputConfig", THROUGHPUT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFeatureGroupRequest, T> g) {
        return obj -> g.apply((UpdateFeatureGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String featureGroupName;
        private List<FeatureDefinition> featureAdditions = DefaultSdkAutoConstructList.getInstance();
        private OnlineStoreConfigUpdate onlineStoreConfig;
        private ThroughputConfigUpdate throughputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFeatureGroupRequest model) {
            super(model);
            this.featureGroupName(model.featureGroupName);
            this.featureAdditions(model.featureAdditions);
            this.onlineStoreConfig(model.onlineStoreConfig);
            this.throughputConfig(model.throughputConfig);
        }

        public final String getFeatureGroupName() {
            return this.featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final List<FeatureDefinition.Builder> getFeatureAdditions() {
            List<FeatureDefinition.Builder> result = FeatureAdditionsCopier.copyToBuilder(this.featureAdditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatureAdditions(Collection<FeatureDefinition.BuilderImpl> featureAdditions) {
            this.featureAdditions = FeatureAdditionsCopier.copyFromBuilder(featureAdditions);
        }

        @Override
        public final Builder featureAdditions(Collection<FeatureDefinition> featureAdditions) {
            this.featureAdditions = FeatureAdditionsCopier.copy(featureAdditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureAdditions(FeatureDefinition ... featureAdditions) {
            this.featureAdditions(Arrays.asList(featureAdditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureAdditions(Consumer<FeatureDefinition.Builder> ... featureAdditions) {
            this.featureAdditions(Stream.of(featureAdditions).map(c -> (FeatureDefinition)((FeatureDefinition.Builder)FeatureDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final OnlineStoreConfigUpdate.Builder getOnlineStoreConfig() {
            return this.onlineStoreConfig != null ? this.onlineStoreConfig.toBuilder() : null;
        }

        public final void setOnlineStoreConfig(OnlineStoreConfigUpdate.BuilderImpl onlineStoreConfig) {
            this.onlineStoreConfig = onlineStoreConfig != null ? onlineStoreConfig.build() : null;
        }

        @Override
        public final Builder onlineStoreConfig(OnlineStoreConfigUpdate onlineStoreConfig) {
            this.onlineStoreConfig = onlineStoreConfig;
            return this;
        }

        public final ThroughputConfigUpdate.Builder getThroughputConfig() {
            return this.throughputConfig != null ? this.throughputConfig.toBuilder() : null;
        }

        public final void setThroughputConfig(ThroughputConfigUpdate.BuilderImpl throughputConfig) {
            this.throughputConfig = throughputConfig != null ? throughputConfig.build() : null;
        }

        @Override
        public final Builder throughputConfig(ThroughputConfigUpdate throughputConfig) {
            this.throughputConfig = throughputConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFeatureGroupRequest build() {
            return new UpdateFeatureGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFeatureGroupRequest> {
        public Builder featureGroupName(String var1);

        public Builder featureAdditions(Collection<FeatureDefinition> var1);

        public Builder featureAdditions(FeatureDefinition ... var1);

        public Builder featureAdditions(Consumer<FeatureDefinition.Builder> ... var1);

        public Builder onlineStoreConfig(OnlineStoreConfigUpdate var1);

        default public Builder onlineStoreConfig(Consumer<OnlineStoreConfigUpdate.Builder> onlineStoreConfig) {
            return this.onlineStoreConfig((OnlineStoreConfigUpdate)((OnlineStoreConfigUpdate.Builder)OnlineStoreConfigUpdate.builder().applyMutation(onlineStoreConfig)).build());
        }

        public Builder throughputConfig(ThroughputConfigUpdate var1);

        default public Builder throughputConfig(Consumer<ThroughputConfigUpdate.Builder> throughputConfig) {
            return this.throughputConfig((ThroughputConfigUpdate)((ThroughputConfigUpdate.Builder)ThroughputConfigUpdate.builder().applyMutation(throughputConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

