/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.PipelineVersionSummary;
import software.amazon.awssdk.services.sagemaker.model.PipelineVersionSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPipelineVersionsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListPipelineVersionsResponse> {
    private static final SdkField<List<PipelineVersionSummary>> PIPELINE_VERSION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PipelineVersionSummaries").getter(ListPipelineVersionsResponse.getter(ListPipelineVersionsResponse::pipelineVersionSummaries)).setter(ListPipelineVersionsResponse.setter(Builder::pipelineVersionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineVersionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPipelineVersionsResponse.getter(ListPipelineVersionsResponse::nextToken)).setter(ListPipelineVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPipelineVersionsResponse.memberNameToFieldInitializer();
    private final List<PipelineVersionSummary> pipelineVersionSummaries;
    private final String nextToken;

    private ListPipelineVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineVersionSummaries = builder.pipelineVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPipelineVersionSummaries() {
        return this.pipelineVersionSummaries != null && !(this.pipelineVersionSummaries instanceof SdkAutoConstructList);
    }

    public final List<PipelineVersionSummary> pipelineVersionSummaries() {
        return this.pipelineVersionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelineVersionSummaries() ? this.pipelineVersionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelineVersionsResponse)) {
            return false;
        }
        ListPipelineVersionsResponse other = (ListPipelineVersionsResponse)((Object)obj);
        return this.hasPipelineVersionSummaries() == other.hasPipelineVersionSummaries() && Objects.equals(this.pipelineVersionSummaries(), other.pipelineVersionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPipelineVersionsResponse").add("PipelineVersionSummaries", this.hasPipelineVersionSummaries() ? this.pipelineVersionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineVersionSummaries": {
                return Optional.ofNullable(clazz.cast(this.pipelineVersionSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PipelineVersionSummaries", PIPELINE_VERSION_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPipelineVersionsResponse, T> g) {
        return obj -> g.apply((ListPipelineVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<PipelineVersionSummary> pipelineVersionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelineVersionsResponse model) {
            super(model);
            this.pipelineVersionSummaries(model.pipelineVersionSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<PipelineVersionSummary.Builder> getPipelineVersionSummaries() {
            List<PipelineVersionSummary.Builder> result = PipelineVersionSummaryListCopier.copyToBuilder(this.pipelineVersionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelineVersionSummaries(Collection<PipelineVersionSummary.BuilderImpl> pipelineVersionSummaries) {
            this.pipelineVersionSummaries = PipelineVersionSummaryListCopier.copyFromBuilder(pipelineVersionSummaries);
        }

        @Override
        public final Builder pipelineVersionSummaries(Collection<PipelineVersionSummary> pipelineVersionSummaries) {
            this.pipelineVersionSummaries = PipelineVersionSummaryListCopier.copy(pipelineVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineVersionSummaries(PipelineVersionSummary ... pipelineVersionSummaries) {
            this.pipelineVersionSummaries(Arrays.asList(pipelineVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineVersionSummaries(Consumer<PipelineVersionSummary.Builder> ... pipelineVersionSummaries) {
            this.pipelineVersionSummaries(Stream.of(pipelineVersionSummaries).map(c -> (PipelineVersionSummary)((PipelineVersionSummary.Builder)PipelineVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPipelineVersionsResponse build() {
            return new ListPipelineVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPipelineVersionsResponse> {
        public Builder pipelineVersionSummaries(Collection<PipelineVersionSummary> var1);

        public Builder pipelineVersionSummaries(PipelineVersionSummary ... var1);

        public Builder pipelineVersionSummaries(Consumer<PipelineVersionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

