/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineExecutionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineExecutionSummary> {
    private static final SdkField<String> PIPELINE_EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineExecutionArn").getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::pipelineExecutionArn)).setter(PipelineExecutionSummary.setter(Builder::pipelineExecutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionArn").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::startTime)).setter(PipelineExecutionSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<String> PIPELINE_EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineExecutionStatus").getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::pipelineExecutionStatusAsString)).setter(PipelineExecutionSummary.setter(Builder::pipelineExecutionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionStatus").build()}).build();
    private static final SdkField<String> PIPELINE_EXECUTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineExecutionDescription").getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::pipelineExecutionDescription)).setter(PipelineExecutionSummary.setter(Builder::pipelineExecutionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionDescription").build()}).build();
    private static final SdkField<String> PIPELINE_EXECUTION_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineExecutionDisplayName").getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::pipelineExecutionDisplayName)).setter(PipelineExecutionSummary.setter(Builder::pipelineExecutionDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionDisplayName").build()}).build();
    private static final SdkField<String> PIPELINE_EXECUTION_FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineExecutionFailureReason").getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::pipelineExecutionFailureReason)).setter(PipelineExecutionSummary.setter(Builder::pipelineExecutionFailureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionFailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_EXECUTION_ARN_FIELD, START_TIME_FIELD, PIPELINE_EXECUTION_STATUS_FIELD, PIPELINE_EXECUTION_DESCRIPTION_FIELD, PIPELINE_EXECUTION_DISPLAY_NAME_FIELD, PIPELINE_EXECUTION_FAILURE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PipelineExecutionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String pipelineExecutionArn;
    private final Instant startTime;
    private final String pipelineExecutionStatus;
    private final String pipelineExecutionDescription;
    private final String pipelineExecutionDisplayName;
    private final String pipelineExecutionFailureReason;

    private PipelineExecutionSummary(BuilderImpl builder) {
        this.pipelineExecutionArn = builder.pipelineExecutionArn;
        this.startTime = builder.startTime;
        this.pipelineExecutionStatus = builder.pipelineExecutionStatus;
        this.pipelineExecutionDescription = builder.pipelineExecutionDescription;
        this.pipelineExecutionDisplayName = builder.pipelineExecutionDisplayName;
        this.pipelineExecutionFailureReason = builder.pipelineExecutionFailureReason;
    }

    public final String pipelineExecutionArn() {
        return this.pipelineExecutionArn;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final PipelineExecutionStatus pipelineExecutionStatus() {
        return PipelineExecutionStatus.fromValue(this.pipelineExecutionStatus);
    }

    public final String pipelineExecutionStatusAsString() {
        return this.pipelineExecutionStatus;
    }

    public final String pipelineExecutionDescription() {
        return this.pipelineExecutionDescription;
    }

    public final String pipelineExecutionDisplayName() {
        return this.pipelineExecutionDisplayName;
    }

    public final String pipelineExecutionFailureReason() {
        return this.pipelineExecutionFailureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionFailureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExecutionSummary)) {
            return false;
        }
        PipelineExecutionSummary other = (PipelineExecutionSummary)obj;
        return Objects.equals(this.pipelineExecutionArn(), other.pipelineExecutionArn()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.pipelineExecutionStatusAsString(), other.pipelineExecutionStatusAsString()) && Objects.equals(this.pipelineExecutionDescription(), other.pipelineExecutionDescription()) && Objects.equals(this.pipelineExecutionDisplayName(), other.pipelineExecutionDisplayName()) && Objects.equals(this.pipelineExecutionFailureReason(), other.pipelineExecutionFailureReason());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineExecutionSummary").add("PipelineExecutionArn", (Object)this.pipelineExecutionArn()).add("StartTime", (Object)this.startTime()).add("PipelineExecutionStatus", (Object)this.pipelineExecutionStatusAsString()).add("PipelineExecutionDescription", (Object)this.pipelineExecutionDescription()).add("PipelineExecutionDisplayName", (Object)this.pipelineExecutionDisplayName()).add("PipelineExecutionFailureReason", (Object)this.pipelineExecutionFailureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineExecutionArn": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionArn()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "PipelineExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionStatusAsString()));
            }
            case "PipelineExecutionDescription": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionDescription()));
            }
            case "PipelineExecutionDisplayName": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionDisplayName()));
            }
            case "PipelineExecutionFailureReason": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionFailureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PipelineExecutionArn", PIPELINE_EXECUTION_ARN_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("PipelineExecutionStatus", PIPELINE_EXECUTION_STATUS_FIELD);
        map.put("PipelineExecutionDescription", PIPELINE_EXECUTION_DESCRIPTION_FIELD);
        map.put("PipelineExecutionDisplayName", PIPELINE_EXECUTION_DISPLAY_NAME_FIELD);
        map.put("PipelineExecutionFailureReason", PIPELINE_EXECUTION_FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipelineExecutionSummary, T> g) {
        return obj -> g.apply((PipelineExecutionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineExecutionArn;
        private Instant startTime;
        private String pipelineExecutionStatus;
        private String pipelineExecutionDescription;
        private String pipelineExecutionDisplayName;
        private String pipelineExecutionFailureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineExecutionSummary model) {
            this.pipelineExecutionArn(model.pipelineExecutionArn);
            this.startTime(model.startTime);
            this.pipelineExecutionStatus(model.pipelineExecutionStatus);
            this.pipelineExecutionDescription(model.pipelineExecutionDescription);
            this.pipelineExecutionDisplayName(model.pipelineExecutionDisplayName);
            this.pipelineExecutionFailureReason(model.pipelineExecutionFailureReason);
        }

        public final String getPipelineExecutionArn() {
            return this.pipelineExecutionArn;
        }

        public final void setPipelineExecutionArn(String pipelineExecutionArn) {
            this.pipelineExecutionArn = pipelineExecutionArn;
        }

        @Override
        public final Builder pipelineExecutionArn(String pipelineExecutionArn) {
            this.pipelineExecutionArn = pipelineExecutionArn;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getPipelineExecutionStatus() {
            return this.pipelineExecutionStatus;
        }

        public final void setPipelineExecutionStatus(String pipelineExecutionStatus) {
            this.pipelineExecutionStatus = pipelineExecutionStatus;
        }

        @Override
        public final Builder pipelineExecutionStatus(String pipelineExecutionStatus) {
            this.pipelineExecutionStatus = pipelineExecutionStatus;
            return this;
        }

        @Override
        public final Builder pipelineExecutionStatus(PipelineExecutionStatus pipelineExecutionStatus) {
            this.pipelineExecutionStatus(pipelineExecutionStatus == null ? null : pipelineExecutionStatus.toString());
            return this;
        }

        public final String getPipelineExecutionDescription() {
            return this.pipelineExecutionDescription;
        }

        public final void setPipelineExecutionDescription(String pipelineExecutionDescription) {
            this.pipelineExecutionDescription = pipelineExecutionDescription;
        }

        @Override
        public final Builder pipelineExecutionDescription(String pipelineExecutionDescription) {
            this.pipelineExecutionDescription = pipelineExecutionDescription;
            return this;
        }

        public final String getPipelineExecutionDisplayName() {
            return this.pipelineExecutionDisplayName;
        }

        public final void setPipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
            this.pipelineExecutionDisplayName = pipelineExecutionDisplayName;
        }

        @Override
        public final Builder pipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
            this.pipelineExecutionDisplayName = pipelineExecutionDisplayName;
            return this;
        }

        public final String getPipelineExecutionFailureReason() {
            return this.pipelineExecutionFailureReason;
        }

        public final void setPipelineExecutionFailureReason(String pipelineExecutionFailureReason) {
            this.pipelineExecutionFailureReason = pipelineExecutionFailureReason;
        }

        @Override
        public final Builder pipelineExecutionFailureReason(String pipelineExecutionFailureReason) {
            this.pipelineExecutionFailureReason = pipelineExecutionFailureReason;
            return this;
        }

        public PipelineExecutionSummary build() {
            return new PipelineExecutionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineExecutionSummary> {
        public Builder pipelineExecutionArn(String var1);

        public Builder startTime(Instant var1);

        public Builder pipelineExecutionStatus(String var1);

        public Builder pipelineExecutionStatus(PipelineExecutionStatus var1);

        public Builder pipelineExecutionDescription(String var1);

        public Builder pipelineExecutionDisplayName(String var1);

        public Builder pipelineExecutionFailureReason(String var1);
    }
}

