/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupSpecification;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupSpecificationsCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupsToDeleteCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterNodeRecovery;
import software.amazon.awssdk.services.sagemaker.model.ClusterRestrictedInstanceGroupSpecification;
import software.amazon.awssdk.services.sagemaker.model.ClusterRestrictedInstanceGroupSpecificationsCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateClusterRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateClusterRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(UpdateClusterRequest.getter(UpdateClusterRequest::clusterName)).setter(UpdateClusterRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<List<ClusterInstanceGroupSpecification>> INSTANCE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceGroups").getter(UpdateClusterRequest.getter(UpdateClusterRequest::instanceGroups)).setter(UpdateClusterRequest.setter(Builder::instanceGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterInstanceGroupSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ClusterRestrictedInstanceGroupSpecification>> RESTRICTED_INSTANCE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RestrictedInstanceGroups").getter(UpdateClusterRequest.getter(UpdateClusterRequest::restrictedInstanceGroups)).setter(UpdateClusterRequest.setter(Builder::restrictedInstanceGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestrictedInstanceGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterRestrictedInstanceGroupSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NODE_RECOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeRecovery").getter(UpdateClusterRequest.getter(UpdateClusterRequest::nodeRecoveryAsString)).setter(UpdateClusterRequest.setter(Builder::nodeRecovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeRecovery").build()}).build();
    private static final SdkField<List<String>> INSTANCE_GROUPS_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceGroupsToDelete").getter(UpdateClusterRequest.getter(UpdateClusterRequest::instanceGroupsToDelete)).setter(UpdateClusterRequest.setter(Builder::instanceGroupsToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupsToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, INSTANCE_GROUPS_FIELD, RESTRICTED_INSTANCE_GROUPS_FIELD, NODE_RECOVERY_FIELD, INSTANCE_GROUPS_TO_DELETE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateClusterRequest.memberNameToFieldInitializer();
    private final String clusterName;
    private final List<ClusterInstanceGroupSpecification> instanceGroups;
    private final List<ClusterRestrictedInstanceGroupSpecification> restrictedInstanceGroups;
    private final String nodeRecovery;
    private final List<String> instanceGroupsToDelete;

    private UpdateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.instanceGroups = builder.instanceGroups;
        this.restrictedInstanceGroups = builder.restrictedInstanceGroups;
        this.nodeRecovery = builder.nodeRecovery;
        this.instanceGroupsToDelete = builder.instanceGroupsToDelete;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final boolean hasInstanceGroups() {
        return this.instanceGroups != null && !(this.instanceGroups instanceof SdkAutoConstructList);
    }

    public final List<ClusterInstanceGroupSpecification> instanceGroups() {
        return this.instanceGroups;
    }

    public final boolean hasRestrictedInstanceGroups() {
        return this.restrictedInstanceGroups != null && !(this.restrictedInstanceGroups instanceof SdkAutoConstructList);
    }

    public final List<ClusterRestrictedInstanceGroupSpecification> restrictedInstanceGroups() {
        return this.restrictedInstanceGroups;
    }

    public final ClusterNodeRecovery nodeRecovery() {
        return ClusterNodeRecovery.fromValue(this.nodeRecovery);
    }

    public final String nodeRecoveryAsString() {
        return this.nodeRecovery;
    }

    public final boolean hasInstanceGroupsToDelete() {
        return this.instanceGroupsToDelete != null && !(this.instanceGroupsToDelete instanceof SdkAutoConstructList);
    }

    public final List<String> instanceGroupsToDelete() {
        return this.instanceGroupsToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceGroups() ? this.instanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRestrictedInstanceGroups() ? this.restrictedInstanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeRecoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceGroupsToDelete() ? this.instanceGroupsToDelete() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterRequest)) {
            return false;
        }
        UpdateClusterRequest other = (UpdateClusterRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && this.hasInstanceGroups() == other.hasInstanceGroups() && Objects.equals(this.instanceGroups(), other.instanceGroups()) && this.hasRestrictedInstanceGroups() == other.hasRestrictedInstanceGroups() && Objects.equals(this.restrictedInstanceGroups(), other.restrictedInstanceGroups()) && Objects.equals(this.nodeRecoveryAsString(), other.nodeRecoveryAsString()) && this.hasInstanceGroupsToDelete() == other.hasInstanceGroupsToDelete() && Objects.equals(this.instanceGroupsToDelete(), other.instanceGroupsToDelete());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateClusterRequest").add("ClusterName", (Object)this.clusterName()).add("InstanceGroups", this.hasInstanceGroups() ? this.instanceGroups() : null).add("RestrictedInstanceGroups", this.hasRestrictedInstanceGroups() ? this.restrictedInstanceGroups() : null).add("NodeRecovery", (Object)this.nodeRecoveryAsString()).add("InstanceGroupsToDelete", this.hasInstanceGroupsToDelete() ? this.instanceGroupsToDelete() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "InstanceGroups": {
                return Optional.ofNullable(clazz.cast(this.instanceGroups()));
            }
            case "RestrictedInstanceGroups": {
                return Optional.ofNullable(clazz.cast(this.restrictedInstanceGroups()));
            }
            case "NodeRecovery": {
                return Optional.ofNullable(clazz.cast(this.nodeRecoveryAsString()));
            }
            case "InstanceGroupsToDelete": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupsToDelete()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("InstanceGroups", INSTANCE_GROUPS_FIELD);
        map.put("RestrictedInstanceGroups", RESTRICTED_INSTANCE_GROUPS_FIELD);
        map.put("NodeRecovery", NODE_RECOVERY_FIELD);
        map.put("InstanceGroupsToDelete", INSTANCE_GROUPS_TO_DELETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterRequest, T> g) {
        return obj -> g.apply((UpdateClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private List<ClusterInstanceGroupSpecification> instanceGroups = DefaultSdkAutoConstructList.getInstance();
        private List<ClusterRestrictedInstanceGroupSpecification> restrictedInstanceGroups = DefaultSdkAutoConstructList.getInstance();
        private String nodeRecovery;
        private List<String> instanceGroupsToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.instanceGroups(model.instanceGroups);
            this.restrictedInstanceGroups(model.restrictedInstanceGroups);
            this.nodeRecovery(model.nodeRecovery);
            this.instanceGroupsToDelete(model.instanceGroupsToDelete);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final List<ClusterInstanceGroupSpecification.Builder> getInstanceGroups() {
            List<ClusterInstanceGroupSpecification.Builder> result = ClusterInstanceGroupSpecificationsCopier.copyToBuilder(this.instanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceGroups(Collection<ClusterInstanceGroupSpecification.BuilderImpl> instanceGroups) {
            this.instanceGroups = ClusterInstanceGroupSpecificationsCopier.copyFromBuilder(instanceGroups);
        }

        @Override
        public final Builder instanceGroups(Collection<ClusterInstanceGroupSpecification> instanceGroups) {
            this.instanceGroups = ClusterInstanceGroupSpecificationsCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(ClusterInstanceGroupSpecification ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<ClusterInstanceGroupSpecification.Builder> ... instanceGroups) {
            this.instanceGroups(Stream.of(instanceGroups).map(c -> (ClusterInstanceGroupSpecification)((ClusterInstanceGroupSpecification.Builder)ClusterInstanceGroupSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ClusterRestrictedInstanceGroupSpecification.Builder> getRestrictedInstanceGroups() {
            List<ClusterRestrictedInstanceGroupSpecification.Builder> result = ClusterRestrictedInstanceGroupSpecificationsCopier.copyToBuilder(this.restrictedInstanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRestrictedInstanceGroups(Collection<ClusterRestrictedInstanceGroupSpecification.BuilderImpl> restrictedInstanceGroups) {
            this.restrictedInstanceGroups = ClusterRestrictedInstanceGroupSpecificationsCopier.copyFromBuilder(restrictedInstanceGroups);
        }

        @Override
        public final Builder restrictedInstanceGroups(Collection<ClusterRestrictedInstanceGroupSpecification> restrictedInstanceGroups) {
            this.restrictedInstanceGroups = ClusterRestrictedInstanceGroupSpecificationsCopier.copy(restrictedInstanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restrictedInstanceGroups(ClusterRestrictedInstanceGroupSpecification ... restrictedInstanceGroups) {
            this.restrictedInstanceGroups(Arrays.asList(restrictedInstanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restrictedInstanceGroups(Consumer<ClusterRestrictedInstanceGroupSpecification.Builder> ... restrictedInstanceGroups) {
            this.restrictedInstanceGroups(Stream.of(restrictedInstanceGroups).map(c -> (ClusterRestrictedInstanceGroupSpecification)((ClusterRestrictedInstanceGroupSpecification.Builder)ClusterRestrictedInstanceGroupSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNodeRecovery() {
            return this.nodeRecovery;
        }

        public final void setNodeRecovery(String nodeRecovery) {
            this.nodeRecovery = nodeRecovery;
        }

        @Override
        public final Builder nodeRecovery(String nodeRecovery) {
            this.nodeRecovery = nodeRecovery;
            return this;
        }

        @Override
        public final Builder nodeRecovery(ClusterNodeRecovery nodeRecovery) {
            this.nodeRecovery(nodeRecovery == null ? null : nodeRecovery.toString());
            return this;
        }

        public final Collection<String> getInstanceGroupsToDelete() {
            if (this.instanceGroupsToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceGroupsToDelete;
        }

        public final void setInstanceGroupsToDelete(Collection<String> instanceGroupsToDelete) {
            this.instanceGroupsToDelete = ClusterInstanceGroupsToDeleteCopier.copy(instanceGroupsToDelete);
        }

        @Override
        public final Builder instanceGroupsToDelete(Collection<String> instanceGroupsToDelete) {
            this.instanceGroupsToDelete = ClusterInstanceGroupsToDeleteCopier.copy(instanceGroupsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroupsToDelete(String ... instanceGroupsToDelete) {
            this.instanceGroupsToDelete(Arrays.asList(instanceGroupsToDelete));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterRequest build() {
            return new UpdateClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateClusterRequest> {
        public Builder clusterName(String var1);

        public Builder instanceGroups(Collection<ClusterInstanceGroupSpecification> var1);

        public Builder instanceGroups(ClusterInstanceGroupSpecification ... var1);

        public Builder instanceGroups(Consumer<ClusterInstanceGroupSpecification.Builder> ... var1);

        public Builder restrictedInstanceGroups(Collection<ClusterRestrictedInstanceGroupSpecification> var1);

        public Builder restrictedInstanceGroups(ClusterRestrictedInstanceGroupSpecification ... var1);

        public Builder restrictedInstanceGroups(Consumer<ClusterRestrictedInstanceGroupSpecification.Builder> ... var1);

        public Builder nodeRecovery(String var1);

        public Builder nodeRecovery(ClusterNodeRecovery var1);

        public Builder instanceGroupsToDelete(Collection<String> var1);

        public Builder instanceGroupsToDelete(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

