/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineVersion> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineArn").getter(PipelineVersion.getter(PipelineVersion::pipelineArn)).setter(PipelineVersion.setter(Builder::pipelineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()}).build();
    private static final SdkField<Long> PIPELINE_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PipelineVersionId").getter(PipelineVersion.getter(PipelineVersion::pipelineVersionId)).setter(PipelineVersion.setter(Builder::pipelineVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineVersionId").build()}).build();
    private static final SdkField<String> PIPELINE_VERSION_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineVersionDisplayName").getter(PipelineVersion.getter(PipelineVersion::pipelineVersionDisplayName)).setter(PipelineVersion.setter(Builder::pipelineVersionDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineVersionDisplayName").build()}).build();
    private static final SdkField<String> PIPELINE_VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineVersionDescription").getter(PipelineVersion.getter(PipelineVersion::pipelineVersionDescription)).setter(PipelineVersion.setter(Builder::pipelineVersionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineVersionDescription").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(PipelineVersion.getter(PipelineVersion::creationTime)).setter(PipelineVersion.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(PipelineVersion.getter(PipelineVersion::lastModifiedTime)).setter(PipelineVersion.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(PipelineVersion.getter(PipelineVersion::createdBy)).setter(PipelineVersion.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedBy").getter(PipelineVersion.getter(PipelineVersion::lastModifiedBy)).setter(PipelineVersion.setter(Builder::lastModifiedBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<String> LAST_EXECUTED_PIPELINE_EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastExecutedPipelineExecutionArn").getter(PipelineVersion.getter(PipelineVersion::lastExecutedPipelineExecutionArn)).setter(PipelineVersion.setter(Builder::lastExecutedPipelineExecutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutedPipelineExecutionArn").build()}).build();
    private static final SdkField<String> LAST_EXECUTED_PIPELINE_EXECUTION_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastExecutedPipelineExecutionDisplayName").getter(PipelineVersion.getter(PipelineVersion::lastExecutedPipelineExecutionDisplayName)).setter(PipelineVersion.setter(Builder::lastExecutedPipelineExecutionDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutedPipelineExecutionDisplayName").build()}).build();
    private static final SdkField<String> LAST_EXECUTED_PIPELINE_EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastExecutedPipelineExecutionStatus").getter(PipelineVersion.getter(PipelineVersion::lastExecutedPipelineExecutionStatusAsString)).setter(PipelineVersion.setter(Builder::lastExecutedPipelineExecutionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutedPipelineExecutionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD, PIPELINE_VERSION_ID_FIELD, PIPELINE_VERSION_DISPLAY_NAME_FIELD, PIPELINE_VERSION_DESCRIPTION_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_BY_FIELD, LAST_EXECUTED_PIPELINE_EXECUTION_ARN_FIELD, LAST_EXECUTED_PIPELINE_EXECUTION_DISPLAY_NAME_FIELD, LAST_EXECUTED_PIPELINE_EXECUTION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PipelineVersion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String pipelineArn;
    private final Long pipelineVersionId;
    private final String pipelineVersionDisplayName;
    private final String pipelineVersionDescription;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final UserContext createdBy;
    private final UserContext lastModifiedBy;
    private final String lastExecutedPipelineExecutionArn;
    private final String lastExecutedPipelineExecutionDisplayName;
    private final String lastExecutedPipelineExecutionStatus;

    private PipelineVersion(BuilderImpl builder) {
        this.pipelineArn = builder.pipelineArn;
        this.pipelineVersionId = builder.pipelineVersionId;
        this.pipelineVersionDisplayName = builder.pipelineVersionDisplayName;
        this.pipelineVersionDescription = builder.pipelineVersionDescription;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastExecutedPipelineExecutionArn = builder.lastExecutedPipelineExecutionArn;
        this.lastExecutedPipelineExecutionDisplayName = builder.lastExecutedPipelineExecutionDisplayName;
        this.lastExecutedPipelineExecutionStatus = builder.lastExecutedPipelineExecutionStatus;
    }

    public final String pipelineArn() {
        return this.pipelineArn;
    }

    public final Long pipelineVersionId() {
        return this.pipelineVersionId;
    }

    public final String pipelineVersionDisplayName() {
        return this.pipelineVersionDisplayName;
    }

    public final String pipelineVersionDescription() {
        return this.pipelineVersionDescription;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final UserContext createdBy() {
        return this.createdBy;
    }

    public final UserContext lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final String lastExecutedPipelineExecutionArn() {
        return this.lastExecutedPipelineExecutionArn;
    }

    public final String lastExecutedPipelineExecutionDisplayName() {
        return this.lastExecutedPipelineExecutionDisplayName;
    }

    public final PipelineExecutionStatus lastExecutedPipelineExecutionStatus() {
        return PipelineExecutionStatus.fromValue(this.lastExecutedPipelineExecutionStatus);
    }

    public final String lastExecutedPipelineExecutionStatusAsString() {
        return this.lastExecutedPipelineExecutionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineVersionDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineVersionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastExecutedPipelineExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastExecutedPipelineExecutionDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastExecutedPipelineExecutionStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineVersion)) {
            return false;
        }
        PipelineVersion other = (PipelineVersion)obj;
        return Objects.equals(this.pipelineArn(), other.pipelineArn()) && Objects.equals(this.pipelineVersionId(), other.pipelineVersionId()) && Objects.equals(this.pipelineVersionDisplayName(), other.pipelineVersionDisplayName()) && Objects.equals(this.pipelineVersionDescription(), other.pipelineVersionDescription()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastExecutedPipelineExecutionArn(), other.lastExecutedPipelineExecutionArn()) && Objects.equals(this.lastExecutedPipelineExecutionDisplayName(), other.lastExecutedPipelineExecutionDisplayName()) && Objects.equals(this.lastExecutedPipelineExecutionStatusAsString(), other.lastExecutedPipelineExecutionStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineVersion").add("PipelineArn", (Object)this.pipelineArn()).add("PipelineVersionId", (Object)this.pipelineVersionId()).add("PipelineVersionDisplayName", (Object)this.pipelineVersionDisplayName()).add("PipelineVersionDescription", (Object)this.pipelineVersionDescription()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("CreatedBy", (Object)this.createdBy()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LastExecutedPipelineExecutionArn", (Object)this.lastExecutedPipelineExecutionArn()).add("LastExecutedPipelineExecutionDisplayName", (Object)this.lastExecutedPipelineExecutionDisplayName()).add("LastExecutedPipelineExecutionStatus", (Object)this.lastExecutedPipelineExecutionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineArn": {
                return Optional.ofNullable(clazz.cast(this.pipelineArn()));
            }
            case "PipelineVersionId": {
                return Optional.ofNullable(clazz.cast(this.pipelineVersionId()));
            }
            case "PipelineVersionDisplayName": {
                return Optional.ofNullable(clazz.cast(this.pipelineVersionDisplayName()));
            }
            case "PipelineVersionDescription": {
                return Optional.ofNullable(clazz.cast(this.pipelineVersionDescription()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "LastExecutedPipelineExecutionArn": {
                return Optional.ofNullable(clazz.cast(this.lastExecutedPipelineExecutionArn()));
            }
            case "LastExecutedPipelineExecutionDisplayName": {
                return Optional.ofNullable(clazz.cast(this.lastExecutedPipelineExecutionDisplayName()));
            }
            case "LastExecutedPipelineExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.lastExecutedPipelineExecutionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PipelineArn", PIPELINE_ARN_FIELD);
        map.put("PipelineVersionId", PIPELINE_VERSION_ID_FIELD);
        map.put("PipelineVersionDisplayName", PIPELINE_VERSION_DISPLAY_NAME_FIELD);
        map.put("PipelineVersionDescription", PIPELINE_VERSION_DESCRIPTION_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("LastExecutedPipelineExecutionArn", LAST_EXECUTED_PIPELINE_EXECUTION_ARN_FIELD);
        map.put("LastExecutedPipelineExecutionDisplayName", LAST_EXECUTED_PIPELINE_EXECUTION_DISPLAY_NAME_FIELD);
        map.put("LastExecutedPipelineExecutionStatus", LAST_EXECUTED_PIPELINE_EXECUTION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipelineVersion, T> g) {
        return obj -> g.apply((PipelineVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineArn;
        private Long pipelineVersionId;
        private String pipelineVersionDisplayName;
        private String pipelineVersionDescription;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private UserContext createdBy;
        private UserContext lastModifiedBy;
        private String lastExecutedPipelineExecutionArn;
        private String lastExecutedPipelineExecutionDisplayName;
        private String lastExecutedPipelineExecutionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineVersion model) {
            this.pipelineArn(model.pipelineArn);
            this.pipelineVersionId(model.pipelineVersionId);
            this.pipelineVersionDisplayName(model.pipelineVersionDisplayName);
            this.pipelineVersionDescription(model.pipelineVersionDescription);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.createdBy(model.createdBy);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastExecutedPipelineExecutionArn(model.lastExecutedPipelineExecutionArn);
            this.lastExecutedPipelineExecutionDisplayName(model.lastExecutedPipelineExecutionDisplayName);
            this.lastExecutedPipelineExecutionStatus(model.lastExecutedPipelineExecutionStatus);
        }

        public final String getPipelineArn() {
            return this.pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final Long getPipelineVersionId() {
            return this.pipelineVersionId;
        }

        public final void setPipelineVersionId(Long pipelineVersionId) {
            this.pipelineVersionId = pipelineVersionId;
        }

        @Override
        public final Builder pipelineVersionId(Long pipelineVersionId) {
            this.pipelineVersionId = pipelineVersionId;
            return this;
        }

        public final String getPipelineVersionDisplayName() {
            return this.pipelineVersionDisplayName;
        }

        public final void setPipelineVersionDisplayName(String pipelineVersionDisplayName) {
            this.pipelineVersionDisplayName = pipelineVersionDisplayName;
        }

        @Override
        public final Builder pipelineVersionDisplayName(String pipelineVersionDisplayName) {
            this.pipelineVersionDisplayName = pipelineVersionDisplayName;
            return this;
        }

        public final String getPipelineVersionDescription() {
            return this.pipelineVersionDescription;
        }

        public final void setPipelineVersionDescription(String pipelineVersionDescription) {
            this.pipelineVersionDescription = pipelineVersionDescription;
        }

        @Override
        public final Builder pipelineVersionDescription(String pipelineVersionDescription) {
            this.pipelineVersionDescription = pipelineVersionDescription;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return this.lastModifiedBy != null ? this.lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final String getLastExecutedPipelineExecutionArn() {
            return this.lastExecutedPipelineExecutionArn;
        }

        public final void setLastExecutedPipelineExecutionArn(String lastExecutedPipelineExecutionArn) {
            this.lastExecutedPipelineExecutionArn = lastExecutedPipelineExecutionArn;
        }

        @Override
        public final Builder lastExecutedPipelineExecutionArn(String lastExecutedPipelineExecutionArn) {
            this.lastExecutedPipelineExecutionArn = lastExecutedPipelineExecutionArn;
            return this;
        }

        public final String getLastExecutedPipelineExecutionDisplayName() {
            return this.lastExecutedPipelineExecutionDisplayName;
        }

        public final void setLastExecutedPipelineExecutionDisplayName(String lastExecutedPipelineExecutionDisplayName) {
            this.lastExecutedPipelineExecutionDisplayName = lastExecutedPipelineExecutionDisplayName;
        }

        @Override
        public final Builder lastExecutedPipelineExecutionDisplayName(String lastExecutedPipelineExecutionDisplayName) {
            this.lastExecutedPipelineExecutionDisplayName = lastExecutedPipelineExecutionDisplayName;
            return this;
        }

        public final String getLastExecutedPipelineExecutionStatus() {
            return this.lastExecutedPipelineExecutionStatus;
        }

        public final void setLastExecutedPipelineExecutionStatus(String lastExecutedPipelineExecutionStatus) {
            this.lastExecutedPipelineExecutionStatus = lastExecutedPipelineExecutionStatus;
        }

        @Override
        public final Builder lastExecutedPipelineExecutionStatus(String lastExecutedPipelineExecutionStatus) {
            this.lastExecutedPipelineExecutionStatus = lastExecutedPipelineExecutionStatus;
            return this;
        }

        @Override
        public final Builder lastExecutedPipelineExecutionStatus(PipelineExecutionStatus lastExecutedPipelineExecutionStatus) {
            this.lastExecutedPipelineExecutionStatus(lastExecutedPipelineExecutionStatus == null ? null : lastExecutedPipelineExecutionStatus.toString());
            return this;
        }

        public PipelineVersion build() {
            return new PipelineVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineVersion> {
        public Builder pipelineArn(String var1);

        public Builder pipelineVersionId(Long var1);

        public Builder pipelineVersionDisplayName(String var1);

        public Builder pipelineVersionDescription(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }

        public Builder lastModifiedBy(UserContext var1);

        default public Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return this.lastModifiedBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(lastModifiedBy)).build());
        }

        public Builder lastExecutedPipelineExecutionArn(String var1);

        public Builder lastExecutedPipelineExecutionDisplayName(String var1);

        public Builder lastExecutedPipelineExecutionStatus(String var1);

        public Builder lastExecutedPipelineExecutionStatus(PipelineExecutionStatus var1);
    }
}

