/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClusterNodeRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, DescribeClusterNodeRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(DescribeClusterNodeRequest.getter(DescribeClusterNodeRequest::clusterName)).setter(DescribeClusterNodeRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeId").getter(DescribeClusterNodeRequest.getter(DescribeClusterNodeRequest::nodeId)).setter(DescribeClusterNodeRequest.setter(Builder::nodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()}).build();
    private static final SdkField<String> NODE_LOGICAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeLogicalId").getter(DescribeClusterNodeRequest.getter(DescribeClusterNodeRequest::nodeLogicalId)).setter(DescribeClusterNodeRequest.setter(Builder::nodeLogicalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeLogicalId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, NODE_ID_FIELD, NODE_LOGICAL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeClusterNodeRequest.memberNameToFieldInitializer();
    private final String clusterName;
    private final String nodeId;
    private final String nodeLogicalId;

    private DescribeClusterNodeRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodeId = builder.nodeId;
        this.nodeLogicalId = builder.nodeLogicalId;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final String nodeLogicalId() {
        return this.nodeLogicalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeLogicalId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterNodeRequest)) {
            return false;
        }
        DescribeClusterNodeRequest other = (DescribeClusterNodeRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.nodeId(), other.nodeId()) && Objects.equals(this.nodeLogicalId(), other.nodeLogicalId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClusterNodeRequest").add("ClusterName", (Object)this.clusterName()).add("NodeId", (Object)this.nodeId()).add("NodeLogicalId", (Object)this.nodeLogicalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "NodeId": {
                return Optional.ofNullable(clazz.cast(this.nodeId()));
            }
            case "NodeLogicalId": {
                return Optional.ofNullable(clazz.cast(this.nodeLogicalId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("NodeId", NODE_ID_FIELD);
        map.put("NodeLogicalId", NODE_LOGICAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterNodeRequest, T> g) {
        return obj -> g.apply((DescribeClusterNodeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String nodeId;
        private String nodeLogicalId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterNodeRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.nodeId(model.nodeId);
            this.nodeLogicalId(model.nodeLogicalId);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getNodeLogicalId() {
            return this.nodeLogicalId;
        }

        public final void setNodeLogicalId(String nodeLogicalId) {
            this.nodeLogicalId = nodeLogicalId;
        }

        @Override
        public final Builder nodeLogicalId(String nodeLogicalId) {
            this.nodeLogicalId = nodeLogicalId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeClusterNodeRequest build() {
            return new DescribeClusterNodeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClusterNodeRequest> {
        public Builder clusterName(String var1);

        public Builder nodeId(String var1);

        public Builder nodeLogicalId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

