/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AmazonQSettings;
import software.amazon.awssdk.services.sagemaker.model.DockerSettings;
import software.amazon.awssdk.services.sagemaker.model.DomainSecurityGroupIdsCopier;
import software.amazon.awssdk.services.sagemaker.model.ExecutionRoleIdentityConfig;
import software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettingsForUpdate;
import software.amazon.awssdk.services.sagemaker.model.TrustedIdentityPropagationSettings;
import software.amazon.awssdk.services.sagemaker.model.UnifiedStudioSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainSettingsForUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainSettingsForUpdate> {
    private static final SdkField<RStudioServerProDomainSettingsForUpdate> R_STUDIO_SERVER_PRO_DOMAIN_SETTINGS_FOR_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RStudioServerProDomainSettingsForUpdate").getter(DomainSettingsForUpdate.getter(DomainSettingsForUpdate::rStudioServerProDomainSettingsForUpdate)).setter(DomainSettingsForUpdate.setter(Builder::rStudioServerProDomainSettingsForUpdate)).constructor(RStudioServerProDomainSettingsForUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RStudioServerProDomainSettingsForUpdate").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_IDENTITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleIdentityConfig").getter(DomainSettingsForUpdate.getter(DomainSettingsForUpdate::executionRoleIdentityConfigAsString)).setter(DomainSettingsForUpdate.setter(Builder::executionRoleIdentityConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleIdentityConfig").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(DomainSettingsForUpdate.getter(DomainSettingsForUpdate::securityGroupIds)).setter(DomainSettingsForUpdate.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TrustedIdentityPropagationSettings> TRUSTED_IDENTITY_PROPAGATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrustedIdentityPropagationSettings").getter(DomainSettingsForUpdate.getter(DomainSettingsForUpdate::trustedIdentityPropagationSettings)).setter(DomainSettingsForUpdate.setter(Builder::trustedIdentityPropagationSettings)).constructor(TrustedIdentityPropagationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedIdentityPropagationSettings").build()}).build();
    private static final SdkField<DockerSettings> DOCKER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DockerSettings").getter(DomainSettingsForUpdate.getter(DomainSettingsForUpdate::dockerSettings)).setter(DomainSettingsForUpdate.setter(Builder::dockerSettings)).constructor(DockerSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DockerSettings").build()}).build();
    private static final SdkField<AmazonQSettings> AMAZON_Q_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AmazonQSettings").getter(DomainSettingsForUpdate.getter(DomainSettingsForUpdate::amazonQSettings)).setter(DomainSettingsForUpdate.setter(Builder::amazonQSettings)).constructor(AmazonQSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonQSettings").build()}).build();
    private static final SdkField<UnifiedStudioSettings> UNIFIED_STUDIO_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UnifiedStudioSettings").getter(DomainSettingsForUpdate.getter(DomainSettingsForUpdate::unifiedStudioSettings)).setter(DomainSettingsForUpdate.setter(Builder::unifiedStudioSettings)).constructor(UnifiedStudioSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnifiedStudioSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(R_STUDIO_SERVER_PRO_DOMAIN_SETTINGS_FOR_UPDATE_FIELD, EXECUTION_ROLE_IDENTITY_CONFIG_FIELD, SECURITY_GROUP_IDS_FIELD, TRUSTED_IDENTITY_PROPAGATION_SETTINGS_FIELD, DOCKER_SETTINGS_FIELD, AMAZON_Q_SETTINGS_FIELD, UNIFIED_STUDIO_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DomainSettingsForUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate;
    private final String executionRoleIdentityConfig;
    private final List<String> securityGroupIds;
    private final TrustedIdentityPropagationSettings trustedIdentityPropagationSettings;
    private final DockerSettings dockerSettings;
    private final AmazonQSettings amazonQSettings;
    private final UnifiedStudioSettings unifiedStudioSettings;

    private DomainSettingsForUpdate(BuilderImpl builder) {
        this.rStudioServerProDomainSettingsForUpdate = builder.rStudioServerProDomainSettingsForUpdate;
        this.executionRoleIdentityConfig = builder.executionRoleIdentityConfig;
        this.securityGroupIds = builder.securityGroupIds;
        this.trustedIdentityPropagationSettings = builder.trustedIdentityPropagationSettings;
        this.dockerSettings = builder.dockerSettings;
        this.amazonQSettings = builder.amazonQSettings;
        this.unifiedStudioSettings = builder.unifiedStudioSettings;
    }

    public final RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate() {
        return this.rStudioServerProDomainSettingsForUpdate;
    }

    public final ExecutionRoleIdentityConfig executionRoleIdentityConfig() {
        return ExecutionRoleIdentityConfig.fromValue(this.executionRoleIdentityConfig);
    }

    public final String executionRoleIdentityConfigAsString() {
        return this.executionRoleIdentityConfig;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final TrustedIdentityPropagationSettings trustedIdentityPropagationSettings() {
        return this.trustedIdentityPropagationSettings;
    }

    public final DockerSettings dockerSettings() {
        return this.dockerSettings;
    }

    public final AmazonQSettings amazonQSettings() {
        return this.amazonQSettings;
    }

    public final UnifiedStudioSettings unifiedStudioSettings() {
        return this.unifiedStudioSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rStudioServerProDomainSettingsForUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleIdentityConfigAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedIdentityPropagationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dockerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonQSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.unifiedStudioSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSettingsForUpdate)) {
            return false;
        }
        DomainSettingsForUpdate other = (DomainSettingsForUpdate)obj;
        return Objects.equals(this.rStudioServerProDomainSettingsForUpdate(), other.rStudioServerProDomainSettingsForUpdate()) && Objects.equals(this.executionRoleIdentityConfigAsString(), other.executionRoleIdentityConfigAsString()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.trustedIdentityPropagationSettings(), other.trustedIdentityPropagationSettings()) && Objects.equals(this.dockerSettings(), other.dockerSettings()) && Objects.equals(this.amazonQSettings(), other.amazonQSettings()) && Objects.equals(this.unifiedStudioSettings(), other.unifiedStudioSettings());
    }

    public final String toString() {
        return ToString.builder((String)"DomainSettingsForUpdate").add("RStudioServerProDomainSettingsForUpdate", (Object)this.rStudioServerProDomainSettingsForUpdate()).add("ExecutionRoleIdentityConfig", (Object)this.executionRoleIdentityConfigAsString()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("TrustedIdentityPropagationSettings", (Object)this.trustedIdentityPropagationSettings()).add("DockerSettings", (Object)this.dockerSettings()).add("AmazonQSettings", (Object)this.amazonQSettings()).add("UnifiedStudioSettings", (Object)this.unifiedStudioSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RStudioServerProDomainSettingsForUpdate": {
                return Optional.ofNullable(clazz.cast(this.rStudioServerProDomainSettingsForUpdate()));
            }
            case "ExecutionRoleIdentityConfig": {
                return Optional.ofNullable(clazz.cast(this.executionRoleIdentityConfigAsString()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "TrustedIdentityPropagationSettings": {
                return Optional.ofNullable(clazz.cast(this.trustedIdentityPropagationSettings()));
            }
            case "DockerSettings": {
                return Optional.ofNullable(clazz.cast(this.dockerSettings()));
            }
            case "AmazonQSettings": {
                return Optional.ofNullable(clazz.cast(this.amazonQSettings()));
            }
            case "UnifiedStudioSettings": {
                return Optional.ofNullable(clazz.cast(this.unifiedStudioSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RStudioServerProDomainSettingsForUpdate", R_STUDIO_SERVER_PRO_DOMAIN_SETTINGS_FOR_UPDATE_FIELD);
        map.put("ExecutionRoleIdentityConfig", EXECUTION_ROLE_IDENTITY_CONFIG_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("TrustedIdentityPropagationSettings", TRUSTED_IDENTITY_PROPAGATION_SETTINGS_FIELD);
        map.put("DockerSettings", DOCKER_SETTINGS_FIELD);
        map.put("AmazonQSettings", AMAZON_Q_SETTINGS_FIELD);
        map.put("UnifiedStudioSettings", UNIFIED_STUDIO_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainSettingsForUpdate, T> g) {
        return obj -> g.apply((DomainSettingsForUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate;
        private String executionRoleIdentityConfig;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private TrustedIdentityPropagationSettings trustedIdentityPropagationSettings;
        private DockerSettings dockerSettings;
        private AmazonQSettings amazonQSettings;
        private UnifiedStudioSettings unifiedStudioSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSettingsForUpdate model) {
            this.rStudioServerProDomainSettingsForUpdate(model.rStudioServerProDomainSettingsForUpdate);
            this.executionRoleIdentityConfig(model.executionRoleIdentityConfig);
            this.securityGroupIds(model.securityGroupIds);
            this.trustedIdentityPropagationSettings(model.trustedIdentityPropagationSettings);
            this.dockerSettings(model.dockerSettings);
            this.amazonQSettings(model.amazonQSettings);
            this.unifiedStudioSettings(model.unifiedStudioSettings);
        }

        public final RStudioServerProDomainSettingsForUpdate.Builder getRStudioServerProDomainSettingsForUpdate() {
            return this.rStudioServerProDomainSettingsForUpdate != null ? this.rStudioServerProDomainSettingsForUpdate.toBuilder() : null;
        }

        public final void setRStudioServerProDomainSettingsForUpdate(RStudioServerProDomainSettingsForUpdate.BuilderImpl rStudioServerProDomainSettingsForUpdate) {
            this.rStudioServerProDomainSettingsForUpdate = rStudioServerProDomainSettingsForUpdate != null ? rStudioServerProDomainSettingsForUpdate.build() : null;
        }

        @Override
        public final Builder rStudioServerProDomainSettingsForUpdate(RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate) {
            this.rStudioServerProDomainSettingsForUpdate = rStudioServerProDomainSettingsForUpdate;
            return this;
        }

        public final String getExecutionRoleIdentityConfig() {
            return this.executionRoleIdentityConfig;
        }

        public final void setExecutionRoleIdentityConfig(String executionRoleIdentityConfig) {
            this.executionRoleIdentityConfig = executionRoleIdentityConfig;
        }

        @Override
        public final Builder executionRoleIdentityConfig(String executionRoleIdentityConfig) {
            this.executionRoleIdentityConfig = executionRoleIdentityConfig;
            return this;
        }

        @Override
        public final Builder executionRoleIdentityConfig(ExecutionRoleIdentityConfig executionRoleIdentityConfig) {
            this.executionRoleIdentityConfig(executionRoleIdentityConfig == null ? null : executionRoleIdentityConfig.toString());
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = DomainSecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = DomainSecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final TrustedIdentityPropagationSettings.Builder getTrustedIdentityPropagationSettings() {
            return this.trustedIdentityPropagationSettings != null ? this.trustedIdentityPropagationSettings.toBuilder() : null;
        }

        public final void setTrustedIdentityPropagationSettings(TrustedIdentityPropagationSettings.BuilderImpl trustedIdentityPropagationSettings) {
            this.trustedIdentityPropagationSettings = trustedIdentityPropagationSettings != null ? trustedIdentityPropagationSettings.build() : null;
        }

        @Override
        public final Builder trustedIdentityPropagationSettings(TrustedIdentityPropagationSettings trustedIdentityPropagationSettings) {
            this.trustedIdentityPropagationSettings = trustedIdentityPropagationSettings;
            return this;
        }

        public final DockerSettings.Builder getDockerSettings() {
            return this.dockerSettings != null ? this.dockerSettings.toBuilder() : null;
        }

        public final void setDockerSettings(DockerSettings.BuilderImpl dockerSettings) {
            this.dockerSettings = dockerSettings != null ? dockerSettings.build() : null;
        }

        @Override
        public final Builder dockerSettings(DockerSettings dockerSettings) {
            this.dockerSettings = dockerSettings;
            return this;
        }

        public final AmazonQSettings.Builder getAmazonQSettings() {
            return this.amazonQSettings != null ? this.amazonQSettings.toBuilder() : null;
        }

        public final void setAmazonQSettings(AmazonQSettings.BuilderImpl amazonQSettings) {
            this.amazonQSettings = amazonQSettings != null ? amazonQSettings.build() : null;
        }

        @Override
        public final Builder amazonQSettings(AmazonQSettings amazonQSettings) {
            this.amazonQSettings = amazonQSettings;
            return this;
        }

        public final UnifiedStudioSettings.Builder getUnifiedStudioSettings() {
            return this.unifiedStudioSettings != null ? this.unifiedStudioSettings.toBuilder() : null;
        }

        public final void setUnifiedStudioSettings(UnifiedStudioSettings.BuilderImpl unifiedStudioSettings) {
            this.unifiedStudioSettings = unifiedStudioSettings != null ? unifiedStudioSettings.build() : null;
        }

        @Override
        public final Builder unifiedStudioSettings(UnifiedStudioSettings unifiedStudioSettings) {
            this.unifiedStudioSettings = unifiedStudioSettings;
            return this;
        }

        public DomainSettingsForUpdate build() {
            return new DomainSettingsForUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainSettingsForUpdate> {
        public Builder rStudioServerProDomainSettingsForUpdate(RStudioServerProDomainSettingsForUpdate var1);

        default public Builder rStudioServerProDomainSettingsForUpdate(Consumer<RStudioServerProDomainSettingsForUpdate.Builder> rStudioServerProDomainSettingsForUpdate) {
            return this.rStudioServerProDomainSettingsForUpdate((RStudioServerProDomainSettingsForUpdate)((RStudioServerProDomainSettingsForUpdate.Builder)RStudioServerProDomainSettingsForUpdate.builder().applyMutation(rStudioServerProDomainSettingsForUpdate)).build());
        }

        public Builder executionRoleIdentityConfig(String var1);

        public Builder executionRoleIdentityConfig(ExecutionRoleIdentityConfig var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder trustedIdentityPropagationSettings(TrustedIdentityPropagationSettings var1);

        default public Builder trustedIdentityPropagationSettings(Consumer<TrustedIdentityPropagationSettings.Builder> trustedIdentityPropagationSettings) {
            return this.trustedIdentityPropagationSettings((TrustedIdentityPropagationSettings)((TrustedIdentityPropagationSettings.Builder)TrustedIdentityPropagationSettings.builder().applyMutation(trustedIdentityPropagationSettings)).build());
        }

        public Builder dockerSettings(DockerSettings var1);

        default public Builder dockerSettings(Consumer<DockerSettings.Builder> dockerSettings) {
            return this.dockerSettings((DockerSettings)((DockerSettings.Builder)DockerSettings.builder().applyMutation(dockerSettings)).build());
        }

        public Builder amazonQSettings(AmazonQSettings var1);

        default public Builder amazonQSettings(Consumer<AmazonQSettings.Builder> amazonQSettings) {
            return this.amazonQSettings((AmazonQSettings)((AmazonQSettings.Builder)AmazonQSettings.builder().applyMutation(amazonQSettings)).build());
        }

        public Builder unifiedStudioSettings(UnifiedStudioSettings var1);

        default public Builder unifiedStudioSettings(Consumer<UnifiedStudioSettings.Builder> unifiedStudioSettings) {
            return this.unifiedStudioSettings((UnifiedStudioSettings)((UnifiedStudioSettings.Builder)UnifiedStudioSettings.builder().applyMutation(unifiedStudioSettings)).build());
        }
    }
}

